const system = require("../../system");
const Dao = require("../dao.base");
class CompanyPayParamDao extends Dao {
  constructor() {
    super(Dao.getModelName(CompanyPayParamDao));
  }
  async getOneByCompanyId(company_id, pay_type) {
    return this.model.findOne({
      where: {
        company_id: company_id,
        isEnabled: 1,
        payType: pay_type
      },
      attributes: ["id", "pay_appid", "mch_id", "pay_key", "pay_url", "notifyUrl"],
      raw: true
    });
  }
}
module.exports = CompanyPayParamDao;
