const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存蜂擎商标智能推荐
class BycCache extends CacheBase{
   constructor(){
     super();
     this.prefix="bycsearch:";
   }
   async delCache(keyCode){
     const key=this.prefix+keyCode;
     await this.redisClient.delete(key);
   }
   async setBycList(keyCode,obj){
       const key=this.prefix+keyCode;
       await this.redisClient.set(key,obj);
       return obj;
   }
   async getBycListByCache(keyCode){
     if(keyCode==null || keyCode==""){
       return null;
     }
     const key=this.prefix+keyCode;
     var cachedVal= await this.redisClient.get(key);
     if(cachedVal){
       return cachedVal;
     }else{
         return null;
       }
     }
   }
module.exports=BycCache;
