const CacheBase = require("../cache.base");
const system = require("../../system");
//缓存首次登录的赠送的宝币数量
class AuthCodeListCache extends CacheBase {
  constructor() {
    super();
    this.prefix = "codeList:";
    this.companyauthcodeDao = system.getObject("db.companyauthcodeDao");
  }
  async setList(values) {
    const key = his.prefix + "app_data_list";
    await this.redisClient.setWithEx(key, values, 60);//秒
    return obj;
  }
  async getListByCache() {
    const key = this.prefix + "app_data_list";
    var cachedVal = await this.redisClient.get(key);
    if (cachedVal && cachedVal != "undefined") {
      return cachedVal;
    } else {
      var codeList = await this.companyauthcodeDao.model.findAll({
        where: { isEnable: 1 },
        order: [["sortNum", 'asc']],
        attributes: ["id", "code", "macAddr", "sortNum", "resetNum", "company_id"],
        include: [{
          model: this.companyauthcodeDao.db.models.company,
          attributes: ["id", "contact", "contactmobile", "zipCode", "agentPerson"],
          raw: true
        }]
      });
      if (!codeList || codeList.length == 0) {
        return null;
      }
      var codeListStr = JSON.stringify(codeList);
      await this.redisClient.setWithEx(key, codeListStr, 30);//秒
      return codeListStr;
    }
  }
}
module.exports = AuthCodeListCache;
