const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const moment = require("moment");
const System = require("../../../system");
const pushQft = require("../../../utils/toqifutongClient")
const TOQFT = require("../../../utils/toQft");


class CompanycaseService extends ServiceBase {
    constructor() {
        super("delivery", ServiceBase.getDaoName(CompanycaseService));
        this.cacheinfoDao = system.getObject("db.delivery.cacheinfoDao");
        this.deliveryDao = system.getObject("db.delivery.deliverDao");
        this.newmaterialDao = system.getObject("db.delivery.newmaterialDao");
        this.statuslogDao = system.getObject("db.bizchance.statuslogDao");
    }

    async submitMaterials(pobj, qobj, req) {
        const deliverData = await this.deliveryDao.findOne({
            id: pobj.deliver_id
        });
        if (!deliverData) {
            throw new Error("查不到此交付单");
        }
        // await TOQFT.getClientByType(deliverData.product_code).submitMaterials(pobj.username, deliverData, pobj.cache_info);
        return this.db.transaction(async (t) => {
            await this.cacheinfoDao.createOrUpdate(pobj, t);
            await this.newmaterialDao.createOrUpdate(pobj, t);
            if ([system.SERVERSESTATUS.COLLECTING].includes(deliverData.delivery_status)) {
                let status = System.SERVERSESTATUS.AUDITING;
                await this.deliveryDao.updateByWhere({
                    delivery_status: status
                }, {
                    id: pobj.deliver_id
                }, t);
                this.statuslogDao.create({
                    flow_type: system.FLOWCODE.DELIVERY,
                    flow_id: pobj.deliver_id,
                    status_code: status,
                    salesman_id: pobj.userid,
                    salesman_name: pobj.username
                });
            }
            return "SUCCESS"
        });
    }

    async changeDeliveryStatus(pobj, qobj, req) {
        const deliverData = await this.deliveryDao.findOne({
            id: pobj.id
        });
        if (!deliverData) {
            throw new Error("没有此交付单");
        }
        let status;
        switch (deliverData.delivery_status) {
            case system.SERVERSESTATUS.RECEIVED:
                if (deliverData.product_code === System.SERVICECODE.COMPANYCASE) {
                    status = system.SERVERSESTATUS.COLLECTING;
                } else {
                    status = system.SERVERSESTATUS.SERVICEING;
                }
                break
            case system.SERVERSESTATUS.AUDITING: // 工商审核环节
                status = system.SERVERSESTATUS.ENGRAVING;
                break
            case system.SERVERSESTATUS.ENGRAVING: // 刻章环节
                status = system.SERVERSESTATUS.SUCCESS;
                break
            case system.SERVERSESTATUS.SERVICEING: // 服务中
                status = system.SERVERSESTATUS.SUCCESS;
                break
            default:
                throw new Error("此状态手动不能更改");
        }
        // await TOQFT.getClientByType(deliverData.product_code).changeStatus(pobj.username, deliverData);
        await this.deliveryDao.updateByWhere({
            delivery_status: status
        }, {
            id: pobj.id
        })
        this.statuslogDao.create({
            flow_type: system.FLOWCODE.DELIVERY,
            flow_id: pobj.id,
            status_code: status,
            salesman_id: pobj.userid,
            salesman_name: pobj.username
        });
        return "SUCCESS"
    }
}
module.exports = CompanycaseService;
