var system = require("../../../system");
const CtlBase = require("../../ctl.base");
class CompanyCaseCtl extends CtlBase {
    constructor() {
        super("delivery", CtlBase.getServiceName(CompanyCaseCtl));
    }

    // 提交材料
    async submitMaterials(pobj, qobj, req) {
        try {
            if (!pobj.deliver_id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.submitMaterials(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    // 更改状态
    async changeDeliveryStatus(pobj, qobj, req) {
        try {
            if (!pobj.id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.changeDeliveryStatus(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }
}
module.exports = CompanyCaseCtl;
