{
    template: '${tmpl}',
    data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            laststatus: '0',
            statustab: '0',
            editTitle: '发布需求',
            submitLoading: false,
            currentUser: null,
            formLabelWidth: '115px',
            showEdit: false,
            showDetail: false,
            jobDetail: {},
            search0: null,
            search1: null,
            search2: null,
            search3: null,
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                applyBegin:'',
                applyEnd:'',
                publishBegin:'',
                publishEnd:'',
                rejectBegin:'',
                rejectEnd:'',
                cancelBegin:'',
                cancelEnd:'',
                num:'',
                name: '',
                workTimeBegin:'',
                workTimeEnd:'',
                sex: '',
                settleType: '',
            },
            sexOptions:[
                {
                    value: 'all',
                    label: '不限'
                },
                {
                    value: 'male',
                    label: '男'
                },
                {
                    value: 'female',
                    label: '女'
                },
            ],
            settleTypeOptions:[
                {
                    value: '0',
                    label: '计时+计件'
                },
                {
                    value: '1',
                    label: '计时'
                },
                {
                    value: '2',
                    label: '计件'
                },
            ],
            ejob: {
                id: 0,
                name: '',
                num: '',
                sex: 'all',
                settleType: '0',
                timeType: null,
                timeSalary: '',
                pieceSalary: '',
                salaryAvg: '',
                addr:'',
                intro: '',
                require: '',
                jobTimes: [{
                    begin_at: "",
                    end_at: "",
                    beginTimes: "",
                    endTimes: "",
                }],
            },
            timesOptions: {
                start: '00:30',
                step: '00:15',
                end: '23:30'
            },
            rules: {
                name : [
                    { required: true, message: '请输入企业名称', trigger: 'blur' }
                ],
                num: [
                    { required: true, message: '请输入所需人数', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                sex: [
                    { required: true, message: '请选择性别', trigger: 'blur' },
                ],
                settleType: [
                    { required: true, message: '请选择结算方式', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                salaryAvg: [
                    { required: true, message: '请输入月均收入', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                addr: [
                    { required: true, message: '请输入工作地址', trigger: 'blur' },
                ],
                jobTimes: [
                    { required: true, message: '请输入工作日期', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                timeSalary: [
                    { validator: validMethod, trigger: 'blur' }
                ],
                pieceSalary: [
                    { validator: validMethod, trigger: 'blur' }
                ],
                a : [],
            },
        }
    },
    mounted: function () {
        this.resetSearch(true);
    },
    created: function () {},
    methods: {
        statusChange(v) {
            this["search" + this.laststatus] = this.search;
            this.statustab = v;
            if(this["search" + this.statustab]) {
                this.search = this["search" + this.statustab];
            } else {
                this.search = this.getEmptySearch();
            }

            this.laststatus = this.statustab;
            if(!this.search.list || this.search.list.length == 0) {
                this.getList();
            }
            console.log(this["search" + this.statustab]);
            console.log(this.search0, this.search1, this.search2, this.search3);
        },
        getEmptySearch() {
            return {
                currentPage: 1,
                pageSize: 20,
                total : 0,
                list:[],    
                applyBegin:'',
                applyEnd:'',
                publishBegin:'',
                publishEnd:'',
                rejectBegin:'',
                rejectEnd:'',
                cancelBegin:'',
                cancelEnd:'',
                num:'',
                name: '',
                workTimeBegin:'',
                workTimeEnd:'',
                sex: '',
                settleType: '',
            }
        },
        resetSearch(all) {
            console.log(all);
            this.search = this.getEmptySearch();
            if(all) {
                this.search0 = this.getEmptySearch();
                this.search1 = this.getEmptySearch();
                this.search2 = this.getEmptySearch();
                this.search3 = this.getEmptySearch();
            } else {
                this["search" + this.statustab] = this.search;
            }
            this.getList();
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.search.currentPage = 1;
            this.search.total = 0;
            this.getList();
        },
        getList() {
            var self = this;
            var params = this.getParams();
            params.status = this.statustab.toString();
            this.$root.postReq("/web/ejobCtl/companyJobs", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },
        jobCancel(id) {
            var self = this;
            self.$confirm('确定要撤销该零工?', '提示', {
                confirmButtonText: '确定',
                cancelButtonText: '取消',
                type: 'warning'
            }).then(() => {
                self.$root.postReq("/web/ejobCtl/jobCancel", {
                    jobId: id
                }).then(function (d) {
                    if (d.status == 0) {
                        self.$message.success(`撤销成功`);
                        self.getList();
                    } else {
                        self.$message.warning(d.msg || `审核失败，请刷新页面后重新操作`);
                    }
                });
            });
        },
        showJobDetail(id) {
            var self = this;
            self.$root.postReq("/web/ejobCtl/jobInfo", {
                jobId: id,
                pattern: {
                    datePattern : "YYYY-MM-DD HH:mm:ss",
                    timesPattern : "YYYY.MM.DD"
                }
            }).then(function (d) {
                if (d.status == 0) {
                    self.jobDetail = d.data;
                    self.showDetail = true;
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        toedit(id) {
            var self = this;
            self.$root.postReq("/web/ejobCtl/jobInfo", {
                jobId: id
            }).then(function (d) {
                if (d.status == 0) {
                    if(d.data.jobStatus != '0') {
                        self.$alert('该需求已经' + d.data.jobStatusName +", 不可以再编辑", '提示', {
                            confirmButtonText: '确定',
                            callback: action => {
                                self.getList();
                            }
                        });
                        return;
                    }
                    self.ejob = d.data;
                    if(!self.ejob.jobTimes || self.ejob.jobTimes.length == 0) {
                        self.ejob.jobTimes = [{
                            begin_at: "",
                            end_at: "",
                            beginTimes: "",
                            endTimes: "",
                        }];
                    }
                    if(!self.ejob.settleType) {
                        self.ejob.settleType = '0';
                    }
                    self.editTitle = '编辑需求';
                    self.showEdit = true;
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        openAddPage() {
            this.ejob = {
                id: 0,
                name: '',
                num: '',
                sex: 'all',
                settleType: '0',
                timeType: null,
                timeSalary: '',
                pieceSalary: '',
                addr:'',
                intro: '',
                require: '',
                jobTimes: [{
                    begin_at: "",
                    end_at: "",
                    beginTimes: "",
                    endTimes: "",
                }],
            };
            this.editTitle = '发布需求';
            this.showEdit = true;
        },
        showApplys(item) {
            this.$root.pushx({
                title : "查看详情",
                name : "/ejobapplys",
                params: {ejobId: item.id},
            });
        },
        validfileds(rule, value, callback) {
            if(rule.field == 'num') {
                if(!this.ejob.num) {
                    return callback(new Error("请输入所需人数"));
                }

                if(isNaN(this.ejob.num)) {
                    return callback(new Error("所需人数请输入数字"));
                }

                if(this.ejob.num < 0) {
                    return callback(new Error("所需人数必须大于0"));
                }

                if(this.ejob.num > 100000000) {
                    return callback(new Error("所需人数太大, 请按照实际需求输入"));
                }
                return callback();
            }
            
            if(rule.field == 'salaryAvg') {
                if(!this.ejob.salaryAvg) {
                    return callback(new Error("请输入月均收入"));
                }
                if(isNaN(this.ejob.salaryAvg)) {
                    return callback(new Error("月均收入请输入数字"));
                }
                if(this.ejob.salaryAvg < 0) {
                    return callback(new Error("月均收入必须大于0"));
                }
                if(this.ejob.salaryAvg > 1000000) {
                    return callback(new Error("月均收入太大, 请按照实际输入, 否则影响审核通过率"));
                }
                return callback();
            }

            if(rule.field == 'timeSalary') {
                if(this.ejob.settleType == '0') {
                    if(!this.ejob.timeSalary) {
                        return callback(new Error("请输入计时报酬"));
                    }
                    if(!this.ejob.timeType) {
                        return callback(new Error("请选择计时类型"));
                    }
                } else if(this.ejob.settleType == '1') {
                    if(!this.ejob.timeType) {
                        return callback(new Error("请选择计时类型"));
                    }
                    if(!this.ejob.timeSalary) {
                        return callback(new Error("请输入计时报酬"));
                    }
                    this.ejob.pieceSalary = 0;
                }
                return callback();
            }

            if(rule.field == 'pieceSalary') {
                if(this.ejob.settleType == '0') {
                    if(!this.ejob.pieceSalary) {
                        return callback(new Error("请输入计件报酬"));
                    }
                } else if(this.ejob.settleType == '2') {
                    if(!this.ejob.pieceSalary) {
                        return callback(new Error("请输入计件报酬"));
                    }
                    this.ejob.timeType = null;
                    this.ejob.timeSalary = null;
                }
                return callback();
            }

            if(rule.field == 'jobTimes') {
                var jobTimes = this.ejob.jobTimes;
                console.log(jobTimes);
                if(!jobTimes || jobTimes.length == 0) {
                    return callback(new Error("请输入工作时间"));
                }
                for(var jt of jobTimes) {
                    if(!jt.begin_at || !jt.end_at|| !jt.beginTimes || !jt.endTimes) {
                        return callback(new Error("工作时间不允许空"));
                    }
                }
                return callback();
            }
            return callback();
        },
        addJobTimes() {
            var self = this;
            var jobTimes = self.ejob.jobTimes || [];
            jobTimes.push(
                {
                    begin_at: "",
                    end_at: "",
                    beginTimes: "",
                    endTimes: "",
                }
            );
            self.ejob.jobTimes = jobTimes;
            console.log("add jobs ");
        },
        removeJobTimes(idx) {
            this.ejob.jobTimes.splice(idx, 1)
        },
        changeSettleType() {
        },
        changeTimeType() {
            this.$refs['ejob'].validateField('timeSalary');
        },
        editJob() {
            var self = this;
            self.submitLoading = true;
            self.$refs['ejob'].validate((valid) => {
                if (valid) {
                    console.log("submit");
                    setTimeout(() => {
                        self.submitLoading = false;
                    }, 5000);
                    self.$root.postReq("/web/ejobCtl/saveJob", {
                        ejob: self.ejob
                    }).then(function (d) {
                        if (d.status == 0) {
                            self.$message.success(`保存成功`);
                            self.showEdit = false;
                            self.getList();
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.submitLoading = false;
                    });
                } else {
                    console.log("valid false");
                    self.submitLoading = false;
                    return false;
                }
            });
        },
    },
    vname: "gsb-ejobmanager"
}