{
    template: '${tmpl}',
    data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            workload: {},
            editTitle: "新增",
            showEdit: false,
            saveLoading: false,
            uploadResult: "",
            uploadSuccess:false,
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                name:'',
                beginMonth: '',
                endMonth: '',
            },
            rules: {
                name : [
                    { required: true, message: '请输入名称', trigger: 'blur' },
                ],
                month : [
                    { required: true, message: '请输入月份', trigger: 'blur' },
                ],
                url : [
                    { required: true, message: '请上传图片凭证', trigger: 'blur' },
                ],

                a : [],
            },
        }
    },
    mounted: function () {
        this.resetSearch(true);
    },
    created: function () {},
    methods: {
        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                name:'',
                beginMonth: '',
                endMonth: '',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.search.currentPage = 1;
            this.search.total = 0;
            this.getList();
        },
        getList() {
            var self = this;
            var params = this.getParams();
            this.$root.postReq("/web/ecompanyworkloadCtl/companylist", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },
        getWorkload(id) {
            var self = this;
            self.$root.postReq("/web/ecompanyworkloadCtl/findOne", {
                id: id,
            }).then(function (d) {
                if (d.status == 0) {
                    if(d.data) {
                        var month = (d.data.month || "").toString();
                        if(month) {
                            d.data.month = month.substring(0, 4) + "-" + month.substring(4);
                            console.log(d.data.month, "-------------------- d.data.month");
                        }
                    }
                    self.workload = d.data;
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        toDetail(id) {
        },
        openEdit(id) {
            if(id) {
                this.getWorkload(id);
                this.editTitle = "修改";
            } else {
                this.editTitle = "新增";
                this.workload = {isEnabled:true};
            }
            this.showEdit = true;
        },
        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            var self = this;
            if(rule.field == 'name') {
                if(!self.workload.name) {
                    return callback(new Error("请输入名称"));
                }
            }
            return callback();
        },
        saveWorkload() {
            var self = this;
            self.saveLoading = true;
            self.$refs.workload.validate((valid) => {
                if (valid) {
                    setTimeout(() => {
                        self.saveLoading = false;
                    }, 5000);
                    self.$root.postReq("/web/ecompanyworkloadCtl/mysave", self.workload).then(function (d) {
                        if (d.status == 0) {
                            self.$message.success(`保存成功`);
                            self.showEdit = false;
                            self.getList();
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.saveLoading = false;
                    });
                } else {
                    self.saveLoading = false;
                    return false;
                }
            });
        },
    },
    vname: "gsb-ecompanyworkload"
}