{
    template: '${tmpl}',
        data: function() {
            var validMethod = (rule, value, callback) => {
                return this.validfileds(rule, value, callback);
            };

            return {
                submitLoading: false,
                currentUser: null,
                dialogTableVisible: false,
                dialogFormVisible: false,
                formLabelWidth: '115px',
                natureList:[],
                industryList: [],
                ecompany : {
                    logo: '',
                    nature: '有限责任公司',
                    industry: '',
                    addr: '',
                    intro: '',
                    businessLicense: '',
                    contractName: '',
                    contractMobile : '',
                    telephone : '',
                    email : '',
                    jdAuthStatus: '0',
                },
                rules : {
                    logo: [
                        { required: true, message: '请上传图片', trigger: 'blur' },
                    ],
                    name : [
                        { required: true, message: '请输入企业名称', trigger: 'blur' },
                        { validator: validMethod, trigger: 'blur' }
                    ],
                    nature : [
                        { required: true, message: '请选择企业性质', trigger: 'blur' },
                    ],
                    industry : [
                        { required: true, message: '请选择所属行业', trigger: 'blur' },
                    ],
                    addr: [
                        { required: true, message: '请输入所在地', trigger: 'blur' },
                    ],
                    businessLicense:[
                        { required: true, message: '请上传营业执照图片', trigger: 'blur' },
                    ],
                    contractName: [
                        { required: true, message: '请输入企业联系人', trigger: 'blur' },
                    ],
                    contractMobile : [
                        { required: true, message: '请输入企业联系人手机号', trigger: 'blur' },
                        { validator: validMethod, trigger: 'blur' }
                    ],
                    email : [
                        { required: true, message: '请输入联系邮箱', trigger: 'blur' },
                        { validator: validMethod, trigger: 'blur' }
                    ],
                    a : [],
                }, 
            }
        },
    mounted: function() {
        this.initCompany();
        this.getNatureList();
        this.getIndustryList();
    },
    created: function() {
    },
    methods: {
        validfileds(rule, value, callback) {
            if(rule.field == 'name') {
                this.$root.postReq("/web/ecompanyCtl/validMyName", {
                    name: value
                }).then(function (d) {
                    if (d.status == 0) {
                        return callback();
                    } else {
                        return callback(new Error(d.msg || "公司名称校验失败"));
                    }
                });
            }

            if(rule.field == 'contractMobile') {
                if (/^1[23456789]\d{9}$/.test(value)) {
                    return callback();
                } else {
                    return callback(new Error("请输入正确格式的手机号"));
                }
            }

            if(rule.field == 'email') {
                var p = /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/;
                if (p.test(value)) {
                    return callback();
                } else {
                    return callback(new Error("请输入正确的邮箱格式"));
                }
            }
        },
        initCompany() {
            var self = this;
            this.$root.postReq("/web/ecompanyCtl/myCompany", {
            }).then(function (d) {
                if (d.status == 0) {
                    if(d.data) {
                        self.ecompany = d.data;
                    }
                }
            });
        },
        getNatureList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig",{"dicKey": "companyNature"}).then(cfg=>{
                console.log(JSON.stringify(cfg.data));
                Object.keys(cfg.data).forEach(key=>{
                    self.natureList.push({"label":cfg.data[key],"value":cfg.data[key]});
                });
            });
        },
        getIndustryList() {
            var self = this;
            this.$root.getReq("/web/metaCtl/getDicConfig",{"dicKey": "companyIndustry"}).then(cfg=>{
                console.log(JSON.stringify(cfg.data));
                Object.keys(cfg.data).forEach(key=>{
                    self.industryList.push({"label":cfg.data[key],"value":cfg.data[key]});
                });
            });
        },
        saveCompany() {
            var self = this;
            self.submitLoading = true;
            self.$refs['ecompany'].validate((valid) => {
                if (valid) {
                    this.$root.postReq("/web/ecompanyCtl/authsave", {
                        ecompany: self.ecompany
                    }).then(function (d) {
                        if (d.status == 0) {
                            if(d.data) {
                                self.$message.success("认证信息提交成功, 请等待审核");
                                self.ecompany = d.data;
                            }
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.submitLoading = false;
                    });
                    setTimeout(() => {
                        self.submitLoading = false;
                    }, 5000);
                } else {
                    self.submitLoading = false;
                    return false;
                }
            });
        },
    },
    vname: "gsb-ecompanyauth"
}

