{
    template: '${tmpl}',
    data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            is_api: 1,
            optionsName:[],
            optionsMerchants: [],
            optionsChannel:[],
            dkcompany: {},
            editTitle: "新增",
            showEdit: false,
            saveLoading: false,
            ownerList:[],
            ownerMap:[],
            ownerLoading:false,
            owner_id: "",
            merchantNameLoading: false,
            merchantNameList: [],
            merchantNameMap:[],

            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total: 0,
                channel_id : '',
                origin_id:'',
                merchant_name: ''
            },
            rules: {
                channel_id : [
                    { required: true, message: '请选择渠道名称', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                origin_id : [
                    { required: true, message: '请选择商户来源', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                origin_merchant_id : [
                    { required: true, message: '请选择商户名称', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                merchant_name: [
                    { required: true, message: '请输入商户名称', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                contact_man: [
                    { required: true, message: '请输入联系人', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                contact_mobile : [
                    { required: true, message: '请输入联系电话', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                contact_email: [
                    { required: true, message: '请输入联系邮箱', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                contact_addr : [
                    { required: true, message: '请输入联系地址', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
            },
        }
    },
    mounted: function () {
        this.resetSearch(true);
        this.originDicsPost();
        this.channelDictsPost();
    },
    created: function () {},
    methods: {
        querySearch(queryString, cb) {
            console.log('?????????????',queryString,cb);
            var self = this;
            this.$root.postReq("/web/channelCtl/originMerchants",  {
                id: this.dkcompany.origin_id,
                name: queryString
            })
            .then(function (d) {
                if (d.status == 0) {
                    let arr = [];
                    for(let i=0;i<d.data.length;i++){
                        arr.push({'value':d.data[i].name, 'address': d.data[i].id});
                    }
                    cb(arr)
                } else {
                }
            });
        },
        handleSelect(item) {
            console.log(item);
            this.dkcompany.origin_merchant_id = item.address;
        },
        originMerchantsPost(value) {
            console.log(value);
            for (let i = 0; i < this.optionsMerchants.length; i++) {
                if (value == this.optionsMerchants[i].id){
                    this.is_api = this.optionsMerchants[i].is_api
                } 
            }
            console.log(this.is_api);
        },
        channelDictsPost() {
            var self = this;
            this.$root.postReq("/web/channelCtl/channelDicts",  {})
            .then(function (d) {
                if (d.status == 0) {
                    self.optionsChannel = d.data || [];
                } else {
                }
            });
        },
        originDicsPost() {
            var self = this;
            this.$root.postReq("/web/channelCtl/originDics",  {})
            .then(function (d) {
                if (d.status == 0) {
                    self.optionsMerchants = d.data || [];
                } else {
                }
            });
        },
        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total: 0,
                channel_id : '',
                origin_id:'',
                merchant_name: ''
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.search.currentPage = 1;
            this.search.total = 0;
            this.getList();
        },
        getList() {
            var self = this;
            var params = this.getParams();
            this.$root.postReq("/web/channelCtl/merchantPage",  params)
            .then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },
        getDKcompany(id) {
            var self = this;
            self.$root.postReq("/web/channelCtl/merchantInfo", {
                id: id,
            }).then(function (d) {
                if (d.status == 0) {
                    self.dkcompany = d.data;
                    if (d.data.origin_id == 10001) {
                        self.is_api = 0
                    }else {
                        self.is_api = 1
                    }
                    /*if(d.data) {
                        d.data.isEnabled = d.data.isEnabled ? true : false;
                    }
                    self.dkcompany.owner_id = self.dkcompany.owner_id || "";
                    self.owner_id = (d.data.owner || {}).id || "";
                    if(d.data.owner) {
                        self.ownerList = [d.data.owner];
                        self.ownerMap["id_" + d.data.owner.id] = d.data.owner;
                    } else {
                        self.ownerList = null;
                    }*/
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        toDetail(id) {
        },
        openEdit(id) {
            this.ownerLoading = false;
            this.saveLoading = false;
            this.owner_id = null;
            if(this.$refs.dkcompany) {
                this.$refs.dkcompany.resetFields();
            }
            if(id) {
                this.getDKcompany(id);
                this.editTitle = "修改";
            } else {
                this.ownerList = [];
                this.editTitle = "新增";
                this.dkcompany = {};
            }
            this.showEdit = true;
        },
        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            var self = this;
            if(rule.field == 'owner_id') {
                if(!self.dkcompany.owner_id) {
                    return callback(new Error("请选择归属人员"));
                } else {
                    return callback();
                }
            } else {
                return callback();
            }
        },

        ownerChange(val) {
            console.log(val, );
            this.dkcompany.owner_id = val || 0;
            this.owner = this.ownerMap["id_" + val];
            console.log(this.owner);
        },
        getOwnerList(query) {
            var self = this;
            self.ownerLoading = true;
            self.$root.postReq("/web/userCtl/rolesSuggest", {
                name: query,
                roleCodes: ["zczy", "zcgl", "qdzy", "qdgl", "ptzy", "ptgl", "dkhzy", "dkhgl", "ziying", "tzgl", "tzzy"]
            }).then(function (d) {
                self.ownerLoading = false;
                self.ownerList = d.data || [];
                self.ownerMap = [];

                for (var o of self.ownerList) {
                    self.ownerMap["id_" + o.id] = o;
                }
            });
            setTimeout(() => {
                self.ownerLoading = false; 
            }, 15000);
        },
        saveCompany() {
            var self = this;
            self.saveLoading = true;
            self.$refs.dkcompany.validate((valid) => {
                if (valid) {
                    self.$root.postReq("/web/channelCtl/merchantSave", self.dkcompany).then(function (d) {
                        if (d.status == 0) {
                            self.$message.success(`保存成功`);
                            self.showEdit = false;
                            self.getList();
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.saveLoading = false;
                    });
                } else {
                    self.saveLoading = false;
                    return false;
                }
            });
            setTimeout(() => {
                self.saveLoading = false;
            }, 5000);
        },
        suggestMerchantNames(query) {
            var self = this;
            self.merchantNameLoading = true;
            self.$root.postReq("/web/channelCtl/originMerchants", {
                id: self.dkcompany.origin_id,
                name: query
            }).then(function (d) {
                self.merchantNameLoading = false;
                self.merchantNameList = d.data || [];
                self.merchantNameMap = {};
                for(let mn of self.merchantNameList) {
                    self.merchantNameMap[mn.id] = mn;
                }
            });
            setTimeout(() => {
                self.merchantNameLoading = false;
            }, 15000);
        },
        merchantNameChange(val) {
            var self = this;
            console.log(val, "-------------");
            let mn = self.merchantNameMap[val] || {};
            console.log(val, "-------------", mn);
            this.dkcompany.origin_merchant_id = mn.id;
            this.dkcompany.merchant_name = mn.name;
            console.log(this.dkcompany);
        },
    },
    vname: "gsb-dkcompanyadmin"
}