var app = new Vue({
  el: "#app",
  data: function () {
    return {
      param: "",
      currentPage: 1,
      pageSize: 10,
      rows: [],
      info: {
        createTime: "",
        incomeTax: "",
        deductAmt: "",
        merchantName: "",
        actualAmt: "",
        itemCount: "",
        serviceTax: "",
      },
    }
  },
  created: function () {
  },
  mounted: function () {
    this.param = this.getUrlParams("data");
    if(!this.param) {
      this.$message.warning("请求参数错误");
      return;
    }
    console.log(this.param, "--------------");
    this.getInfo();
  },
  methods: {
    postReq(path, data) {
      return axios.post(path, data).then(function (r) {
        return r.data ? r.data : null;
      })
    },
    getUrlParams: function (name) {
      return decodeURIComponent(
          (new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.href) || [, ""])[1].replace(/\+/g, '%20')) || null;
    },
    onColFormater(row, column, cellValue, index) {
      if(column.property == 'trade_status') {
        if(cellValue === '00') {
          return "成功";
        } else if(cellValue === "01") {
          return "待处理";
        } else if(cellValue === "02") {
          return "失败";
        } else if(cellValue === "03") {
          return "失败且退款";
        } else {
          return "";
        }
      }
      return cellValue || "0";
    },
    getInfo() {
      let self = this;
      this.$root.postReq("/api/channelApi/orderInfo", {
        data: self.param
      }).then(d => {
        if (d.status === 0) {
          self.info = d.data || {};
          self.getItemPage();
        } else {
          self.$message.warning(d.msg || "订单数据获取失败");
        }
      });
    },
    getItemPage() {
      let self = this;
      this.$root.postReq("/api/channelApi/itemPage", {
        currentPage: self.currentPage,
        pageSize: self.pageSize,
        data: self.param
      }).then(d => {
        if (d.status === 0) {
          let page = d.data || {};
          console.log(page, '------------------------')
          self.rows = page.rows || [];
          self.info.itemCount = page.count || 0;
        } else {
          self.$message.warning(d.msg || "订单详情列表获取失败");
        }
      });
    },
    handleSizeChange(val) {
      this.pageSize = val;
      console.log(`每页 ${val} 条`);
      this.getItemPage();
    },
    handleCurrentChange(val) {
      this.currentPage = val;
      console.log(`当前页: ${val}`);
      this.getItemPage();
    },
  },
});