var app = new Vue({
  el: "#app",
  data: function () {

    var validMethod = (rule, value, callback) => {
      return this.validfileds(rule, value, callback);
    };
    return {
      domainUrl:"",
      sendCodeLoading:false,
      sendCodeText:"发送验证码",
      sendCodeTime: 60,
      timelock: null,
      dataForm: {
        mobile: '',
        captcha: '',
        captchaKey: '',
        vcode: '',
        passwd: '',
      },
      rules: {
        mobile: [
          { required: true, message: '请输入手机号', trigger: 'blur' },
          { validator: validMethod, trigger: 'blur' }
        ],
        vcode : [
          { required: true, message: '请输入验证码', trigger: 'blur' },
        ],
        captcha : [
            { required: true, message: '请输入图形验证码', trigger: 'blur' },
        ],
        passwd : [
            { required: true, message: '请输入新密码', trigger: 'blur' },
            // { min: 6, max: 18, message: '请输入6-18位密码', trigger: 'blur' }
        ],
      },
    }
  },
  created: function () {
  },
  mounted: function () {
    this.captcha();
    var harr = window.location.href.split("//");
    this.domainUrl = harr[0] + "//" + window.location.host;
  },

  methods: {
    postReq(path, data) {
      return axios.post(path, data).then(function (r) {
        return r.data ? r.data : null;
      })
    },
    validfileds(rule, value, callback) {
      if(rule.field == 'mobile') {
        if (/^1[23456789]\d{9}$/.test(this.dataForm.mobile)) {
            return callback();
        } else {
            return callback(new Error("请输入正确格式的手机号"));
        }
      }
      return callback();
    },
    goback() {
      window.history.back(-1);
    },
    sendCode() {
      var self = this;
      if (!/^1[23456789]\d{9}$/.test(self.dataForm.mobile)) {
        self.$refs.dataForm.validateField('mobile');
        return;
      }

      if(!self.dataForm.captcha) {
          self.$refs.dataForm.validateField('captcha');
          return;
      }
      if(self.sendCodeLoading) {
          return;
      }
      self.sendCodeLoading = true;
      if(self.timelock) {
          clearInterval(self.timelock);
      }
      self.sendCodeTime = 59;
      self.sendCodeText = self.sendCodeTime + 's';

      self.$root.postReq("/web/userCtl/sendSMSCode", self.dataForm).then(function (d) {
          if (d.status == 0) {
              self.$message.success(`发送成功`);
              self.timelock = setInterval(() => {
                  if(self.sendCodeTime > 0) {
                      self.sendCodeTime = self.sendCodeTime - 1;
                      self.sendCodeText = self.sendCodeTime + 'S';
                  } else {
                      self.sendCodeLoading = false;
                      self.sendCodeTime = 60;
                      self.sendCodeText = "发送验证码";
                  }
              }, 1000);
          } else {
              self.sendCodeLoading = false;
              self.sendCodeTime = 60;
              self.sendCodeText = "发送验证码";

              self.$alert(d.msg || '发送失败', '提示', {
                  confirmButtonText: '确定',
                  callback: action => {}
              });
              self.captcha(2);
          }
      });
    },
    captcha() {
      var self = this;
      this.$root.postReq("/api/captchaApi/captcha", {
          width: 99,
          height: 40
      }).then(function (d) {
          if (d.status == 0) {
            if(d.data) {
              self.dataForm.captchaKey = d.data.key;
              $("#captchaDiv").html(d.data.captcha);
            }
          }
      });
    },
    sub() {
      var self = this;
      this.$refs.dataForm.validate((valid) => {
        console.log(valid);
        if (valid) {
            //处理登录逻辑
            self.$root.postReq("/web/userCtl/saveCompanyForget",self.dataForm).then(function(d){
              if (d.status==0) {
                self.$message.success(`密码修改成功`);
                self.goback();
              } else {
                self.$message.warning(d.msg || "修改失败");
              }
            });
        } else {
          return false;
        }
      });
    },
  },
});