var app = new Vue({
  el: "#app",
  data: function () {
    var checkPhone = (rule, value, callback) => {
      if (!value) {
        return callback(new Error('手机号不能为空'));
      } else {
        const reg = /^1[23456789]\d{9}$/
        console.log(reg.test(value));
        if (reg.test(value)) {
          callback();
        } else {
          return callback(new Error('手机号码格式错误'));
        }
      }
    };

    return {
      top: 0,
      isApplying: false,
      options: [
        {
          value: '企业资源多',
          label: '企业资源多'
        },
        {
          value: '企业高层朋友多',
          label: '企业高层朋友多'
        },
        {
          value: '熟悉财税社保业务',
          label: '熟悉财税社保业务'
        },
        {
          value: '其他',
          label: '其他'
        },
      ],
      epartner: {
        city: '',
        userName: '',
        mobile: '',
        advList:[],
      },
      rules: {
        city: [
          { required: true, message: '请输入所在城市', trigger: 'blur' },
          { max: 20, message: '城市太长了, 不能超过20个字', trigger: 'blur' }

        ],
        userName: [
          { required: true, message: '请输入联系人姓名', trigger: 'blur' },
          { max: 20, message: '姓名不能超过20个字', trigger: 'blur' }

        ],
        mobile: [
          { required: true, message: '请输入联系人手机', trigger: 'blur' },
          { validator: checkPhone, trigger: 'blur'}
        ],
      },
      img1Style: "position:absolute;top:48px;text-align: center;width: 1200px; left: 18%;",
      img2Style: "position:absolute;top:66px;text-align: center;width: 1200px; left: 18%;",
      bottomStyle: "position:absolute;text-align: center;width: 1200px; left: 18%;",
      formStyle:"width:422px;height:400px;background-color:#fff;text-align: center;border-radius:15px;position:absolute;z-index:999;left:1040px;top:240px;",
      a: "a",
    }
  },
  created: function () {
  },
  mounted: function () {
    $("#needh5").text("招募薪必果合伙人");
    var w = document.documentElement.clientWidth;
    var top = 120;
    var defw = 1200;
    var img1w = 0;
    if(w < 1200) {
      w = 1200;
      top = 120;
    } else {
      top = (w / 10).toFixed(0);

      img1w = (w - 1200) / 2
    }

    this.applyStyle = "width:422px;height:330px;background-color:#fff;text-align: center;border-radius:15px;position:absolute;z-index:999;left: 56%; top: " + top + "px;";
    this.img1Style = "position:absolute;top:48px;text-align: center;width: 1200px;left: " + img1w + "px;";
    this.img2Style = "position:absolute;top:66px;text-align: center;width: 1200px;left: " + img1w + "px;";
    this.formStyle = "width:422px;height:400px;background-color:#fff;text-align: center;border-radius:15px;position:absolute;z-index:999;left:" + (w * 1040/1903).toFixed(0) + "px;top:240px;";

    this.bottomStyle= "position:absolute;text-align: center;width: 1200px; left: " + img1w + "px;";

    console.log(w, this.img1Style);
  },
  
  methods: {
    getImg1Style() {
      return this.img1Style;
    },
    postReq(path, data) {
      return axios.post(path, data).then(function (r) {
        return r.data ? r.data : null;
      })
    },
    validmethod: function (rule, value, callback) {
      console.log("code validdate");
      var self = this;
      if (rule.field == "mobile") {
        if (/^1[23456789]\d{9}$/.test(value) == false) {
          return callback(new Error("手机号格式错误"));
        }
      }
      return callback();
    },
    btnclick:function(pfm,code){
    },
    apply() {
      console.log(this.epartner);
      var self = this;

      if (this.isApplying) {
        return false;
      }

      this.isApplying = true;
      this.$refs['epartner'].validate((valid) => {        
        if (valid) {
          self.$root.postReq("/web/epartnerCtl/apply", this.epartner).then(function (d) {
            console.log(d);
            self.isApplying = false;
            if (d.code == 0) {
              self.$message.warning("提交成功");
            } else {
              self.$message.warning(d.msg || "提交失败, 擎稍后重试");
            }
          });
        } else {
          console.log('error submit!!');
          self.isApplying = false;
          return false;
        }
      });

      
    }
  },
});