const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require("moment");

class EsettleofflineitemService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(EsettleofflineitemService));
  }

  async pageByCondition(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};

    if (params.esettleoffline_id) {
      where.esettleoffline_id = params.esettleoffline_id;
    }

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "esettleoffline_id", "id_no", "id_name", "acc_no", "open_bank", 
    "amt", "actual_amt", "total_amt", "income_rate", "income_tax", "service_tax", "added_value_tax", "remark"
    ];

    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      for (var row of page.rows) {
      }
      system.f2y4list(page.rows, ["amt", "actual_amt", "total_amt", "income_tax", "service_tax", "added_value_tax"]);
    }
    return page;
  } 

  async pageByByOrderId(esettleoffline_id, currentPage, pageSize) {
    if (!esettleoffline_id) {
      return {count:0, rows: []};
    }

    currentPage = Number(currentPage || 1);
    pageSize = Number(pageSize || 10);

    var where = {
      esettleoffline_id: esettleoffline_id
    };

    var orderby = [
      ["id", 'desc']
    ];
    var attributes = [
      // "id_no", "id_name",
      "id_name", "actual_amt", "income_tax", "service_tax", "amt"
    ];
    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      for (var row of page.rows) {
      }
    }
    return page;
  } 


  async sumIncome(esettleoffline_id) {
    let sql = "SELECT SUM(income_tax) AS incomeTax FROM `c_esettle_offline_item` WHERE esettleoffline_id = :esettleoffline_id";
    var list = await this.dao.customQuery(sql, {esettleoffline_id: esettleoffline_id});
    if(!list || list.length == 0) {
      return 0;
    }
    return list[0].incomeTax || 0;
  }
}
module.exports = EsettleofflineitemService;