const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require("moment");
class EmessageService extends ServiceBase {
   constructor() {
      super(ServiceBase.getDaoName(EmessageService));
   }

   async getList(params, currentPage, pageSize) {
      var whereObj = {};
      if(params.user_id) {
         whereObj.user_id = params.user_id
      }

      if(params.types) {
         whereObj.type = {[this.db.Op.in]: params.types};
      }

      var orderbyObj = [
         ["id", 'desc']
      ];

      var attributesObj = ["id", "type", "title", "content", "read", "created_at"];
      var page = await this.getPageList(currentPage, pageSize, whereObj, orderbyObj, attributesObj);

      if (page && page.rows) {
         for (var row of page.rows) {
            row.created_at = moment(row.created_at).format("YYYY-MM-DD HH:mm:ss");
         }
      }
      return page;
   }

   async readAll(userId) {
      var sql = "UPDATE c_emessage SET `read` = 1 WHERE user_id = " + Number(userId);
      await this.dao.customExecAddOrPutSql(sql);
   }
}
module.exports = EmessageService;