const system = require("../../system");
const ServiceBase = require("../sve.base");
class EjobcollectService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(EjobcollectService));
    this.ejobDao = system.getObject("db.ejobDao");
  }

  async opCollect(userId, jobId, isCollect) {
    var job = await this.ejobDao.findById(jobId);
    var collectCount = job.collectCount || 0;
    if (isCollect) {
      var collect = await this.findOne({user_id:userId, ejob_id: jobId});
      if(!collect) {
        collect = {
          ejob_id: jobId,
          user_id: userId
        }
        await this.create(collect);
        job.collectCount = Number(collectCount) + 1;
        job.save();
      }
    } else {
      var delSql = "DELETE FROM c_ejob_collect WHERE user_id = " + Number(userId) + " AND ejob_id = " + Number(jobId);
      await this.dao.customExecAddOrPutSql(delSql);

      if(Number(collectCount) > 0) {
        job.collectCount = Number(collectCount) - 1;
        job.save();
      }
    }
    return 1;
  }
}

module.exports = EjobcollectService;