const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require("moment");
class EintentionfollowService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(EintentionfollowService));

    this.userDao = system.getObject("db.userDao");
  }

  async pageByCondition(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};

    if (params.eintention_id) {
      where.eintention_id = params.eintention_id;
    }

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "eintention_id", "followUserId", "followUserName", 
      "followStatus", "followStatusName", "content", "created_at"
    ];

    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      for (var row of page.rows) {
        this.handleDate(row, ["created_at"], null, -8);
      }
    }
    return page;
  }
}


module.exports = EintentionfollowService;