const system=require("../../system");
const ServiceBase=require("../sve.base");
class DKtemplateService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(DKtemplateService));
     //this.appDao=system.getObject("db.appDao");

     this.dkcompanyDao = system.getObject("db.dkcompanyDao");
     this.dkaggreementDao = system.getObject("db.dkaggreementDao");
  }

  async pageByCondition(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};
    if (params.name) {
      where.name = {
        [this.db.Op.like]: "%" + params.name + "%"
      };
    }

    if(params.dkcompanyIds) {
      where.dkcompany_id = {
        [this.db.Op.in]: params.dkcompanyIds
      };
    }
    if (params.dkcompany_id) {
      where.dkcompany_id = params.dkcompany_id;
    }

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "dkcompany_id", "dkaggreement_id", "name", "codeurl", "remark", "created_at", "updated_at"];
    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      for(var row of page.rows) {
        this.handleDate(row, ["created_at" , "updated_at"]);
      }
      await this.setCompany(page.rows);
      await this.setAggreement(page.rows);
    }
    return page;
  }

  async setCompany(list) {
    if (!list || list.length == 0) {
      return;
    }

    var companyIds = [];
    for (var item of list) {
      companyIds.push(item.dkcompany_id || 0);
    }
    var companyMap = await this.dkcompanyDao.findMapByIds(companyIds);
    for (var item of list) {
      item.dkcompany = companyMap["id_" + (item.dkcompany_id || 0)];
    }
  }

  async setAggreement(list) {
    if (!list || list.length == 0) {
      return;
    }
    var aggreementIds = [];
    for (var item of list) {
      aggreementIds.push(item.dkaggreement_id || 0);
    }

    var aggreementMap = await this.dkaggreementDao.findMapByIds(aggreementIds);
    for (var item of list) {
      item.dkaggreement = aggreementMap["id_" + (item.dkaggreement_id || 0)];
    }
  }

  async getInfo(id) {
    var attrs = ["id", "dkcompany_id", "dkaggreement_id", "name", "codeurl", "remark", "created_at", "updated_at"];
    var obj = await this.dao.model.findOne({
      where: { id: id }, attrs, raw: true
    });

    await this.setCompany([obj]);
    await this.setAggreement([obj]);
    return obj;
  }

  async findReadyContracts(obj){
    // obj.isEnabled=true;
    // let sql = "SELECT t1.*, t2.id AS companyid, t2.`name` AS companyname " +
    //           "FROM `c_etemplate` t1 " +
    //           "INNER JOIN c_ecompany t2 ON t1.`ecompany_id` = t2.id " +
    //           "WHERE t1.isEnabled = 1 AND t1.ecompany_id = :ecompany_id " +
    //           "AND t1.id NOT IN  (SELECT etemplate_id FROM `c_econtract` WHERE usereaccount_id = :usereaccount_id  AND eflowstatus = '2') " +
    //           "AND t2.`deleted_at` IS NULL AND t1.`deleted_at` IS NULL ";

    // let params = {ecompany_id:obj.ecompany_id, usereaccount_id : obj.eaccount_id};
    // var list = await this.dao.customQuery(sql, params);
    // if(!list || list.length == 0) {
    //   return [];
    // }
    // list.forEach(item => {
    //   var ecompany = {};
    //   ecompany.id = item.companyid;
    //   ecompany.name = item.companyname;
    //   item.ecompany = ecompany;
    // });
    // return list;
  }
}
module.exports=DKtemplateService;
