const system=require("../../system");
const ServiceBase=require("../sve.base");
class DKaggreementService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(DKaggreementService));
  }

  async pageByCondition(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};
    if (params.name) {
      where.name = {
        [this.db.Op.like]: "%" + params.name + "%"
      };
    }

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "name", "templateid", "filekey", "filepath", "remark", "ctlname", "callbackurl", "created_at", "updated_at"];
    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      for(var row of page.rows) {
        this.handleDate(row, ["created_at" , "updated_at"]);
      }
    }
    return page;
  }


  async getInfo(id) {
    var attrs = ["id", "name", "templateid", "filekey", "filepath", "remark", "ctlname", "callbackurl", "created_at", "updated_at"];
    return await this.dao.model.findOne({
      where: { id: id }, attrs, raw: true
    });
  }

}
module.exports=DKaggreementService;
