const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("ecompany", {
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    nameA:DataTypes.STRING(50),
    isEnabled: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true
    },
    // 是否静默签
    isQuiet: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true
    },
    encryptkey: DataTypes.STRING, // 加密key
    posturl: DataTypes.STRING, // 推送地址
    sealurl: DataTypes.STRING, // 公司盖章图地址
    userName: DataTypes.STRING(50), // 账号
    credit_code: DataTypes.STRING(255), // 统一社会信用代码
    contractName: DataTypes.STRING(20), // 联系人
    contractMobile: DataTypes.STRING(20), // 联系人电话
    ecompanyLevelName: {
      // 客户等级名称
      type: DataTypes.STRING(20),
      defaultValue: "普通",
    },
    ecompanyLevel: {
      // 客户等级  0普通 1小微 2重要
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.ecompanyLevel),
      set: function (val) {
        this.setDataValue("ecompanyLevel", val);
        this.setDataValue("ecompanyLevelName", uiconfig.config.pdict.ecompanyLevel[val]);
      },
      defaultValue: "0",
    },
    ecompanySourceTypeName: {
      // 客户来源名称
      type: DataTypes.STRING(20),
      defaultValue: "直接开发",
    },
    ecompanySourceType: {
      // 客户来源 0:直接开发,10:转介绍,20:扫码推广,90:其他来源
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.ecompanySourceType),
      set: function (val) {
        this.setDataValue("ecompanySourceType", val);
        this.setDataValue("ecompanySourceTypeName", uiconfig.config.pdict.ecompanySourceType[val]);
      },
      defaultValue: "0",
    },
    cityCode: DataTypes.STRING,
    cityName: DataTypes.STRING(20),
    pcode: DataTypes.STRING(30),
    ccode: DataTypes.STRING(30),
    epartner_id: DataTypes.INTEGER, // 合伙人id
    user_id: DataTypes.INTEGER, // 用户id
    ecompanycontract_id:DataTypes.INTEGER, //合同id
    owner_id:DataTypes.INTEGER, // 所属人id
    bank: DataTypes.STRING(100), // 开户行
    bankno: DataTypes.STRING(30), // 开户行账号
    payCount: DataTypes.INTEGER, // 发薪人数
    pay_at: DataTypes.DATE, // 发薪时间
    partnerType: {
      // 合伙人类型 0初级 1一级 2二级
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.partnerType),
      set: function (val) {
        this.setDataValue("partnerType", val);
      },
      defaultValue: "0",
    },
    isBenefit: {
      // 是否分润(与合伙人等级快照相关)
      type: DataTypes.BOOLEAN,
      defaultValue: true
    },

    // 零工系统增加字段
    businessLicense: DataTypes.STRING(300),
    jdAuthStatusName: {
      // 认证状态
      type: DataTypes.STRING(20),
      defaultValue: "待认证",
    },
    jdAuthStatus: {
      // 认证状态
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.jdAuthStatus),
      set: function (val) {
        this.setDataValue("jdAuthStatus", val);
        this.setDataValue("jdAuthStatusName", uiconfig.config.pdict.jdAuthStatus[val]);
      },
      defaultValue: "0",
    },
    jdAuthApplyTime : DataTypes.DATE,
    jdAuthId : DataTypes.INTEGER,
    jdAuthTime : DataTypes.DATE,
    authNotes: DataTypes.STRING(200),
    logo: DataTypes.STRING(300),

    nature:  DataTypes.STRING(30),
    industry: DataTypes.STRING(30),

    addr:DataTypes.STRING(200),
    intro:DataTypes.STRING(200),
    telephone:DataTypes.STRING(20),
    email:DataTypes.STRING(100),
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'c_ecompany',
    validate: {
    },
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}