const system=require("../../system");
const Dao=require("../dao.base");
class EnttemplateDao extends Dao{
    constructor(){
        super(Dao.getModelName(EnttemplateDao));
    }

    async findIdsLikeName(name) {
        var result = [];
        if(!name) {
            return result;
        }

        var sql = "SELECT id FROM `c_enttemplate` WHERE NAME LIKE :nameLike";
        var list = await this.customQuery(sql, {nameLike: "%" + name + "%"});
        if(!list || list.length == 0) {
            return result;
        }

        for(var item of list) {
            result.push(item.id);
        }
        return result;
    }

    async findMapByIds(ids, attrs) {
        var result = {};
        if(!ids || ids.length == 0) {
            return result;
        }

        attrs = attrs || "*";
        var sql = "SELECT " + attrs + " FROM c_enttemplate where id IN (:ids) ";
        var list = await this.customQuery(sql, {ids:ids});
        if(!list || list.length == 0) {
            return result;
        }

        for(var item of list) {
            result[item.id] = item;
        }

        return result;
    }
}
module.exports=EnttemplateDao;
