var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);

class ProxyapplicantCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(ProxyapplicantCtl));
    this.userSve = system.getObject("service.userSve");
    this.epartneradvSve = system.getObject("service.epartneradvSve");
  }

  async advantage() {
    var dict = uiconfig.config.pdict.bpoAdvantage;
    var list = [];

    for (var id in dict) {
      list.push({
        id: id,
        name: dict[id]
      });
    }
    return system.getResult2(list);
  }

  async apply(queryobj, qobj, req) {
    var userName = super.trim(qobj.userName);
    var mobile = super.trim(qobj.mobile);
    var city = super.trim(qobj.city);
    var advList = qobj.advList || [];
    if (!userName) {
      return system.getErrResult2("请输入姓名");
    }
    if (userName.length > 20) {
      return system.getErrResult2("姓名不能超过20个字");
    }
    if (!mobile) {
      return system.getErrResult2("请输入手机号");
    }
    if (!/^1[23456789]\d{9}$/.test(mobile)) {
      return system.getErrResult2("手机号格式不正确");
    }

    if (city.length > 20) {
      return system.getErrResult2("城市太长了");
    }
    var applicant = await this.service.findOne({
      mobile: mobile,
      auditStatus: '1'
    });
    if (applicant) {
      return system.getErrResult2("您已经提交申请, 请耐心等待审核");
    }
    var puser = await this.userSve.findOne({
      mobile: mobile
    });
    if (puser) {
      return system.getErrResult2("您的手机号已注册");
    }

    applicant = {
      userName: userName,
      mobile: mobile,
      city: city,
      intro: "",
      owner_id: 0,
      auditStatus: '0',
      auditStatusName: '待审核',
      audit_id: 0,
      isEnabled: 1,
      advNames: advList.join(",")
    }
    var rs = await this.service.create(applicant);
    if (rs) {
      var id = rs.id;
      if (advList.length > 0) {
        for (var adv of advList) {
          this.epartneradvSve.create({
            epartner_id: id,
            name: adv
          });
        }
      }
    }
    return system.getResult2(1);
  }

  async pass(queryobj, qobj, req) {
    var id = qobj.id || 0;

    try {
      var rs = await this.service.auditPass(id, req.session.user.id);
      if (rs == -1) {
        return system.getErrResult2("该合伙人已审核");
      }

      if (rs == -2) {
        return system.getErrResult2("该合伙人账户已存在");
      }
    } catch (error) {
      console.error(error);
      return system.getErrResult2("审核失败, " + error.stack);
    }

    return system.getResult2("1");
  }

  async reject(queryobj, qobj, req) {
    var id = qobj.id || 0;

    var tc = await this.service.findById(id);
    if (tc.auditStatus != '0') {
      return system.getErrResult2("该合伙人已审核");
    }

    tc.audit_id = req.session.user.id;
    tc.auditStatus = '2';
    tc.auditStatusName = '审核驳回';
    await tc.save();

    return system.getResult2(tc);
  }
}
module.exports = ProxyapplicantCtl;