var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');

class EintentionCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(EintentionCtl));
    this.regionareaSve = system.getObject("service.regionareaSve");
    this.ecompanySve = system.getObject("service.ecompanySve");
    this.userSve = system.getObject("service.userSve");

  }
  async create(queryobj,qobj,req){
    if(req && req.session && req.session.user){
      // qobj.app_id=req.session.app.id;
      qobj.owner_id=req.session.user.id;
      qobj.owner_name=req.session.user.nickName;
      if(req.codepath){
        qobj.codepath=req.codepath;
      }
    }
    if (qobj.cityCode) {
      qobj.cityName = await this.regionareaSve.findNameByCode(qobj.cityCode);
    }

    var ecompany = await this.ecompanySve.findOne({name: qobj.name});
    if(ecompany && ecompany.owner_id != qobj.owner_id) {
      var user = await this.userSve.findById(ecompany.owner_id);
      var nickName = "直营人员";
      if(user) {
        nickName = user.nickName;
      }
      return system.getErrResult2("该客户已被" + nickName + "录入");
    }

    var repeat = await this.service.findOne({name:qobj.name});
    if(repeat) {
      return system.getErrResult2("该客户已被" + (repeat.owner_name || "") + "录入");
    }

    try {
      var rd=await this.service.create(qobj);
      return system.getResult2(rd,null);
    } catch (error) {
      if(error.name == 'SequelizeUniqueConstraintError') {
        return system.getErrResult2("该客户已录入");
      }
      return system.getErrResult2("你的网络繁忙，请稍候重试");
    }
  }
  async update(queryobj,qobj,req){
    if(req && req.session && req.session.user){
      qobj["update_id"]=req.session.user.id;
      qobj["update_name"]=req.session.user.nickName;
    }
    if(req.codepath){
      qobj.codepath=req.codepath;
    }

    var old = await this.service.findById(qobj.id) || {};
    if(old.name != qobj.name) {
      var ecompany = await this.ecompanySve.findOne({name: qobj.name});
      if(ecompany && ecompany.owner_id && ecompany.owner_id != old.owner_id) {
        var user = await this.userSve.findById(ecompany.owner_id);
        var nickName = "直营人员";
        if(user) {
          nickName = user.nickName;
        }
        return system.getErrResult2("该客户已被" + nickName + "录入");
      }
      var repeat = await this.service.findOne({name:qobj.name});
      if(repeat) {
        return system.getErrResult2("该客户已被" + (repeat.owner_name || "") + "录入");
      }
    }
    if (qobj.cityCode) {
      qobj.cityName = await this.regionareaSve.findNameByCode(qobj.cityCode);
    }
    try {
      var rd = await this.service.update(qobj);
      return system.getResult2(rd,null);
    } catch (error) {
      if(error.name == 'SequelizeUniqueConstraintError') {
        return system.getErrResult2("该客户已录入");
      }
      return system.getErrResult2("你的网络繁忙，请稍候重试");
    }
  }

  async validName(queryobj, qobj, req) {
    var loginid = req.session.user.id;

    var intention = await this.service.findOne({name:qobj.name});
    if(intention && intention.owner_id != loginid) {
      return system.getErrResult2("该客户已被" + (intention.owner_name || "") + "录入");
    }

    var ecompany = await this.ecompanySve.findOne({name: qobj.name});
    if(ecompany && ecompany.owner_id != loginid) {
      var user = await this.userSve.findById(ecompany.owner_id);
      var nickName = "直营人员";
      if(user) {
        nickName = user.nickName;
      }
      return system.getErrResult2("该客户已被" + nickName + "录入");
    }

    return system.getResult2(1);
  }

  async myList(queryobj, qobj, req) {
    var params = qobj.search || {};
    params.ownerIds = [req.session.user.id];
    return await this.queryList(params);
  } 

  async allList(queryobj, qobj, req) {
    var search = qobj.search || {};
    var loginUser = req.session.user;
    var roles = loginUser.Roles || [];
    var isZC = false;
    for(var r of roles) {
      if(r.code == 'zcry' || r.code == 'zcgl') {
        isZC = true;
        break;
      }
    }
    if(!loginUser.isAdmin && !isZC) {
      if(!req.session.myIds || req.session.myIds.length == 0) {
        return system.getResult2({count: 0, rows: []});
      }
      search.ownerIds = req.session.myIds;
    }
    return await this.queryList(qobj.search);
  }

  async queryList(params) {
    var params = params || {};
    this.doTimeCondition(params, ["createdBegin", "createdEnd"]);
    try {
      var page = await this.service.pageByCondition(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async assignUser(queryobj, qobj, req) {
    var loginuser = req.session.user;

    var id = qobj.id;
    var assignUserId = qobj.assignUserId;

    if(!id || !assignUserId) {
      return system.getErrResult2("分配错误，请重试");
    }

    try {
      var rs = await this.service.assignUser(id, assignUserId, loginuser.id);
      if(rs == -1) {
        return system.getErrResult2("意向不存在，请刷新重试");
      }
      return system.getResult2(rs);
      } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }
}
module.exports = EintentionCtl;