var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("web.oplogCtl");
const moment = require("moment");

class DKaggreementCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(DKaggreementCtl));

    this.utilesignbaoSve = system.getObject("service.utilesignbaoSve");

    this.excelClient = system.getObject("util.excelClient");
  }

  async aggreements(queryobj, qobj, req) {
    try {
      var list = await this.service.findAll();
      return system.getResult2(list);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async list(queryobj, qobj, req) {
    var params = qobj.search;
    try {
      var page = await this.service.pageByCondition(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async info(queryobj, qobj, req) {
    var id = Number(qobj.id);
    try {
      var info = await this.service.getInfo(id);
      if (info) {
        if (info.created_at) {
          info.created_at = moment(info.created_at).format("YYYY-MM-DD HH:mm:ss");
        }
      }
      return system.getResult2(info);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async mysave(queryobj, qobj, req) {
    try {
      var aggreement = null;
      let id = qobj.id;
      if (id) {
        aggreement = await this.service.findById(id);
      }

      var oldfilepath = "";
      if (aggreement) {
        oldfilepath = aggreement.filepath;
        //修改
        aggreement.name = qobj.name || "";
        aggreement.filepath = qobj.filepath || "";
        aggreement.callbackurl = qobj.callbackurl || "";
        aggreement.remark = qobj.remark || "";
        aggreement.ctlname = qobj.ctlname || "";
        aggreement.homeurl = qobj.homeurl || "";
        aggreement.signinforouter = qobj.signinforouter || "";

        await aggreement.save();
      } else {
        //新增
        console.log("new++++++++++++++++++++++++++++++++++++");
        aggreement = {};
        aggreement.name = qobj.name || "";
        aggreement.filepath = qobj.filepath || "";
        aggreement.callbackurl = qobj.callbackurl || "";
        aggreement.remark = qobj.remark || "";
        aggreement.ctlname = qobj.ctlname || "";
        aggreement.homeurl = qobj.homeurl || "";
        aggreement.signinforouter = qobj.signinforouter || "";

        aggreement = await this.service.create(aggreement);
      }

      // 调用e签宝接口生成aggreement
      if (aggreement.filepath && aggreement.filepath != oldfilepath) {
        try {
          let aggreementRs = await this.utilesignbaoSve.createEntTemplate(aggreement.filepath, aggreement.name, "etemplateCtl");

          logCtl.info({
            optitle: "e签宝===>保存协议信息aggreement",
            op: "app/base/controller/impl/dkaggreementCtl/mysave",
            content: "参数：filepath=" + aggreement.filepath + ";name=" + aggreement.name + "; result : " + JSON.stringify(aggreementRs),
            clientIp: ""
          });

          if (aggreementRs && aggreementRs.code == 1 && aggreementRs.data) {
            aggreement.filekey = aggreementRs.data.fileKey;
            aggreement.templateid = aggreementRs.data.templateId;
            await aggreement.save();
          } else {
          }
        } catch (e) {
          console.error(e);
        }
      }

      return system.getResult2(aggreement, null);
    } catch (e) {
      console.log("-----------------------------e");
      console.log(e);
      return {
        code: -1
      }
    }
  }
}
module.exports = DKaggreementCtl;