const system=require("../system");
const settings=require("../../config/settings");

class CtlBase{
  constructor(sname){
     this.serviceName=sname;
     this.service=system.getObject("service."+sname);
     this.cacheManager=system.getObject("db.cacheManager");
     this.md5 = require("MD5");
  }
  notify(req,msg){
    if(req.session){
      req.session.bizmsg=msg;
    }
  }
  async findOne(queryobj,qobj){
    var rd=await this.service.findOne(qobj);
    return system.getResult2(rd,null);
  }
  async findAndCountAll(queryobj,obj,req){
    obj.codepath=req.codepath;

    if(req.session.user){
      obj.uid=req.session.user.id;
      obj.appid=req.session.user.app_id;
      obj.onlyCode=req.session.user.unionId;
      obj.ukstr=req.session.user.app_id+"￥"+req.session.user.id+"￥"+req.session.user.nickName+"￥"+req.session.user.headUrl;
    }
    var apps=await this.service.findAndCountAll(obj);
    return system.getResult2(apps,null);
  }
  async refQuery(queryobj,qobj){
    var rd=await this.service.refQuery(qobj);
    return system.getResult2(rd,null);
  }
  async bulkDelete(queryobj,ids){
    var rd=await this.service.bulkDelete(ids);
    return system.getResult2(rd,null);
  }
  async delete(queryobj,qobj){
    var rd=await this.service.delete(qobj);
    return system.getResult2(rd,null);
  }
  async create(queryobj,qobj,req){
    if(req && req.session && req.session.app){
      qobj.app_id=req.session.app.id;
      qobj.onlyCode=req.session.user.unionId;
      if(req.codepath){
        qobj.codepath=req.codepath;
      }
    }
    var rd=await this.service.create(qobj);
    return system.getResult2(rd,null);
  }
  async update(queryobj,qobj,req){
    if(req && req.session && req.session.user){
      qobj.onlyCode=req.session.user.unionId;
    }
    if(req.codepath){
      qobj.codepath=req.codepath;
    }
    var rd=await this.service.update(qobj);
    return system.getResult2(rd,null);
  }
  static getServiceName(ClassObj){

    return ClassObj["name"].substring(0,ClassObj["name"].lastIndexOf("Ctl")).toLowerCase()+"Sve";
  }
  async initNewInstance(queryobj,req){
    return system.getResult2({},null);
  }
  async findById(oid){
    var rd=await this.service.findById(oid);
    return system.getResult2(rd,null);
  }
  trim(o) {
    if(!o) {
      return "";
    }
    return o.toString().trim();
  }

  doTimeCondition(params, fields) {
    if (!params || !fields || fields.length == 0) {
      return;
    }

    for (var f of fields) {
        if (params[f]) {
        var suffix = this.endWith(f, 'Begin') ? " 00:00:00" : " 23:59:59";
        params[f] =  params[f] + suffix;
      }
    }
  }

  encryptPasswd(passwd) {
    if(!passwd) {
			throw new Error("请输入密码");
		}
		var md5 = this.md5(passwd + "_" + settings.salt);
		return md5.toString().toLowerCase();
  }

  endWith(source, str){
    if(!str  || !source || source.length == 0 || str.length > source.length) {
      return false;
    }
    return source.substring(source.length - str.length) == str;
  }
    
    
  // async doExecute(methodname,params){
  //   var result= await this[methodname](params);
  //   return system.getResult2(result,null);
  // }
}
module.exports=CtlBase;
