module.exports={
  "bizName":"apps",
  "list":{
    columnMetaData:[
      {"width":"100","label":"应用名称","prop":"name","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"应用标识","prop":"appid","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"应用标识","prop":"secret","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"认证页面","prop":"authPage","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"跳转页面","prop":"homePage","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"API调用次数","prop":"apiCallCount","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"API应收余额","prop":"amount","isShowTip":true,"isTmpl":false},
      {"width":"100","label":"logo","prop":"logoUrl","isShowTip":false,"isTmpl":true,"isBtns":false},
      {"width":"100","label":"应用图形","prop":"appimgUrl","isShowTip":false,"isTmpl":true,"isBtns":false},
      {"width":"null","label":"操作","name":"null","isShowTip":false,"isTmpl":true,"isBtns":"true"},
    ]
  },
  "form":[
    {
      "title":"应用名称",
      "validProp":"name",
      "rule": [
           { "required": true, "message": '请输入应用名称', "trigger": 'blur' },
       ],
       ctls:[
         {"type":"input","label":"应用名称","prop":"name","placeHolder":"应用名称","style":""},
       ]
    },
    {
      "title":"应用ID",
       "ctls":[
         {"type":"input","label":"应用ID","prop":"appid","disabled":true,"placeHolder":"","style":""},
       ]
    },
    {
      "title":"密钥",
       "ctls":[
         {"type":"input","label":"应用ID","prop":"secret","disabled":false,"placeHolder":"","style":""},
       ]
    },
    {
      "title":"认证页面",
       "ctls":[
         {"type":"input","label":"认证页面","prop":"authPage","disabled":false,"placeHolder":"","style":""},
       ]
    },
    {
      "title":"跳转页面",
       "ctls":[
         {"type":"input","label":"跳转页面","prop":"homePage","disabled":false,"placeHolder":"","style":""},
       ]
    },
    {
      "title":"logo",
       "ctls":[
         {"type":"upload","label":"logo","prop":"logoUrl","placeHolder":"请输入标题","style":""},
       ]
    },
    {
      "title":"应用图形",
       "ctls":[
         {"type":"upload","label":"右图","prop":"appimgUrl","placeHolder":"请输入标题","style":""},
       ]
    },
  ],
  "search":[
    {
      "title":"应用名称",
       ctls:[
         {"type":"input","label":"应用名称","prop":"name","placeHolder":"应用名称","style":""},
       ]
    },
    {
      "title":"应用KEY",
       "ctls":[
         {"type":"input","label":"应用ID","prop":"appid","placeHolder":"","style":""},
       ]
    },
  ],
  "auth":{
    "add":[
      {"icon":"el-icon-plus","title":"新增","type":"default","key":"new","isOnGrid":true},
      {"icon":"el-icon-save","title":"保存","type":"default","key":"save","isOnForm":true},
    ],
    "edit":[
      {"icon":"el-icon-edit","title":"修改","type":"default","key":"edit","isInRow":true},
      {"icon":"el-icon-edit","title":"详情","type":"default","key":"detail","isInRow":true},
    ],
    "delete":[
      {"icon":"el-icon-remove","title":"删除","type":"default","key":"delete","isInRow":true},
    ],
    "common":[
      {"icon":"el-icon-cancel","title":"取消","type":"default","key":"cancel","isOnForm":true},
    ],
  }
}
