const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class UsersService extends ServiceBase {
  constructor() {
    super("operator", ServiceBase.getDaoName(UsersService));
  }

  async findUserInfoByPhone(params){//根据电话号码获取用户信息
    var phone_no = params.phone_no;
    var users = await this.dao.findUserInfoByPhone(phone_no);
    if (users.length > 0){
      return system.getResult(users[0]);
    }
    else{
      return system.getResult(null,"不存在相关信息!");

    }
  }

  async findUserInfo(obj){//根据条件返回用户信息
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    var where = {};
    if (obj.id){
      where.id = obj.id;
    }
    if (obj.user_name){
      where.user_name = obj.user_name;
    }
    if (obj.user_type && obj.user_type != "全部"){
      where.user_type = obj.user_type;
    }
    if (obj.phone_no){
      where.phone_no = obj.phone_no;
    }
    if (obj.com_name){
      where.com_name = obj.com_name;
    }
    if (obj.user_address && obj.user_address != "全部"){
      where.user_address = {[this.db.Op.like]: "%" + obj.user_address + "%"};
    }
    if (obj.status_name && obj.status_name != "全部"){
      where.status_name = obj.status_name;
    }

    if (obj.find_type == 0){
      if (obj.real_status && obj.real_status != "全部"){
        if (obj.real_status == "未实名"){
          where.user_name = null;
        }
        else if (obj.real_status == "个人认证中"){
          where.is_real = 0;
        }
        else if (obj.real_status == "个人已认证"){
          where.is_real = 1;
        }
        else if (obj.real_status == "个人未通过"){
          where.is_real = 2;
        }
        else if (obj.real_status == "企业认证中"){
          where.is_com = 0;
        }
        else if (obj.real_status == "企业已认证"){
          where.is_com = 1;
        }
        else if (obj.real_status == "企业未通过"){
          where.is_com = 2;
        }
      }

    }
    else if (obj.find_type == 1){
      where.com_type = 1;
      if (obj.real_status && obj.real_status != "全部"){
        if (obj.real_status == "待审核"){
          where.is_real = 0;
        }
        else if (obj.real_status == "已通过"){
          where.is_real = 1;
        }
        else if (obj.real_status == "已拒绝"){
          where.is_real = 2;
        }
      }
    }
    else if (obj.find_type == 2){
      where.com_type = 2;
      if (obj.real_status && obj.real_status != "全部"){
        if (obj.real_status == "待审核"){
          where.is_com = 0;
        }
        else if (obj.real_status == "已通过"){
          where.is_com = 1;
        }
        else if (obj.real_status == "已拒绝"){
          where.is_com = 2;
        }
      }
    }

    try {
      var sqlwhere = {
          where: where,
          //order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      //console.log(e);
      return system.getResult(null,"操作失败");
    }
  }



  async findUserInfoByid(user_id){
    var users = await this.dao.findUserInfoByid(user_id);
    // if (users.length > 0){
    //   return system.getResult(users[0]);
    // }
    // else{
    //   return system.getResult(null,"不存在相关信息!");

    // }
    return users;
  }

  async findAllList(obj){//获取全部用户信息，返回符合条件的列表
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sqlwhere = {
          //order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      return system.getResult(null,"操作失败");
    }
  }

  async SaveUserInfo(params){//添加和更新数据库里的信息
    var id = params.id;
    var users;
    if (id){
      users = await this.dao.findById(id);
      users.phone_no = params.phone_no;
      users.com_type = params.com_type;
      users.com_name = params.com_name;
      users.user_type = params.user_type;
      users.user_identity = params.user_identity;
      users.user_name = params.user_name;
      users.id_card = params.id_card;
      users.user_photo = params.user_photo;
      users.cert_no = params.cert_no;
      users.user_post = params.cert_post;
      users.status_type = params.status_type;
      users.status_name = params.status_name;
      users.legal_name = params.legal_name;
      users.bus_term = params.bus_term;
      users.user_address = params.user_address;
      users.user_path = params.user_path;
      users.com_path = params.com_path;
      users.card_path = params.card_path;
      users.cert_path = params.cert_path;
      users.reg_time = params.reg_time;
      users.cattes_time = params.cattes_time;
      users.uattes_time = params.uattes_time;
      users.memo1_text = params.memo1_text;
      users.memo2_text = params.memo2_text;
      users.is_real = params.is_real;
      users.is_com = params.is_com;
      users = await users.save();
      users = await this.dao.findById(id);
    }
    else{
      users = await this.dao.create(params);
      
    }
    return system.getResult(users.dataValues);
  }

  async updateUserInfo(obj){
    try{
      var whereobj = {where:{id: obj.id}};
      var setobj = {};
      if (obj.phone_no){
        setobj.phone_no = obj.phone_no;
      }
      if (obj.com_type){
        setobj.com_type = obj.com_type;
      }
      if (obj.com_name){
        setobj.com_name = obj.com_name;
      }
      if (obj.user_type){
        setobj.user_type = obj.user_type;
      }
      if (obj.user_identity){
        setobj.user_identity = obj.user_identity;
      }
      if (obj.user_name){
        setobj.user_name = obj.user_name;
      }
      if (obj.id_card){
        setobj.id_card = obj.id_card;
      }
      if (obj.user_photo){
        setobj.user_photo = obj.user_photo;
      }
      if (obj.cert_no){
        setobj.cert_no = obj.cert_no;
      }
      if (obj.user_post){
        setobj.user_post = obj.user_post;
      }
      if (obj.status_name){
        setobj.status_name = obj.status_name;
        if (obj.status_name == "正常"){
          setobj.status_type = 1;
        }
        else if (obj.status_name == "冻结"){
          setobj.status_type = 2;
        }
        else if (obj.status_name == "解冻"){
          setobj.status_type = 3;
        }
      }
      if (obj.legal_name){
        setobj.legal_name = obj.legal_name;
      }
      if (obj.bus_term){
        setobj.bus_term = obj.bus_term;
      }
      if (obj.user_address){
        setobj.user_address = obj.user_address;
      }
      if (obj.user_path){
        setobj.user_path = setobj.user_path;
      }
      if (obj.com_path){
        setobj.com_path = obj.com_path;
      }
      if (obj.card_path){
        setobj.card_path = obj.card_path;
      }
      if (obj.cert_path){
        setobj.cert_path = obj.cert_path;
      }
      if (obj.real_status){
        if (obj.real_status == "未审核"){
          setobj.is_real = 0;
        }
        else if (obj.real_status == "通过"){
          setobj.is_real = 1;
        }
        else if (obj.real_status == "拒绝"){
          setobj.is_real = 2;
        }

        if (obj.real_status != "未审核"){
          setobj.uattes_time = (new Date()).Format("yyyy-MM-dd");
          if (obj.memo1_text){
            setobj.memo1_text = obj.memo1_text;
          }
        }
      }
      if (obj.com_status){
        if (obj.com_status == "未审核"){
          setobj.is_com = 0;
        }
        else if (obj.com_status == "通过"){
          setobj.is_com = 1;    
        }
        else if (obj.com_status == "拒绝"){
          setobj.is_com = 2;
        }

        if (obj.com_status != "未审核"){
          setobj.cattes_time = (new Date()).Format("yyyy-MM-dd");
          if (obj.memo2_text){
            setobj.memo2_text = obj.memo2_text;
          }
        }
      }
      var self = this;
      var v = await this.db.transaction(async function (t) {
        await self.dao.updateByWhere(setobj,whereobj,t);
      });
      
      return 1;
    }
    catch (e){
      console.log(e);
      return 0;
    }
  }

  async updateAccountstatus(obj){//更新账户状态信息
    try{
      var whereobj = {where:{id: obj.id}};
      var setobj = {};
      setobj.status_name = obj.cur_status;
      if (obj.cur_status == "正常"){
        setobj.status_type = 1;
      }
      else if (obj.cur_status == "冻结"){
        setobj.status_type = 2;
      }
      else if (obj.cur_status == "解冻"){
        setobj.status_type = 3;
      }

      var self = this;
      var v = await this.db.transaction(async function (t) {
        await self.dao.updateByWhere(setobj,whereobj,t);
      });

      return 1;

    }
    catch (e){
      console.log(e);
      return 0;
    }
  }

  async updateUserstatus(obj){//更新用户实名认证信息
    try{
      var whereobj = {where:{id: obj.id}};
      var setobj = {};
      setobj.uattes_time = (new Date()).Format("yyyy-MM-dd");
      if (obj.cur_status == "未认证"){
        setobj.is_real = 0;
      }
      else if (obj.cur_status == "已认证"){
        setobj.is_real = 1;
      }
      else if (obj.cur_status == "未通过"){
        setobj.is_real = 2;
      }

      if (obj.memo_text){
        setobj.memo1_text = obj.memo_text;
      }

      var self = this;
      var v = await this.db.transaction(async function (t) {
        await self.dao.updateByWhere(setobj,whereobj,t);
      });

      return 1;

    }
    catch (e){
      console.log(e);
      return 0;
    }
  }

  async updateCompanystatus(obj){//更新企业实名认证信息
    try{
      var whereobj = {where:{id: obj.id}};
      var setobj = {};
      setobj.cattes_time = (new Date()).Format("yyyy-MM-dd");
      if (obj.cur_status == "未认证"){
        setobj.is_com = 0;
      }
      else if (obj.cur_status == "已认证"){
        setobj.is_com = 1;
      }
      else if (obj.cur_status == "未通过"){
        setobj.is_com = 2;
      }

      if (obj.memo_text){
        setobj.memo2_text = obj.memo_text;
      }

      var self = this;
      var v = await this.db.transaction(async function (t) {
        await self.dao.updateByWhere(setobj,whereobj,t);
      });

      return 1;

    }
    catch (e){
      console.log(e);
      return 0;
    }
  }



}
module.exports = UsersService;

// var tesk = new UsersService();
// var par = {
//   // phone_no:"333",
//   // user_type:"招人方",
//   // status_type:1,
//   // status_name:"正常",
//   // reg_time:(new Date()).Format("yyyy-MM-dd")
//   id = 3
// };
// var user_id = 3; 
// tesk.findUserInfoByid(user_id).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
