const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class RecruitService extends ServiceBase {
  constructor() {
    super("operator", ServiceBase.getDaoName(RecruitService));
  }

  async SaveRecruitInfo(params){//添加或更新招聘信息
    var id = params.id;
    var recruit;
    if (id){
      recruit = await this.dao.findById(id);
      recruit.recruit_name = params.recruit_name;
      recruit.recruit_type = params.recruit_type;
      recruit.recruit_count = params.recruit_count;
      recruit.pay_type = params.pay_type;
      recruit.pay_name = params.pay_name;
      recruit.pay_unit = params.pay_unit;
      recruit.work_duration = params.work_duration;
      recruit.basic_salary = params.basic_salary;
      recruit.compre_salary = params.compre_salary;
      recruit.rfee_type = params.rfee_type;
      recruit.rfee_unit = params.rfee_unit;
      recruit.rfee_duration = params.rfee_duration;
      recruit.rfee_time = params.rfee_time;
      recruit.age_range = params.age_range;
      recruit.work_address = params.work_address;
      recruit.publish_date = params.publish_date;
      recruit.end_date = params.end_date;
      recruit.pic_path = params.pic_path;
      recruit.recrui_require = params.recrui_require;
      recruit.phone_no = params.phone_no;
      recruit.counter_mark = params.counter_mark;
      recruit.user_id = params.user_id;
      recruit.cur_type = params.cur_type;
      recruit.cur_status = params.cur_status;
      recruit = await recruit.save();
      recruit = await this.dao.findById(id);
    }
    else{
      recruit = await this.dao.create(params);
    }

    return system.getResultSuccess(recruit);
  }

  async findAllList(obj){//获取全部招聘信息，返回符合条件的列表
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sqlwhere = {
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      //var list = await this.dao.model.findAll(sqlwhere);
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }
  }

  async findListByUserid(obj){//获取userid招聘信息，返回符合条件的列表
    if (!obj.user_id){
      return system.getResult(null,"参数错误!");
    }
    var user_id = obj.user_id;
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sqlwhere = {
          where: {user_id:user_id},
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }
  }

  async findListByName(obj){//获取岗位名称招聘信息，返回符合条件的列表
    //return await this.dao.findListByName(obj);
    if (!obj.recruit_name){
      return system.getResult(null,"参数错误!");
    }
    var recruit_name = obj.recruit_name;
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try{
      var sqlwhere = {
        where:{recruit_name:{[this.db.Op.like]: "%" + recruit_name + "%"}},
        order: [["publish_date", 'desc']],
        limit: pageSize,
        offset: (currentPage - 1) * pageSize,
        raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }
    catch{
      return system.getResult(null,"操作失败");
    }
  }

  async findListByMark(obj){//获取标签招聘信息，返回符合条件的列表
    if (!obj.counter_mark){
      return system.getResult(null,"参数错误!");
    }
    var counter_mark = obj.counter_mark;
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sqlwhere = {
          where:{counter_mark:{[this.db.Op.like]: "%" + counter_mark + "%"}},
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      return system.getResult(null,"操作失败");
    }
  }

  async findRecruitByWhere(obj){//根据条件获取招聘信息
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    var where = {};
    if (obj.id){
      where.id = obj.id;
    }
    if (obj.recruit_name){
      where.recruit_name = obj.recruit_name;
    }
    if (obj.recruit_type && obj.recruit_type != "全部"){
      where.recruit_type = obj.recruit_type;
    }
    if (obj.pay_name && obj.pay_name != "全部"){
      where.pay_name = obj.pay_name;
    }
    if (obj.rfee_type && obj.rfee_type != "全部"){
      if (obj.rfee_type == "面议"){
        where.rfee_type = 0;
      }
      else if (obj.rfee_type == "时返"){
        where.rfee_type = 3;
      }
      else if (obj.rfee_type == "月返"){
        where.rfee_type = 1;
      }
      else if (obj.rfee_type == "日返"){
        where.rfee_type = 2;
      }
      else if (obj.rfee_type == "一次返"){
        where.rfee_type = 4;
      }
    }
    if (obj.work_address && obj.work_address != "全部"){
      where.work_address = {[this.db.Op.like]: "%" + obj.work_address + "%"};
    }
    if (obj.user_id){
      where.user_id = obj.user_id;
    }
    
    if (obj.phone_no){
      where.phone_no = obj.phone_no;
    }
    if (obj.cur_status && obj.cur_status != "全部"){
      where.cur_status = obj.cur_status;
    }

    try {
      var sqlwhere = {
          where: where,
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAndCountAll(sqlwhere) || [];
      return system.getResult(list);
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }

  }

  async updatestatus(obj){//更新状态信息
    try{
      var whereobj = {where:{id: obj.id}};
      var setobj = {};
      setobj.cur_status = obj.cur_status;
      if (obj.cur_status == "展示中"){
        setobj.cur_type = 1;
      }
      else if (obj.cur_status == "已下架"){
        setobj.cur_type = 2;
      }
      else if (obj.cur_status == "已过期"){
        setobj.cur_type = 3;
      }
      else if (obj.cur_status == "审核未通过"){
        setobj.cur_type = 4;
      }

      var self = this;
      var v = await this.db.transaction(async function (t) {
        await self.dao.updateByWhere(setobj,whereobj,t);
      });
      
      return 1;
    }
    catch (e){
      console.log(e);
      return 0;
    }
  }

  


}
module.exports = RecruitService;

// var tesk = new RecruitService();
// var par = {
//   id:1,
//   cur_type:1,
//   recruit_name:"物流"
// };
// tesk.findListByName(par).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
