var System=require("../../system");
var settings=require("../../../config/settings");
const logCtl=System.getObject("web.oplogCtl");
//内容过滤查询
class UtilsTmService{
  constructor(){
    this.reqEsAddr=settings.reqEsAddr();
  }
  async getSynonymsList(obj,opName){
    var result={
       code: 1,
       message: "success",
       data: []
    };
    var name=obj.name==null||obj.name==""||obj.name=="undefined"?"":obj.name;
    if(name==""){
      result.code=-101;
      result.message="name参数有误";
      return result;
    }
     var reqUrl=this.reqEsAddr+"bigdata_synonyms_filter/_search";
     var params ={
          "query" : {
              "term" : { "name" : name }
          },
         "from": 0,
         "size": 200,
         "_source": [
         "name"
         ]
      };
    var tResult=await this.returnResult(params,reqUrl,opName,"getSynonymsList");
    if(tResult.status!=0){
      result.code=-200;
      result.message="查询错误";
      return result;
    }
    var tArry=[name];
    if(tResult.data.length>0){
      for (var i = 0; i < tResult.data.length; i++) {
        var tmp=tResult.data[i];
        if(tmp!=null && tmp!="" && tmp.name!=null && tmp.name!=""){
          for (var j = 0; j < tmp.name.length; j++) {
            var tmpName=tmp.name[j];
            var indexLength=tArry.findIndex(v => v ===tmpName);
            if(indexLength<0){
              tArry.push(tmpName);
            }
          }
        }
      }
    }
    result.data=tArry;
    return result;
  }

  async getSimilarList(obj,opName){
      var result={
         code: 1,
         message: "success",
         data: []
      };
      var name=obj.name==null||obj.name==""||obj.name=="undefined"?"":obj.name;
      if(name==""){
        result.code=-101;
        result.message="name参数有误";
        return result;
      }
       var reqUrl=this.reqEsAddr+"bigdata_similar_filter/_search";
       var params ={
            "query" : {
                "term" : { "name" : name }
            },
           "from": 0,
           "size": 200,
           "_source": [
           "name"
           ]
        };
      var tResult=await this.returnResult(params,reqUrl,opName,"getSimilarList");
      if(tResult.status!=0){
        result.code=-200;
        result.message="查询错误";
        return result;
      }
      var tArry=[name];
      if(tResult.data.length>0){
        for (var i = 0; i < tResult.data.length; i++) {
          var tmp=tResult.data[i];
          if(tmp!=null && tmp!="" && tmp.name!=null && tmp.name!=""){
            for (var j = 0; j < tmp.name.length; j++) {
              var tmpName=tmp.name[j];
              var indexLength=tArry.findIndex(v => v ===tmpName);
              if(indexLength<0){
                tArry.push(tmpName);
              }
            }
          }
        }
      }
      result.data=tArry;
      return result;
  }

  async returnResult(params,reqUrl,opClassName,opMethod){
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(params,reqUrl);
      var j=JSON.parse(rtn.stdout);
      if(j.status!=undefined){
        //执行查询有错
        //日志记录
        logCtl.error({
           optitle:"ES内容过滤查询opClassName="+opClassName+"，opMethod="+opMethod+"ES执行异常error",
           op:"base/service/impl/tmutilsSve.js",
           content:rtn.stdout,
           clientIp:""
         });
         return System.getResult2(null,null,null,"查询出错");
      }
      return System.getResult3(j.hits,null);
    }catch(e){
      //日志记录
      logCtl.error({
         optitle:"ES内容过滤查询opClassName="+opClassName+"，opMethod="+opMethod+"操作异常异常error",
         op:"base/service/impl/tmutilsSve.js",
         content:e.stack,
         clientIp:""
       });
      return System.getResult2(null,null,null,"查询异常");
    }
  }
}
module.exports=UtilsTmService;
