const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {//产品类型-二类名称
  var base = require("../basemodel/codenamebase")(db, DataTypes);
  return db.define("producttype", Object.assign({
    orderNo: {//排序
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    isSystem: {//是否系统数据,0否，1是
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    // itemType: {
    //   //项目类型:ip:商标服务,pa:专利服务,ic:版权服务,icbc:工商注册,iso:海外业务,common:增值服务,zscq:知识产权,cwfw:财务服务,hyzz:行业资质,gqzr:股权转让,xzsp:行政审批
    //   type: DataTypes.ENUM,
    //   values: Object.keys(uiconfig.config.pdict.productCata),
    //   set: function (val) {
    //     this.setDataValue("itemType", val);
    //     this.setDataValue("itemTypeName", uiconfig.config.pdict.productCata[val]);
    //   },
    //   defaultValue: "ip",
    // },
    itemType: {
      type: DataTypes.STRING,
    },
    itemTypeName: {//服务类型名称
      type: DataTypes.STRING,
    },
    pid: {//父id
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    iconUrl: DataTypes.STRING(500),//产品图标地址   
    isPubed: {//是否可以交易，0不发布，1发布，默认为1
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    }, 
    oneIconUrl: DataTypes.STRING(500),//产品大类图标地址        
    oneMoblieIconUrl: DataTypes.STRING(500),//产品大类移动端图标地址     
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 's_producttype',
      validate: {
      }
    });
}

