const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/codenamebase")(db, DataTypes);
  return db.define("icpcustomerinfo", Object.assign({
    //基类name法人企业或机构名称 
    //基类code为统一社会信用代码或机构代码
    customerTypeName: DataTypes.STRING,//法人类型
    customerType: {//法人类型 { "enterprise": "企业法人", "socialorganization": "社会组织法人","institutional":"事业单位法人" }
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.icp_customer_type),
      set: function (val) {
        this.setDataValue("customerType", val);
        this.setDataValue("customerTypeName", uiconfig.config.pdict.icp_customer_type[val]);
      }
    },
    customerName: DataTypes.STRING,//企业法定代表人姓名
    credentialsTypeName: DataTypes.STRING,//企业法定代表人证件类型
    credentialsType:{//企业法定代表人证件类型 {"idcard":"身份证","passport":"护照","gaidcard":"港澳居民往来内地通行证或港澳身份证","tidcard":"台湾居民往来大陆通行证或台湾身份证","officerscard":"中国人民解放军军官证"}
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.icp_credentials_type),
      set: function (val) {
        this.setDataValue("credentialsType", val);
        this.setDataValue("credentialsTypeName", uiconfig.config.pdict.icp_credentials_type[val]);
      }
    },
    legalRepresentativeCertificateNo: DataTypes.STRING(50),//法定代表人证件号
    legalRepresentativeCertificatePic:DataTypes.STRING,//证件扫描件
    businessLicensePic: DataTypes.STRING,//营业执照图片   
    notes: DataTypes.STRING,//备注
    isLastOp: {//是否最后的操作，0否，1是，默认为1
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    owner_id: DataTypes.INTEGER,
    applyAddr: DataTypes.STRING,//申请地址
    valueAddedTelecomBusinessApplicationForm: DataTypes.STRING,//增值电信业务申请表 
    naturalPersonShareholderIdCard: DataTypes.STRING,//自然人股东身份证   
    trusteeshipAgreementAndIDC: DataTypes.STRING,//托管协议及IDC证   
    domainNameCertificate: DataTypes.STRING,//域名证书   
    paymentAgreementAndLicense: DataTypes.STRING,//支付协议及支付牌照  =====>社保人员及社保证明 
    capitalFlowDesAndMerchantPresenceTemp: DataTypes.STRING,//资金流向说明及商家入驻模板===>盖章材料返回
  },base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      tableName: 'biz_icpcustomerinfo',
      validate: {

      },
      indexes: [
      ]
    });
}
