const system=require("../../system");
const Dao=require("../dao.base");
class TmOfficialDao extends Dao{
  constructor(){
    super(Dao.getModelName(TmOfficialDao));
  }
  extraModelFilter(){
    return {
      "key":"include","value":[
        {model:this.db.models.trademark,include:{ model: this.db.models.order,include:{ model: this.db.models.customerinfo}}}
      ]
    };
  }

  async findAndCountAll(obj,t){
    var orderNum=null;
    var trademarkName=null;
    var tmRegistNum=null;
    var customer=null;
    var productTypeName=null;
    if(obj.search.trademarkName){
      trademarkName=obj.search.trademarkName
      delete obj.search.trademarkName;
     }
    if(obj.search.orderNum){
      orderNum=obj.search.orderNum
      delete obj.search.orderNum;
     }
     if(obj.search.tmRegistNum){
      tmRegistNum=obj.search.tmRegistNum
      delete obj.search.tmRegistNum;
     }
     if(obj.search.customer){
      customer=obj.search.customer
      delete obj.search.customer;
     }
     if(obj.search.productTypeName){
      productTypeName=obj.search.productTypeName
      delete obj.search.productTypeName;
     }
    var qc = this.buildQuery(obj);

    qc["include"]=[ { model: this.db.models.trademark, where: {},include:[{ model: this.db.models.order, where: {},include:[{ model: this.db.models.customerinfo, where: {}}]}]},{ model: this.db.models.user,as: 'createuser',where: {}}];
    if(obj.codepath.indexOf("myarcmag")>=0 ){
       qc.include[0].include[0].where[this.db.Op.or]=[
        {createuser_id:obj.user.id},{mobile:obj.user.mobile},
      ];
    }
    if(orderNum){
      qc.include[0].include[0].where["code"]=orderNum;
    }
    if(productTypeName){
      qc.include[0].include[0].where["productTypeName"]=productTypeName;
    }
    if(trademarkName){
      qc.include[0].where["name"]=trademarkName;
    }
    if(tmRegistNum){
      qc.include[0].where["tmRegistNum"]=tmRegistNum;
    }
    if(customer){
      qc.include[0].include[0].include[0].where["name"]=customer;
    }
    var apps = await this.model.findAndCountAll(qc);
    var aggresult = await this.findAggs(obj, qc);
    var rtn = {};
    rtn.results = apps;
    rtn.aggresult = aggresult;
    return rtn;
  }
  extraWhere(obj,w,qc,linkAttrs){
    var showAll = false;
    var user = obj.user;
    if(user && (user.isAdmin || user.isSuper)){
      showAll=true;
    }
    if(!showAll){
      var roles = obj.user.Roles;
      for(var i=0;i<roles.length;i++){
        var code = roles[i].code;
        if(code && (code=="bizhostman" || code=="boss" || code=="productmag")){
          showAll=true;
        }
      }
    }
    if(!showAll){
      w["createuser_id"] = obj.user.id;
    }
    if(obj.codepath && obj.codepath!=""){
     //  if(obj.codepath.indexOf("userarch")>0){//说明是应用管理员的查询
     //    console.log(obj);
     //     w["app_id"]=obj.appid;
     //  }
    }
    if(linkAttrs.length>0){
      var search=obj.search;
      var lnkKey=linkAttrs[0];
      var strq="$"+lnkKey.replace("~",".")+"$";
      w[strq]= {[this.db.Op.like]:"%"+search[lnkKey]+"%"};

    }
    return w;
 }
}
module.exports=TmOfficialDao;
