var system = require("../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl = system.getObject("web.oplogCtl");
class ProducttypeCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(ProducttypeCtl));
    this.companySve = system.getObject("service.companySve");
  }
  async initNewInstance(queryobj, req) {
    var rtn = {};
    var vcode = await this.service.getBusUid("lx");
    rtn.code = vcode;
    return system.getResult2(rtn, null);
  }
  //通过大类ip获取产品类型列表中的大类名称---暂时没有用到
  async getProductType(obj, req) {
    if (req) {
      try {
        if (req.pid == 0) {
          return { code: -100, msg: "大类", name: "大类" };
        }
        var result = await this.service.getTypeOneByCompanyId(req, 1);
        if (result && result.code == 1 && result.data.length > 0) {
          var index = result.data.findIndex(f => f.id == req.pid);
          if (index >= 0) {
            return { code: 1, name: result.data[index].name, msg: "ok" };
          }
        }
        return { code: -100, msg: "暂无信息", name: "---" };
      } catch (error) {
        return { code: -200, msg: "操作失败" };
      }
    } else {
      return { code: -101, msg: "参数错误" };
    }
  }
  //获取产品一类列表及其产品---代下其他订单使用
  async getTypeOneByCompanyId(obj, req) {
    var user = req.session.user;
    if (user) {
      obj["company_id"] = user.company_id;
      try {
        var list = await this.service.getTypeOneByCompanyId(obj, 3);
        return list;
      } catch (error) {
        return { code: -100, msg: "操作失败" };
      }
    } else {
      return { code: -101, msg: "用户数据为空" };
    }
  }

  //获得某一公司下的产品大类信息
  async getProductTypeList(gobj, pobj, req) {
    try {
      logCtl.error({
        optitle: "获得某一公司下的产品大类信息===req",
        op: "/igirl-web/app/base/controller/impl/producttypeCtl.js/getProductTypeList",
        content: req.companyid+"++++"+req.hostname,
        clientIp: ""
      });
      var companyId = req.companyid || "";
      var hostname = req.hostname;
      if (!companyId) {
        var item = await this.companySve.getCompanyByHostname(hostname);
        if (item) {
          companyId = item.id;
        }
      }
      pobj["company_id"] = companyId;
      logCtl.error({
        optitle: "获得某一公司下的产品大类信息===pobj",
        op: "/igirl-web/app/base/controller/impl/producttypeCtl.js/getProductTypeList",
        content: JSON.stringify(pobj),
        clientIp: ""
      });
      return await this.service.getTypeOneByCompanyId(pobj, 1);
    } catch (e) {
      logCtl.error({
        optitle: "获得某一公司下的产品大类信息===error",
        op: "/igirl-web/app/base/controller/impl/producttypeCtl.js/getProductTypeList",
        content: "obj=" + JSON.stringify(pobj) + "，error=" + e.stack,
        clientIp: ""
      });
      return { code: -200, msg: "接口异常" };
    }
  }
  //通过大类code获取产品列表
  async getProductList(gobj, pobj, req) {
    try {
      var companyId = req.companyid || "";
      var hostname = req.hostname;
      var typeCode = pobj.type_code || "";
      if (!typeCode) {
        return { code: -102, msg: "type_code参数错误" };
      }
      if (!companyId) {
        var item = await this.companySve.getCompanyByHostname(hostname);
        if (item) {
          companyId = item.id;
        }
      }
      pobj["company_id"] = companyId;
      pobj["typeCode"] = typeCode;
      return await this.service.getTypeOneByCompanyId(pobj, 2);
    } catch (e) {
      logCtl.error({
        optitle: "获得某一公司下的产品大类信息===error",
        op: "/igirl-web/app/base/controller/impl/producttypeCtl.js/getProductTypeList",
        content: "obj=" + JSON.stringify(pobj) + "，error=" + e.stack,
        clientIp: ""
      });
      return { code: -200, msg: "接口异常" };
    }
  }

  //获得某一公司下的所有服务信息
  async getAllProducts(obj, req) {
    try {
      var companyId = req.companyid || "";
      var hostname = req.hostname;
      if (!companyId) {
        var item = await this.companySve.getCompanyByHostname(hostname);
        if (item) {
          companyId = item.id;
        }
      }
      return await this.service.getAllProducts({companyId:companyId});
    } catch (e) {
      logCtl.error({
        optitle: "获得某一公司下的所有服务信息===error",
        op: "/igirl-web/app/base/controller/impl/producttypeCtl.js/getAllProducts",
        content: "obj=" + JSON.stringify(pobj) + "，error=" + e.stack,
        clientIp: ""
      });
      return { code: -200, msg: "接口异常" };
    }
  }
}
module.exports = ProducttypeCtl;
