(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.ExcelJS = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var fs = require('fs');

var fastCsv = require('fast-csv');

var customParseFormat = require('dayjs/plugin/customParseFormat');

var utc = require('dayjs/plugin/utc');

var dayjs = require('dayjs').extend(customParseFormat).extend(utc);

var StreamBuf = require('../utils/stream-buf');

var _require = require('../utils/utils'),
    exists = _require.fs.exists;
/* eslint-disable quote-props */


var SpecialValues = {
  true: true,
  false: false,
  '#N/A': {
    error: '#N/A'
  },
  '#REF!': {
    error: '#REF!'
  },
  '#NAME?': {
    error: '#NAME?'
  },
  '#DIV/0!': {
    error: '#DIV/0!'
  },
  '#NULL!': {
    error: '#NULL!'
  },
  '#VALUE!': {
    error: '#VALUE!'
  },
  '#NUM!': {
    error: '#NUM!'
  }
};
/* eslint-ensable quote-props */

var CSV = /*#__PURE__*/function () {
  function CSV(workbook) {
    _classCallCheck(this, CSV);

    this.workbook = workbook;
    this.worksheet = null;
  }

  _createClass(CSV, [{
    key: "readFile",
    value: function () {
      var _readFile = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(filename, options) {
        var stream, worksheet;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                options = options || {};
                _context.next = 3;
                return exists(filename);

              case 3:
                if (_context.sent) {
                  _context.next = 5;
                  break;
                }

                throw new Error("File not found: ".concat(filename));

              case 5:
                stream = fs.createReadStream(filename);
                _context.next = 8;
                return this.read(stream, options);

              case 8:
                worksheet = _context.sent;
                stream.close();
                return _context.abrupt("return", worksheet);

              case 11:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function readFile(_x, _x2) {
        return _readFile.apply(this, arguments);
      }

      return readFile;
    }()
  }, {
    key: "read",
    value: function read(stream, options) {
      var _this = this;

      options = options || {};
      return new Promise(function (resolve, reject) {
        var worksheet = _this.workbook.addWorksheet(options.sheetName);

        var dateFormats = options.dateFormats || ['YYYY-MM-DD[T]HH:mm:ssZ', 'YYYY-MM-DD[T]HH:mm:ss', 'MM-DD-YYYY', 'YYYY-MM-DD'];

        var map = options.map || function (datum) {
          if (datum === '') {
            return null;
          }

          var datumNumber = Number(datum);

          if (!Number.isNaN(datumNumber) && datumNumber !== Infinity) {
            return datumNumber;
          }

          var dt = dateFormats.reduce(function (matchingDate, currentDateFormat) {
            if (matchingDate) {
              return matchingDate;
            }

            var dayjsObj = dayjs(datum, currentDateFormat, true);

            if (dayjsObj.isValid()) {
              return dayjsObj;
            }

            return null;
          }, null);

          if (dt) {
            return new Date(dt.valueOf());
          }

          var special = SpecialValues[datum];

          if (special !== undefined) {
            return special;
          }

          return datum;
        };

        var csvStream = fastCsv.parse(options.parserOptions).on('data', function (data) {
          worksheet.addRow(data.map(map));
        }).on('end', function () {
          csvStream.emit('worksheet', worksheet);
        });
        csvStream.on('worksheet', resolve).on('error', reject);
        stream.pipe(csvStream);
      });
    }
    /**
     * @deprecated since version 4.0. You should use `CSV#read` instead. Please follow upgrade instruction: https://github.com/exceljs/exceljs/blob/master/UPGRADE-4.0.md
     */

  }, {
    key: "createInputStream",
    value: function createInputStream() {
      throw new Error('`CSV#createInputStream` is deprecated. You should use `CSV#read` instead. This method will be removed in version 5.0. Please follow upgrade instruction: https://github.com/exceljs/exceljs/blob/master/UPGRADE-4.0.md');
    }
  }, {
    key: "write",
    value: function write(stream, options) {
      var _this2 = this;

      return new Promise(function (resolve, reject) {
        options = options || {}; // const encoding = options.encoding || 'utf8';
        // const separator = options.separator || ',';
        // const quoteChar = options.quoteChar || '\'';

        var worksheet = _this2.workbook.getWorksheet(options.sheetName || options.sheetId);

        var csvStream = fastCsv.format(options.formatterOptions);
        stream.on('finish', function () {
          resolve();
        });
        csvStream.on('error', reject);
        csvStream.pipe(stream);
        var _options = options,
            dateFormat = _options.dateFormat,
            dateUTC = _options.dateUTC;

        var map = options.map || function (value) {
          if (value) {
            if (value.text || value.hyperlink) {
              return value.hyperlink || value.text || '';
            }

            if (value.formula || value.result) {
              return value.result || '';
            }

            if (value instanceof Date) {
              if (dateFormat) {
                return dateUTC ? dayjs.utc(value).format(dateFormat) : dayjs(value).format(dateFormat);
              }

              return dateUTC ? dayjs.utc(value).format() : dayjs(value).format();
            }

            if (value.error) {
              return value.error;
            }

            if (_typeof(value) === 'object') {
              return JSON.stringify(value);
            }
          }

          return value;
        };

        var includeEmptyRows = options.includeEmptyRows === undefined || options.includeEmptyRows;
        var lastRow = 1;

        if (worksheet) {
          worksheet.eachRow(function (row, rowNumber) {
            if (includeEmptyRows) {
              while (lastRow++ < rowNumber - 1) {
                csvStream.write([]);
              }
            }

            var values = row.values;
            values.shift();
            csvStream.write(values.map(map));
            lastRow = rowNumber;
          });
        }

        csvStream.end();
      });
    }
  }, {
    key: "writeFile",
    value: function writeFile(filename, options) {
      options = options || {};
      var streamOptions = {
        encoding: options.encoding || 'utf8'
      };
      var stream = fs.createWriteStream(filename, streamOptions);
      return this.write(stream, options);
    }
  }, {
    key: "writeBuffer",
    value: function () {
      var _writeBuffer = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(options) {
        var stream;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                stream = new StreamBuf();
                _context2.next = 3;
                return this.write(stream, options);

              case 3:
                return _context2.abrupt("return", stream.read());

              case 4:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function writeBuffer(_x3) {
        return _writeBuffer.apply(this, arguments);
      }

      return writeBuffer;
    }()
  }]);

  return CSV;
}();

module.exports = CSV;

},{"../utils/stream-buf":23,"../utils/utils":26,"dayjs":227,"dayjs/plugin/customParseFormat":228,"dayjs/plugin/utc":229,"fast-csv":260,"fs":215}],2:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var colCache = require('../utils/col-cache');

var Anchor = /*#__PURE__*/function () {
  function Anchor(worksheet, address) {
    var offset = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

    _classCallCheck(this, Anchor);

    if (!address) {
      this.nativeCol = 0;
      this.nativeColOff = 0;
      this.nativeRow = 0;
      this.nativeRowOff = 0;
    } else if (typeof address === 'string') {
      var decoded = colCache.decodeAddress(address);
      this.nativeCol = decoded.col + offset;
      this.nativeColOff = 0;
      this.nativeRow = decoded.row + offset;
      this.nativeRowOff = 0;
    } else if (address.nativeCol !== undefined) {
      this.nativeCol = address.nativeCol || 0;
      this.nativeColOff = address.nativeColOff || 0;
      this.nativeRow = address.nativeRow || 0;
      this.nativeRowOff = address.nativeRowOff || 0;
    } else if (address.col !== undefined) {
      this.col = address.col + offset;
      this.row = address.row + offset;
    } else {
      this.nativeCol = 0;
      this.nativeColOff = 0;
      this.nativeRow = 0;
      this.nativeRowOff = 0;
    }

    this.worksheet = worksheet;
  }

  _createClass(Anchor, [{
    key: "col",
    get: function get() {
      return this.nativeCol + Math.min(this.colWidth - 1, this.nativeColOff) / this.colWidth;
    },
    set: function set(v) {
      this.nativeCol = Math.floor(v);
      this.nativeColOff = Math.floor((v - this.nativeCol) * this.colWidth);
    }
  }, {
    key: "row",
    get: function get() {
      return this.nativeRow + Math.min(this.rowHeight - 1, this.nativeRowOff) / this.rowHeight;
    },
    set: function set(v) {
      this.nativeRow = Math.floor(v);
      this.nativeRowOff = Math.floor((v - this.nativeRow) * this.rowHeight);
    }
  }, {
    key: "colWidth",
    get: function get() {
      return this.worksheet && this.worksheet.getColumn(this.nativeCol + 1) && this.worksheet.getColumn(this.nativeCol + 1).isCustomWidth ? Math.floor(this.worksheet.getColumn(this.nativeCol + 1).width * 10000) : 640000;
    }
  }, {
    key: "rowHeight",
    get: function get() {
      return this.worksheet && this.worksheet.getRow(this.nativeRow + 1) && this.worksheet.getRow(this.nativeRow + 1).height ? Math.floor(this.worksheet.getRow(this.nativeRow + 1).height * 10000) : 180000;
    }
  }, {
    key: "model",
    get: function get() {
      return {
        nativeCol: this.nativeCol,
        nativeColOff: this.nativeColOff,
        nativeRow: this.nativeRow,
        nativeRowOff: this.nativeRowOff
      };
    },
    set: function set(value) {
      this.nativeCol = value.nativeCol;
      this.nativeColOff = value.nativeColOff;
      this.nativeRow = value.nativeRow;
      this.nativeRowOff = value.nativeRowOff;
    }
  }], [{
    key: "asInstance",
    value: function asInstance(model) {
      return model instanceof Anchor || model == null ? model : new Anchor(model);
    }
  }]);

  return Anchor;
}();

module.exports = Anchor;

},{"../utils/col-cache":19}],3:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/* eslint-disable max-classes-per-file */
var colCache = require('../utils/col-cache');

var _ = require('../utils/under-dash');

var Enums = require('./enums');

var _require = require('../utils/shared-formula'),
    slideFormula = _require.slideFormula;

var Note = require('./note'); // Cell requirements
//  Operate inside a worksheet
//  Store and retrieve a value with a range of types: text, number, date, hyperlink, reference, formula, etc.
//  Manage/use and manipulate cell format either as local to cell or inherited from column or row.


var Cell = /*#__PURE__*/function () {
  function Cell(row, column, address) {
    _classCallCheck(this, Cell);

    if (!row || !column) {
      throw new Error('A Cell needs a Row');
    }

    this._row = row;
    this._column = column;
    colCache.validateAddress(address);
    this._address = address; // TODO: lazy evaluation of this._value

    this._value = Value.create(Cell.Types.Null, this);
    this.style = this._mergeStyle(row.style, column.style, {});
    this._mergeCount = 0;
  }

  _createClass(Cell, [{
    key: "destroy",
    // help GC by removing cyclic (and other) references
    value: function destroy() {
      delete this.style;
      delete this._value;
      delete this._row;
      delete this._column;
      delete this._address;
    } // =========================================================================
    // Styles stuff

  }, {
    key: "_mergeStyle",
    value: function _mergeStyle(rowStyle, colStyle, style) {
      var numFmt = rowStyle && rowStyle.numFmt || colStyle && colStyle.numFmt;
      if (numFmt) style.numFmt = numFmt;
      var font = rowStyle && rowStyle.font || colStyle && colStyle.font;
      if (font) style.font = font;
      var alignment = rowStyle && rowStyle.alignment || colStyle && colStyle.alignment;
      if (alignment) style.alignment = alignment;
      var border = rowStyle && rowStyle.border || colStyle && colStyle.border;
      if (border) style.border = border;
      var fill = rowStyle && rowStyle.fill || colStyle && colStyle.fill;
      if (fill) style.fill = fill;
      var protection = rowStyle && rowStyle.protection || colStyle && colStyle.protection;
      if (protection) style.protection = protection;
      return style;
    } // =========================================================================
    // return the address for this cell

  }, {
    key: "toCsvString",
    value: function toCsvString() {
      return this._value.toCsvString();
    } // =========================================================================
    // Merge stuff

  }, {
    key: "addMergeRef",
    value: function addMergeRef() {
      this._mergeCount++;
    }
  }, {
    key: "releaseMergeRef",
    value: function releaseMergeRef() {
      this._mergeCount--;
    }
  }, {
    key: "merge",
    value: function merge(master, ignoreStyle) {
      this._value.release();

      this._value = Value.create(Cell.Types.Merge, this, master);

      if (!ignoreStyle) {
        this.style = master.style;
      }
    }
  }, {
    key: "unmerge",
    value: function unmerge() {
      if (this.type === Cell.Types.Merge) {
        this._value.release();

        this._value = Value.create(Cell.Types.Null, this);
        this.style = this._mergeStyle(this._row.style, this._column.style, {});
      }
    }
  }, {
    key: "isMergedTo",
    value: function isMergedTo(master) {
      if (this._value.type !== Cell.Types.Merge) return false;
      return this._value.isMergedTo(master);
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.text;
    }
  }, {
    key: "_upgradeToHyperlink",
    value: function _upgradeToHyperlink(hyperlink) {
      // if this cell is a string, turn it into a Hyperlink
      if (this.type === Cell.Types.String) {
        this._value = Value.create(Cell.Types.Hyperlink, this, {
          text: this._value.value,
          hyperlink: hyperlink
        });
      }
    } // =========================================================================
    // Formula stuff

  }, {
    key: "addName",
    value: function addName(name) {
      this.workbook.definedNames.addEx(this.fullAddress, name);
    }
  }, {
    key: "removeName",
    value: function removeName(name) {
      this.workbook.definedNames.removeEx(this.fullAddress, name);
    }
  }, {
    key: "removeAllNames",
    value: function removeAllNames() {
      this.workbook.definedNames.removeAllNames(this.fullAddress);
    } // =========================================================================
    // Data Validation stuff

  }, {
    key: "worksheet",
    get: function get() {
      return this._row.worksheet;
    }
  }, {
    key: "workbook",
    get: function get() {
      return this._row.worksheet.workbook;
    }
  }, {
    key: "numFmt",
    get: function get() {
      return this.style.numFmt;
    },
    set: function set(value) {
      this.style.numFmt = value;
    }
  }, {
    key: "font",
    get: function get() {
      return this.style.font;
    },
    set: function set(value) {
      this.style.font = value;
    }
  }, {
    key: "alignment",
    get: function get() {
      return this.style.alignment;
    },
    set: function set(value) {
      this.style.alignment = value;
    }
  }, {
    key: "border",
    get: function get() {
      return this.style.border;
    },
    set: function set(value) {
      this.style.border = value;
    }
  }, {
    key: "fill",
    get: function get() {
      return this.style.fill;
    },
    set: function set(value) {
      this.style.fill = value;
    }
  }, {
    key: "protection",
    get: function get() {
      return this.style.protection;
    },
    set: function set(value) {
      this.style.protection = value;
    }
  }, {
    key: "address",
    get: function get() {
      return this._address;
    }
  }, {
    key: "row",
    get: function get() {
      return this._row.number;
    }
  }, {
    key: "col",
    get: function get() {
      return this._column.number;
    }
  }, {
    key: "$col$row",
    get: function get() {
      return "$".concat(this._column.letter, "$").concat(this.row);
    } // =========================================================================
    // Value stuff

  }, {
    key: "type",
    get: function get() {
      return this._value.type;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return this._value.effectiveType;
    }
  }, {
    key: "isMerged",
    get: function get() {
      return this._mergeCount > 0 || this.type === Cell.Types.Merge;
    }
  }, {
    key: "master",
    get: function get() {
      if (this.type === Cell.Types.Merge) {
        return this._value.master;
      }

      return this; // an unmerged cell is its own master
    }
  }, {
    key: "isHyperlink",
    get: function get() {
      return this._value.type === Cell.Types.Hyperlink;
    }
  }, {
    key: "hyperlink",
    get: function get() {
      return this._value.hyperlink;
    } // return the value

  }, {
    key: "value",
    get: function get() {
      return this._value.value;
    } // set the value - can be number, string or raw
    ,
    set: function set(v) {
      // special case - merge cells set their master's value
      if (this.type === Cell.Types.Merge) {
        this._value.master.value = v;
        return;
      }

      this._value.release(); // assign value


      this._value = Value.create(Value.getType(v), this, v);
    }
  }, {
    key: "note",
    get: function get() {
      return this._comment && this._comment.note;
    },
    set: function set(note) {
      this._comment = new Note(note);
    }
  }, {
    key: "text",
    get: function get() {
      return this._value.toString();
    }
  }, {
    key: "html",
    get: function get() {
      return _.escapeHtml(this.text);
    }
  }, {
    key: "formula",
    get: function get() {
      return this._value.formula;
    }
  }, {
    key: "result",
    get: function get() {
      return this._value.result;
    }
  }, {
    key: "formulaType",
    get: function get() {
      return this._value.formulaType;
    } // =========================================================================
    // Name stuff

  }, {
    key: "fullAddress",
    get: function get() {
      var worksheet = this._row.worksheet;
      return {
        sheetName: worksheet.name,
        address: this.address,
        row: this.row,
        col: this.col
      };
    }
  }, {
    key: "name",
    get: function get() {
      return this.names[0];
    },
    set: function set(value) {
      this.names = [value];
    }
  }, {
    key: "names",
    get: function get() {
      return this.workbook.definedNames.getNamesEx(this.fullAddress);
    },
    set: function set(value) {
      var _this = this;

      var definedNames = this.workbook.definedNames;
      definedNames.removeAllNames(this.fullAddress);
      value.forEach(function (name) {
        definedNames.addEx(_this.fullAddress, name);
      });
    }
  }, {
    key: "_dataValidations",
    get: function get() {
      return this.worksheet.dataValidations;
    }
  }, {
    key: "dataValidation",
    get: function get() {
      return this._dataValidations.find(this.address);
    },
    set: function set(value) {
      this._dataValidations.add(this.address, value);
    } // =========================================================================
    // Model stuff

  }, {
    key: "model",
    get: function get() {
      var model = this._value.model;
      model.style = this.style;

      if (this._comment) {
        model.comment = this._comment.model;
      }

      return model;
    },
    set: function set(value) {
      this._value.release();

      this._value = Value.create(value.type, this);
      this._value.model = value;

      if (value.comment) {
        switch (value.comment.type) {
          case 'note':
            this._comment = Note.fromModel(value.comment);
            break;
        }
      }

      if (value.style) {
        this.style = value.style;
      } else {
        this.style = {};
      }
    }
  }]);

  return Cell;
}();

Cell.Types = Enums.ValueType; // =============================================================================
// Internal Value Types

var NullValue = /*#__PURE__*/function () {
  function NullValue(cell) {
    _classCallCheck(this, NullValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Null
    };
  }

  _createClass(NullValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return '';
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return '';
    }
  }, {
    key: "value",
    get: function get() {
      return null;
    },
    set: function set(value) {// nothing to do
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Null;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Null;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return NullValue;
}();

var NumberValue = /*#__PURE__*/function () {
  function NumberValue(cell, value) {
    _classCallCheck(this, NumberValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Number,
      value: value
    };
  }

  _createClass(NumberValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.value.toString();
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Number;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Number;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return NumberValue;
}();

var StringValue = /*#__PURE__*/function () {
  function StringValue(cell, value) {
    _classCallCheck(this, StringValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.String,
      value: value
    };
  }

  _createClass(StringValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return "\"".concat(this.model.value.replace(/"/g, '""'), "\"");
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value;
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.String;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.String;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return StringValue;
}();

var RichTextValue = /*#__PURE__*/function () {
  function RichTextValue(cell, value) {
    _classCallCheck(this, RichTextValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.String,
      value: value
    };
  }

  _createClass(RichTextValue, [{
    key: "toString",
    value: function toString() {
      return this.model.value.richText.map(function (t) {
        return t.text;
      }).join('');
    }
  }, {
    key: "toCsvString",
    value: function toCsvString() {
      return "\"".concat(this.text.replace(/"/g, '""'), "\"");
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.RichText;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.RichText;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return RichTextValue;
}();

var DateValue = /*#__PURE__*/function () {
  function DateValue(cell, value) {
    _classCallCheck(this, DateValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Date,
      value: value
    };
  }

  _createClass(DateValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.value.toISOString();
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Date;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Date;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return DateValue;
}();

var HyperlinkValue = /*#__PURE__*/function () {
  function HyperlinkValue(cell, value) {
    _classCallCheck(this, HyperlinkValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Hyperlink,
      text: value ? value.text : undefined,
      hyperlink: value ? value.hyperlink : undefined
    };

    if (value && value.tooltip) {
      this.model.tooltip = value.tooltip;
    }
  }

  _createClass(HyperlinkValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.hyperlink;
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.text;
    }
  }, {
    key: "value",
    get: function get() {
      var v = {
        text: this.model.text,
        hyperlink: this.model.hyperlink
      };

      if (this.model.tooltip) {
        v.tooltip = this.model.tooltip;
      }

      return v;
    },
    set: function set(value) {
      this.model = {
        text: value.text,
        hyperlink: value.hyperlink
      };

      if (value.tooltip) {
        this.model.tooltip = value.tooltip;
      }
    }
  }, {
    key: "text",
    get: function get() {
      return this.model.text;
    },
    set: function set(value) {
      this.model.text = value;
    }
    /*
    get tooltip() {
      return this.model.tooltip;
    }
      set tooltip(value) {
      this.model.tooltip = value;
    } */

  }, {
    key: "hyperlink",
    get: function get() {
      return this.model.hyperlink;
    },
    set: function set(value) {
      this.model.hyperlink = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Hyperlink;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Hyperlink;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return HyperlinkValue;
}();

var MergeValue = /*#__PURE__*/function () {
  function MergeValue(cell, master) {
    _classCallCheck(this, MergeValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Merge,
      master: master ? master.address : undefined
    };
    this._master = master;

    if (master) {
      master.addMergeRef();
    }
  }

  _createClass(MergeValue, [{
    key: "isMergedTo",
    value: function isMergedTo(master) {
      return master === this._master;
    }
  }, {
    key: "toCsvString",
    value: function toCsvString() {
      return '';
    }
  }, {
    key: "release",
    value: function release() {
      this._master.releaseMergeRef();
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.value.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this._master.value;
    },
    set: function set(value) {
      if (value instanceof Cell) {
        if (this._master) {
          this._master.releaseMergeRef();
        }

        value.addMergeRef();
        this._master = value;
      } else {
        this._master.value = value;
      }
    }
  }, {
    key: "master",
    get: function get() {
      return this._master;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Merge;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return this._master.effectiveType;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return MergeValue;
}();

var FormulaValue = /*#__PURE__*/function () {
  function FormulaValue(cell, value) {
    _classCallCheck(this, FormulaValue);

    this.cell = cell;
    this.model = {
      address: cell.address,
      type: Cell.Types.Formula,
      shareType: value ? value.shareType : undefined,
      ref: value ? value.ref : undefined,
      formula: value ? value.formula : undefined,
      sharedFormula: value ? value.sharedFormula : undefined,
      result: value ? value.result : undefined
    };
  }

  _createClass(FormulaValue, [{
    key: "_copyModel",
    value: function _copyModel(model) {
      var copy = {};

      var cp = function cp(name) {
        var value = model[name];

        if (value) {
          copy[name] = value;
        }
      };

      cp('formula');
      cp('result');
      cp('ref');
      cp('shareType');
      cp('sharedFormula');
      return copy;
    }
  }, {
    key: "validate",
    value: function validate(value) {
      switch (Value.getType(value)) {
        case Cell.Types.Null:
        case Cell.Types.String:
        case Cell.Types.Number:
        case Cell.Types.Date:
          break;

        case Cell.Types.Hyperlink:
        case Cell.Types.Formula:
        default:
          throw new Error('Cannot process that type of result value');
      }
    }
  }, {
    key: "_getTranslatedFormula",
    value: function _getTranslatedFormula() {
      if (!this._translatedFormula && this.model.sharedFormula) {
        var worksheet = this.cell.worksheet;
        var master = worksheet.findCell(this.model.sharedFormula);
        this._translatedFormula = master && slideFormula(master.formula, master.address, this.model.address);
      }

      return this._translatedFormula;
    }
  }, {
    key: "toCsvString",
    value: function toCsvString() {
      return "".concat(this.model.result || '');
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.result ? this.model.result.toString() : '';
    }
  }, {
    key: "value",
    get: function get() {
      return this._copyModel(this.model);
    },
    set: function set(value) {
      this.model = this._copyModel(value);
    }
  }, {
    key: "dependencies",
    get: function get() {
      // find all the ranges and cells mentioned in the formula
      var ranges = this.formula.match(/([a-zA-Z0-9]+!)?[A-Z]{1,3}\d{1,4}:[A-Z]{1,3}\d{1,4}/g);
      var cells = this.formula.replace(/([a-zA-Z0-9]+!)?[A-Z]{1,3}\d{1,4}:[A-Z]{1,3}\d{1,4}/g, '').match(/([a-zA-Z0-9]+!)?[A-Z]{1,3}\d{1,4}/g);
      return {
        ranges: ranges,
        cells: cells
      };
    }
  }, {
    key: "formula",
    get: function get() {
      return this.model.formula || this._getTranslatedFormula();
    },
    set: function set(value) {
      this.model.formula = value;
    }
  }, {
    key: "formulaType",
    get: function get() {
      if (this.model.formula) {
        return Enums.FormulaType.Master;
      }

      if (this.model.sharedFormula) {
        return Enums.FormulaType.Shared;
      }

      return Enums.FormulaType.None;
    }
  }, {
    key: "result",
    get: function get() {
      return this.model.result;
    },
    set: function set(value) {
      this.model.result = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Formula;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      var v = this.model.result;

      if (v === null || v === undefined) {
        return Enums.ValueType.Null;
      }

      if (v instanceof String || typeof v === 'string') {
        return Enums.ValueType.String;
      }

      if (typeof v === 'number') {
        return Enums.ValueType.Number;
      }

      if (v instanceof Date) {
        return Enums.ValueType.Date;
      }

      if (v.text && v.hyperlink) {
        return Enums.ValueType.Hyperlink;
      }

      if (v.formula) {
        return Enums.ValueType.Formula;
      }

      return Enums.ValueType.Null;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return FormulaValue;
}();

var SharedStringValue = /*#__PURE__*/function () {
  function SharedStringValue(cell, value) {
    _classCallCheck(this, SharedStringValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.SharedString,
      value: value
    };
  }

  _createClass(SharedStringValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.value.toString();
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.SharedString;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.SharedString;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return SharedStringValue;
}();

var BooleanValue = /*#__PURE__*/function () {
  function BooleanValue(cell, value) {
    _classCallCheck(this, BooleanValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Boolean,
      value: value
    };
  }

  _createClass(BooleanValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.value ? 1 : 0;
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Boolean;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Boolean;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return BooleanValue;
}();

var ErrorValue = /*#__PURE__*/function () {
  function ErrorValue(cell, value) {
    _classCallCheck(this, ErrorValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.Error,
      value: value
    };
  }

  _createClass(ErrorValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.toString();
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value.error.toString();
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.value;
    },
    set: function set(value) {
      this.model.value = value;
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.Error;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.Error;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return ErrorValue;
}();

var JSONValue = /*#__PURE__*/function () {
  function JSONValue(cell, value) {
    _classCallCheck(this, JSONValue);

    this.model = {
      address: cell.address,
      type: Cell.Types.String,
      value: JSON.stringify(value),
      rawValue: value
    };
  }

  _createClass(JSONValue, [{
    key: "toCsvString",
    value: function toCsvString() {
      return this.model.value;
    }
  }, {
    key: "release",
    value: function release() {}
  }, {
    key: "toString",
    value: function toString() {
      return this.model.value;
    }
  }, {
    key: "value",
    get: function get() {
      return this.model.rawValue;
    },
    set: function set(value) {
      this.model.rawValue = value;
      this.model.value = JSON.stringify(value);
    }
  }, {
    key: "type",
    get: function get() {
      return Cell.Types.String;
    }
  }, {
    key: "effectiveType",
    get: function get() {
      return Cell.Types.String;
    }
  }, {
    key: "address",
    get: function get() {
      return this.model.address;
    },
    set: function set(value) {
      this.model.address = value;
    }
  }]);

  return JSONValue;
}(); // Value is a place to hold common static Value type functions


var Value = {
  getType: function getType(value) {
    if (value === null || value === undefined) {
      return Cell.Types.Null;
    }

    if (value instanceof String || typeof value === 'string') {
      return Cell.Types.String;
    }

    if (typeof value === 'number') {
      return Cell.Types.Number;
    }

    if (typeof value === 'boolean') {
      return Cell.Types.Boolean;
    }

    if (value instanceof Date) {
      return Cell.Types.Date;
    }

    if (value.text && value.hyperlink) {
      return Cell.Types.Hyperlink;
    }

    if (value.formula || value.sharedFormula) {
      return Cell.Types.Formula;
    }

    if (value.richText) {
      return Cell.Types.RichText;
    }

    if (value.sharedString) {
      return Cell.Types.SharedString;
    }

    if (value.error) {
      return Cell.Types.Error;
    }

    return Cell.Types.JSON;
  },
  // map valueType to constructor
  types: [{
    t: Cell.Types.Null,
    f: NullValue
  }, {
    t: Cell.Types.Number,
    f: NumberValue
  }, {
    t: Cell.Types.String,
    f: StringValue
  }, {
    t: Cell.Types.Date,
    f: DateValue
  }, {
    t: Cell.Types.Hyperlink,
    f: HyperlinkValue
  }, {
    t: Cell.Types.Formula,
    f: FormulaValue
  }, {
    t: Cell.Types.Merge,
    f: MergeValue
  }, {
    t: Cell.Types.JSON,
    f: JSONValue
  }, {
    t: Cell.Types.SharedString,
    f: SharedStringValue
  }, {
    t: Cell.Types.RichText,
    f: RichTextValue
  }, {
    t: Cell.Types.Boolean,
    f: BooleanValue
  }, {
    t: Cell.Types.Error,
    f: ErrorValue
  }].reduce(function (p, t) {
    p[t.t] = t.f;
    return p;
  }, []),
  create: function create(type, cell, value) {
    var T = this.types[type];

    if (!T) {
      throw new Error("Could not create Value of type ".concat(type));
    }

    return new T(cell, value);
  }
};
module.exports = Cell;

},{"../utils/col-cache":19,"../utils/shared-formula":22,"../utils/under-dash":25,"./enums":7,"./note":9}],4:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../utils/under-dash');

var Enums = require('./enums');

var colCache = require('../utils/col-cache');

var DEFAULT_COLUMN_WIDTH = 9; // Column defines the column properties for 1 column.
// This includes header rows, widths, key, (style), etc.
// Worksheet will condense the columns as appropriate during serialization

var Column = /*#__PURE__*/function () {
  function Column(worksheet, number, defn) {
    _classCallCheck(this, Column);

    this._worksheet = worksheet;
    this._number = number;

    if (defn !== false) {
      // sometimes defn will follow
      this.defn = defn;
    }
  }

  _createClass(Column, [{
    key: "toString",
    value: function toString() {
      return JSON.stringify({
        key: this.key,
        width: this.width,
        headers: this.headers.length ? this.headers : undefined
      });
    }
  }, {
    key: "equivalentTo",
    value: function equivalentTo(other) {
      return this.width === other.width && this.hidden === other.hidden && this.outlineLevel === other.outlineLevel && _.isEqual(this.style, other.style);
    }
  }, {
    key: "eachCell",
    value: function eachCell(options, iteratee) {
      var colNumber = this.number;

      if (!iteratee) {
        iteratee = options;
        options = null;
      }

      this._worksheet.eachRow(options, function (row, rowNumber) {
        iteratee(row.getCell(colNumber), rowNumber);
      });
    }
  }, {
    key: "_applyStyle",
    // =========================================================================
    // styles
    value: function _applyStyle(name, value) {
      this.style[name] = value;
      this.eachCell(function (cell) {
        cell[name] = value;
      });
      return value;
    }
  }, {
    key: "number",
    get: function get() {
      return this._number;
    }
  }, {
    key: "worksheet",
    get: function get() {
      return this._worksheet;
    }
  }, {
    key: "letter",
    get: function get() {
      return colCache.n2l(this._number);
    }
  }, {
    key: "isCustomWidth",
    get: function get() {
      return this.width !== undefined && this.width !== DEFAULT_COLUMN_WIDTH;
    }
  }, {
    key: "defn",
    get: function get() {
      return {
        header: this._header,
        key: this.key,
        width: this.width,
        style: this.style,
        hidden: this.hidden,
        outlineLevel: this.outlineLevel
      };
    },
    set: function set(value) {
      if (value) {
        this.key = value.key;
        this.width = value.width !== undefined ? value.width : DEFAULT_COLUMN_WIDTH;
        this.outlineLevel = value.outlineLevel;

        if (value.style) {
          this.style = value.style;
        } else {
          this.style = {};
        } // headers must be set after style


        this.header = value.header;
        this._hidden = !!value.hidden;
      } else {
        delete this._header;
        delete this._key;
        delete this.width;
        this.style = {};
        this.outlineLevel = 0;
      }
    }
  }, {
    key: "headers",
    get: function get() {
      return this._header && this._header instanceof Array ? this._header : [this._header];
    }
  }, {
    key: "header",
    get: function get() {
      return this._header;
    },
    set: function set(value) {
      var _this = this;

      if (value !== undefined) {
        this._header = value;
        this.headers.forEach(function (text, index) {
          _this._worksheet.getCell(index + 1, _this.number).value = text;
        });
      } else {
        this._header = undefined;
      }
    }
  }, {
    key: "key",
    get: function get() {
      return this._key;
    },
    set: function set(value) {
      var column = this._key && this._worksheet.getColumnKey(this._key);

      if (column === this) {
        this._worksheet.deleteColumnKey(this._key);
      }

      this._key = value;

      if (value) {
        this._worksheet.setColumnKey(this._key, this);
      }
    }
  }, {
    key: "hidden",
    get: function get() {
      return !!this._hidden;
    },
    set: function set(value) {
      this._hidden = value;
    }
  }, {
    key: "outlineLevel",
    get: function get() {
      return this._outlineLevel || 0;
    },
    set: function set(value) {
      this._outlineLevel = value;
    }
  }, {
    key: "collapsed",
    get: function get() {
      return !!(this._outlineLevel && this._outlineLevel >= this._worksheet.properties.outlineLevelCol);
    }
  }, {
    key: "isDefault",
    get: function get() {
      if (this.isCustomWidth) {
        return false;
      }

      if (this.hidden) {
        return false;
      }

      if (this.outlineLevel) {
        return false;
      }

      var s = this.style;

      if (s && (s.font || s.numFmt || s.alignment || s.border || s.fill || s.protection)) {
        return false;
      }

      return true;
    }
  }, {
    key: "headerCount",
    get: function get() {
      return this.headers.length;
    }
  }, {
    key: "values",
    get: function get() {
      var v = [];
      this.eachCell(function (cell, rowNumber) {
        if (cell && cell.type !== Enums.ValueType.Null) {
          v[rowNumber] = cell.value;
        }
      });
      return v;
    },
    set: function set(v) {
      var _this2 = this;

      if (!v) {
        return;
      }

      var colNumber = this.number;
      var offset = 0;

      if (v.hasOwnProperty('0')) {
        // assume contiguous array, start at row 1
        offset = 1;
      }

      v.forEach(function (value, index) {
        _this2._worksheet.getCell(index + offset, colNumber).value = value;
      });
    }
  }, {
    key: "numFmt",
    get: function get() {
      return this.style.numFmt;
    },
    set: function set(value) {
      this._applyStyle('numFmt', value);
    }
  }, {
    key: "font",
    get: function get() {
      return this.style.font;
    },
    set: function set(value) {
      this._applyStyle('font', value);
    }
  }, {
    key: "alignment",
    get: function get() {
      return this.style.alignment;
    },
    set: function set(value) {
      this._applyStyle('alignment', value);
    }
  }, {
    key: "protection",
    get: function get() {
      return this.style.protection;
    },
    set: function set(value) {
      this._applyStyle('protection', value);
    }
  }, {
    key: "border",
    get: function get() {
      return this.style.border;
    },
    set: function set(value) {
      this._applyStyle('border', value);
    }
  }, {
    key: "fill",
    get: function get() {
      return this.style.fill;
    },
    set: function set(value) {
      this._applyStyle('fill', value);
    } // =============================================================================
    // static functions

  }], [{
    key: "toModel",
    value: function toModel(columns) {
      // Convert array of Column into compressed list cols
      var cols = [];
      var col = null;

      if (columns) {
        columns.forEach(function (column, index) {
          if (column.isDefault) {
            if (col) {
              col = null;
            }
          } else if (!col || !column.equivalentTo(col)) {
            col = {
              min: index + 1,
              max: index + 1,
              width: column.width !== undefined ? column.width : DEFAULT_COLUMN_WIDTH,
              style: column.style,
              isCustomWidth: column.isCustomWidth,
              hidden: column.hidden,
              outlineLevel: column.outlineLevel,
              collapsed: column.collapsed
            };
            cols.push(col);
          } else {
            col.max = index + 1;
          }
        });
      }

      return cols.length ? cols : undefined;
    }
  }, {
    key: "fromModel",
    value: function fromModel(worksheet, cols) {
      cols = cols || [];
      var columns = [];
      var count = 1;
      var index = 0;

      while (index < cols.length) {
        var col = cols[index++];

        while (count < col.min) {
          columns.push(new Column(worksheet, count++));
        }

        while (count <= col.max) {
          columns.push(new Column(worksheet, count++, col));
        }
      }

      return columns.length ? columns : null;
    }
  }]);

  return Column;
}();

module.exports = Column;

},{"../utils/col-cache":19,"../utils/under-dash":25,"./enums":7}],5:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var DataValidations = /*#__PURE__*/function () {
  function DataValidations(model) {
    _classCallCheck(this, DataValidations);

    this.model = model || {};
  }

  _createClass(DataValidations, [{
    key: "add",
    value: function add(address, validation) {
      return this.model[address] = validation;
    }
  }, {
    key: "find",
    value: function find(address) {
      return this.model[address];
    }
  }, {
    key: "remove",
    value: function remove(address) {
      this.model[address] = undefined;
    }
  }]);

  return DataValidations;
}();

module.exports = DataValidations;

},{}],6:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../utils/under-dash');

var colCache = require('../utils/col-cache');

var CellMatrix = require('../utils/cell-matrix');

var Range = require('./range');

var rangeRegexp = /[$](\w+)[$](\d+)(:[$](\w+)[$](\d+))?/;

var DefinedNames = /*#__PURE__*/function () {
  function DefinedNames() {
    _classCallCheck(this, DefinedNames);

    this.matrixMap = {};
  }

  _createClass(DefinedNames, [{
    key: "getMatrix",
    value: function getMatrix(name) {
      var matrix = this.matrixMap[name] || (this.matrixMap[name] = new CellMatrix());
      return matrix;
    } // add a name to a cell. locStr in the form SheetName!$col$row or SheetName!$c1$r1:$c2:$r2

  }, {
    key: "add",
    value: function add(locStr, name) {
      var location = colCache.decodeEx(locStr);
      this.addEx(location, name);
    }
  }, {
    key: "addEx",
    value: function addEx(location, name) {
      var matrix = this.getMatrix(name);

      if (location.top) {
        for (var col = location.left; col <= location.right; col++) {
          for (var row = location.top; row <= location.bottom; row++) {
            var address = {
              sheetName: location.sheetName,
              address: colCache.n2l(col) + row,
              row: row,
              col: col
            };
            matrix.addCellEx(address);
          }
        }
      } else {
        matrix.addCellEx(location);
      }
    }
  }, {
    key: "remove",
    value: function remove(locStr, name) {
      var location = colCache.decodeEx(locStr);
      this.removeEx(location, name);
    }
  }, {
    key: "removeEx",
    value: function removeEx(location, name) {
      var matrix = this.getMatrix(name);
      matrix.removeCellEx(location);
    }
  }, {
    key: "removeAllNames",
    value: function removeAllNames(location) {
      _.each(this.matrixMap, function (matrix) {
        matrix.removeCellEx(location);
      });
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      _.each(this.matrixMap, function (matrix, name) {
        matrix.forEach(function (cell) {
          callback(name, cell);
        });
      });
    } // get all the names of a cell

  }, {
    key: "getNames",
    value: function getNames(addressStr) {
      return this.getNamesEx(colCache.decodeEx(addressStr));
    }
  }, {
    key: "getNamesEx",
    value: function getNamesEx(address) {
      return _.map(this.matrixMap, function (matrix, name) {
        return matrix.findCellEx(address) && name;
      }).filter(Boolean);
    }
  }, {
    key: "_explore",
    value: function _explore(matrix, cell) {
      cell.mark = false;
      var sheetName = cell.sheetName;
      var range = new Range(cell.row, cell.col, cell.row, cell.col, sheetName);
      var x;
      var y; // grow vertical - only one col to worry about

      function vGrow(yy, edge) {
        var c = matrix.findCellAt(sheetName, yy, cell.col);

        if (!c || !c.mark) {
          return false;
        }

        range[edge] = yy;
        c.mark = false;
        return true;
      }

      for (y = cell.row - 1; vGrow(y, 'top'); y--) {
        ;
      }

      for (y = cell.row + 1; vGrow(y, 'bottom'); y++) {
        ;
      } // grow horizontal - ensure all rows can grow


      function hGrow(xx, edge) {
        var cells = [];

        for (y = range.top; y <= range.bottom; y++) {
          var c = matrix.findCellAt(sheetName, y, xx);

          if (c && c.mark) {
            cells.push(c);
          } else {
            return false;
          }
        }

        range[edge] = xx;

        for (var i = 0; i < cells.length; i++) {
          cells[i].mark = false;
        }

        return true;
      }

      for (x = cell.col - 1; hGrow(x, 'left'); x--) {
        ;
      }

      for (x = cell.col + 1; hGrow(x, 'right'); x++) {
        ;
      }

      return range;
    }
  }, {
    key: "getRanges",
    value: function getRanges(name, matrix) {
      var _this = this;

      matrix = matrix || this.matrixMap[name];

      if (!matrix) {
        return {
          name: name,
          ranges: []
        };
      } // mark and sweep!


      matrix.forEach(function (cell) {
        cell.mark = true;
      });
      var ranges = matrix.map(function (cell) {
        return cell.mark && _this._explore(matrix, cell);
      }).filter(Boolean).map(function (range) {
        return range.$shortRange;
      });
      return {
        name: name,
        ranges: ranges
      };
    }
  }, {
    key: "normaliseMatrix",
    value: function normaliseMatrix(matrix, sheetName) {
      // some of the cells might have shifted on specified sheet
      // need to reassign rows, cols
      matrix.forEachInSheet(sheetName, function (cell, row, col) {
        if (cell) {
          if (cell.row !== row || cell.col !== col) {
            cell.row = row;
            cell.col = col;
            cell.address = colCache.n2l(col) + row;
          }
        }
      });
    }
  }, {
    key: "spliceRows",
    value: function spliceRows(sheetName, start, numDelete, numInsert) {
      var _this2 = this;

      _.each(this.matrixMap, function (matrix) {
        matrix.spliceRows(sheetName, start, numDelete, numInsert);

        _this2.normaliseMatrix(matrix, sheetName);
      });
    }
  }, {
    key: "spliceColumns",
    value: function spliceColumns(sheetName, start, numDelete, numInsert) {
      var _this3 = this;

      _.each(this.matrixMap, function (matrix) {
        matrix.spliceColumns(sheetName, start, numDelete, numInsert);

        _this3.normaliseMatrix(matrix, sheetName);
      });
    }
  }, {
    key: "model",
    get: function get() {
      var _this4 = this;

      // To get names per cell - just iterate over all names finding cells if they exist
      return _.map(this.matrixMap, function (matrix, name) {
        return _this4.getRanges(name, matrix);
      }).filter(function (definedName) {
        return definedName.ranges.length;
      });
    },
    set: function set(value) {
      // value is [ { name, ranges }, ... ]
      var matrixMap = this.matrixMap = {};
      value.forEach(function (definedName) {
        var matrix = matrixMap[definedName.name] = new CellMatrix();
        definedName.ranges.forEach(function (rangeStr) {
          if (rangeRegexp.test(rangeStr.split('!').pop() || '')) {
            matrix.addCell(rangeStr);
          }
        });
      });
    }
  }]);

  return DefinedNames;
}();

module.exports = DefinedNames;

},{"../utils/cell-matrix":18,"../utils/col-cache":19,"../utils/under-dash":25,"./range":10}],7:[function(require,module,exports){
'use strict';

module.exports = {
  ValueType: {
    Null: 0,
    Merge: 1,
    Number: 2,
    String: 3,
    Date: 4,
    Hyperlink: 5,
    Formula: 6,
    SharedString: 7,
    RichText: 8,
    Boolean: 9,
    Error: 10
  },
  FormulaType: {
    None: 0,
    Master: 1,
    Shared: 2
  },
  RelationshipType: {
    None: 0,
    OfficeDocument: 1,
    Worksheet: 2,
    CalcChain: 3,
    SharedStrings: 4,
    Styles: 5,
    Theme: 6,
    Hyperlink: 7
  },
  DocumentType: {
    Xlsx: 1
  },
  ReadingOrder: {
    LeftToRight: 1,
    RightToLeft: 2
  },
  ErrorValue: {
    NotApplicable: '#N/A',
    Ref: '#REF!',
    Name: '#NAME?',
    DivZero: '#DIV/0!',
    Null: '#NULL!',
    Value: '#VALUE!',
    Num: '#NUM!'
  }
};

},{}],8:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var colCache = require('../utils/col-cache');

var Anchor = require('./anchor');

var Image = /*#__PURE__*/function () {
  function Image(worksheet, model) {
    _classCallCheck(this, Image);

    this.worksheet = worksheet;
    this.model = model;
  }

  _createClass(Image, [{
    key: "model",
    get: function get() {
      switch (this.type) {
        case 'background':
          return {
            type: this.type,
            imageId: this.imageId
          };

        case 'image':
          return {
            type: this.type,
            imageId: this.imageId,
            hyperlinks: this.range.hyperlinks,
            range: {
              tl: this.range.tl.model,
              br: this.range.br && this.range.br.model,
              ext: this.range.ext,
              editAs: this.range.editAs
            }
          };

        default:
          throw new Error('Invalid Image Type');
      }
    },
    set: function set(_ref) {
      var type = _ref.type,
          imageId = _ref.imageId,
          range = _ref.range,
          hyperlinks = _ref.hyperlinks;
      this.type = type;
      this.imageId = imageId;

      if (type === 'image') {
        if (typeof range === 'string') {
          var decoded = colCache.decode(range);
          this.range = {
            tl: new Anchor(this.worksheet, {
              col: decoded.left,
              row: decoded.top
            }, -1),
            br: new Anchor(this.worksheet, {
              col: decoded.right,
              row: decoded.bottom
            }, 0),
            editAs: 'oneCell'
          };
        } else {
          this.range = {
            tl: new Anchor(this.worksheet, range.tl, 0),
            br: range.br && new Anchor(this.worksheet, range.br, 0),
            ext: range.ext,
            editAs: range.editAs,
            hyperlinks: hyperlinks || range.hyperlinks
          };
        }
      }
    }
  }]);

  return Image;
}();

module.exports = Image;

},{"../utils/col-cache":19,"./anchor":2}],9:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../utils/under-dash');

var Note = /*#__PURE__*/function () {
  function Note(note) {
    _classCallCheck(this, Note);

    this.note = note;
  }

  _createClass(Note, [{
    key: "model",
    get: function get() {
      var value = null;

      switch (_typeof(this.note)) {
        case 'string':
          value = {
            type: 'note',
            note: {
              texts: [{
                text: this.note
              }]
            }
          };
          break;

        default:
          value = {
            type: 'note',
            note: this.note
          };
          break;
      } // Suitable for all cell comments


      return _.deepMerge({}, Note.DEFAULT_CONFIGS, value);
    },
    set: function set(value) {
      var note = value.note;
      var texts = note.texts;

      if (texts.length === 1 && Object.keys(texts[0]).length === 1) {
        this.note = texts[0].text;
      } else {
        this.note = note;
      }
    }
  }], [{
    key: "fromModel",
    value: function fromModel(model) {
      var note = new Note();
      note.model = model;
      return note;
    }
  }]);

  return Note;
}();

Note.DEFAULT_CONFIGS = {
  note: {
    margins: {
      insetmode: 'auto',
      inset: [0.13, 0.13, 0.25, 0.25]
    },
    protection: {
      locked: 'True',
      lockText: 'True'
    },
    editAs: 'absolute'
  }
};
module.exports = Note;

},{"../utils/under-dash":25}],10:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var colCache = require('../utils/col-cache'); // used by worksheet to calculate sheet dimensions


var Range = /*#__PURE__*/function () {
  function Range() {
    _classCallCheck(this, Range);

    this.decode(arguments);
  }

  _createClass(Range, [{
    key: "setTLBR",
    value: function setTLBR(t, l, b, r, s) {
      if (arguments.length < 4) {
        // setTLBR(tl, br, s)
        var tl = colCache.decodeAddress(t);
        var br = colCache.decodeAddress(l);
        this.model = {
          top: Math.min(tl.row, br.row),
          left: Math.min(tl.col, br.col),
          bottom: Math.max(tl.row, br.row),
          right: Math.max(tl.col, br.col),
          sheetName: b
        };
        this.setTLBR(tl.row, tl.col, br.row, br.col, s);
      } else {
        // setTLBR(t, l, b, r, s)
        this.model = {
          top: Math.min(t, b),
          left: Math.min(l, r),
          bottom: Math.max(t, b),
          right: Math.max(l, r),
          sheetName: s
        };
      }
    }
  }, {
    key: "decode",
    value: function decode(argv) {
      switch (argv.length) {
        case 5:
          // [t,l,b,r,s]
          this.setTLBR(argv[0], argv[1], argv[2], argv[3], argv[4]);
          break;

        case 4:
          // [t,l,b,r]
          this.setTLBR(argv[0], argv[1], argv[2], argv[3]);
          break;

        case 3:
          // [tl,br,s]
          this.setTLBR(argv[0], argv[1], argv[2]);
          break;

        case 2:
          // [tl,br]
          this.setTLBR(argv[0], argv[1]);
          break;

        case 1:
          {
            var value = argv[0];

            if (value instanceof Range) {
              // copy constructor
              this.model = {
                top: value.model.top,
                left: value.model.left,
                bottom: value.model.bottom,
                right: value.model.right,
                sheetName: value.sheetName
              };
            } else if (value instanceof Array) {
              // an arguments array
              this.decode(value);
            } else if (value.top && value.left && value.bottom && value.right) {
              // a model
              this.model = {
                top: value.top,
                left: value.left,
                bottom: value.bottom,
                right: value.right,
                sheetName: value.sheetName
              };
            } else {
              // [sheetName!]tl:br
              var tlbr = colCache.decodeEx(value);

              if (tlbr.top) {
                this.model = {
                  top: tlbr.top,
                  left: tlbr.left,
                  bottom: tlbr.bottom,
                  right: tlbr.right,
                  sheetName: tlbr.sheetName
                };
              } else {
                this.model = {
                  top: tlbr.row,
                  left: tlbr.col,
                  bottom: tlbr.row,
                  right: tlbr.col,
                  sheetName: tlbr.sheetName
                };
              }
            }

            break;
          }

        case 0:
          this.model = {
            top: 0,
            left: 0,
            bottom: 0,
            right: 0
          };
          break;

        default:
          throw new Error("Invalid number of arguments to _getDimensions() - ".concat(argv.length));
      }
    }
  }, {
    key: "expand",
    value: function expand(top, left, bottom, right) {
      if (!this.model.top || top < this.top) this.top = top;
      if (!this.model.left || left < this.left) this.left = left;
      if (!this.model.bottom || bottom > this.bottom) this.bottom = bottom;
      if (!this.model.right || right > this.right) this.right = right;
    }
  }, {
    key: "expandRow",
    value: function expandRow(row) {
      if (row) {
        var dimensions = row.dimensions,
            number = row.number;

        if (dimensions) {
          this.expand(number, dimensions.min, number, dimensions.max);
        }
      }
    }
  }, {
    key: "expandToAddress",
    value: function expandToAddress(addressStr) {
      var address = colCache.decodeEx(addressStr);
      this.expand(address.row, address.col, address.row, address.col);
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.range;
    }
  }, {
    key: "intersects",
    value: function intersects(other) {
      if (other.sheetName && this.sheetName && other.sheetName !== this.sheetName) return false;
      if (other.bottom < this.top) return false;
      if (other.top > this.bottom) return false;
      if (other.right < this.left) return false;
      if (other.left > this.right) return false;
      return true;
    }
  }, {
    key: "contains",
    value: function contains(addressStr) {
      var address = colCache.decodeEx(addressStr);
      return this.containsEx(address);
    }
  }, {
    key: "containsEx",
    value: function containsEx(address) {
      if (address.sheetName && this.sheetName && address.sheetName !== this.sheetName) return false;
      return address.row >= this.top && address.row <= this.bottom && address.col >= this.left && address.col <= this.right;
    }
  }, {
    key: "forEachAddress",
    value: function forEachAddress(cb) {
      for (var col = this.left; col <= this.right; col++) {
        for (var row = this.top; row <= this.bottom; row++) {
          cb(colCache.encodeAddress(row, col), row, col);
        }
      }
    }
  }, {
    key: "top",
    get: function get() {
      return this.model.top || 1;
    },
    set: function set(value) {
      this.model.top = value;
    }
  }, {
    key: "left",
    get: function get() {
      return this.model.left || 1;
    },
    set: function set(value) {
      this.model.left = value;
    }
  }, {
    key: "bottom",
    get: function get() {
      return this.model.bottom || 1;
    },
    set: function set(value) {
      this.model.bottom = value;
    }
  }, {
    key: "right",
    get: function get() {
      return this.model.right || 1;
    },
    set: function set(value) {
      this.model.right = value;
    }
  }, {
    key: "sheetName",
    get: function get() {
      return this.model.sheetName;
    },
    set: function set(value) {
      this.model.sheetName = value;
    }
  }, {
    key: "_serialisedSheetName",
    get: function get() {
      var sheetName = this.model.sheetName;

      if (sheetName) {
        if (/^[a-zA-Z0-9]*$/.test(sheetName)) {
          return "".concat(sheetName, "!");
        }

        return "'".concat(sheetName, "'!");
      }

      return '';
    }
  }, {
    key: "tl",
    get: function get() {
      return colCache.n2l(this.left) + this.top;
    }
  }, {
    key: "$t$l",
    get: function get() {
      return "$".concat(colCache.n2l(this.left), "$").concat(this.top);
    }
  }, {
    key: "br",
    get: function get() {
      return colCache.n2l(this.right) + this.bottom;
    }
  }, {
    key: "$b$r",
    get: function get() {
      return "$".concat(colCache.n2l(this.right), "$").concat(this.bottom);
    }
  }, {
    key: "range",
    get: function get() {
      return "".concat(this._serialisedSheetName + this.tl, ":").concat(this.br);
    }
  }, {
    key: "$range",
    get: function get() {
      return "".concat(this._serialisedSheetName + this.$t$l, ":").concat(this.$b$r);
    }
  }, {
    key: "shortRange",
    get: function get() {
      return this.count > 1 ? this.range : this._serialisedSheetName + this.tl;
    }
  }, {
    key: "$shortRange",
    get: function get() {
      return this.count > 1 ? this.$range : this._serialisedSheetName + this.$t$l;
    }
  }, {
    key: "count",
    get: function get() {
      return (1 + this.bottom - this.top) * (1 + this.right - this.left);
    }
  }]);

  return Range;
}();

module.exports = Range;

},{"../utils/col-cache":19}],11:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../utils/under-dash');

var Enums = require('./enums');

var colCache = require('../utils/col-cache');

var Cell = require('./cell');

var Row = /*#__PURE__*/function () {
  function Row(worksheet, number) {
    _classCallCheck(this, Row);

    this._worksheet = worksheet;
    this._number = number;
    this._cells = [];
    this.style = {};
    this.outlineLevel = 0;
  } // return the row number


  _createClass(Row, [{
    key: "commit",
    // Inform Streaming Writer that this row (and all rows before it) are complete
    // and ready to write. Has no effect on Worksheet document
    value: function commit() {
      this._worksheet._commitRow(this); // eslint-disable-line no-underscore-dangle

    } // helps GC by breaking cyclic references

  }, {
    key: "destroy",
    value: function destroy() {
      delete this._worksheet;
      delete this._cells;
      delete this.style;
    }
  }, {
    key: "findCell",
    value: function findCell(colNumber) {
      return this._cells[colNumber - 1];
    } // given {address, row, col}, find or create new cell

  }, {
    key: "getCellEx",
    value: function getCellEx(address) {
      var cell = this._cells[address.col - 1];

      if (!cell) {
        var column = this._worksheet.getColumn(address.col);

        cell = new Cell(this, column, address.address);
        this._cells[address.col - 1] = cell;
      }

      return cell;
    } // get cell by key, letter or column number

  }, {
    key: "getCell",
    value: function getCell(col) {
      if (typeof col === 'string') {
        // is it a key?
        var column = this._worksheet.getColumnKey(col);

        if (column) {
          col = column.number;
        } else {
          col = colCache.l2n(col);
        }
      }

      return this._cells[col - 1] || this.getCellEx({
        address: colCache.encodeAddress(this._number, col),
        row: this._number,
        col: col
      });
    } // remove cell(s) and shift all higher cells down by count

  }, {
    key: "splice",
    value: function splice(start, count) {
      var nKeep = start + count;

      for (var _len = arguments.length, inserts = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        inserts[_key - 2] = arguments[_key];
      }

      var nExpand = inserts.length - count;
      var nEnd = this._cells.length;
      var i;
      var cSrc;
      var cDst;

      if (nExpand < 0) {
        // remove cells
        for (i = start + inserts.length; i <= nEnd; i++) {
          cDst = this._cells[i - 1];
          cSrc = this._cells[i - nExpand - 1];

          if (cSrc) {
            cDst = this.getCell(i);
            cDst.value = cSrc.value;
            cDst.style = cSrc.style; // eslint-disable-next-line no-underscore-dangle

            cDst._comment = cSrc._comment;
          } else if (cDst) {
            cDst.value = null;
            cDst.style = {}; // eslint-disable-next-line no-underscore-dangle

            cDst._comment = undefined;
          }
        }
      } else if (nExpand > 0) {
        // insert new cells
        for (i = nEnd; i >= nKeep; i--) {
          cSrc = this._cells[i - 1];

          if (cSrc) {
            cDst = this.getCell(i + nExpand);
            cDst.value = cSrc.value;
            cDst.style = cSrc.style; // eslint-disable-next-line no-underscore-dangle

            cDst._comment = cSrc._comment;
          } else {
            this._cells[i + nExpand - 1] = undefined;
          }
        }
      } // now add the new values


      for (i = 0; i < inserts.length; i++) {
        cDst = this.getCell(start + i);
        cDst.value = inserts[i];
        cDst.style = {}; // eslint-disable-next-line no-underscore-dangle

        cDst._comment = undefined;
      }
    } // Iterate over all non-null cells in this row

  }, {
    key: "eachCell",
    value: function eachCell(options, iteratee) {
      if (!iteratee) {
        iteratee = options;
        options = null;
      }

      if (options && options.includeEmpty) {
        var n = this._cells.length;

        for (var i = 1; i <= n; i++) {
          iteratee(this.getCell(i), i);
        }
      } else {
        this._cells.forEach(function (cell, index) {
          if (cell && cell.type !== Enums.ValueType.Null) {
            iteratee(cell, index + 1);
          }
        });
      }
    } // ===========================================================================
    // Page Breaks

  }, {
    key: "addPageBreak",
    value: function addPageBreak(lft, rght) {
      var ws = this._worksheet;
      var left = Math.max(0, lft - 1) || 0;
      var right = Math.max(0, rght - 1) || 16838;
      var pb = {
        id: this._number,
        max: right,
        man: 1
      };
      if (left) pb.min = left;
      ws.rowBreaks.push(pb);
    } // return a sparse array of cell values

  }, {
    key: "_applyStyle",
    // =========================================================================
    // styles
    value: function _applyStyle(name, value) {
      this.style[name] = value;

      this._cells.forEach(function (cell) {
        if (cell) {
          cell[name] = value;
        }
      });

      return value;
    }
  }, {
    key: "number",
    get: function get() {
      return this._number;
    }
  }, {
    key: "worksheet",
    get: function get() {
      return this._worksheet;
    }
  }, {
    key: "values",
    get: function get() {
      var values = [];

      this._cells.forEach(function (cell) {
        if (cell && cell.type !== Enums.ValueType.Null) {
          values[cell.col] = cell.value;
        }
      });

      return values;
    } // set the values by contiguous or sparse array, or by key'd object literal
    ,
    set: function set(value) {
      var _this = this;

      // this operation is not additive - any prior cells are removed
      this._cells = [];

      if (!value) {// empty row
      } else if (value instanceof Array) {
        var offset = 0;

        if (value.hasOwnProperty('0')) {
          // contiguous array - start at column 1
          offset = 1;
        }

        value.forEach(function (item, index) {
          if (item !== undefined) {
            _this.getCellEx({
              address: colCache.encodeAddress(_this._number, index + offset),
              row: _this._number,
              col: index + offset
            }).value = item;
          }
        });
      } else {
        // assume object with column keys
        this._worksheet.eachColumnKey(function (column, key) {
          if (value[key] !== undefined) {
            _this.getCellEx({
              address: colCache.encodeAddress(_this._number, column.number),
              row: _this._number,
              col: column.number
            }).value = value[key];
          }
        });
      }
    } // returns true if the row includes at least one cell with a value

  }, {
    key: "hasValues",
    get: function get() {
      return _.some(this._cells, function (cell) {
        return cell && cell.type !== Enums.ValueType.Null;
      });
    }
  }, {
    key: "cellCount",
    get: function get() {
      return this._cells.length;
    }
  }, {
    key: "actualCellCount",
    get: function get() {
      var count = 0;
      this.eachCell(function () {
        count++;
      });
      return count;
    } // get the min and max column number for the non-null cells in this row or null

  }, {
    key: "dimensions",
    get: function get() {
      var min = 0;
      var max = 0;

      this._cells.forEach(function (cell) {
        if (cell && cell.type !== Enums.ValueType.Null) {
          if (!min || min > cell.col) {
            min = cell.col;
          }

          if (max < cell.col) {
            max = cell.col;
          }
        }
      });

      return min > 0 ? {
        min: min,
        max: max
      } : null;
    }
  }, {
    key: "numFmt",
    get: function get() {
      return this.style.numFmt;
    },
    set: function set(value) {
      this._applyStyle('numFmt', value);
    }
  }, {
    key: "font",
    get: function get() {
      return this.style.font;
    },
    set: function set(value) {
      this._applyStyle('font', value);
    }
  }, {
    key: "alignment",
    get: function get() {
      return this.style.alignment;
    },
    set: function set(value) {
      this._applyStyle('alignment', value);
    }
  }, {
    key: "protection",
    get: function get() {
      return this.style.protection;
    },
    set: function set(value) {
      this._applyStyle('protection', value);
    }
  }, {
    key: "border",
    get: function get() {
      return this.style.border;
    },
    set: function set(value) {
      this._applyStyle('border', value);
    }
  }, {
    key: "fill",
    get: function get() {
      return this.style.fill;
    },
    set: function set(value) {
      this._applyStyle('fill', value);
    }
  }, {
    key: "hidden",
    get: function get() {
      return !!this._hidden;
    },
    set: function set(value) {
      this._hidden = value;
    }
  }, {
    key: "outlineLevel",
    get: function get() {
      return this._outlineLevel || 0;
    },
    set: function set(value) {
      this._outlineLevel = value;
    }
  }, {
    key: "collapsed",
    get: function get() {
      return !!(this._outlineLevel && this._outlineLevel >= this._worksheet.properties.outlineLevelRow);
    } // =========================================================================

  }, {
    key: "model",
    get: function get() {
      var cells = [];
      var min = 0;
      var max = 0;

      this._cells.forEach(function (cell) {
        if (cell) {
          var cellModel = cell.model;

          if (cellModel) {
            if (!min || min > cell.col) {
              min = cell.col;
            }

            if (max < cell.col) {
              max = cell.col;
            }

            cells.push(cellModel);
          }
        }
      });

      return this.height || cells.length ? {
        cells: cells,
        number: this.number,
        min: min,
        max: max,
        height: this.height,
        style: this.style,
        hidden: this.hidden,
        outlineLevel: this.outlineLevel,
        collapsed: this.collapsed
      } : null;
    },
    set: function set(value) {
      var _this2 = this;

      if (value.number !== this._number) {
        throw new Error('Invalid row number in model');
      }

      this._cells = [];
      var previousAddress;
      value.cells.forEach(function (cellModel) {
        switch (cellModel.type) {
          case Cell.Types.Merge:
            // special case - don't add this types
            break;

          default:
            {
              var address;

              if (cellModel.address) {
                address = colCache.decodeAddress(cellModel.address);
              } else if (previousAddress) {
                // This is a <c> element without an r attribute
                // Assume that it's the cell for the next column
                var _previousAddress = previousAddress,
                    row = _previousAddress.row;
                var col = previousAddress.col + 1;
                address = {
                  row: row,
                  col: col,
                  address: colCache.encodeAddress(row, col),
                  $col$row: "$".concat(colCache.n2l(col), "$").concat(row)
                };
              }

              previousAddress = address;

              var cell = _this2.getCellEx(address);

              cell.model = cellModel;
              break;
            }
        }
      });

      if (value.height) {
        this.height = value.height;
      } else {
        delete this.height;
      }

      this.hidden = value.hidden;
      this.outlineLevel = value.outlineLevel || 0;
      this.style = value.style && JSON.parse(JSON.stringify(value.style)) || {};
    }
  }]);

  return Row;
}();

module.exports = Row;

},{"../utils/col-cache":19,"../utils/under-dash":25,"./cell":3,"./enums":7}],12:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/* eslint-disable max-classes-per-file */
var colCache = require('../utils/col-cache');

var Column = /*#__PURE__*/function () {
  // wrapper around column model, allowing access and manipulation
  function Column(table, column, index) {
    _classCallCheck(this, Column);

    this.table = table;
    this.column = column;
    this.index = index;
  }

  _createClass(Column, [{
    key: "_set",
    value: function _set(name, value) {
      this.table.cacheState();
      this.column[name] = value;
    }
    /* eslint-disable lines-between-class-members */

  }, {
    key: "name",
    get: function get() {
      return this.column.name;
    },
    set: function set(value) {
      this._set('name', value);
    }
  }, {
    key: "filterButton",
    get: function get() {
      return this.column.filterButton;
    },
    set: function set(value) {
      this.column.filterButton = value;
    }
  }, {
    key: "style",
    get: function get() {
      return this.column.style;
    },
    set: function set(value) {
      this.column.style = value;
    }
  }, {
    key: "totalsRowLabel",
    get: function get() {
      return this.column.totalsRowLabel;
    },
    set: function set(value) {
      this._set('totalsRowLabel', value);
    }
  }, {
    key: "totalsRowFunction",
    get: function get() {
      return this.column.totalsRowFunction;
    },
    set: function set(value) {
      this._set('totalsRowFunction', value);
    }
  }, {
    key: "totalsRowResult",
    get: function get() {
      return this.column.totalsRowResult;
    },
    set: function set(value) {
      this._set('totalsRowResult', value);
    }
  }, {
    key: "totalsRowFormula",
    get: function get() {
      return this.column.totalsRowFormula;
    },
    set: function set(value) {
      this._set('totalsRowFormula', value);
    }
    /* eslint-enable lines-between-class-members */

  }]);

  return Column;
}();

var Table = /*#__PURE__*/function () {
  function Table(worksheet, table) {
    _classCallCheck(this, Table);

    this.worksheet = worksheet;

    if (table) {
      this.table = table; // check things are ok first

      this.validate();
      this.store();
    }
  }

  _createClass(Table, [{
    key: "getFormula",
    value: function getFormula(column) {
      // get the correct formula to apply to the totals row
      switch (column.totalsRowFunction) {
        case 'none':
          return null;

        case 'average':
          return "SUBTOTAL(101,".concat(this.table.name, "[").concat(column.name, "])");

        case 'countNums':
          return "SUBTOTAL(102,".concat(this.table.name, "[").concat(column.name, "])");

        case 'count':
          return "SUBTOTAL(103,".concat(this.table.name, "[").concat(column.name, "])");

        case 'max':
          return "SUBTOTAL(104,".concat(this.table.name, "[").concat(column.name, "])");

        case 'min':
          return "SUBTOTAL(105,".concat(this.table.name, "[").concat(column.name, "])");

        case 'stdDev':
          return "SUBTOTAL(106,".concat(this.table.name, "[").concat(column.name, "])");

        case 'var':
          return "SUBTOTAL(107,".concat(this.table.name, "[").concat(column.name, "])");

        case 'sum':
          return "SUBTOTAL(109,".concat(this.table.name, "[").concat(column.name, "])");

        case 'custom':
          return column.totalsRowFormula;

        default:
          throw new Error("Invalid Totals Row Function: ".concat(column.totalsRowFunction));
      }
    }
  }, {
    key: "validate",
    value: function validate() {
      var _this = this;

      var table = this.table; // set defaults and check is valid

      var assign = function assign(o, name, dflt) {
        if (o[name] === undefined) {
          o[name] = dflt;
        }
      };

      assign(table, 'headerRow', true);
      assign(table, 'totalsRow', false);
      assign(table, 'style', {});
      assign(table.style, 'theme', 'TableStyleMedium2');
      assign(table.style, 'showFirstColumn', false);
      assign(table.style, 'showLastColumn', false);
      assign(table.style, 'showRowStripes', false);
      assign(table.style, 'showColumnStripes', false);

      var assert = function assert(test, message) {
        if (!test) {
          throw new Error(message);
        }
      };

      assert(table.ref, 'Table must have ref');
      assert(table.columns, 'Table must have column definitions');
      assert(table.rows, 'Table must have row definitions');
      table.tl = colCache.decodeAddress(table.ref);
      var _table$tl = table.tl,
          row = _table$tl.row,
          col = _table$tl.col;
      assert(row > 0, 'Table must be on valid row');
      assert(col > 0, 'Table must be on valid col');
      var width = this.width,
          filterHeight = this.filterHeight,
          tableHeight = this.tableHeight; // autoFilterRef is a range that includes optional headers only

      table.autoFilterRef = colCache.encode(row, col, row + filterHeight - 1, col + width - 1); // tableRef is a range that includes optional headers and totals

      table.tableRef = colCache.encode(row, col, row + tableHeight - 1, col + width - 1);
      table.columns.forEach(function (column, i) {
        assert(column.name, "Column ".concat(i, " must have a name"));

        if (i === 0) {
          assign(column, 'totalsRowLabel', 'Total');
        } else {
          assign(column, 'totalsRowFunction', 'none');
          column.totalsRowFormula = _this.getFormula(column);
        }
      });
    }
  }, {
    key: "store",
    value: function store() {
      var _this2 = this;

      // where the table needs to store table data, headers, footers in
      // the sheet...
      var assignStyle = function assignStyle(cell, style) {
        if (style) {
          Object.keys(style).forEach(function (key) {
            cell[key] = style[key];
          });
        }
      };

      var worksheet = this.worksheet,
          table = this.table;
      var _table$tl2 = table.tl,
          row = _table$tl2.row,
          col = _table$tl2.col;
      var count = 0;

      if (table.headerRow) {
        var r = worksheet.getRow(row + count++);
        table.columns.forEach(function (column, j) {
          var style = column.style,
              name = column.name;
          var cell = r.getCell(col + j);
          cell.value = name;
          assignStyle(cell, style);
        });
      }

      table.rows.forEach(function (data) {
        var r = worksheet.getRow(row + count++);
        data.forEach(function (value, j) {
          var cell = r.getCell(col + j);
          cell.value = value;
          assignStyle(cell, table.columns[j].style);
        });
      });

      if (table.totalsRow) {
        var _r = worksheet.getRow(row + count++);

        table.columns.forEach(function (column, j) {
          var cell = _r.getCell(col + j);

          if (j === 0) {
            cell.value = column.totalsRowLabel;
          } else {
            var formula = _this2.getFormula(column);

            if (formula) {
              cell.value = {
                formula: column.totalsRowFormula,
                result: column.totalsRowResult
              };
            } else {
              cell.value = null;
            }
          }

          assignStyle(cell, column.style);
        });
      }
    }
  }, {
    key: "load",
    value: function load(worksheet) {
      var _this3 = this;

      // where the table will read necessary features from a loaded sheet
      var table = this.table;
      var _table$tl3 = table.tl,
          row = _table$tl3.row,
          col = _table$tl3.col;
      var count = 0;

      if (table.headerRow) {
        var r = worksheet.getRow(row + count++);
        table.columns.forEach(function (column, j) {
          var cell = r.getCell(col + j);
          cell.value = column.name;
        });
      }

      table.rows.forEach(function (data) {
        var r = worksheet.getRow(row + count++);
        data.forEach(function (value, j) {
          var cell = r.getCell(col + j);
          cell.value = value;
        });
      });

      if (table.totalsRow) {
        var _r2 = worksheet.getRow(row + count++);

        table.columns.forEach(function (column, j) {
          var cell = _r2.getCell(col + j);

          if (j === 0) {
            cell.value = column.totalsRowLabel;
          } else {
            var formula = _this3.getFormula(column);

            if (formula) {
              cell.value = {
                formula: column.totalsRowFormula,
                result: column.totalsRowResult
              };
            }
          }
        });
      }
    }
  }, {
    key: "cacheState",
    // ================================================================
    // TODO: Mutating methods
    value: function cacheState() {
      if (!this._cache) {
        this._cache = {
          ref: this.ref,
          width: this.width,
          tableHeight: this.tableHeight
        };
      }
    }
  }, {
    key: "commit",
    value: function commit() {
      // changes may have been made that might have on-sheet effects
      if (!this._cache) {
        return;
      } // check things are ok first


      this.validate();
      var ref = colCache.decodeAddress(this._cache.ref);

      if (this.ref !== this._cache.ref) {
        // wipe out whole table footprint at previous location
        for (var i = 0; i < this._cache.tableHeight; i++) {
          var row = this.worksheet.getRow(ref.row + i);

          for (var j = 0; j < this._cache.width; j++) {
            var cell = row.getCell(ref.col + j);
            cell.value = null;
          }
        }
      } else {
        // clear out below table if it has shrunk
        for (var _i = this.tableHeight; _i < this._cache.tableHeight; _i++) {
          var _row = this.worksheet.getRow(ref.row + _i);

          for (var _j = 0; _j < this._cache.width; _j++) {
            var _cell = _row.getCell(ref.col + _j);

            _cell.value = null;
          }
        } // clear out to right of table if it has lost columns


        for (var _i2 = 0; _i2 < this.tableHeight; _i2++) {
          var _row2 = this.worksheet.getRow(ref.row + _i2);

          for (var _j2 = this.width; _j2 < this._cache.width; _j2++) {
            var _cell2 = _row2.getCell(ref.col + _j2);

            _cell2.value = null;
          }
        }
      }

      this.store();
    }
  }, {
    key: "addRow",
    value: function addRow(values, rowNumber) {
      // Add a row of data, either insert at rowNumber or append
      this.cacheState();

      if (rowNumber === undefined) {
        this.table.rows.push(values);
      } else {
        this.table.rows.splice(rowNumber, 0, values);
      }
    }
  }, {
    key: "removeRows",
    value: function removeRows(rowIndex) {
      var count = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      // Remove a rows of data
      this.cacheState();
      this.table.rows.splice(rowIndex, count);
    }
  }, {
    key: "getColumn",
    value: function getColumn(colIndex) {
      var column = this.table.columns[colIndex];
      return new Column(this, column, colIndex);
    }
  }, {
    key: "addColumn",
    value: function addColumn(column, values, colIndex) {
      // Add a new column, including column defn and values
      // Inserts at colNumber or adds to the right
      this.cacheState();

      if (colIndex === undefined) {
        this.table.columns.push(column);
        this.table.rows.forEach(function (row, i) {
          row.push(values[i]);
        });
      } else {
        this.table.columns.splice(colIndex, 0, column);
        this.table.rows.forEach(function (row, i) {
          row.splice(colIndex, 0, values[i]);
        });
      }
    }
  }, {
    key: "removeColumns",
    value: function removeColumns(colIndex) {
      var count = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      // Remove a column with data
      this.cacheState();
      this.table.columns.splice(colIndex, count);
      this.table.rows.forEach(function (row) {
        row.splice(colIndex, count);
      });
    }
  }, {
    key: "_assign",
    value: function _assign(target, prop, value) {
      this.cacheState();
      target[prop] = value;
    }
    /* eslint-disable lines-between-class-members */

  }, {
    key: "width",
    get: function get() {
      // width of the table
      return this.table.columns.length;
    }
  }, {
    key: "height",
    get: function get() {
      // height of the table data
      return this.table.rows.length;
    }
  }, {
    key: "filterHeight",
    get: function get() {
      // height of the table data plus optional header row
      return this.height + (this.table.headerRow ? 1 : 0);
    }
  }, {
    key: "tableHeight",
    get: function get() {
      // full height of the table on the sheet
      return this.filterHeight + (this.table.totalsRow ? 1 : 0);
    }
  }, {
    key: "model",
    get: function get() {
      return this.table;
    },
    set: function set(value) {
      this.table = value;
    }
  }, {
    key: "ref",
    get: function get() {
      return this.table.ref;
    },
    set: function set(value) {
      this._assign(this.table, 'ref', value);
    }
  }, {
    key: "name",
    get: function get() {
      return this.table.name;
    },
    set: function set(value) {
      this.table.name = value;
    }
  }, {
    key: "displayName",
    get: function get() {
      return this.table.displyName || this.table.name;
    }
  }, {
    key: "displayNamename",
    set: function set(value) {
      this.table.displayName = value;
    }
  }, {
    key: "headerRow",
    get: function get() {
      return this.table.headerRow;
    },
    set: function set(value) {
      this._assign(this.table, 'headerRow', value);
    }
  }, {
    key: "totalsRow",
    get: function get() {
      return this.table.totalsRow;
    },
    set: function set(value) {
      this._assign(this.table, 'totalsRow', value);
    }
  }, {
    key: "theme",
    get: function get() {
      return this.table.style.name;
    },
    set: function set(value) {
      this.table.style.name = value;
    }
  }, {
    key: "showFirstColumn",
    get: function get() {
      return this.table.style.showFirstColumn;
    },
    set: function set(value) {
      this.table.style.showFirstColumn = value;
    }
  }, {
    key: "showLastColumn",
    get: function get() {
      return this.table.style.showLastColumn;
    },
    set: function set(value) {
      this.table.style.showLastColumn = value;
    }
  }, {
    key: "showRowStripes",
    get: function get() {
      return this.table.style.showRowStripes;
    },
    set: function set(value) {
      this.table.style.showRowStripes = value;
    }
  }, {
    key: "showColumnStripes",
    get: function get() {
      return this.table.style.showColumnStripes;
    },
    set: function set(value) {
      this.table.style.showColumnStripes = value;
    }
    /* eslint-enable lines-between-class-members */

  }]);

  return Table;
}();

module.exports = Table;

},{"../utils/col-cache":19}],13:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Worksheet = require('./worksheet');

var DefinedNames = require('./defined-names');

var XLSX = require('../xlsx/xlsx');

var CSV = require('../csv/csv'); // Workbook requirements
//  Load and Save from file and stream
//  Access/Add/Delete individual worksheets
//  Manage String table, Hyperlink table, etc.
//  Manage scaffolding for contained objects to write to/read from


var Workbook = /*#__PURE__*/function () {
  function Workbook() {
    _classCallCheck(this, Workbook);

    this.created = new Date();
    this.modified = this.created;
    this.properties = {};
    this.calcProperties = {};
    this._worksheets = [];
    this.views = [];
    this.media = [];
    this._definedNames = new DefinedNames();
  }

  _createClass(Workbook, [{
    key: "addWorksheet",
    value: function addWorksheet(name, options) {
      var id = this.nextId;

      if (name && name.length > 31) {
        // eslint-disable-next-line no-console
        console.warn("Worksheet name ".concat(name, " exceeds 31 chars. This will be truncated"));
      } // Illegal character in worksheet name: asterisk (*), question mark (?),
      // colon (:), forward slash (/ \), or bracket ([])


      if (/[*?:/\\[\]]/.test(name)) {
        throw new Error("Worksheet name ".concat(name, " cannot include any of the following characters: * ? : \\ / [ ]"));
      }

      if (/(^')|('$)/.test(name)) {
        throw new Error("The first or last character of worksheet name cannot be a single quotation mark: ".concat(name));
      }

      name = (name || "sheet".concat(id)).substring(0, 31);

      if (this._worksheets.find(function (ws) {
        return ws && ws.name.toLowerCase() === name.toLowerCase();
      })) {
        throw new Error("Worksheet name already exists: ".concat(name));
      } // if options is a color, call it tabColor (and signal deprecated message)


      if (options) {
        if (typeof options === 'string') {
          // eslint-disable-next-line no-console
          console.trace('tabColor argument is now deprecated. Please use workbook.addWorksheet(name, {properties: { tabColor: { argb: "rbg value" } }');
          options = {
            properties: {
              tabColor: {
                argb: options
              }
            }
          };
        } else if (options.argb || options.theme || options.indexed) {
          // eslint-disable-next-line no-console
          console.trace('tabColor argument is now deprecated. Please use workbook.addWorksheet(name, {properties: { tabColor: { ... } }');
          options = {
            properties: {
              tabColor: options
            }
          };
        }
      }

      var lastOrderNo = this._worksheets.reduce(function (acc, ws) {
        return (ws && ws.orderNo) > acc ? ws.orderNo : acc;
      }, 0);

      var worksheetOptions = Object.assign({}, options, {
        id: id,
        name: name,
        orderNo: lastOrderNo + 1,
        workbook: this
      });
      var worksheet = new Worksheet(worksheetOptions);
      this._worksheets[id] = worksheet;
      return worksheet;
    }
  }, {
    key: "removeWorksheetEx",
    value: function removeWorksheetEx(worksheet) {
      delete this._worksheets[worksheet.id];
    }
  }, {
    key: "removeWorksheet",
    value: function removeWorksheet(id) {
      var worksheet = this.getWorksheet(id);

      if (worksheet) {
        worksheet.destroy();
      }
    }
  }, {
    key: "getWorksheet",
    value: function getWorksheet(id) {
      if (id === undefined) {
        return this._worksheets.find(Boolean);
      }

      if (typeof id === 'number') {
        return this._worksheets[id];
      }

      if (typeof id === 'string') {
        return this._worksheets.find(function (worksheet) {
          return worksheet && worksheet.name === id;
        });
      }

      return undefined;
    }
  }, {
    key: "eachSheet",
    value: function eachSheet(iteratee) {
      this.worksheets.forEach(function (sheet) {
        iteratee(sheet, sheet.id);
      });
    }
  }, {
    key: "clearThemes",
    value: function clearThemes() {
      // Note: themes are not an exposed feature, meddle at your peril!
      this._themes = undefined;
    }
  }, {
    key: "addImage",
    value: function addImage(image) {
      // TODO:  validation?
      var id = this.media.length;
      this.media.push(Object.assign({}, image, {
        type: 'image'
      }));
      return id;
    }
  }, {
    key: "getImage",
    value: function getImage(id) {
      return this.media[id];
    }
  }, {
    key: "xlsx",
    get: function get() {
      if (!this._xlsx) this._xlsx = new XLSX(this);
      return this._xlsx;
    }
  }, {
    key: "csv",
    get: function get() {
      if (!this._csv) this._csv = new CSV(this);
      return this._csv;
    }
  }, {
    key: "nextId",
    get: function get() {
      // find the next unique spot to add worksheet
      for (var i = 1; i < this._worksheets.length; i++) {
        if (!this._worksheets[i]) {
          return i;
        }
      }

      return this._worksheets.length || 1;
    }
  }, {
    key: "worksheets",
    get: function get() {
      // return a clone of _worksheets
      return this._worksheets.slice(1).sort(function (a, b) {
        return a.orderNo - b.orderNo;
      }).filter(Boolean);
    }
  }, {
    key: "definedNames",
    get: function get() {
      return this._definedNames;
    }
  }, {
    key: "model",
    get: function get() {
      return {
        creator: this.creator || 'Unknown',
        lastModifiedBy: this.lastModifiedBy || 'Unknown',
        lastPrinted: this.lastPrinted,
        created: this.created,
        modified: this.modified,
        properties: this.properties,
        worksheets: this.worksheets.map(function (worksheet) {
          return worksheet.model;
        }),
        sheets: this.worksheets.map(function (ws) {
          return ws.model;
        }).filter(Boolean),
        definedNames: this._definedNames.model,
        views: this.views,
        company: this.company,
        manager: this.manager,
        title: this.title,
        subject: this.subject,
        keywords: this.keywords,
        category: this.category,
        description: this.description,
        language: this.language,
        revision: this.revision,
        contentStatus: this.contentStatus,
        themes: this._themes,
        media: this.media,
        calcProperties: this.calcProperties
      };
    },
    set: function set(value) {
      var _this = this;

      this.creator = value.creator;
      this.lastModifiedBy = value.lastModifiedBy;
      this.lastPrinted = value.lastPrinted;
      this.created = value.created;
      this.modified = value.modified;
      this.company = value.company;
      this.manager = value.manager;
      this.title = value.title;
      this.subject = value.subject;
      this.keywords = value.keywords;
      this.category = value.category;
      this.description = value.description;
      this.language = value.language;
      this.revision = value.revision;
      this.contentStatus = value.contentStatus;
      this.properties = value.properties;
      this.calcProperties = value.calcProperties;
      this._worksheets = [];
      value.worksheets.forEach(function (worksheetModel) {
        var id = worksheetModel.id,
            name = worksheetModel.name,
            state = worksheetModel.state;
        var orderNo = value.sheets && value.sheets.findIndex(function (ws) {
          return ws.id === id;
        });
        var worksheet = _this._worksheets[id] = new Worksheet({
          id: id,
          name: name,
          orderNo: orderNo,
          state: state,
          workbook: _this
        });
        worksheet.model = worksheetModel;
      });
      this._definedNames.model = value.definedNames;
      this.views = value.views;
      this._themes = value.themes;
      this.media = value.media || [];
    }
  }]);

  return Workbook;
}();

module.exports = Workbook;

},{"../csv/csv":1,"../xlsx/xlsx":141,"./defined-names":6,"./worksheet":14}],14:[function(require,module,exports){
"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../utils/under-dash');

var colCache = require('../utils/col-cache');

var Range = require('./range');

var Row = require('./row');

var Column = require('./column');

var Enums = require('./enums');

var Image = require('./image');

var Table = require('./table');

var DataValidations = require('./data-validations');

var Encryptor = require('../utils/encryptor'); // Worksheet requirements
//  Operate as sheet inside workbook or standalone
//  Load and Save from file and stream
//  Access/Add/Delete individual cells
//  Manage column widths and row heights


var Worksheet = /*#__PURE__*/function () {
  function Worksheet(options) {
    _classCallCheck(this, Worksheet);

    options = options || {}; // in a workbook, each sheet will have a number

    this.id = options.id;
    this.orderNo = options.orderNo; // and a name

    this.name = options.name || "Sheet".concat(this.id); // add a state

    this.state = options.state || 'visible'; // rows allows access organised by row. Sparse array of arrays indexed by row-1, col
    // Note: _rows is zero based. Must subtract 1 to go from cell.row to index

    this._rows = []; // column definitions

    this._columns = null; // column keys (addRow convenience): key ==> this._collumns index

    this._keys = {}; // keep record of all merges

    this._merges = {}; // record of all row and column pageBreaks

    this.rowBreaks = [];
    this._workbook = options.workbook; // for tabColor, default row height, outline levels, etc

    this.properties = Object.assign({}, {
      defaultRowHeight: 15,
      dyDescent: 55,
      outlineLevelCol: 0,
      outlineLevelRow: 0
    }, options.properties); // for all things printing

    this.pageSetup = Object.assign({}, {
      margins: {
        left: 0.7,
        right: 0.7,
        top: 0.75,
        bottom: 0.75,
        header: 0.3,
        footer: 0.3
      },
      orientation: 'portrait',
      horizontalDpi: 4294967295,
      verticalDpi: 4294967295,
      fitToPage: !!(options.pageSetup && (options.pageSetup.fitToWidth || options.pageSetup.fitToHeight) && !options.pageSetup.scale),
      pageOrder: 'downThenOver',
      blackAndWhite: false,
      draft: false,
      cellComments: 'None',
      errors: 'displayed',
      scale: 100,
      fitToWidth: 1,
      fitToHeight: 1,
      paperSize: undefined,
      showRowColHeaders: false,
      showGridLines: false,
      firstPageNumber: undefined,
      horizontalCentered: false,
      verticalCentered: false,
      rowBreaks: null,
      colBreaks: null
    }, options.pageSetup);
    this.headerFooter = Object.assign({}, {
      differentFirst: false,
      differentOddEven: false,
      oddHeader: null,
      oddFooter: null,
      evenHeader: null,
      evenFooter: null,
      firstHeader: null,
      firstFooter: null
    }, options.headerFooter);
    this.dataValidations = new DataValidations(); // for freezepanes, split, zoom, gridlines, etc

    this.views = options.views || [];
    this.autoFilter = options.autoFilter || null; // for images, etc

    this._media = []; // worksheet protection

    this.sheetProtection = null; // for tables

    this.tables = {};
    this.conditionalFormattings = [];
  }

  _createClass(Worksheet, [{
    key: "destroy",
    // when you're done with this worksheet, call this to remove from workbook
    value: function destroy() {
      this._workbook.removeWorksheetEx(this);
    } // Get the bounding range of the cells in this worksheet

  }, {
    key: "getColumnKey",
    value: function getColumnKey(key) {
      return this._keys[key];
    }
  }, {
    key: "setColumnKey",
    value: function setColumnKey(key, value) {
      this._keys[key] = value;
    }
  }, {
    key: "deleteColumnKey",
    value: function deleteColumnKey(key) {
      delete this._keys[key];
    }
  }, {
    key: "eachColumnKey",
    value: function eachColumnKey(f) {
      _.each(this._keys, f);
    } // get a single column by col number. If it doesn't exist, create it and any gaps before it

  }, {
    key: "getColumn",
    value: function getColumn(c) {
      if (typeof c === 'string') {
        // if it matches a key'd column, return that
        var col = this._keys[c];
        if (col) return col; // otherwise, assume letter

        c = colCache.l2n(c);
      }

      if (!this._columns) {
        this._columns = [];
      }

      if (c > this._columns.length) {
        var n = this._columns.length + 1;

        while (n <= c) {
          this._columns.push(new Column(this, n++));
        }
      }

      return this._columns[c - 1];
    }
  }, {
    key: "spliceColumns",
    value: function spliceColumns(start, count) {
      var _this = this;

      var rows = this._rows;
      var nRows = rows.length;

      for (var _len = arguments.length, inserts = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        inserts[_key - 2] = arguments[_key];
      }

      if (inserts.length > 0) {
        var _loop = function _loop(i) {
          var rowArguments = [start, count]; // eslint-disable-next-line no-loop-func

          inserts.forEach(function (insert) {
            rowArguments.push(insert[i] || null);
          });

          var row = _this.getRow(i + 1); // eslint-disable-next-line prefer-spread


          row.splice.apply(row, rowArguments);
        };

        // must iterate over all rows whether they exist yet or not
        for (var i = 0; i < nRows; i++) {
          _loop(i);
        }
      } else {
        // nothing to insert, so just splice all rows
        this._rows.forEach(function (r) {
          if (r) {
            r.splice(start, count);
          }
        });
      } // splice column definitions


      var nExpand = inserts.length - count;
      var nKeep = start + count;
      var nEnd = this._columns.length;

      if (nExpand < 0) {
        for (var _i = start + inserts.length; _i <= nEnd; _i++) {
          this.getColumn(_i).defn = this.getColumn(_i - nExpand).defn;
        }
      } else if (nExpand > 0) {
        for (var _i2 = nEnd; _i2 >= nKeep; _i2--) {
          this.getColumn(_i2 + nExpand).defn = this.getColumn(_i2).defn;
        }
      }

      for (var _i3 = start; _i3 < start + inserts.length; _i3++) {
        this.getColumn(_i3).defn = null;
      } // account for defined names


      this.workbook.definedNames.spliceColumns(this.name, start, count, inserts.length);
    }
  }, {
    key: "_commitRow",
    // =========================================================================
    // Rows
    value: function _commitRow() {// nop - allows streaming reader to fill a document
    }
  }, {
    key: "findRow",
    // find a row (if exists) by row number
    value: function findRow(r) {
      return this._rows[r - 1];
    } // find multiple rows (if exists) by row number

  }, {
    key: "findRows",
    value: function findRows(start, length) {
      return this._rows.slice(start - 1, start - 1 + length);
    }
  }, {
    key: "getRow",
    // get a row by row number.
    value: function getRow(r) {
      var row = this._rows[r - 1];

      if (!row) {
        row = this._rows[r - 1] = new Row(this, r);
      }

      return row;
    } // get multiple rows by row number.

  }, {
    key: "getRows",
    value: function getRows(start, length) {
      if (length < 1) return undefined;
      var rows = [];

      for (var i = start; i < start + length; i++) {
        rows.push(this.getRow(i));
      }

      return rows;
    }
  }, {
    key: "addRow",
    value: function addRow(value) {
      var style = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'n';
      var rowNo = this._nextRow;
      var row = this.getRow(rowNo);
      row.values = value;

      this._setStyleOption(rowNo, style[0] === 'i' ? style : 'n');

      return row;
    }
  }, {
    key: "addRows",
    value: function addRows(value) {
      var _this2 = this;

      var style = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'n';
      var rows = [];
      value.forEach(function (row) {
        rows.push(_this2.addRow(row, style));
      });
      return rows;
    }
  }, {
    key: "insertRow",
    value: function insertRow(pos, value) {
      var style = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'n';
      this.spliceRows(pos, 0, value);

      this._setStyleOption(pos, style);

      return this.getRow(pos);
    }
  }, {
    key: "insertRows",
    value: function insertRows(pos, values) {
      var style = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'n';
      this.spliceRows.apply(this, [pos, 0].concat(_toConsumableArray(values)));

      if (style !== 'n') {
        // copy over the styles
        for (var i = 0; i < values.length; i++) {
          if (style[0] === 'o' && this.findRow(values.length + pos + i) !== undefined) {
            this._copyStyle(values.length + pos + i, pos + i, style[1] === '+');
          } else if (style[0] === 'i' && this.findRow(pos - 1) !== undefined) {
            this._copyStyle(pos - 1, pos + i, style[1] === '+');
          }
        }
      }

      return this.getRows(pos, values.length);
    } // set row at position to same style as of either pervious row (option 'i') or next row (option 'o')

  }, {
    key: "_setStyleOption",
    value: function _setStyleOption(pos) {
      var style = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'n';

      if (style[0] === 'o' && this.findRow(pos + 1) !== undefined) {
        this._copyStyle(pos + 1, pos, style[1] === '+');
      } else if (style[0] === 'i' && this.findRow(pos - 1) !== undefined) {
        this._copyStyle(pos - 1, pos, style[1] === '+');
      }
    }
  }, {
    key: "_copyStyle",
    value: function _copyStyle(src, dest) {
      var styleEmpty = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var rSrc = this.getRow(src);
      var rDst = this.getRow(dest);
      rDst.style = Object.freeze(_objectSpread({}, rSrc.style)); // eslint-disable-next-line no-loop-func

      rSrc.eachCell({
        includeEmpty: styleEmpty
      }, function (cell, colNumber) {
        rDst.getCell(colNumber).style = Object.freeze(_objectSpread({}, cell.style));
      });
      rDst.height = rSrc.height;
    }
  }, {
    key: "duplicateRow",
    value: function duplicateRow(rowNum, count) {
      var _this3 = this;

      var insert = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      // create count duplicates of rowNum
      // either inserting new or overwriting existing rows
      var rSrc = this._rows[rowNum - 1];
      var inserts = new Array(count).fill(rSrc.values);
      this.spliceRows.apply(this, [rowNum + 1, insert ? 0 : count].concat(_toConsumableArray(inserts))); // now copy styles...

      var _loop2 = function _loop2(i) {
        var rDst = _this3._rows[rowNum + i];
        rDst.style = rSrc.style;
        rDst.height = rSrc.height; // eslint-disable-next-line no-loop-func

        rSrc.eachCell({
          includeEmpty: true
        }, function (cell, colNumber) {
          rDst.getCell(colNumber).style = cell.style;
        });
      };

      for (var i = 0; i < count; i++) {
        _loop2(i);
      }
    }
  }, {
    key: "spliceRows",
    value: function spliceRows(start, count) {
      var _this4 = this;

      // same problem as row.splice, except worse.
      var nKeep = start + count;

      for (var _len2 = arguments.length, inserts = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
        inserts[_key2 - 2] = arguments[_key2];
      }

      var nInserts = inserts.length;
      var nExpand = nInserts - count;
      var nEnd = this._rows.length;
      var i;
      var rSrc;

      if (nExpand < 0) {
        // remove rows
        for (i = nKeep; i <= nEnd; i++) {
          rSrc = this._rows[i - 1];

          if (rSrc) {
            (function () {
              var rDst = _this4.getRow(i + nExpand);

              rDst.values = rSrc.values;
              rDst.style = rSrc.style;
              rDst.height = rSrc.height; // eslint-disable-next-line no-loop-func

              rSrc.eachCell({
                includeEmpty: true
              }, function (cell, colNumber) {
                rDst.getCell(colNumber).style = cell.style;
              });
              _this4._rows[i - 1] = undefined;
            })();
          } else {
            this._rows[i + nExpand - 1] = undefined;
          }
        }
      } else if (nExpand > 0) {
        // insert new cells
        for (i = nEnd; i >= nKeep; i--) {
          rSrc = this._rows[i - 1];

          if (rSrc) {
            (function () {
              var rDst = _this4.getRow(i + nExpand);

              rDst.values = rSrc.values;
              rDst.style = rSrc.style;
              rDst.height = rSrc.height; // eslint-disable-next-line no-loop-func

              rSrc.eachCell({
                includeEmpty: true
              }, function (cell, colNumber) {
                rDst.getCell(colNumber).style = cell.style; // remerge cells accounting for insert offset

                if (cell._value.constructor.name === 'MergeValue') {
                  var cellToBeMerged = _this4.getRow(cell._row._number + nInserts).getCell(colNumber);

                  var prevMaster = cell._value._master;

                  var newMaster = _this4.getRow(prevMaster._row._number + nInserts).getCell(prevMaster._column._number);

                  cellToBeMerged.merge(newMaster);
                }
              });
            })();
          } else {
            this._rows[i + nExpand - 1] = undefined;
          }
        }
      } // now copy over the new values


      for (i = 0; i < nInserts; i++) {
        var rDst = this.getRow(start + i);
        rDst.style = {};
        rDst.values = inserts[i];
      } // account for defined names


      this.workbook.definedNames.spliceRows(this.name, start, count, nInserts);
    } // iterate over every row in the worksheet, including maybe empty rows

  }, {
    key: "eachRow",
    value: function eachRow(options, iteratee) {
      if (!iteratee) {
        iteratee = options;
        options = undefined;
      }

      if (options && options.includeEmpty) {
        var n = this._rows.length;

        for (var i = 1; i <= n; i++) {
          iteratee(this.getRow(i), i);
        }
      } else {
        this._rows.forEach(function (row) {
          if (row && row.hasValues) {
            iteratee(row, row.number);
          }
        });
      }
    } // return all rows as sparse array

  }, {
    key: "getSheetValues",
    value: function getSheetValues() {
      var rows = [];

      this._rows.forEach(function (row) {
        if (row) {
          rows[row.number] = row.values;
        }
      });

      return rows;
    } // =========================================================================
    // Cells
    // returns the cell at [r,c] or address given by r. If not found, return undefined

  }, {
    key: "findCell",
    value: function findCell(r, c) {
      var address = colCache.getAddress(r, c);
      var row = this._rows[address.row - 1];
      return row ? row.findCell(address.col) : undefined;
    } // return the cell at [r,c] or address given by r. If not found, create a new one.

  }, {
    key: "getCell",
    value: function getCell(r, c) {
      var address = colCache.getAddress(r, c);
      var row = this.getRow(address.row);
      return row.getCellEx(address);
    } // =========================================================================
    // Merge
    // convert the range defined by ['tl:br'], [tl,br] or [t,l,b,r] into a single 'merged' cell

  }, {
    key: "mergeCells",
    value: function mergeCells() {
      for (var _len3 = arguments.length, cells = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        cells[_key3] = arguments[_key3];
      }

      var dimensions = new Range(cells);

      this._mergeCellsInternal(dimensions);
    }
  }, {
    key: "mergeCellsWithoutStyle",
    value: function mergeCellsWithoutStyle() {
      for (var _len4 = arguments.length, cells = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        cells[_key4] = arguments[_key4];
      }

      var dimensions = new Range(cells);

      this._mergeCellsInternal(dimensions, true);
    }
  }, {
    key: "_mergeCellsInternal",
    value: function _mergeCellsInternal(dimensions, ignoreStyle) {
      // check cells aren't already merged
      _.each(this._merges, function (merge) {
        if (merge.intersects(dimensions)) {
          throw new Error('Cannot merge already merged cells');
        }
      }); // apply merge


      var master = this.getCell(dimensions.top, dimensions.left);

      for (var i = dimensions.top; i <= dimensions.bottom; i++) {
        for (var j = dimensions.left; j <= dimensions.right; j++) {
          // merge all but the master cell
          if (i > dimensions.top || j > dimensions.left) {
            this.getCell(i, j).merge(master, ignoreStyle);
          }
        }
      } // index merge


      this._merges[master.address] = dimensions;
    }
  }, {
    key: "_unMergeMaster",
    value: function _unMergeMaster(master) {
      // master is always top left of a rectangle
      var merge = this._merges[master.address];

      if (merge) {
        for (var i = merge.top; i <= merge.bottom; i++) {
          for (var j = merge.left; j <= merge.right; j++) {
            this.getCell(i, j).unmerge();
          }
        }

        delete this._merges[master.address];
      }
    }
  }, {
    key: "unMergeCells",
    // scan the range defined by ['tl:br'], [tl,br] or [t,l,b,r] and if any cell is part of a merge,
    // un-merge the group. Note this function can affect multiple merges and merge-blocks are
    // atomic - either they're all merged or all un-merged.
    value: function unMergeCells() {
      for (var _len5 = arguments.length, cells = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
        cells[_key5] = arguments[_key5];
      }

      var dimensions = new Range(cells); // find any cells in that range and unmerge them

      for (var i = dimensions.top; i <= dimensions.bottom; i++) {
        for (var j = dimensions.left; j <= dimensions.right; j++) {
          var cell = this.findCell(i, j);

          if (cell) {
            if (cell.type === Enums.ValueType.Merge) {
              // this cell merges to another master
              this._unMergeMaster(cell.master);
            } else if (this._merges[cell.address]) {
              // this cell is a master
              this._unMergeMaster(cell);
            }
          }
        }
      }
    } // ===========================================================================
    // Shared/Array Formula

  }, {
    key: "fillFormula",
    value: function fillFormula(range, formula, results) {
      var shareType = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'shared';
      // Define formula for top-left cell and share to rest
      var decoded = colCache.decode(range);
      var top = decoded.top,
          left = decoded.left,
          bottom = decoded.bottom,
          right = decoded.right;
      var width = right - left + 1;
      var masterAddress = colCache.encodeAddress(top, left);
      var isShared = shareType === 'shared'; // work out result accessor

      var getResult;

      if (typeof results === 'function') {
        getResult = results;
      } else if (Array.isArray(results)) {
        if (Array.isArray(results[0])) {
          getResult = function getResult(row, col) {
            return results[row - top][col - left];
          };
        } else {
          // eslint-disable-next-line no-mixed-operators
          getResult = function getResult(row, col) {
            return results[(row - top) * width + (col - left)];
          };
        }
      } else {
        getResult = function getResult() {
          return undefined;
        };
      }

      var first = true;

      for (var r = top; r <= bottom; r++) {
        for (var c = left; c <= right; c++) {
          if (first) {
            this.getCell(r, c).value = {
              shareType: shareType,
              formula: formula,
              ref: range,
              result: getResult(r, c)
            };
            first = false;
          } else {
            this.getCell(r, c).value = isShared ? {
              sharedFormula: masterAddress,
              result: getResult(r, c)
            } : getResult(r, c);
          }
        }
      }
    } // =========================================================================
    // Images

  }, {
    key: "addImage",
    value: function addImage(imageId, range) {
      var model = {
        type: 'image',
        imageId: imageId,
        range: range
      };

      this._media.push(new Image(this, model));
    }
  }, {
    key: "getImages",
    value: function getImages() {
      return this._media.filter(function (m) {
        return m.type === 'image';
      });
    }
  }, {
    key: "addBackgroundImage",
    value: function addBackgroundImage(imageId) {
      var model = {
        type: 'background',
        imageId: imageId
      };

      this._media.push(new Image(this, model));
    }
  }, {
    key: "getBackgroundImageId",
    value: function getBackgroundImageId() {
      var image = this._media.find(function (m) {
        return m.type === 'background';
      });

      return image && image.imageId;
    } // =========================================================================
    // Worksheet Protection

  }, {
    key: "protect",
    value: function protect(password, options) {
      var _this5 = this;

      // TODO: make this function truly async
      // perhaps marshal to worker thread or something
      return new Promise(function (resolve) {
        _this5.sheetProtection = {
          sheet: true
        };

        if (options && 'spinCount' in options) {
          // force spinCount to be integer >= 0
          options.spinCount = Number.isFinite(options.spinCount) ? Math.round(Math.max(0, options.spinCount)) : 100000;
        }

        if (password) {
          _this5.sheetProtection.algorithmName = 'SHA-512';
          _this5.sheetProtection.saltValue = Encryptor.randomBytes(16).toString('base64');
          _this5.sheetProtection.spinCount = options && 'spinCount' in options ? options.spinCount : 100000; // allow user specified spinCount

          _this5.sheetProtection.hashValue = Encryptor.convertPasswordToHash(password, 'SHA512', _this5.sheetProtection.saltValue, _this5.sheetProtection.spinCount);
        }

        if (options) {
          _this5.sheetProtection = Object.assign(_this5.sheetProtection, options);

          if (!password && 'spinCount' in options) {
            delete _this5.sheetProtection.spinCount;
          }
        }

        resolve();
      });
    }
  }, {
    key: "unprotect",
    value: function unprotect() {
      this.sheetProtection = null;
    } // =========================================================================
    // Tables

  }, {
    key: "addTable",
    value: function addTable(model) {
      var table = new Table(this, model);
      this.tables[model.name] = table;
      return table;
    }
  }, {
    key: "getTable",
    value: function getTable(name) {
      return this.tables[name];
    }
  }, {
    key: "removeTable",
    value: function removeTable(name) {
      delete this.tables[name];
    }
  }, {
    key: "getTables",
    value: function getTables() {
      return Object.values(this.tables);
    } // ===========================================================================
    // Conditional Formatting

  }, {
    key: "addConditionalFormatting",
    value: function addConditionalFormatting(cf) {
      this.conditionalFormattings.push(cf);
    }
  }, {
    key: "removeConditionalFormatting",
    value: function removeConditionalFormatting(filter) {
      if (typeof filter === 'number') {
        this.conditionalFormattings.splice(filter, 1);
      } else if (filter instanceof Function) {
        this.conditionalFormattings = this.conditionalFormattings.filter(filter);
      } else {
        this.conditionalFormattings = [];
      }
    } // ===========================================================================
    // Deprecated

  }, {
    key: "_parseRows",
    value: function _parseRows(model) {
      var _this6 = this;

      this._rows = [];
      model.rows.forEach(function (rowModel) {
        var row = new Row(_this6, rowModel.number);
        _this6._rows[row.number - 1] = row;
        row.model = rowModel;
      });
    }
  }, {
    key: "_parseMergeCells",
    value: function _parseMergeCells(model) {
      var _this7 = this;

      _.each(model.mergeCells, function (merge) {
        // Do not merge styles when importing an Excel file
        // since each cell may have different styles intentionally.
        _this7.mergeCellsWithoutStyle(merge);
      });
    }
  }, {
    key: "workbook",
    get: function get() {
      return this._workbook;
    }
  }, {
    key: "dimensions",
    get: function get() {
      var dimensions = new Range();

      this._rows.forEach(function (row) {
        if (row) {
          var rowDims = row.dimensions;

          if (rowDims) {
            dimensions.expand(row.number, rowDims.min, row.number, rowDims.max);
          }
        }
      });

      return dimensions;
    } // =========================================================================
    // Columns
    // get the current columns array.

  }, {
    key: "columns",
    get: function get() {
      return this._columns;
    } // set the columns from an array of column definitions.
    // Note: any headers defined will overwrite existing values.
    ,
    set: function set(value) {
      var _this8 = this;

      // calculate max header row count
      this._headerRowCount = value.reduce(function (pv, cv) {
        var headerCount = cv.header && 1 || cv.headers && cv.headers.length || 0;
        return Math.max(pv, headerCount);
      }, 0); // construct Column objects

      var count = 1;
      var columns = this._columns = [];
      value.forEach(function (defn) {
        var column = new Column(_this8, count++, false);
        columns.push(column);
        column.defn = defn;
      });
    }
  }, {
    key: "lastColumn",
    get: function get() {
      return this.getColumn(this.columnCount);
    }
  }, {
    key: "columnCount",
    get: function get() {
      var maxCount = 0;
      this.eachRow(function (row) {
        maxCount = Math.max(maxCount, row.cellCount);
      });
      return maxCount;
    }
  }, {
    key: "actualColumnCount",
    get: function get() {
      // performance nightmare - for each row, counts all the columns used
      var counts = [];
      var count = 0;
      this.eachRow(function (row) {
        row.eachCell(function (_ref) {
          var col = _ref.col;

          if (!counts[col]) {
            counts[col] = true;
            count++;
          }
        });
      });
      return count;
    }
  }, {
    key: "_lastRowNumber",
    get: function get() {
      // need to cope with results of splice
      var rows = this._rows;
      var n = rows.length;

      while (n > 0 && rows[n - 1] === undefined) {
        n--;
      }

      return n;
    }
  }, {
    key: "_nextRow",
    get: function get() {
      return this._lastRowNumber + 1;
    }
  }, {
    key: "lastRow",
    get: function get() {
      if (this._rows.length) {
        return this._rows[this._rows.length - 1];
      }

      return undefined;
    }
  }, {
    key: "rowCount",
    get: function get() {
      return this._lastRowNumber;
    }
  }, {
    key: "actualRowCount",
    get: function get() {
      // counts actual rows that have actual data
      var count = 0;
      this.eachRow(function () {
        count++;
      });
      return count;
    }
  }, {
    key: "hasMerges",
    get: function get() {
      // return true if this._merges has a merge object
      return _.some(this._merges, Boolean);
    }
  }, {
    key: "tabColor",
    get: function get() {
      // eslint-disable-next-line no-console
      console.trace('worksheet.tabColor property is now deprecated. Please use worksheet.properties.tabColor');
      return this.properties.tabColor;
    },
    set: function set(value) {
      // eslint-disable-next-line no-console
      console.trace('worksheet.tabColor property is now deprecated. Please use worksheet.properties.tabColor');
      this.properties.tabColor = value;
    } // ===========================================================================
    // Model

  }, {
    key: "model",
    get: function get() {
      var model = {
        id: this.id,
        name: this.name,
        dataValidations: this.dataValidations.model,
        properties: this.properties,
        state: this.state,
        pageSetup: this.pageSetup,
        headerFooter: this.headerFooter,
        rowBreaks: this.rowBreaks,
        views: this.views,
        autoFilter: this.autoFilter,
        media: this._media.map(function (medium) {
          return medium.model;
        }),
        sheetProtection: this.sheetProtection,
        tables: Object.values(this.tables).map(function (table) {
          return table.model;
        }),
        conditionalFormattings: this.conditionalFormattings
      }; // =================================================
      // columns

      model.cols = Column.toModel(this.columns); // ==========================================================
      // Rows

      var rows = model.rows = [];
      var dimensions = model.dimensions = new Range();

      this._rows.forEach(function (row) {
        var rowModel = row && row.model;

        if (rowModel) {
          dimensions.expand(rowModel.number, rowModel.min, rowModel.number, rowModel.max);
          rows.push(rowModel);
        }
      }); // ==========================================================
      // Merges


      model.merges = [];

      _.each(this._merges, function (merge) {
        model.merges.push(merge.range);
      });

      return model;
    },
    set: function set(value) {
      var _this9 = this;

      this.name = value.name;
      this._columns = Column.fromModel(this, value.cols);

      this._parseRows(value);

      this._parseMergeCells(value);

      this.dataValidations = new DataValidations(value.dataValidations);
      this.properties = value.properties;
      this.pageSetup = value.pageSetup;
      this.headerFooter = value.headerFooter;
      this.views = value.views;
      this.autoFilter = value.autoFilter;
      this._media = value.media.map(function (medium) {
        return new Image(_this9, medium);
      });
      this.sheetProtection = value.sheetProtection;
      this.tables = value.tables.reduce(function (tables, table) {
        var t = new Table();
        t.model = table;
        tables[table.name] = t;
        return tables;
      }, {});
      this.conditionalFormattings = value.conditionalFormattings;
    }
  }]);

  return Worksheet;
}();

module.exports = Worksheet;

},{"../utils/col-cache":19,"../utils/encryptor":20,"../utils/under-dash":25,"./column":4,"./data-validations":5,"./enums":7,"./image":8,"./range":10,"./row":11,"./table":12}],15:[function(require,module,exports){
"use strict";

// this bundle is built without polyfill leaving apps the freedom to add their own
var ExcelJS = {
  Workbook: require('./doc/workbook')
}; // Object.assign mono-fill

var Enums = require('./doc/enums');

Object.keys(Enums).forEach(function (key) {
  ExcelJS[key] = Enums[key];
});
module.exports = ExcelJS;

},{"./doc/enums":7,"./doc/workbook":13}],16:[function(require,module,exports){
"use strict";

// eslint-disable-next-line node/no-unsupported-features/node-builtins
var textDecoder = typeof TextDecoder === 'undefined' ? null : new TextDecoder('utf-8');

function bufferToString(chunk) {
  if (typeof chunk === 'string') {
    return chunk;
  }

  if (textDecoder) {
    return textDecoder.decode(chunk);
  }

  return chunk.toString();
}

exports.bufferToString = bufferToString;

},{}],17:[function(require,module,exports){
"use strict";

// eslint-disable-next-line node/no-unsupported-features/node-builtins
var textEncoder = typeof TextEncoder === 'undefined' ? null : new TextEncoder('utf-8');

var _require = require('buffer'),
    Buffer = _require.Buffer;

function stringToBuffer(str) {
  if (typeof str !== 'string') {
    return str;
  }

  if (textEncoder) {
    return Buffer.from(textEncoder.encode(str).buffer);
  }

  return Buffer.from(str);
}

exports.stringToBuffer = stringToBuffer;

},{"buffer":216}],18:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('./under-dash');

var colCache = require('./col-cache');

var CellMatrix = /*#__PURE__*/function () {
  function CellMatrix(template) {
    _classCallCheck(this, CellMatrix);

    this.template = template;
    this.sheets = {};
  }

  _createClass(CellMatrix, [{
    key: "addCell",
    value: function addCell(addressStr) {
      this.addCellEx(colCache.decodeEx(addressStr));
    }
  }, {
    key: "getCell",
    value: function getCell(addressStr) {
      return this.findCellEx(colCache.decodeEx(addressStr), true);
    }
  }, {
    key: "findCell",
    value: function findCell(addressStr) {
      return this.findCellEx(colCache.decodeEx(addressStr), false);
    }
  }, {
    key: "findCellAt",
    value: function findCellAt(sheetName, rowNumber, colNumber) {
      var sheet = this.sheets[sheetName];
      var row = sheet && sheet[rowNumber];
      return row && row[colNumber];
    }
  }, {
    key: "addCellEx",
    value: function addCellEx(address) {
      if (address.top) {
        for (var row = address.top; row <= address.bottom; row++) {
          for (var col = address.left; col <= address.right; col++) {
            this.getCellAt(address.sheetName, row, col);
          }
        }
      } else {
        this.findCellEx(address, true);
      }
    }
  }, {
    key: "getCellEx",
    value: function getCellEx(address) {
      return this.findCellEx(address, true);
    }
  }, {
    key: "findCellEx",
    value: function findCellEx(address, create) {
      var sheet = this.findSheet(address, create);
      var row = this.findSheetRow(sheet, address, create);
      return this.findRowCell(row, address, create);
    }
  }, {
    key: "getCellAt",
    value: function getCellAt(sheetName, rowNumber, colNumber) {
      var sheet = this.sheets[sheetName] || (this.sheets[sheetName] = []);
      var row = sheet[rowNumber] || (sheet[rowNumber] = []);
      var cell = row[colNumber] || (row[colNumber] = {
        sheetName: sheetName,
        address: colCache.n2l(colNumber) + rowNumber,
        row: rowNumber,
        col: colNumber
      });
      return cell;
    }
  }, {
    key: "removeCellEx",
    value: function removeCellEx(address) {
      var sheet = this.findSheet(address);

      if (!sheet) {
        return;
      }

      var row = this.findSheetRow(sheet, address);

      if (!row) {
        return;
      }

      delete row[address.col];
    }
  }, {
    key: "forEachInSheet",
    value: function forEachInSheet(sheetName, callback) {
      var sheet = this.sheets[sheetName];

      if (sheet) {
        sheet.forEach(function (row, rowNumber) {
          if (row) {
            row.forEach(function (cell, colNumber) {
              if (cell) {
                callback(cell, rowNumber, colNumber);
              }
            });
          }
        });
      }
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      var _this = this;

      _.each(this.sheets, function (sheet, sheetName) {
        _this.forEachInSheet(sheetName, callback);
      });
    }
  }, {
    key: "map",
    value: function map(callback) {
      var results = [];
      this.forEach(function (cell) {
        results.push(callback(cell));
      });
      return results;
    }
  }, {
    key: "findSheet",
    value: function findSheet(address, create) {
      var name = address.sheetName;

      if (this.sheets[name]) {
        return this.sheets[name];
      }

      if (create) {
        return this.sheets[name] = [];
      }

      return undefined;
    }
  }, {
    key: "findSheetRow",
    value: function findSheetRow(sheet, address, create) {
      var row = address.row;

      if (sheet && sheet[row]) {
        return sheet[row];
      }

      if (create) {
        return sheet[row] = [];
      }

      return undefined;
    }
  }, {
    key: "findRowCell",
    value: function findRowCell(row, address, create) {
      var col = address.col;

      if (row && row[col]) {
        return row[col];
      }

      if (create) {
        return row[col] = this.template ? Object.assign(address, JSON.parse(JSON.stringify(this.template))) : address;
      }

      return undefined;
    }
  }, {
    key: "spliceRows",
    value: function spliceRows(sheetName, start, numDelete, numInsert) {
      var sheet = this.sheets[sheetName];

      if (sheet) {
        var inserts = [];

        for (var i = 0; i < numInsert; i++) {
          inserts.push([]);
        }

        sheet.splice.apply(sheet, [start, numDelete].concat(inserts));
      }
    }
  }, {
    key: "spliceColumns",
    value: function spliceColumns(sheetName, start, numDelete, numInsert) {
      var sheet = this.sheets[sheetName];

      if (sheet) {
        var inserts = [];

        for (var i = 0; i < numInsert; i++) {
          inserts.push(null);
        }

        _.each(sheet, function (row) {
          row.splice.apply(row, [start, numDelete].concat(inserts));
        });
      }
    }
  }]);

  return CellMatrix;
}();

module.exports = CellMatrix;

},{"./col-cache":19,"./under-dash":25}],19:[function(require,module,exports){
"use strict";

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var addressRegex = /^[A-Z]+\d+$/; // =========================================================================
// Column Letter to Number conversion

var colCache = {
  _dictionary: ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'],
  _l2nFill: 0,
  _l2n: {},
  _n2l: [],
  _level: function _level(n) {
    if (n <= 26) {
      return 1;
    }

    if (n <= 26 * 26) {
      return 2;
    }

    return 3;
  },
  _fill: function _fill(level) {
    var c;
    var v;
    var l1;
    var l2;
    var l3;
    var n = 1;

    if (level >= 4) {
      throw new Error('Out of bounds. Excel supports columns from 1 to 16384');
    }

    if (this._l2nFill < 1 && level >= 1) {
      while (n <= 26) {
        c = this._dictionary[n - 1];
        this._n2l[n] = c;
        this._l2n[c] = n;
        n++;
      }

      this._l2nFill = 1;
    }

    if (this._l2nFill < 2 && level >= 2) {
      n = 27;

      while (n <= 26 + 26 * 26) {
        v = n - (26 + 1);
        l1 = v % 26;
        l2 = Math.floor(v / 26);
        c = this._dictionary[l2] + this._dictionary[l1];
        this._n2l[n] = c;
        this._l2n[c] = n;
        n++;
      }

      this._l2nFill = 2;
    }

    if (this._l2nFill < 3 && level >= 3) {
      n = 26 + 26 * 26 + 1;

      while (n <= 16384) {
        v = n - (26 * 26 + 26 + 1);
        l1 = v % 26;
        l2 = Math.floor(v / 26) % 26;
        l3 = Math.floor(v / (26 * 26));
        c = this._dictionary[l3] + this._dictionary[l2] + this._dictionary[l1];
        this._n2l[n] = c;
        this._l2n[c] = n;
        n++;
      }

      this._l2nFill = 3;
    }
  },
  l2n: function l2n(l) {
    if (!this._l2n[l]) {
      this._fill(l.length);
    }

    if (!this._l2n[l]) {
      throw new Error("Out of bounds. Invalid column letter: ".concat(l));
    }

    return this._l2n[l];
  },
  n2l: function n2l(n) {
    if (n < 1 || n > 16384) {
      throw new Error("".concat(n, " is out of bounds. Excel supports columns from 1 to 16384"));
    }

    if (!this._n2l[n]) {
      this._fill(this._level(n));
    }

    return this._n2l[n];
  },
  // =========================================================================
  // Address processing
  _hash: {},
  // check if value looks like an address
  validateAddress: function validateAddress(value) {
    if (!addressRegex.test(value)) {
      throw new Error("Invalid Address: ".concat(value));
    }

    return true;
  },
  // convert address string into structure
  decodeAddress: function decodeAddress(value) {
    var addr = value.length < 5 && this._hash[value];

    if (addr) {
      return addr;
    }

    var hasCol = false;
    var col = '';
    var colNumber = 0;
    var hasRow = false;
    var row = '';
    var rowNumber = 0;

    for (var i = 0, char; i < value.length; i++) {
      char = value.charCodeAt(i); // col should before row

      if (!hasRow && char >= 65 && char <= 90) {
        // 65 = 'A'.charCodeAt(0)
        // 90 = 'Z'.charCodeAt(0)
        hasCol = true;
        col += value[i]; // colNumber starts from 1

        colNumber = colNumber * 26 + char - 64;
      } else if (char >= 48 && char <= 57) {
        // 48 = '0'.charCodeAt(0)
        // 57 = '9'.charCodeAt(0)
        hasRow = true;
        row += value[i]; // rowNumber starts from 0

        rowNumber = rowNumber * 10 + char - 48;
      } else if (hasRow && hasCol && char !== 36) {
        // 36 = '$'.charCodeAt(0)
        break;
      }
    }

    if (!hasCol) {
      colNumber = undefined;
    } else if (colNumber > 16384) {
      throw new Error("Out of bounds. Invalid column letter: ".concat(col));
    }

    if (!hasRow) {
      rowNumber = undefined;
    } // in case $row$col


    value = col + row;
    var address = {
      address: value,
      col: colNumber,
      row: rowNumber,
      $col$row: "$".concat(col, "$").concat(row)
    }; // mem fix - cache only the tl 100x100 square

    if (colNumber <= 100 && rowNumber <= 100) {
      this._hash[value] = address;
      this._hash[address.$col$row] = address;
    }

    return address;
  },
  // convert r,c into structure (if only 1 arg, assume r is address string)
  getAddress: function getAddress(r, c) {
    if (c) {
      var address = this.n2l(c) + r;
      return this.decodeAddress(address);
    }

    return this.decodeAddress(r);
  },
  // convert [address], [tl:br] into address structures
  decode: function decode(value) {
    var parts = value.split(':');

    if (parts.length === 2) {
      var tl = this.decodeAddress(parts[0]);
      var br = this.decodeAddress(parts[1]);
      var result = {
        top: Math.min(tl.row, br.row),
        left: Math.min(tl.col, br.col),
        bottom: Math.max(tl.row, br.row),
        right: Math.max(tl.col, br.col)
      }; // reconstruct tl, br and dimensions

      result.tl = this.n2l(result.left) + result.top;
      result.br = this.n2l(result.right) + result.bottom;
      result.dimensions = "".concat(result.tl, ":").concat(result.br);
      return result;
    }

    return this.decodeAddress(value);
  },
  // convert [sheetName!][$]col[$]row[[$]col[$]row] into address or range structures
  decodeEx: function decodeEx(value) {
    var groups = value.match(/(?:(?:(?:'((?:[^']|'')*)')|([^'^ !]*))!)?(.*)/);
    var sheetName = groups[1] || groups[2]; // Qouted and unqouted groups

    var reference = groups[3]; // Remaining address

    var parts = reference.split(':');

    if (parts.length > 1) {
      var tl = this.decodeAddress(parts[0]);
      var br = this.decodeAddress(parts[1]);
      var top = Math.min(tl.row, br.row);
      var left = Math.min(tl.col, br.col);
      var bottom = Math.max(tl.row, br.row);
      var right = Math.max(tl.col, br.col);
      tl = this.n2l(left) + top;
      br = this.n2l(right) + bottom;
      return {
        top: top,
        left: left,
        bottom: bottom,
        right: right,
        sheetName: sheetName,
        tl: {
          address: tl,
          col: left,
          row: top,
          $col$row: "$".concat(this.n2l(left), "$").concat(top),
          sheetName: sheetName
        },
        br: {
          address: br,
          col: right,
          row: bottom,
          $col$row: "$".concat(this.n2l(right), "$").concat(bottom),
          sheetName: sheetName
        },
        dimensions: "".concat(tl, ":").concat(br)
      };
    }

    if (reference.startsWith('#')) {
      return sheetName ? {
        sheetName: sheetName,
        error: reference
      } : {
        error: reference
      };
    }

    var address = this.decodeAddress(reference);
    return sheetName ? _objectSpread({
      sheetName: sheetName
    }, address) : address;
  },
  // convert row,col into address string
  encodeAddress: function encodeAddress(row, col) {
    return colCache.n2l(col) + row;
  },
  // convert row,col into string address or t,l,b,r into range
  encode: function encode() {
    switch (arguments.length) {
      case 2:
        return colCache.encodeAddress(arguments[0], arguments[1]);

      case 4:
        return "".concat(colCache.encodeAddress(arguments[0], arguments[1]), ":").concat(colCache.encodeAddress(arguments[2], arguments[3]));

      default:
        throw new Error('Can only encode with 2 or 4 arguments');
    }
  },
  // return true if address is contained within range
  inRange: function inRange(range, address) {
    var _range = _slicedToArray(range, 5),
        left = _range[0],
        top = _range[1],
        right = _range[3],
        bottom = _range[4];

    var _address = _slicedToArray(address, 2),
        col = _address[0],
        row = _address[1];

    return col >= left && col <= right && row >= top && row <= bottom;
  }
};
module.exports = colCache;

},{}],20:[function(require,module,exports){
(function (Buffer){
'use strict';

var crypto = require('crypto');

var Encryptor = {
  /**
   * Calculate a hash of the concatenated buffers with the given algorithm.
   * @param {string} algorithm - The hash algorithm.
   * @returns {Buffer} The hash
   */
  hash: function hash(algorithm) {
    var hash = crypto.createHash(algorithm);

    for (var _len = arguments.length, buffers = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      buffers[_key - 1] = arguments[_key];
    }

    hash.update(Buffer.concat(buffers));
    return hash.digest();
  },

  /**
   * Convert a password into an encryption key
   * @param {string} password - The password
   * @param {string} hashAlgorithm - The hash algoritm
   * @param {string} saltValue - The salt value
   * @param {number} spinCount - The spin count
   * @param {number} keyBits - The length of the key in bits
   * @param {Buffer} blockKey - The block key
   * @returns {Buffer} The encryption key
   */
  convertPasswordToHash: function convertPasswordToHash(password, hashAlgorithm, saltValue, spinCount) {
    hashAlgorithm = hashAlgorithm.toLowerCase();
    var hashes = crypto.getHashes();

    if (hashes.indexOf(hashAlgorithm) < 0) {
      throw new Error("Hash algorithm '".concat(hashAlgorithm, "' not supported!"));
    } // Password must be in unicode buffer


    var passwordBuffer = Buffer.from(password, 'utf16le'); // Generate the initial hash

    var key = this.hash(hashAlgorithm, Buffer.from(saltValue, 'base64'), passwordBuffer); // Now regenerate until spin count

    for (var i = 0; i < spinCount; i++) {
      var iterator = Buffer.alloc(4); // this is the 'special' element of Excel password hashing
      // that stops us from using crypto.pbkdf2()

      iterator.writeUInt32LE(i, 0);
      key = this.hash(hashAlgorithm, key, iterator);
    }

    return key.toString('base64');
  },

  /**
   * Generates cryptographically strong pseudo-random data.
   * @param size The size argument is a number indicating the number of bytes to generate.
   */
  randomBytes: function randomBytes(size) {
    return crypto.randomBytes(size);
  }
};
module.exports = Encryptor;

}).call(this,require("buffer").Buffer)

},{"buffer":216,"crypto":226}],21:[function(require,module,exports){
"use strict";

function _awaitAsyncGenerator(value) { return new _AwaitValue(value); }

function _wrapAsyncGenerator(fn) { return function () { return new _AsyncGenerator(fn.apply(this, arguments)); }; }

function _AsyncGenerator(gen) { var front, back; function send(key, arg) { return new Promise(function (resolve, reject) { var request = { key: key, arg: arg, resolve: resolve, reject: reject, next: null }; if (back) { back = back.next = request; } else { front = back = request; resume(key, arg); } }); } function resume(key, arg) { try { var result = gen[key](arg); var value = result.value; var wrappedAwait = value instanceof _AwaitValue; Promise.resolve(wrappedAwait ? value.wrapped : value).then(function (arg) { if (wrappedAwait) { resume(key === "return" ? "return" : "next", arg); return; } settle(result.done ? "return" : "normal", arg); }, function (err) { resume("throw", err); }); } catch (err) { settle("throw", err); } } function settle(type, value) { switch (type) { case "return": front.resolve({ value: value, done: true }); break; case "throw": front.reject(value); break; default: front.resolve({ value: value, done: false }); break; } front = front.next; if (front) { resume(front.key, front.arg); } else { back = null; } } this._invoke = send; if (typeof gen.return !== "function") { this.return = undefined; } }

if (typeof Symbol === "function" && Symbol.asyncIterator) { _AsyncGenerator.prototype[Symbol.asyncIterator] = function () { return this; }; }

_AsyncGenerator.prototype.next = function (arg) { return this._invoke("next", arg); };

_AsyncGenerator.prototype.throw = function (arg) { return this._invoke("throw", arg); };

_AsyncGenerator.prototype.return = function (arg) { return this._invoke("return", arg); };

function _AwaitValue(value) { this.wrapped = value; }

function _asyncIterator(iterable) { var method; if (typeof Symbol !== "undefined") { if (Symbol.asyncIterator) { method = iterable[Symbol.asyncIterator]; if (method != null) return method.call(iterable); } if (Symbol.iterator) { method = iterable[Symbol.iterator]; if (method != null) return method.call(iterable); } } throw new TypeError("Object is not async iterable"); }

var _require = require('saxes'),
    SaxesParser = _require.SaxesParser;

var _require2 = require('readable-stream'),
    PassThrough = _require2.PassThrough;

var _require3 = require('./browser-buffer-decode'),
    bufferToString = _require3.bufferToString;

module.exports = /*#__PURE__*/function () {
  var _ref = _wrapAsyncGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(iterable) {
    var saxesParser, error, events, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, _value, chunk;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            // TODO: Remove once node v8 is deprecated
            // Detect and upgrade old streams
            if (iterable.pipe && !iterable[Symbol.asyncIterator]) {
              iterable = iterable.pipe(new PassThrough());
            }

            saxesParser = new SaxesParser();
            saxesParser.on('error', function (err) {
              error = err;
            });
            events = [];
            saxesParser.on('opentag', function (value) {
              return events.push({
                eventType: 'opentag',
                value: value
              });
            });
            saxesParser.on('text', function (value) {
              return events.push({
                eventType: 'text',
                value: value
              });
            });
            saxesParser.on('closetag', function (value) {
              return events.push({
                eventType: 'closetag',
                value: value
              });
            });
            _iteratorNormalCompletion = true;
            _didIteratorError = false;
            _context.prev = 9;
            _iterator = _asyncIterator(iterable);

          case 11:
            _context.next = 13;
            return _awaitAsyncGenerator(_iterator.next());

          case 13:
            _step = _context.sent;
            _iteratorNormalCompletion = _step.done;
            _context.next = 17;
            return _awaitAsyncGenerator(_step.value);

          case 17:
            _value = _context.sent;

            if (_iteratorNormalCompletion) {
              _context.next = 29;
              break;
            }

            chunk = _value;
            saxesParser.write(bufferToString(chunk)); // saxesParser.write and saxesParser.on() are synchronous,
            // so we can only reach the below line once all events have been emitted

            if (!error) {
              _context.next = 23;
              break;
            }

            throw error;

          case 23:
            _context.next = 25;
            return events;

          case 25:
            events = [];

          case 26:
            _iteratorNormalCompletion = true;
            _context.next = 11;
            break;

          case 29:
            _context.next = 35;
            break;

          case 31:
            _context.prev = 31;
            _context.t0 = _context["catch"](9);
            _didIteratorError = true;
            _iteratorError = _context.t0;

          case 35:
            _context.prev = 35;
            _context.prev = 36;

            if (!(!_iteratorNormalCompletion && _iterator.return != null)) {
              _context.next = 40;
              break;
            }

            _context.next = 40;
            return _awaitAsyncGenerator(_iterator.return());

          case 40:
            _context.prev = 40;

            if (!_didIteratorError) {
              _context.next = 43;
              break;
            }

            throw _iteratorError;

          case 43:
            return _context.finish(40);

          case 44:
            return _context.finish(35);

          case 45:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[9, 31, 35, 45], [36,, 40, 44]]);
  }));

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

},{"./browser-buffer-decode":16,"readable-stream":382,"saxes":386}],22:[function(require,module,exports){
"use strict";

var colCache = require('./col-cache'); // const cellRefRegex = /(([a-z_\-0-9]*)!)?[$]?([a-z]+)[$]?([1-9][0-9]*)/i;


var replacementCandidateRx = /(([a-z_\-0-9]*)!)?([a-z0-9_$]{2,})([(])?/gi;
var CRrx = /^([$])?([a-z]+)([$])?([1-9][0-9]*)$/i;

function slideFormula(formula, fromCell, toCell) {
  var offset = colCache.decode(fromCell);
  var to = colCache.decode(toCell);
  return formula.replace(replacementCandidateRx, function (refMatch, sheet, sheetMaybe, addrPart, trailingParen) {
    if (trailingParen) {
      return refMatch;
    }

    var match = CRrx.exec(addrPart);

    if (match) {
      var colDollar = match[1];
      var colStr = match[2].toUpperCase();
      var rowDollar = match[3];
      var rowStr = match[4];

      if (colStr.length > 3 || colStr.length === 3 && colStr > 'XFD') {
        // > XFD is the highest col number in excel 2007 and beyond, so this is a named range
        return refMatch;
      }

      var col = colCache.l2n(colStr);
      var row = parseInt(rowStr, 10);

      if (!colDollar) {
        col += to.col - offset.col;
      }

      if (!rowDollar) {
        row += to.row - offset.row;
      }

      var res = (sheet || '') + (colDollar || '') + colCache.n2l(col) + (rowDollar || '') + row;
      return res;
    }

    return refMatch;
  });
}

module.exports = {
  slideFormula: slideFormula
};

},{"./col-cache":19}],23:[function(require,module,exports){
(function (process,Buffer){
"use strict";

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/* eslint-disable max-classes-per-file */
var Stream = require('readable-stream');

var utils = require('./utils');

var StringBuf = require('./string-buf'); // =============================================================================
// data chunks - encapsulating incoming data


var StringChunk = /*#__PURE__*/function () {
  function StringChunk(data, encoding) {
    _classCallCheck(this, StringChunk);

    this._data = data;
    this._encoding = encoding;
  }

  _createClass(StringChunk, [{
    key: "copy",
    // copy to target buffer
    value: function copy(target, targetOffset, offset, length) {
      return this.toBuffer().copy(target, targetOffset, offset, length);
    }
  }, {
    key: "toBuffer",
    value: function toBuffer() {
      if (!this._buffer) {
        this._buffer = Buffer.from(this._data, this._encoding);
      }

      return this._buffer;
    }
  }, {
    key: "length",
    get: function get() {
      return this.toBuffer().length;
    }
  }]);

  return StringChunk;
}();

var StringBufChunk = /*#__PURE__*/function () {
  function StringBufChunk(data) {
    _classCallCheck(this, StringBufChunk);

    this._data = data;
  }

  _createClass(StringBufChunk, [{
    key: "copy",
    // copy to target buffer
    value: function copy(target, targetOffset, offset, length) {
      // eslint-disable-next-line no-underscore-dangle
      return this._data._buf.copy(target, targetOffset, offset, length);
    }
  }, {
    key: "toBuffer",
    value: function toBuffer() {
      return this._data.toBuffer();
    }
  }, {
    key: "length",
    get: function get() {
      return this._data.length;
    }
  }]);

  return StringBufChunk;
}();

var BufferChunk = /*#__PURE__*/function () {
  function BufferChunk(data) {
    _classCallCheck(this, BufferChunk);

    this._data = data;
  }

  _createClass(BufferChunk, [{
    key: "copy",
    // copy to target buffer
    value: function copy(target, targetOffset, offset, length) {
      this._data.copy(target, targetOffset, offset, length);
    }
  }, {
    key: "toBuffer",
    value: function toBuffer() {
      return this._data;
    }
  }, {
    key: "length",
    get: function get() {
      return this._data.length;
    }
  }]);

  return BufferChunk;
}(); // =============================================================================
// ReadWriteBuf - a single buffer supporting simple read-write


var ReadWriteBuf = /*#__PURE__*/function () {
  function ReadWriteBuf(size) {
    _classCallCheck(this, ReadWriteBuf);

    this.size = size; // the buffer

    this.buffer = Buffer.alloc(size); // read index

    this.iRead = 0; // write index

    this.iWrite = 0;
  }

  _createClass(ReadWriteBuf, [{
    key: "toBuffer",
    value: function toBuffer() {
      if (this.iRead === 0 && this.iWrite === this.size) {
        return this.buffer;
      }

      var buf = Buffer.alloc(this.iWrite - this.iRead);
      this.buffer.copy(buf, 0, this.iRead, this.iWrite);
      return buf;
    }
  }, {
    key: "read",
    value: function read(size) {
      var buf; // read size bytes from buffer and return buffer

      if (size === 0) {
        // special case - return null if no data requested
        return null;
      }

      if (size === undefined || size >= this.length) {
        // if no size specified or size is at least what we have then return all of the bytes
        buf = this.toBuffer();
        this.iRead = this.iWrite;
        return buf;
      } // otherwise return a chunk


      buf = Buffer.alloc(size);
      this.buffer.copy(buf, 0, this.iRead, size);
      this.iRead += size;
      return buf;
    }
  }, {
    key: "write",
    value: function write(chunk, offset, length) {
      // write as many bytes from data from optional source offset
      // and return number of bytes written
      var size = Math.min(length, this.size - this.iWrite);
      chunk.copy(this.buffer, this.iWrite, offset, offset + size);
      this.iWrite += size;
      return size;
    }
  }, {
    key: "length",
    get: function get() {
      return this.iWrite - this.iRead;
    }
  }, {
    key: "eod",
    get: function get() {
      return this.iRead === this.iWrite;
    }
  }, {
    key: "full",
    get: function get() {
      return this.iWrite === this.size;
    }
  }]);

  return ReadWriteBuf;
}(); // =============================================================================
// StreamBuf - a multi-purpose read-write stream
//  As MemBuf - write as much data as you like. Then call toBuffer() to consolidate
//  As StreamHub - pipe to multiple writables
//  As readable stream - feed data into the writable part and have some other code read from it.
// Note: Not sure why but StreamBuf does not like JS "class" sugar. It fails the
// integration tests


var StreamBuf = function StreamBuf(options) {
  options = options || {};
  this.bufSize = options.bufSize || 1024 * 1024;
  this.buffers = []; // batch mode fills a buffer completely before passing the data on
  // to pipes or 'readable' event listeners

  this.batch = options.batch || false;
  this.corked = false; // where in the current writable buffer we're up to

  this.inPos = 0; // where in the current readable buffer we've read up to

  this.outPos = 0; // consuming pipe streams go here

  this.pipes = []; // controls emit('data')

  this.paused = false;
  this.encoding = null;
};

utils.inherits(StreamBuf, Stream.Duplex, {
  toBuffer: function toBuffer() {
    switch (this.buffers.length) {
      case 0:
        return null;

      case 1:
        return this.buffers[0].toBuffer();

      default:
        return Buffer.concat(this.buffers.map(function (rwBuf) {
          return rwBuf.toBuffer();
        }));
    }
  },
  // writable
  // event drain - if write returns false (which it won't), indicates when safe to write again.
  // finish - end() has been called
  // pipe(src) - pipe() has been called on readable
  // unpipe(src) - unpipe() has been called on readable
  // error - duh
  _getWritableBuffer: function _getWritableBuffer() {
    if (this.buffers.length) {
      var last = this.buffers[this.buffers.length - 1];

      if (!last.full) {
        return last;
      }
    }

    var buf = new ReadWriteBuf(this.bufSize);
    this.buffers.push(buf);
    return buf;
  },
  _pipe: function _pipe(chunk) {
    var _this = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var write;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              write = function write(pipe) {
                return new Promise(function (resolve) {
                  pipe.write(chunk.toBuffer(), function () {
                    resolve();
                  });
                });
              };

              _context.next = 3;
              return Promise.all(_this.pipes.map(write));

            case 3:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  },
  _writeToBuffers: function _writeToBuffers(chunk) {
    var inPos = 0;
    var inLen = chunk.length;

    while (inPos < inLen) {
      // find writable buffer
      var buffer = this._getWritableBuffer(); // write some data


      inPos += buffer.write(chunk, inPos, inLen - inPos);
    }
  },
  write: function write(data, encoding, callback) {
    var _this2 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var chunk;
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              if (encoding instanceof Function) {
                callback = encoding;
                encoding = 'utf8';
              }

              callback = callback || utils.nop; // encapsulate data into a chunk

              if (!(data instanceof StringBuf)) {
                _context2.next = 6;
                break;
              }

              chunk = new StringBufChunk(data);
              _context2.next = 15;
              break;

            case 6:
              if (!(data instanceof Buffer)) {
                _context2.next = 10;
                break;
              }

              chunk = new BufferChunk(data);
              _context2.next = 15;
              break;

            case 10:
              if (!(typeof data === 'string' || data instanceof String || data instanceof ArrayBuffer)) {
                _context2.next = 14;
                break;
              }

              chunk = new StringChunk(data, encoding);
              _context2.next = 15;
              break;

            case 14:
              throw new Error('Chunk must be one of type String, Buffer or StringBuf.');

            case 15:
              if (!_this2.pipes.length) {
                _context2.next = 31;
                break;
              }

              if (!_this2.batch) {
                _context2.next = 21;
                break;
              }

              _this2._writeToBuffers(chunk);

              while (!_this2.corked && _this2.buffers.length > 1) {
                _this2._pipe(_this2.buffers.shift());
              }

              _context2.next = 29;
              break;

            case 21:
              if (_this2.corked) {
                _context2.next = 27;
                break;
              }

              _context2.next = 24;
              return _this2._pipe(chunk);

            case 24:
              callback();
              _context2.next = 29;
              break;

            case 27:
              _this2._writeToBuffers(chunk);

              process.nextTick(callback);

            case 29:
              _context2.next = 34;
              break;

            case 31:
              if (!_this2.paused) {
                _this2.emit('data', chunk.toBuffer());
              }

              _this2._writeToBuffers(chunk);

              _this2.emit('readable');

            case 34:
              return _context2.abrupt("return", true);

            case 35:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    }))();
  },
  cork: function cork() {
    this.corked = true;
  },
  _flush: function _flush()
  /* destination */
  {
    // if we have comsumers...
    if (this.pipes.length) {
      // and there's stuff not written
      while (this.buffers.length) {
        this._pipe(this.buffers.shift());
      }
    }
  },
  uncork: function uncork() {
    this.corked = false;

    this._flush();
  },
  end: function end(chunk, encoding, callback) {
    var _this3 = this;

    var writeComplete = function writeComplete(error) {
      if (error) {
        callback(error);
      } else {
        _this3._flush();

        _this3.pipes.forEach(function (pipe) {
          pipe.end();
        });

        _this3.emit('finish');
      }
    };

    if (chunk) {
      this.write(chunk, encoding, writeComplete);
    } else {
      writeComplete();
    }
  },
  // readable
  // event readable - some data is now available
  // event data - switch to flowing mode - feeds chunks to handler
  // event end - no more data
  // event close - optional, indicates upstream close
  // event error - duh
  read: function read(size) {
    var buffers; // read min(buffer, size || infinity)

    if (size) {
      buffers = [];

      while (size && this.buffers.length && !this.buffers[0].eod) {
        var first = this.buffers[0];
        var buffer = first.read(size);
        size -= buffer.length;
        buffers.push(buffer);

        if (first.eod && first.full) {
          this.buffers.shift();
        }
      }

      return Buffer.concat(buffers);
    }

    buffers = this.buffers.map(function (buf) {
      return buf.toBuffer();
    }).filter(Boolean);
    this.buffers = [];
    return Buffer.concat(buffers);
  },
  setEncoding: function setEncoding(encoding) {
    // causes stream.read or stream.on('data) to return strings of encoding instead of Buffer objects
    this.encoding = encoding;
  },
  pause: function pause() {
    this.paused = true;
  },
  resume: function resume() {
    this.paused = false;
  },
  isPaused: function isPaused() {
    return !!this.paused;
  },
  pipe: function pipe(destination) {
    // add destination to pipe list & write current buffer
    this.pipes.push(destination);

    if (!this.paused && this.buffers.length) {
      this.end();
    }
  },
  unpipe: function unpipe(destination) {
    // remove destination from pipe list
    this.pipes = this.pipes.filter(function (pipe) {
      return pipe !== destination;
    });
  },
  unshift: function unshift()
  /* chunk */
  {
    // some numpty has read some data that's not for them and they want to put it back!
    // Might implement this some day
    throw new Error('Not Implemented');
  },
  wrap: function wrap()
  /* stream */
  {
    // not implemented
    throw new Error('Not Implemented');
  }
});
module.exports = StreamBuf;

}).call(this,require('_process'),require("buffer").Buffer)

},{"./string-buf":24,"./utils":26,"_process":358,"buffer":216,"readable-stream":382}],24:[function(require,module,exports){
(function (Buffer){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// StringBuf - a way to keep string memory operations to a minimum
// while building the strings for the xml files
var StringBuf = /*#__PURE__*/function () {
  function StringBuf(options) {
    _classCallCheck(this, StringBuf);

    this._buf = Buffer.alloc(options && options.size || 16384);
    this._encoding = options && options.encoding || 'utf8'; // where in the buffer we are at

    this._inPos = 0; // for use by toBuffer()

    this._buffer = undefined;
  }

  _createClass(StringBuf, [{
    key: "toBuffer",
    value: function toBuffer() {
      // return the current data as a single enclosing buffer
      if (!this._buffer) {
        this._buffer = Buffer.alloc(this.length);

        this._buf.copy(this._buffer, 0, 0, this.length);
      }

      return this._buffer;
    }
  }, {
    key: "reset",
    value: function reset(position) {
      position = position || 0;
      this._buffer = undefined;
      this._inPos = position;
    }
  }, {
    key: "_grow",
    value: function _grow(min) {
      var size = this._buf.length * 2;

      while (size < min) {
        size *= 2;
      }

      var buf = Buffer.alloc(size);

      this._buf.copy(buf, 0);

      this._buf = buf;
    }
  }, {
    key: "addText",
    value: function addText(text) {
      this._buffer = undefined;

      var inPos = this._inPos + this._buf.write(text, this._inPos, this._encoding); // if we've hit (or nearing capacity), grow the buf


      while (inPos >= this._buf.length - 4) {
        this._grow(this._inPos + text.length); // keep trying to write until we've completely written the text


        inPos = this._inPos + this._buf.write(text, this._inPos, this._encoding);
      }

      this._inPos = inPos;
    }
  }, {
    key: "addStringBuf",
    value: function addStringBuf(inBuf) {
      if (inBuf.length) {
        this._buffer = undefined;

        if (this.length + inBuf.length > this.capacity) {
          this._grow(this.length + inBuf.length);
        } // eslint-disable-next-line no-underscore-dangle


        inBuf._buf.copy(this._buf, this._inPos, 0, inBuf.length);

        this._inPos += inBuf.length;
      }
    }
  }, {
    key: "length",
    get: function get() {
      return this._inPos;
    }
  }, {
    key: "capacity",
    get: function get() {
      return this._buf.length;
    }
  }, {
    key: "buffer",
    get: function get() {
      return this._buf;
    }
  }]);

  return StringBuf;
}();

module.exports = StringBuf;

}).call(this,require("buffer").Buffer)

},{"buffer":216}],25:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var toString = Object.prototype.toString;
var escapeHtmlRegex = /["&<>]/;
var _ = {
  each: function each(obj, cb) {
    if (obj) {
      if (Array.isArray(obj)) {
        obj.forEach(cb);
      } else {
        Object.keys(obj).forEach(function (key) {
          cb(obj[key], key);
        });
      }
    }
  },
  some: function some(obj, cb) {
    if (obj) {
      if (Array.isArray(obj)) {
        return obj.some(cb);
      }

      return Object.keys(obj).some(function (key) {
        return cb(obj[key], key);
      });
    }

    return false;
  },
  every: function every(obj, cb) {
    if (obj) {
      if (Array.isArray(obj)) {
        return obj.every(cb);
      }

      return Object.keys(obj).every(function (key) {
        return cb(obj[key], key);
      });
    }

    return true;
  },
  map: function map(obj, cb) {
    if (obj) {
      if (Array.isArray(obj)) {
        return obj.map(cb);
      }

      return Object.keys(obj).map(function (key) {
        return cb(obj[key], key);
      });
    }

    return [];
  },
  keyBy: function keyBy(a, p) {
    return a.reduce(function (o, v) {
      o[v[p]] = v;
      return o;
    }, {});
  },
  isEqual: function isEqual(a, b) {
    var aType = _typeof(a);

    var bType = _typeof(b);

    var aArray = Array.isArray(a);
    var bArray = Array.isArray(b);

    if (aType !== bType) {
      return false;
    }

    switch (_typeof(a)) {
      case 'object':
        if (aArray || bArray) {
          if (aArray && bArray) {
            return a.length === b.length && a.every(function (aValue, index) {
              var bValue = b[index];
              return _.isEqual(aValue, bValue);
            });
          }

          return false;
        }

        return _.every(a, function (aValue, key) {
          var bValue = b[key];
          return _.isEqual(aValue, bValue);
        });

      default:
        return a === b;
    }
  },
  escapeHtml: function escapeHtml(html) {
    var regexResult = escapeHtmlRegex.exec(html);
    if (!regexResult) return html;
    var result = '';
    var escape = '';
    var lastIndex = 0;
    var i = regexResult.index;

    for (; i < html.length; i++) {
      switch (html.charAt(i)) {
        case '"':
          escape = '&quot;';
          break;

        case '&':
          escape = '&amp;';
          break;

        case '\'':
          escape = '&apos;';
          break;

        case '<':
          escape = '&lt;';
          break;

        case '>':
          escape = '&gt;';
          break;

        default:
          continue;
      }

      if (lastIndex !== i) result += html.substring(lastIndex, i);
      lastIndex = i + 1;
      result += escape;
    }

    if (lastIndex !== i) return result + html.substring(lastIndex, i);
    return result;
  },
  strcmp: function strcmp(a, b) {
    if (a < b) return -1;
    if (a > b) return 1;
    return 0;
  },
  isUndefined: function isUndefined(val) {
    return toString.call(val) === '[object Undefined]';
  },
  isObject: function isObject(val) {
    return toString.call(val) === '[object Object]';
  },
  deepMerge: function deepMerge() {
    var target = arguments[0] || {};
    var length = arguments.length; // eslint-disable-next-line one-var

    var src, clone, copyIsArray;

    function assignValue(val, key) {
      src = target[key];
      copyIsArray = Array.isArray(val);

      if (_.isObject(val) || copyIsArray) {
        if (copyIsArray) {
          copyIsArray = false;
          clone = src && Array.isArray(src) ? src : [];
        } else {
          clone = src && _.isObject(src) ? src : {};
        }

        target[key] = _.deepMerge(clone, val);
      } else if (!_.isUndefined(val)) {
        target[key] = val;
      }
    }

    for (var i = 0; i < length; i++) {
      _.each(arguments[i], assignValue);
    }

    return target;
  }
};
module.exports = _;

},{}],26:[function(require,module,exports){
(function (global,setImmediate){
"use strict";

var fs = require('fs'); // useful stuff


var inherits = function inherits(cls, superCtor, statics, prototype) {
  // eslint-disable-next-line no-underscore-dangle
  cls.super_ = superCtor;

  if (!prototype) {
    prototype = statics;
    statics = null;
  }

  if (statics) {
    Object.keys(statics).forEach(function (i) {
      Object.defineProperty(cls, i, Object.getOwnPropertyDescriptor(statics, i));
    });
  }

  var properties = {
    constructor: {
      value: cls,
      enumerable: false,
      writable: false,
      configurable: true
    }
  };

  if (prototype) {
    Object.keys(prototype).forEach(function (i) {
      properties[i] = Object.getOwnPropertyDescriptor(prototype, i);
    });
  }

  cls.prototype = Object.create(superCtor.prototype, properties);
}; // eslint-disable-next-line no-control-regex


var xmlDecodeRegex = /[<>&'"\x7F\x00-\x08\x0B-\x0C\x0E-\x1F]/;
var utils = {
  nop: function nop() {},
  promiseImmediate: function promiseImmediate(value) {
    return new Promise(function (resolve) {
      if (global.setImmediate) {
        setImmediate(function () {
          resolve(value);
        });
      } else {
        // poorman's setImmediate - must wait at least 1ms
        setTimeout(function () {
          resolve(value);
        }, 1);
      }
    });
  },
  inherits: inherits,
  dateToExcel: function dateToExcel(d, date1904) {
    return 25569 + d.getTime() / (24 * 3600 * 1000) - (date1904 ? 1462 : 0);
  },
  excelToDate: function excelToDate(v, date1904) {
    var millisecondSinceEpoch = Math.round((v - 25569 + (date1904 ? 1462 : 0)) * 24 * 3600 * 1000);
    return new Date(millisecondSinceEpoch);
  },
  parsePath: function parsePath(filepath) {
    var last = filepath.lastIndexOf('/');
    return {
      path: filepath.substring(0, last),
      name: filepath.substring(last + 1)
    };
  },
  getRelsPath: function getRelsPath(filepath) {
    var path = utils.parsePath(filepath);
    return "".concat(path.path, "/_rels/").concat(path.name, ".rels");
  },
  xmlEncode: function xmlEncode(text) {
    var regexResult = xmlDecodeRegex.exec(text);
    if (!regexResult) return text;
    var result = '';
    var escape = '';
    var lastIndex = 0;
    var i = regexResult.index;

    for (; i < text.length; i++) {
      var charCode = text.charCodeAt(i);

      switch (charCode) {
        case 34:
          // "
          escape = '&quot;';
          break;

        case 38:
          // &
          escape = '&amp;';
          break;

        case 39:
          // '
          escape = '&apos;';
          break;

        case 60:
          // <
          escape = '&lt;';
          break;

        case 62:
          // >
          escape = '&gt;';
          break;

        case 127:
          escape = '';
          break;

        default:
          {
            if (charCode <= 31 && (charCode <= 8 || charCode >= 11 && charCode !== 13)) {
              escape = '';
              break;
            }

            continue;
          }
      }

      if (lastIndex !== i) result += text.substring(lastIndex, i);
      lastIndex = i + 1;
      if (escape) result += escape;
    }

    if (lastIndex !== i) return result + text.substring(lastIndex, i);
    return result;
  },
  xmlDecode: function xmlDecode(text) {
    return text.replace(/&([a-z]*);/g, function (c) {
      switch (c) {
        case '&lt;':
          return '<';

        case '&gt;':
          return '>';

        case '&amp;':
          return '&';

        case '&apos;':
          return '\'';

        case '&quot;':
          return '"';

        default:
          return c;
      }
    });
  },
  validInt: function validInt(value) {
    var i = parseInt(value, 10);
    return !Number.isNaN(i) ? i : 0;
  },
  isDateFmt: function isDateFmt(fmt) {
    if (!fmt) {
      return false;
    } // must remove all chars inside quotes and []


    fmt = fmt.replace(/\[[^\]]*]/g, '');
    fmt = fmt.replace(/"[^"]*"/g, ''); // then check for date formatting chars

    var result = fmt.match(/[ymdhMsb]+/) !== null;
    return result;
  },
  fs: {
    exists: function exists(path) {
      return new Promise(function (resolve) {
        fs.access(path, fs.constants.F_OK, function (err) {
          resolve(!err);
        });
      });
    }
  },
  toIsoDateString: function toIsoDateString(dt) {
    return dt.toIsoString().subsstr(0, 10);
  }
};
module.exports = utils;

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {},require("timers").setImmediate)

},{"fs":215,"timers":411}],27:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('./under-dash');

var utils = require('./utils'); // constants


var OPEN_ANGLE = '<';
var CLOSE_ANGLE = '>';
var OPEN_ANGLE_SLASH = '</';
var CLOSE_SLASH_ANGLE = '/>';
var EQUALS_QUOTE = '="';
var QUOTE = '"';
var SPACE = ' ';

function pushAttribute(xml, name, value) {
  xml.push(SPACE);
  xml.push(name);
  xml.push(EQUALS_QUOTE);
  xml.push(utils.xmlEncode(value.toString()));
  xml.push(QUOTE);
}

function pushAttributes(xml, attributes) {
  if (attributes) {
    _.each(attributes, function (value, name) {
      if (value !== undefined) {
        pushAttribute(xml, name, value);
      }
    });
  }
}

var XmlStream = /*#__PURE__*/function () {
  function XmlStream() {
    _classCallCheck(this, XmlStream);

    this._xml = [];
    this._stack = [];
    this._rollbacks = [];
  }

  _createClass(XmlStream, [{
    key: "openXml",
    value: function openXml(docAttributes) {
      var xml = this._xml; // <?xml version="1.0" encoding="UTF-8" standalone="yes"?>

      xml.push('<?xml');
      pushAttributes(xml, docAttributes);
      xml.push('?>\n');
    }
  }, {
    key: "openNode",
    value: function openNode(name, attributes) {
      var parent = this.tos;
      var xml = this._xml;

      if (parent && this.open) {
        xml.push(CLOSE_ANGLE);
      }

      this._stack.push(name); // start streaming node


      xml.push(OPEN_ANGLE);
      xml.push(name);
      pushAttributes(xml, attributes);
      this.leaf = true;
      this.open = true;
    }
  }, {
    key: "addAttribute",
    value: function addAttribute(name, value) {
      if (!this.open) {
        throw new Error('Cannot write attributes to node if it is not open');
      }

      if (value !== undefined) {
        pushAttribute(this._xml, name, value);
      }
    }
  }, {
    key: "addAttributes",
    value: function addAttributes(attrs) {
      if (!this.open) {
        throw new Error('Cannot write attributes to node if it is not open');
      }

      pushAttributes(this._xml, attrs);
    }
  }, {
    key: "writeText",
    value: function writeText(text) {
      var xml = this._xml;

      if (this.open) {
        xml.push(CLOSE_ANGLE);
        this.open = false;
      }

      this.leaf = false;
      xml.push(utils.xmlEncode(text.toString()));
    }
  }, {
    key: "writeXml",
    value: function writeXml(xml) {
      if (this.open) {
        this._xml.push(CLOSE_ANGLE);

        this.open = false;
      }

      this.leaf = false;

      this._xml.push(xml);
    }
  }, {
    key: "closeNode",
    value: function closeNode() {
      var node = this._stack.pop();

      var xml = this._xml;

      if (this.leaf) {
        xml.push(CLOSE_SLASH_ANGLE);
      } else {
        xml.push(OPEN_ANGLE_SLASH);
        xml.push(node);
        xml.push(CLOSE_ANGLE);
      }

      this.open = false;
      this.leaf = false;
    }
  }, {
    key: "leafNode",
    value: function leafNode(name, attributes, text) {
      this.openNode(name, attributes);

      if (text !== undefined) {
        // zeros need to be written
        this.writeText(text);
      }

      this.closeNode();
    }
  }, {
    key: "closeAll",
    value: function closeAll() {
      while (this._stack.length) {
        this.closeNode();
      }
    }
  }, {
    key: "addRollback",
    value: function addRollback() {
      this._rollbacks.push({
        xml: this._xml.length,
        stack: this._stack.length,
        leaf: this.leaf,
        open: this.open
      });

      return this.cursor;
    }
  }, {
    key: "commit",
    value: function commit() {
      this._rollbacks.pop();
    }
  }, {
    key: "rollback",
    value: function rollback() {
      var r = this._rollbacks.pop();

      if (this._xml.length > r.xml) {
        this._xml.splice(r.xml, this._xml.length - r.xml);
      }

      if (this._stack.length > r.stack) {
        this._stack.splice(r.stack, this._stack.length - r.stack);
      }

      this.leaf = r.leaf;
      this.open = r.open;
    }
  }, {
    key: "tos",
    get: function get() {
      return this._stack.length ? this._stack[this._stack.length - 1] : undefined;
    }
  }, {
    key: "cursor",
    get: function get() {
      // handy way to track whether anything has been added
      return this._xml.length;
    }
  }, {
    key: "xml",
    get: function get() {
      this.closeAll();
      return this._xml.join('');
    }
  }]);

  return XmlStream;
}();

XmlStream.StdDocAttributes = {
  version: '1.0',
  encoding: 'UTF-8',
  standalone: 'yes'
};
module.exports = XmlStream;

},{"./under-dash":25,"./utils":26}],28:[function(require,module,exports){
(function (process){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var events = require('events');

var JSZip = require('jszip');

var StreamBuf = require('./stream-buf');

var _require = require('./browser-buffer-encode'),
    stringToBuffer = _require.stringToBuffer; // =============================================================================
// The ZipWriter class
// Packs streamed data into an output zip stream


var ZipWriter = /*#__PURE__*/function (_events$EventEmitter) {
  _inherits(ZipWriter, _events$EventEmitter);

  var _super = _createSuper(ZipWriter);

  function ZipWriter(options) {
    var _this;

    _classCallCheck(this, ZipWriter);

    _this = _super.call(this);
    _this.options = Object.assign({
      type: 'nodebuffer',
      compression: 'DEFLATE'
    }, options);
    _this.zip = new JSZip();
    _this.stream = new StreamBuf();
    return _this;
  }

  _createClass(ZipWriter, [{
    key: "append",
    value: function append(data, options) {
      if (options.hasOwnProperty('base64') && options.base64) {
        this.zip.file(options.name, data, {
          base64: true
        });
      } else {
        // https://www.npmjs.com/package/process
        if (process.browser && typeof data === 'string') {
          // use TextEncoder in browser
          data = stringToBuffer(data);
        }

        this.zip.file(options.name, data);
      }
    }
  }, {
    key: "finalize",
    value: function () {
      var _finalize = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var content;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return this.zip.generateAsync(this.options);

              case 2:
                content = _context.sent;
                this.stream.end(content);
                this.emit('finish');

              case 5:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function finalize() {
        return _finalize.apply(this, arguments);
      }

      return finalize;
    }() // ==========================================================================
    // Stream.Readable interface

  }, {
    key: "read",
    value: function read(size) {
      return this.stream.read(size);
    }
  }, {
    key: "setEncoding",
    value: function setEncoding(encoding) {
      return this.stream.setEncoding(encoding);
    }
  }, {
    key: "pause",
    value: function pause() {
      return this.stream.pause();
    }
  }, {
    key: "resume",
    value: function resume() {
      return this.stream.resume();
    }
  }, {
    key: "isPaused",
    value: function isPaused() {
      return this.stream.isPaused();
    }
  }, {
    key: "pipe",
    value: function pipe(destination, options) {
      return this.stream.pipe(destination, options);
    }
  }, {
    key: "unpipe",
    value: function unpipe(destination) {
      return this.stream.unpipe(destination);
    }
  }, {
    key: "unshift",
    value: function unshift(chunk) {
      return this.stream.unshift(chunk);
    }
  }, {
    key: "wrap",
    value: function wrap(stream) {
      return this.stream.wrap(stream);
    }
  }]);

  return ZipWriter;
}(events.EventEmitter); // =============================================================================


module.exports = {
  ZipWriter: ZipWriter
};

}).call(this,require('_process'))

},{"./browser-buffer-encode":17,"./stream-buf":23,"_process":358,"events":258,"jszip":290}],29:[function(require,module,exports){
"use strict";

module.exports = {
  0: {
    f: 'General'
  },
  1: {
    f: '0'
  },
  2: {
    f: '0.00'
  },
  3: {
    f: '#,##0'
  },
  4: {
    f: '#,##0.00'
  },
  9: {
    f: '0%'
  },
  10: {
    f: '0.00%'
  },
  11: {
    f: '0.00E+00'
  },
  12: {
    f: '# ?/?'
  },
  13: {
    f: '# ??/??'
  },
  14: {
    f: 'mm-dd-yy'
  },
  15: {
    f: 'd-mmm-yy'
  },
  16: {
    f: 'd-mmm'
  },
  17: {
    f: 'mmm-yy'
  },
  18: {
    f: 'h:mm AM/PM'
  },
  19: {
    f: 'h:mm:ss AM/PM'
  },
  20: {
    f: 'h:mm'
  },
  21: {
    f: 'h:mm:ss'
  },
  22: {
    f: 'm/d/yy "h":mm'
  },
  27: {
    'zh-tw': '[$-404]e/m/d',
    'zh-cn': 'yyyy"年"m"月"',
    'ja-jp': '[$-411]ge.m.d',
    'ko-kr': 'yyyy"年" mm"月" dd"日"'
  },
  28: {
    'zh-tw': '[$-404]e"年"m"月"d"日"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': '[$-411]ggge"年"m"月"d"日"',
    'ko-kr': 'mm-dd'
  },
  29: {
    'zh-tw': '[$-404]e"年"m"月"d"日"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': '[$-411]ggge"年"m"月"d"日"',
    'ko-kr': 'mm-dd'
  },
  30: {
    'zh-tw': 'm/d/yy ',
    'zh-cn': 'm-d-yy',
    'ja-jp': 'm/d/yy',
    'ko-kr': 'mm-dd-yy'
  },
  31: {
    'zh-tw': 'yyyy"年"m"月"d"日"',
    'zh-cn': 'yyyy"年"m"月"d"日"',
    'ja-jp': 'yyyy"年"m"月"d"日"',
    'ko-kr': 'yyyy"년" mm"월" dd"일"'
  },
  32: {
    'zh-tw': 'hh"時"mm"分"',
    'zh-cn': 'h"时"mm"分"',
    'ja-jp': 'h"時"mm"分"',
    'ko-kr': 'h"시" mm"분"'
  },
  33: {
    'zh-tw': 'hh"時"mm"分"ss"秒"',
    'zh-cn': 'h"时"mm"分"ss"秒"',
    'ja-jp': 'h"時"mm"分"ss"秒"',
    'ko-kr': 'h"시" mm"분" ss"초"'
  },
  34: {
    'zh-tw': '上午/下午 hh"時"mm"分"',
    'zh-cn': '上午/下午 h"时"mm"分"',
    'ja-jp': 'yyyy"年"m"月"',
    'ko-kr': 'yyyy-mm-dd'
  },
  35: {
    'zh-tw': '上午/下午 hh"時"mm"分"ss"秒"',
    'zh-cn': '上午/下午 h"时"mm"分"ss"秒"',
    'ja-jp': 'm"月"d"日"',
    'ko-kr': 'yyyy-mm-dd'
  },
  36: {
    'zh-tw': '[$-404]e/m/d',
    'zh-cn': 'yyyy"年"m"月"',
    'ja-jp': '[$-411]ge.m.d',
    'ko-kr': 'yyyy"年" mm"月" dd"日"'
  },
  37: {
    f: '#,##0 ;(#,##0)'
  },
  38: {
    f: '#,##0 ;[Red](#,##0)'
  },
  39: {
    f: '#,##0.00 ;(#,##0.00)'
  },
  40: {
    f: '#,##0.00 ;[Red](#,##0.00)'
  },
  45: {
    f: 'mm:ss'
  },
  46: {
    f: '[h]:mm:ss'
  },
  47: {
    f: 'mmss.0'
  },
  48: {
    f: '##0.0E+0'
  },
  49: {
    f: '@'
  },
  50: {
    'zh-tw': '[$-404]e/m/d',
    'zh-cn': 'yyyy"年"m"月"',
    'ja-jp': '[$-411]ge.m.d',
    'ko-kr': 'yyyy"年" mm"月" dd"日"'
  },
  51: {
    'zh-tw': '[$-404]e"年"m"月"d"日"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': '[$-411]ggge"年"m"月"d"日"',
    'ko-kr': 'mm-dd'
  },
  52: {
    'zh-tw': '上午/下午 hh"時"mm"分"',
    'zh-cn': 'yyyy"年"m"月"',
    'ja-jp': 'yyyy"年"m"月"',
    'ko-kr': 'yyyy-mm-dd'
  },
  53: {
    'zh-tw': '上午/下午 hh"時"mm"分"ss"秒"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': 'm"月"d"日"',
    'ko-kr': 'yyyy-mm-dd'
  },
  54: {
    'zh-tw': '[$-404]e"年"m"月"d"日"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': '[$-411]ggge"年"m"月"d"日"',
    'ko-kr': 'mm-dd'
  },
  55: {
    'zh-tw': '上午/下午 hh"時"mm"分"',
    'zh-cn': '上午/下午 h"时"mm"分"',
    'ja-jp': 'yyyy"年"m"月"',
    'ko-kr': 'yyyy-mm-dd'
  },
  56: {
    'zh-tw': '上午/下午 hh"時"mm"分"ss"秒"',
    'zh-cn': '上午/下午 h"时"mm"分"ss"秒"',
    'ja-jp': 'm"月"d"日"',
    'ko-kr': 'yyyy-mm-dd'
  },
  57: {
    'zh-tw': '[$-404]e/m/d',
    'zh-cn': 'yyyy"年"m"月"',
    'ja-jp': '[$-411]ge.m.d',
    'ko-kr': 'yyyy"年" mm"月" dd"日"'
  },
  58: {
    'zh-tw': '[$-404]e"年"m"月"d"日"',
    'zh-cn': 'm"月"d"日"',
    'ja-jp': '[$-411]ggge"年"m"月"d"日"',
    'ko-kr': 'mm-dd'
  },
  59: {
    'th-th': 't0'
  },
  60: {
    'th-th': 't0.00'
  },
  61: {
    'th-th': 't#,##0'
  },
  62: {
    'th-th': 't#,##0.00'
  },
  67: {
    'th-th': 't0%'
  },
  68: {
    'th-th': 't0.00%'
  },
  69: {
    'th-th': 't# ?/?'
  },
  70: {
    'th-th': 't# ??/??'
  },
  81: {
    'th-th': 'd/m/bb'
  }
};

},{}],30:[function(require,module,exports){
'use strict';

module.exports = {
  OfficeDocument: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument',
  Worksheet: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet',
  CalcChain: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/calcChain',
  SharedStrings: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings',
  Styles: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles',
  Theme: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme',
  Hyperlink: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink',
  Image: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/image',
  CoreProperties: 'http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties',
  ExtenderProperties: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties',
  Comments: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments',
  VmlDrawing: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing',
  Table: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/table'
};

},{}],31:[function(require,module,exports){
"use strict";

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _asyncIterator(iterable) { var method; if (typeof Symbol !== "undefined") { if (Symbol.asyncIterator) { method = iterable[Symbol.asyncIterator]; if (method != null) return method.call(iterable); } if (Symbol.iterator) { method = iterable[Symbol.iterator]; if (method != null) return method.call(iterable); } } throw new TypeError("Object is not async iterable"); }

var parseSax = require('../../utils/parse-sax');

var XmlStream = require('../../utils/xml-stream');
/* 'virtual' methods used as a form of documentation */

/* eslint-disable class-methods-use-this */
// Base class for Xforms


var BaseXform = /*#__PURE__*/function () {
  function BaseXform() {
    _classCallCheck(this, BaseXform);
  }

  _createClass(BaseXform, [{
    key: "prepare",
    // constructor(/* model, name */) {}
    // ============================================================
    // Virtual Interface
    value: function prepare()
    /* model, options */
    {// optional preparation (mutation) of model so it is ready for write
    }
  }, {
    key: "render",
    value: function render()
    /* xmlStream, model */
    {// convert model to xml
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {// XML node opened
    }
  }, {
    key: "parseText",
    value: function parseText(text) {// chunk of text encountered for current node
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {// XML node closed
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {// optional post-parse step (opposite to prepare)
    } // ============================================================

  }, {
    key: "reset",
    value: function reset() {
      // to make sure parses don't bleed to next iteration
      this.model = null; // if we have a map - reset them too

      if (this.map) {
        Object.values(this.map).forEach(function (xform) {
          if (xform instanceof BaseXform) {
            xform.reset();
          } else if (xform.xform) {
            xform.xform.reset();
          }
        });
      }
    }
  }, {
    key: "mergeModel",
    value: function mergeModel(obj) {
      // set obj's props to this.model
      this.model = Object.assign(this.model || {}, obj);
    }
  }, {
    key: "parse",
    value: function () {
      var _parse = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(saxParser) {
        var _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, _value, events, _iterator2, _step2, _step2$value, eventType, value;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _iteratorNormalCompletion = true;
                _didIteratorError = false;
                _context.prev = 2;
                _iterator = _asyncIterator(saxParser);

              case 4:
                _context.next = 6;
                return _iterator.next();

              case 6:
                _step = _context.sent;
                _iteratorNormalCompletion = _step.done;
                _context.next = 10;
                return _step.value;

              case 10:
                _value = _context.sent;

                if (_iteratorNormalCompletion) {
                  _context.next = 42;
                  break;
                }

                events = _value;
                _iterator2 = _createForOfIteratorHelper(events);
                _context.prev = 14;

                _iterator2.s();

              case 16:
                if ((_step2 = _iterator2.n()).done) {
                  _context.next = 31;
                  break;
                }

                _step2$value = _step2.value, eventType = _step2$value.eventType, value = _step2$value.value;

                if (!(eventType === 'opentag')) {
                  _context.next = 22;
                  break;
                }

                this.parseOpen(value);
                _context.next = 29;
                break;

              case 22:
                if (!(eventType === 'text')) {
                  _context.next = 26;
                  break;
                }

                this.parseText(value);
                _context.next = 29;
                break;

              case 26:
                if (!(eventType === 'closetag')) {
                  _context.next = 29;
                  break;
                }

                if (this.parseClose(value.name)) {
                  _context.next = 29;
                  break;
                }

                return _context.abrupt("return", this.model);

              case 29:
                _context.next = 16;
                break;

              case 31:
                _context.next = 36;
                break;

              case 33:
                _context.prev = 33;
                _context.t0 = _context["catch"](14);

                _iterator2.e(_context.t0);

              case 36:
                _context.prev = 36;

                _iterator2.f();

                return _context.finish(36);

              case 39:
                _iteratorNormalCompletion = true;
                _context.next = 4;
                break;

              case 42:
                _context.next = 48;
                break;

              case 44:
                _context.prev = 44;
                _context.t1 = _context["catch"](2);
                _didIteratorError = true;
                _iteratorError = _context.t1;

              case 48:
                _context.prev = 48;
                _context.prev = 49;

                if (!(!_iteratorNormalCompletion && _iterator.return != null)) {
                  _context.next = 53;
                  break;
                }

                _context.next = 53;
                return _iterator.return();

              case 53:
                _context.prev = 53;

                if (!_didIteratorError) {
                  _context.next = 56;
                  break;
                }

                throw _iteratorError;

              case 56:
                return _context.finish(53);

              case 57:
                return _context.finish(48);

              case 58:
                return _context.abrupt("return", this.model);

              case 59:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[2, 44, 48, 58], [14, 33, 36, 39], [49,, 53, 57]]);
      }));

      function parse(_x) {
        return _parse.apply(this, arguments);
      }

      return parse;
    }()
  }, {
    key: "parseStream",
    value: function () {
      var _parseStream = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(stream) {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                return _context2.abrupt("return", this.parse(parseSax(stream)));

              case 1:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function parseStream(_x2) {
        return _parseStream.apply(this, arguments);
      }

      return parseStream;
    }()
  }, {
    key: "toXml",
    value: function toXml(model) {
      var xmlStream = new XmlStream();
      this.render(xmlStream, model);
      return xmlStream.xml;
    } // ============================================================
    // Useful Utilities

  }, {
    key: "xml",
    get: function get() {
      // convenience function to get the xml of this.model
      // useful for manager types that are built during the prepare phase
      return this.toXml(this.model);
    }
  }], [{
    key: "toAttribute",
    value: function toAttribute(value, dflt) {
      var always = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

      if (value === undefined) {
        if (always) {
          return dflt;
        }
      } else if (always || value !== dflt) {
        return value.toString();
      }

      return undefined;
    }
  }, {
    key: "toStringAttribute",
    value: function toStringAttribute(value, dflt) {
      var always = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      return BaseXform.toAttribute(value, dflt, always);
    }
  }, {
    key: "toStringValue",
    value: function toStringValue(attr, dflt) {
      return attr === undefined ? dflt : attr;
    }
  }, {
    key: "toBoolAttribute",
    value: function toBoolAttribute(value, dflt) {
      var always = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

      if (value === undefined) {
        if (always) {
          return dflt;
        }
      } else if (always || value !== dflt) {
        return value ? '1' : '0';
      }

      return undefined;
    }
  }, {
    key: "toBoolValue",
    value: function toBoolValue(attr, dflt) {
      return attr === undefined ? dflt : attr === '1';
    }
  }, {
    key: "toIntAttribute",
    value: function toIntAttribute(value, dflt) {
      var always = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      return BaseXform.toAttribute(value, dflt, always);
    }
  }, {
    key: "toIntValue",
    value: function toIntValue(attr, dflt) {
      return attr === undefined ? dflt : parseInt(attr, 10);
    }
  }, {
    key: "toFloatAttribute",
    value: function toFloatAttribute(value, dflt) {
      var always = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      return BaseXform.toAttribute(value, dflt, always);
    }
  }, {
    key: "toFloatValue",
    value: function toFloatValue(attr, dflt) {
      return attr === undefined ? dflt : parseFloat(attr);
    }
  }]);

  return BaseXform;
}();

module.exports = BaseXform;

},{"../../utils/parse-sax":21,"../../utils/xml-stream":27}],32:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var colCache = require('../../../utils/col-cache');

var DefinedNamesXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(DefinedNamesXform, _BaseXform);

  var _super = _createSuper(DefinedNamesXform);

  function DefinedNamesXform() {
    _classCallCheck(this, DefinedNamesXform);

    return _super.apply(this, arguments);
  }

  _createClass(DefinedNamesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      // <definedNames>
      //   <definedName name="name">name.ranges.join(',')</definedName>
      //   <definedName name="_xlnm.Print_Area" localSheetId="0">name.ranges.join(',')</definedName>
      // </definedNames>
      xmlStream.openNode('definedName', {
        name: model.name,
        localSheetId: model.localSheetId
      });
      xmlStream.writeText(model.ranges.join(','));
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'definedName':
          this._parsedName = node.attributes.name;
          this._parsedLocalSheetId = node.attributes.localSheetId;
          this._parsedText = [];
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this._parsedText.push(text);
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      this.model = {
        name: this._parsedName,
        ranges: extractRanges(this._parsedText.join(''))
      };

      if (this._parsedLocalSheetId !== undefined) {
        this.model.localSheetId = parseInt(this._parsedLocalSheetId, 10);
      }

      return false;
    }
  }]);

  return DefinedNamesXform;
}(BaseXform);

function isValidRange(range) {
  try {
    colCache.decodeEx(range);
    return true;
  } catch (err) {
    return false;
  }
}

function extractRanges(parsedText) {
  var ranges = [];
  var quotesOpened = false;
  var last = '';
  parsedText.split(',').forEach(function (item) {
    if (!item) {
      return;
    }

    var quotes = (item.match(/'/g) || []).length;

    if (!quotes) {
      if (quotesOpened) {
        last += "".concat(item, ",");
      } else if (isValidRange(item)) {
        ranges.push(item);
      }

      return;
    }

    var quotesEven = quotes % 2 === 0;

    if (!quotesOpened && quotesEven && isValidRange(item)) {
      ranges.push(item);
    } else if (quotesOpened && !quotesEven) {
      quotesOpened = false;

      if (isValidRange(last + item)) {
        ranges.push(last + item);
      }

      last = '';
    } else {
      quotesOpened = true;
      last += "".concat(item, ",");
    }
  });
  return ranges;
}

module.exports = DefinedNamesXform;

},{"../../../utils/col-cache":19,"../base-xform":31}],33:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var WorksheetXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(WorksheetXform, _BaseXform);

  var _super = _createSuper(WorksheetXform);

  function WorksheetXform() {
    _classCallCheck(this, WorksheetXform);

    return _super.apply(this, arguments);
  }

  _createClass(WorksheetXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('sheet', {
        sheetId: model.id,
        name: model.name,
        state: model.state,
        'r:id': model.rId
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'sheet') {
        this.model = {
          name: utils.xmlDecode(node.attributes.name),
          id: parseInt(node.attributes.sheetId, 10),
          state: node.attributes.state,
          rId: node.attributes['r:id']
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return WorksheetXform;
}(BaseXform);

module.exports = WorksheetXform;

},{"../../../utils/utils":26,"../base-xform":31}],34:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var WorkbookCalcPropertiesXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(WorkbookCalcPropertiesXform, _BaseXform);

  var _super = _createSuper(WorkbookCalcPropertiesXform);

  function WorkbookCalcPropertiesXform() {
    _classCallCheck(this, WorkbookCalcPropertiesXform);

    return _super.apply(this, arguments);
  }

  _createClass(WorkbookCalcPropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('calcPr', {
        calcId: 171027,
        fullCalcOnLoad: model.fullCalcOnLoad ? 1 : undefined
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'calcPr') {
        this.model = {};
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return WorkbookCalcPropertiesXform;
}(BaseXform);

module.exports = WorkbookCalcPropertiesXform;

},{"../base-xform":31}],35:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var WorksheetPropertiesXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(WorksheetPropertiesXform, _BaseXform);

  var _super = _createSuper(WorksheetPropertiesXform);

  function WorksheetPropertiesXform() {
    _classCallCheck(this, WorksheetPropertiesXform);

    return _super.apply(this, arguments);
  }

  _createClass(WorksheetPropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('workbookPr', {
        date1904: model.date1904 ? 1 : undefined,
        defaultThemeVersion: 164011,
        filterPrivacy: 1
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'workbookPr') {
        this.model = {
          date1904: node.attributes.date1904 === '1'
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return WorksheetPropertiesXform;
}(BaseXform);

module.exports = WorksheetPropertiesXform;

},{"../base-xform":31}],36:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var WorkbookViewXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(WorkbookViewXform, _BaseXform);

  var _super = _createSuper(WorkbookViewXform);

  function WorkbookViewXform() {
    _classCallCheck(this, WorkbookViewXform);

    return _super.apply(this, arguments);
  }

  _createClass(WorkbookViewXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var attributes = {
        xWindow: model.x || 0,
        yWindow: model.y || 0,
        windowWidth: model.width || 12000,
        windowHeight: model.height || 24000,
        firstSheet: model.firstSheet,
        activeTab: model.activeTab
      };

      if (model.visibility && model.visibility !== 'visible') {
        attributes.visibility = model.visibility;
      }

      xmlStream.leafNode('workbookView', attributes);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'workbookView') {
        var model = this.model = {};

        var addS = function addS(name, value, dflt) {
          var s = value !== undefined ? model[name] = value : dflt;

          if (s !== undefined) {
            model[name] = s;
          }
        };

        var addN = function addN(name, value, dflt) {
          var n = value !== undefined ? model[name] = parseInt(value, 10) : dflt;

          if (n !== undefined) {
            model[name] = n;
          }
        };

        addN('x', node.attributes.xWindow, 0);
        addN('y', node.attributes.yWindow, 0);
        addN('width', node.attributes.windowWidth, 25000);
        addN('height', node.attributes.windowHeight, 10000);
        addS('visibility', node.attributes.visibility, 'visible');
        addN('activeTab', node.attributes.activeTab, undefined);
        addN('firstSheet', node.attributes.firstSheet, undefined);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return WorkbookViewXform;
}(BaseXform);

module.exports = WorkbookViewXform;

},{"../base-xform":31}],37:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var _ = require('../../../utils/under-dash');

var colCache = require('../../../utils/col-cache');

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var StaticXform = require('../static-xform');

var ListXform = require('../list-xform');

var DefinedNameXform = require('./defined-name-xform');

var SheetXform = require('./sheet-xform');

var WorkbookViewXform = require('./workbook-view-xform');

var WorkbookPropertiesXform = require('./workbook-properties-xform');

var WorkbookCalcPropertiesXform = require('./workbook-calc-properties-xform');

var WorkbookXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(WorkbookXform, _BaseXform);

  var _super = _createSuper(WorkbookXform);

  function WorkbookXform() {
    var _this;

    _classCallCheck(this, WorkbookXform);

    _this = _super.call(this);
    _this.map = {
      fileVersion: WorkbookXform.STATIC_XFORMS.fileVersion,
      workbookPr: new WorkbookPropertiesXform(),
      bookViews: new ListXform({
        tag: 'bookViews',
        count: false,
        childXform: new WorkbookViewXform()
      }),
      sheets: new ListXform({
        tag: 'sheets',
        count: false,
        childXform: new SheetXform()
      }),
      definedNames: new ListXform({
        tag: 'definedNames',
        count: false,
        childXform: new DefinedNameXform()
      }),
      calcPr: new WorkbookCalcPropertiesXform()
    };
    return _this;
  }

  _createClass(WorkbookXform, [{
    key: "prepare",
    value: function prepare(model) {
      model.sheets = model.worksheets; // collate all the print areas from all of the sheets and add them to the defined names

      var printAreas = [];
      var index = 0; // sheets is sparse array - calc index manually

      model.sheets.forEach(function (sheet) {
        if (sheet.pageSetup && sheet.pageSetup.printArea) {
          sheet.pageSetup.printArea.split('&&').forEach(function (printArea) {
            var printAreaComponents = printArea.split(':');
            var definedName = {
              name: '_xlnm.Print_Area',
              ranges: ["'".concat(sheet.name, "'!$").concat(printAreaComponents[0], ":$").concat(printAreaComponents[1])],
              localSheetId: index
            };
            printAreas.push(definedName);
          });
        }

        if (sheet.pageSetup && (sheet.pageSetup.printTitlesRow || sheet.pageSetup.printTitlesColumn)) {
          var ranges = [];

          if (sheet.pageSetup.printTitlesColumn) {
            var titlesColumns = sheet.pageSetup.printTitlesColumn.split(':');
            ranges.push("'".concat(sheet.name, "'!$").concat(titlesColumns[0], ":$").concat(titlesColumns[1]));
          }

          if (sheet.pageSetup.printTitlesRow) {
            var titlesRows = sheet.pageSetup.printTitlesRow.split(':');
            ranges.push("'".concat(sheet.name, "'!$").concat(titlesRows[0], ":$").concat(titlesRows[1]));
          }

          var definedName = {
            name: '_xlnm.Print_Titles',
            ranges: ranges,
            localSheetId: index
          };
          printAreas.push(definedName);
        }

        index++;
      });

      if (printAreas.length) {
        model.definedNames = model.definedNames.concat(printAreas);
      }

      (model.media || []).forEach(function (medium, i) {
        // assign name
        medium.name = medium.type + (i + 1);
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('workbook', WorkbookXform.WORKBOOK_ATTRIBUTES);
      this.map.fileVersion.render(xmlStream);
      this.map.workbookPr.render(xmlStream, model.properties);
      this.map.bookViews.render(xmlStream, model.views);
      this.map.sheets.render(xmlStream, model.sheets);
      this.map.definedNames.render(xmlStream, model.definedNames);
      this.map.calcPr.render(xmlStream, model.calcProperties);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'workbook':
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'workbook':
          this.model = {
            sheets: this.map.sheets.model,
            properties: this.map.workbookPr.model || {},
            views: this.map.bookViews.model,
            calcProperties: {}
          };

          if (this.map.definedNames.model) {
            this.model.definedNames = this.map.definedNames.model;
          }

          return false;

        default:
          // not quite sure how we get here!
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model) {
      var rels = (model.workbookRels || []).reduce(function (map, rel) {
        map[rel.Id] = rel;
        return map;
      }, {}); // reconcile sheet ids, rIds and names

      var worksheets = [];
      var worksheet;
      var index = 0;
      (model.sheets || []).forEach(function (sheet) {
        var rel = rels[sheet.rId];

        if (!rel) {
          return;
        } // if rel.Target start with `[space]/xl/` or `/xl/` , then it will be replaced with `''` and spliced behind `xl/`,
        // otherwise it will be spliced directly behind `xl/`. i.g.


        worksheet = model.worksheetHash["xl/".concat(rel.Target.replace(/^(\s|\/xl\/)+/, ''))]; // If there are "chartsheets" in the file, rel.Target will
        // come out as chartsheets/sheet1.xml or similar here, and
        // that won't be in model.worksheetHash.
        // As we don't have the infrastructure to support chartsheets,
        // we will ignore them for now:

        if (worksheet) {
          worksheet.name = sheet.name;
          worksheet.id = sheet.id;
          worksheet.state = sheet.state;
          worksheets[index++] = worksheet;
        }
      }); // reconcile print areas

      var definedNames = [];

      _.each(model.definedNames, function (definedName) {
        if (definedName.name === '_xlnm.Print_Area') {
          worksheet = worksheets[definedName.localSheetId];

          if (worksheet) {
            if (!worksheet.pageSetup) {
              worksheet.pageSetup = {};
            }

            var range = colCache.decodeEx(definedName.ranges[0]);
            worksheet.pageSetup.printArea = worksheet.pageSetup.printArea ? "".concat(worksheet.pageSetup.printArea, "&&").concat(range.dimensions) : range.dimensions;
          }
        } else if (definedName.name === '_xlnm.Print_Titles') {
          worksheet = worksheets[definedName.localSheetId];

          if (worksheet) {
            if (!worksheet.pageSetup) {
              worksheet.pageSetup = {};
            }

            var rangeString = definedName.ranges.join(',');
            var dollarRegex = /\$/g;
            var rowRangeRegex = /\$\d+:\$\d+/;
            var rowRangeMatches = rangeString.match(rowRangeRegex);

            if (rowRangeMatches && rowRangeMatches.length) {
              var _range = rowRangeMatches[0];
              worksheet.pageSetup.printTitlesRow = _range.replace(dollarRegex, '');
            }

            var columnRangeRegex = /\$[A-Z]+:\$[A-Z]+/;
            var columnRangeMatches = rangeString.match(columnRangeRegex);

            if (columnRangeMatches && columnRangeMatches.length) {
              var _range2 = columnRangeMatches[0];
              worksheet.pageSetup.printTitlesColumn = _range2.replace(dollarRegex, '');
            }
          }
        } else {
          definedNames.push(definedName);
        }
      });

      model.definedNames = definedNames; // used by sheets to build their image models

      model.media.forEach(function (media, i) {
        media.index = i;
      });
    }
  }]);

  return WorkbookXform;
}(BaseXform);

WorkbookXform.WORKBOOK_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
  'xmlns:r': 'http://schemas.openxmlformats.org/officeDocument/2006/relationships',
  'xmlns:mc': 'http://schemas.openxmlformats.org/markup-compatibility/2006',
  'mc:Ignorable': 'x15',
  'xmlns:x15': 'http://schemas.microsoft.com/office/spreadsheetml/2010/11/main'
};
WorkbookXform.STATIC_XFORMS = {
  fileVersion: new StaticXform({
    tag: 'fileVersion',
    $: {
      appName: 'xl',
      lastEdited: 5,
      lowestEdited: 5,
      rupBuild: 9303
    }
  })
};
module.exports = WorkbookXform;

},{"../../../utils/col-cache":19,"../../../utils/under-dash":25,"../../../utils/xml-stream":27,"../base-xform":31,"../list-xform":70,"../static-xform":119,"./defined-name-xform":32,"./sheet-xform":33,"./workbook-calc-properties-xform":34,"./workbook-properties-xform":35,"./workbook-view-xform":36}],38:[function(require,module,exports){
"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var RichTextXform = require('../strings/rich-text-xform');

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');
/**
  <comment ref="B1" authorId="0">
    <text>
      <r>
        <rPr>
          <b/>
          <sz val="9"/>
          <rFont val="宋体"/>
          <charset val="134"/>
        </rPr>
        <t>51422:</t>
      </r>
      <r>
        <rPr>
          <sz val="9"/>
          <rFont val="宋体"/>
          <charset val="134"/>
        </rPr>
        <t xml:space="preserve">&#10;test</t>
      </r>
    </text>
  </comment>
 */


var CommentXform = module.exports = function (model) {
  this.model = model;
};

utils.inherits(CommentXform, BaseXform, {
  get tag() {
    return 'r';
  },

  get richTextXform() {
    if (!this._richTextXform) {
      this._richTextXform = new RichTextXform();
    }

    return this._richTextXform;
  },

  render: function render(xmlStream, model) {
    var _this = this;

    model = model || this.model;
    xmlStream.openNode('comment', {
      ref: model.ref,
      authorId: 0
    });
    xmlStream.openNode('text');

    if (model && model.note && model.note.texts) {
      model.note.texts.forEach(function (text) {
        _this.richTextXform.render(xmlStream, text);
      });
    }

    xmlStream.closeNode();
    xmlStream.closeNode();
  },
  parseOpen: function parseOpen(node) {
    if (this.parser) {
      this.parser.parseOpen(node);
      return true;
    }

    switch (node.name) {
      case 'comment':
        this.model = _objectSpread({
          type: 'note',
          note: {
            texts: []
          }
        }, node.attributes);
        return true;

      case 'r':
        this.parser = this.richTextXform;
        this.parser.parseOpen(node);
        return true;

      default:
        return false;
    }
  },
  parseText: function parseText(text) {
    if (this.parser) {
      this.parser.parseText(text);
    }
  },
  parseClose: function parseClose(name) {
    switch (name) {
      case 'comment':
        return false;

      case 'r':
        this.model.note.texts.push(this.parser.model);
        this.parser = undefined;
        return true;

      default:
        if (this.parser) {
          this.parser.parseClose(name);
        }

        return true;
    }
  }
});

},{"../../../utils/utils":26,"../base-xform":31,"../strings/rich-text-xform":121}],39:[function(require,module,exports){
"use strict";

var XmlStream = require('../../../utils/xml-stream');

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var CommentXform = require('./comment-xform');

var CommentsXform = module.exports = function () {
  this.map = {
    comment: new CommentXform()
  };
};

utils.inherits(CommentsXform, BaseXform, {
  COMMENTS_ATTRIBUTES: {
    xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main'
  }
}, {
  render: function render(xmlStream, model) {
    var _this = this;

    model = model || this.model;
    xmlStream.openXml(XmlStream.StdDocAttributes);
    xmlStream.openNode('comments', CommentsXform.COMMENTS_ATTRIBUTES); // authors
    // TODO: support authors properly

    xmlStream.openNode('authors');
    xmlStream.leafNode('author', null, 'Author');
    xmlStream.closeNode(); // comments

    xmlStream.openNode('commentList');
    model.comments.forEach(function (comment) {
      _this.map.comment.render(xmlStream, comment);
    });
    xmlStream.closeNode();
    xmlStream.closeNode();
  },
  parseOpen: function parseOpen(node) {
    if (this.parser) {
      this.parser.parseOpen(node);
      return true;
    }

    switch (node.name) {
      case 'commentList':
        this.model = {
          comments: []
        };
        return true;

      case 'comment':
        this.parser = this.map.comment;
        this.parser.parseOpen(node);
        return true;

      default:
        return false;
    }
  },
  parseText: function parseText(text) {
    if (this.parser) {
      this.parser.parseText(text);
    }
  },
  parseClose: function parseClose(name) {
    switch (name) {
      case 'commentList':
        return false;

      case 'comment':
        this.model.comments.push(this.parser.model);
        this.parser = undefined;
        return true;

      default:
        if (this.parser) {
          this.parser.parseClose(name);
        }

        return true;
    }
  }
});

},{"../../../utils/utils":26,"../../../utils/xml-stream":27,"../base-xform":31,"./comment-xform":38}],40:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var VmlPositionXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(VmlPositionXform, _BaseXform);

  var _super = _createSuper(VmlPositionXform);

  function VmlPositionXform(model) {
    var _this;

    _classCallCheck(this, VmlPositionXform);

    _this = _super.call(this);
    _this._model = model;
    return _this;
  }

  _createClass(VmlPositionXform, [{
    key: "render",
    value: function render(xmlStream, model, type) {
      if (model === type[2]) {
        xmlStream.leafNode(this.tag);
      } else if (this.tag === 'x:SizeWithCells' && model === type[1]) {
        xmlStream.leafNode(this.tag);
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {};
          this.model[this.tag] = true;
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return this._model && this._model.tag;
    }
  }]);

  return VmlPositionXform;
}(BaseXform);

module.exports = VmlPositionXform;

},{"../../base-xform":31}],41:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var VmlProtectionXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(VmlProtectionXform, _BaseXform);

  var _super = _createSuper(VmlProtectionXform);

  function VmlProtectionXform(model) {
    var _this;

    _classCallCheck(this, VmlProtectionXform);

    _this = _super.call(this);
    _this._model = model;
    return _this;
  }

  _createClass(VmlProtectionXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, null, model);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.text = '';
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this.text = text;
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return this._model && this._model.tag;
    }
  }]);

  return VmlProtectionXform;
}(BaseXform);

module.exports = VmlProtectionXform;

},{"../../base-xform":31}],42:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform'); // render the triangle in the cell for the comment


var VmlAnchorXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(VmlAnchorXform, _BaseXform);

  var _super = _createSuper(VmlAnchorXform);

  function VmlAnchorXform() {
    _classCallCheck(this, VmlAnchorXform);

    return _super.apply(this, arguments);
  }

  _createClass(VmlAnchorXform, [{
    key: "getAnchorRect",
    value: function getAnchorRect(anchor) {
      var l = Math.floor(anchor.left);
      var lf = Math.floor((anchor.left - l) * 68);
      var t = Math.floor(anchor.top);
      var tf = Math.floor((anchor.top - t) * 18);
      var r = Math.floor(anchor.right);
      var rf = Math.floor((anchor.right - r) * 68);
      var b = Math.floor(anchor.bottom);
      var bf = Math.floor((anchor.bottom - b) * 18);
      return [l, lf, t, tf, r, rf, b, bf];
    }
  }, {
    key: "getDefaultRect",
    value: function getDefaultRect(ref) {
      var l = ref.col;
      var lf = 6;
      var t = Math.max(ref.row - 2, 0);
      var tf = 14;
      var r = l + 2;
      var rf = 2;
      var b = t + 4;
      var bf = 16;
      return [l, lf, t, tf, r, rf, b, bf];
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var rect = model.anchor ? this.getAnchorRect(model.anchor) : this.getDefaultRect(model.refAddress);
      xmlStream.leafNode('x:Anchor', null, rect.join(', '));
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.text = '';
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this.text = text;
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x:Anchor';
    }
  }]);

  return VmlAnchorXform;
}(BaseXform);

module.exports = VmlAnchorXform;

},{"../base-xform":31}],43:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var VmlAnchorXform = require('./vml-anchor-xform');

var VmlProtectionXform = require('./style/vml-protection-xform');

var VmlPositionXform = require('./style/vml-position-xform');

var POSITION_TYPE = ['twoCells', 'oneCells', 'absolute'];

var VmlClientDataXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(VmlClientDataXform, _BaseXform);

  var _super = _createSuper(VmlClientDataXform);

  function VmlClientDataXform() {
    var _this;

    _classCallCheck(this, VmlClientDataXform);

    _this = _super.call(this);
    _this.map = {
      'x:Anchor': new VmlAnchorXform(),
      'x:Locked': new VmlProtectionXform({
        tag: 'x:Locked'
      }),
      'x:LockText': new VmlProtectionXform({
        tag: 'x:LockText'
      }),
      'x:SizeWithCells': new VmlPositionXform({
        tag: 'x:SizeWithCells'
      }),
      'x:MoveWithCells': new VmlPositionXform({
        tag: 'x:MoveWithCells'
      })
    };
    return _this;
  }

  _createClass(VmlClientDataXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _model$note = model.note,
          protection = _model$note.protection,
          editAs = _model$note.editAs;
      xmlStream.openNode(this.tag, {
        ObjectType: 'Note'
      });
      this.map['x:MoveWithCells'].render(xmlStream, editAs, POSITION_TYPE);
      this.map['x:SizeWithCells'].render(xmlStream, editAs, POSITION_TYPE);
      this.map['x:Anchor'].render(xmlStream, model);
      this.map['x:Locked'].render(xmlStream, protection.locked);
      xmlStream.leafNode('x:AutoFill', null, 'False');
      this.map['x:LockText'].render(xmlStream, protection.lockText);
      xmlStream.leafNode('x:Row', null, model.refAddress.row - 1);
      xmlStream.leafNode('x:Column', null, model.refAddress.col - 1);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.reset();
          this.model = {
            anchor: [],
            protection: {},
            editAs: ''
          };
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.normalizeModel();
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "normalizeModel",
    value: function normalizeModel() {
      var position = Object.assign({}, this.map['x:MoveWithCells'].model, this.map['x:SizeWithCells'].model);
      var len = Object.keys(position).length;
      this.model.editAs = POSITION_TYPE[len];
      this.model.anchor = this.map['x:Anchor'].text;
      this.model.protection.locked = this.map['x:Locked'].text;
      this.model.protection.lockText = this.map['x:LockText'].text;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x:ClientData';
    }
  }]);

  return VmlClientDataXform;
}(BaseXform);

module.exports = VmlClientDataXform;

},{"../base-xform":31,"./style/vml-position-xform":40,"./style/vml-protection-xform":41,"./vml-anchor-xform":42}],44:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var VmlShapeXform = require('./vml-shape-xform'); // This class is (currently) single purposed to insert the triangle
// drawing icons on commented cells


var VmlNotesXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(VmlNotesXform, _BaseXform);

  var _super = _createSuper(VmlNotesXform);

  function VmlNotesXform() {
    var _this;

    _classCallCheck(this, VmlNotesXform);

    _this = _super.call(this);
    _this.map = {
      'v:shape': new VmlShapeXform()
    };
    return _this;
  }

  _createClass(VmlNotesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode(this.tag, VmlNotesXform.DRAWING_ATTRIBUTES);
      xmlStream.openNode('o:shapelayout', {
        'v:ext': 'edit'
      });
      xmlStream.leafNode('o:idmap', {
        'v:ext': 'edit',
        data: 1
      });
      xmlStream.closeNode();
      xmlStream.openNode('v:shapetype', {
        id: '_x0000_t202',
        coordsize: '21600,21600',
        'o:spt': 202,
        path: 'm,l,21600r21600,l21600,xe'
      });
      xmlStream.leafNode('v:stroke', {
        joinstyle: 'miter'
      });
      xmlStream.leafNode('v:path', {
        gradientshapeok: 't',
        'o:connecttype': 'rect'
      });
      xmlStream.closeNode();
      model.comments.forEach(function (item, index) {
        _this2.map['v:shape'].render(xmlStream, item, index);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          this.model = {
            comments: []
          };
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.comments.push(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          // could be some unrecognised tags
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      var _this3 = this;

      model.anchors.forEach(function (anchor) {
        if (anchor.br) {
          _this3.map['xdr:twoCellAnchor'].reconcile(anchor, options);
        } else {
          _this3.map['xdr:oneCellAnchor'].reconcile(anchor, options);
        }
      });
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xml';
    }
  }]);

  return VmlNotesXform;
}(BaseXform);

VmlNotesXform.DRAWING_ATTRIBUTES = {
  'xmlns:v': 'urn:schemas-microsoft-com:vml',
  'xmlns:o': 'urn:schemas-microsoft-com:office:office',
  'xmlns:x': 'urn:schemas-microsoft-com:office:excel'
};
module.exports = VmlNotesXform;

},{"../../../utils/xml-stream":27,"../base-xform":31,"./vml-shape-xform":45}],45:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var VmlTextboxXform = require('./vml-textbox-xform');

var VmlClientDataXform = require('./vml-client-data-xform');

var VmlShapeXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(VmlShapeXform, _BaseXform);

  var _super = _createSuper(VmlShapeXform);

  function VmlShapeXform() {
    var _this;

    _classCallCheck(this, VmlShapeXform);

    _this = _super.call(this);
    _this.map = {
      'v:textbox': new VmlTextboxXform(),
      'x:ClientData': new VmlClientDataXform()
    };
    return _this;
  }

  _createClass(VmlShapeXform, [{
    key: "render",
    value: function render(xmlStream, model, index) {
      xmlStream.openNode('v:shape', VmlShapeXform.V_SHAPE_ATTRIBUTES(model, index));
      xmlStream.leafNode('v:fill', {
        color2: 'infoBackground [80]'
      });
      xmlStream.leafNode('v:shadow', {
        color: 'none [81]',
        obscured: 't'
      });
      xmlStream.leafNode('v:path', {
        'o:connecttype': 'none'
      });
      this.map['v:textbox'].render(xmlStream, model);
      this.map['x:ClientData'].render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          this.model = {
            margins: {
              insetmode: node.attributes['o:insetmode']
            },
            anchor: '',
            editAs: '',
            protection: {}
          };
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model.margins.inset = this.map['v:textbox'].model && this.map['v:textbox'].model.inset;
          this.model.protection = this.map['x:ClientData'].model && this.map['x:ClientData'].model.protection;
          this.model.anchor = this.map['x:ClientData'].model && this.map['x:ClientData'].model.anchor;
          this.model.editAs = this.map['x:ClientData'].model && this.map['x:ClientData'].model.editAs;
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'v:shape';
    }
  }]);

  return VmlShapeXform;
}(BaseXform);

VmlShapeXform.V_SHAPE_ATTRIBUTES = function (model, index) {
  return {
    id: "_x0000_s".concat(1025 + index),
    type: '#_x0000_t202',
    style: 'position:absolute; margin-left:105.3pt;margin-top:10.5pt;width:97.8pt;height:59.1pt;z-index:1;visibility:hidden',
    fillcolor: 'infoBackground [80]',
    strokecolor: 'none [81]',
    'o:insetmode': model.note.margins && model.note.margins.insetmode
  };
};

module.exports = VmlShapeXform;

},{"../base-xform":31,"./vml-client-data-xform":43,"./vml-textbox-xform":46}],46:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var VmlTextboxXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(VmlTextboxXform, _BaseXform);

  var _super = _createSuper(VmlTextboxXform);

  function VmlTextboxXform() {
    _classCallCheck(this, VmlTextboxXform);

    return _super.apply(this, arguments);
  }

  _createClass(VmlTextboxXform, [{
    key: "conversionUnit",
    value: function conversionUnit(value, multiple, unit) {
      return "".concat(parseFloat(value) * multiple.toFixed(2)).concat(unit);
    }
  }, {
    key: "reverseConversionUnit",
    value: function reverseConversionUnit(inset) {
      var _this = this;

      return (inset || '').split(',').map(function (margin) {
        return Number(parseFloat(_this.conversionUnit(parseFloat(margin), 0.1, '')).toFixed(2));
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      var attributes = {
        style: 'mso-direction-alt:auto'
      };

      if (model && model.note) {
        var _ref = model.note && model.note.margins,
            inset = _ref.inset;

        if (Array.isArray(inset)) {
          inset = inset.map(function (margin) {
            return _this2.conversionUnit(margin, 10, 'mm');
          }).join(',');
        }

        if (inset) {
          attributes.inset = inset;
        }
      }

      xmlStream.openNode('v:textbox', attributes);
      xmlStream.leafNode('div', {
        style: 'text-align:left'
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            inset: this.reverseConversionUnit(node.attributes.inset)
          };
          return true;

        default:
          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case this.tag:
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'v:textbox';
    }
  }]);

  return VmlTextboxXform;
}(BaseXform);

module.exports = VmlTextboxXform;

},{"../base-xform":31}],47:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('./base-xform');
/* 'virtual' methods used as a form of documentation */

/* eslint-disable class-methods-use-this */
// base class for xforms that are composed of other xforms
// offers some default implementations


var CompositeXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(CompositeXform, _BaseXform);

  var _super = _createSuper(CompositeXform);

  function CompositeXform() {
    _classCallCheck(this, CompositeXform);

    return _super.apply(this, arguments);
  }

  _createClass(CompositeXform, [{
    key: "createNewModel",
    value: function createNewModel(node) {
      return {};
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      // Typical pattern for composite xform
      this.parser = this.parser || this.map[node.name];

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (node.name === this.tag) {
        this.model = this.createNewModel(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      // Default implementation. Send text to child parser
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      // parseClose has seen a child parser close
      // now need to incorporate into this.model somehow
      this.model[name] = parser.model;
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      // Default implementation
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.onParserClose(name, this.parser);
          this.parser = undefined;
        }

        return true;
      }

      return name !== this.tag;
    }
  }]);

  return CompositeXform;
}(BaseXform);

module.exports = CompositeXform;

},{"./base-xform":31}],48:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var AppHeadingPairsXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(AppHeadingPairsXform, _BaseXform);

  var _super = _createSuper(AppHeadingPairsXform);

  function AppHeadingPairsXform() {
    _classCallCheck(this, AppHeadingPairsXform);

    return _super.apply(this, arguments);
  }

  _createClass(AppHeadingPairsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('HeadingPairs');
      xmlStream.openNode('vt:vector', {
        size: 2,
        baseType: 'variant'
      });
      xmlStream.openNode('vt:variant');
      xmlStream.leafNode('vt:lpstr', undefined, 'Worksheets');
      xmlStream.closeNode();
      xmlStream.openNode('vt:variant');
      xmlStream.leafNode('vt:i4', undefined, model.length);
      xmlStream.closeNode();
      xmlStream.closeNode();
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      // no parsing
      return node.name === 'HeadingPairs';
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      return name !== 'HeadingPairs';
    }
  }]);

  return AppHeadingPairsXform;
}(BaseXform);

module.exports = AppHeadingPairsXform;

},{"../base-xform":31}],49:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var AppTitlesOfPartsXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(AppTitlesOfPartsXform, _BaseXform);

  var _super = _createSuper(AppTitlesOfPartsXform);

  function AppTitlesOfPartsXform() {
    _classCallCheck(this, AppTitlesOfPartsXform);

    return _super.apply(this, arguments);
  }

  _createClass(AppTitlesOfPartsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('TitlesOfParts');
      xmlStream.openNode('vt:vector', {
        size: model.length,
        baseType: 'lpstr'
      });
      model.forEach(function (sheet) {
        xmlStream.leafNode('vt:lpstr', undefined, sheet.name);
      });
      xmlStream.closeNode();
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      // no parsing
      return node.name === 'TitlesOfParts';
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      return name !== 'TitlesOfParts';
    }
  }]);

  return AppTitlesOfPartsXform;
}(BaseXform);

module.exports = AppTitlesOfPartsXform;

},{"../base-xform":31}],50:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var StringXform = require('../simple/string-xform');

var AppHeadingPairsXform = require('./app-heading-pairs-xform');

var AppTitleOfPartsXform = require('./app-titles-of-parts-xform');

var AppXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(AppXform, _BaseXform);

  var _super = _createSuper(AppXform);

  function AppXform() {
    var _this;

    _classCallCheck(this, AppXform);

    _this = _super.call(this);
    _this.map = {
      Company: new StringXform({
        tag: 'Company'
      }),
      Manager: new StringXform({
        tag: 'Manager'
      }),
      HeadingPairs: new AppHeadingPairsXform(),
      TitleOfParts: new AppTitleOfPartsXform()
    };
    return _this;
  }

  _createClass(AppXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('Properties', AppXform.PROPERTY_ATTRIBUTES);
      xmlStream.leafNode('Application', undefined, 'Microsoft Excel');
      xmlStream.leafNode('DocSecurity', undefined, '0');
      xmlStream.leafNode('ScaleCrop', undefined, 'false');
      this.map.HeadingPairs.render(xmlStream, model.worksheets);
      this.map.TitleOfParts.render(xmlStream, model.worksheets);
      this.map.Company.render(xmlStream, model.company || '');
      this.map.Manager.render(xmlStream, model.manager);
      xmlStream.leafNode('LinksUpToDate', undefined, 'false');
      xmlStream.leafNode('SharedDoc', undefined, 'false');
      xmlStream.leafNode('HyperlinksChanged', undefined, 'false');
      xmlStream.leafNode('AppVersion', undefined, '16.0300');
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'Properties':
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          } // there's a lot we don't bother to parse


          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'Properties':
          this.model = {
            worksheets: this.map.TitleOfParts.model,
            company: this.map.Company.model,
            manager: this.map.Manager.model
          };
          return false;

        default:
          return true;
      }
    }
  }]);

  return AppXform;
}(BaseXform);

AppXform.DateFormat = function (dt) {
  return dt.toISOString().replace(/[.]\d{3,6}/, '');
};

AppXform.DateAttrs = {
  'xsi:type': 'dcterms:W3CDTF'
};
AppXform.PROPERTY_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/officeDocument/2006/extended-properties',
  'xmlns:vt': 'http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes'
};
module.exports = AppXform;

},{"../../../utils/xml-stream":27,"../base-xform":31,"../simple/string-xform":118,"./app-heading-pairs-xform":48,"./app-titles-of-parts-xform":49}],51:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform'); // used for rendering the [Content_Types].xml file
// not used for parsing


var ContentTypesXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(ContentTypesXform, _BaseXform);

  var _super = _createSuper(ContentTypesXform);

  function ContentTypesXform() {
    _classCallCheck(this, ContentTypesXform);

    return _super.apply(this, arguments);
  }

  _createClass(ContentTypesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('Types', ContentTypesXform.PROPERTY_ATTRIBUTES);
      var mediaHash = {};
      (model.media || []).forEach(function (medium) {
        if (medium.type === 'image') {
          var imageType = medium.extension;

          if (!mediaHash[imageType]) {
            mediaHash[imageType] = true;
            xmlStream.leafNode('Default', {
              Extension: imageType,
              ContentType: "image/".concat(imageType)
            });
          }
        }
      });
      xmlStream.leafNode('Default', {
        Extension: 'rels',
        ContentType: 'application/vnd.openxmlformats-package.relationships+xml'
      });
      xmlStream.leafNode('Default', {
        Extension: 'xml',
        ContentType: 'application/xml'
      });
      xmlStream.leafNode('Override', {
        PartName: '/xl/workbook.xml',
        ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml'
      });
      model.worksheets.forEach(function (worksheet) {
        var name = "/xl/worksheets/sheet".concat(worksheet.id, ".xml");
        xmlStream.leafNode('Override', {
          PartName: name,
          ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml'
        });
      });
      xmlStream.leafNode('Override', {
        PartName: '/xl/theme/theme1.xml',
        ContentType: 'application/vnd.openxmlformats-officedocument.theme+xml'
      });
      xmlStream.leafNode('Override', {
        PartName: '/xl/styles.xml',
        ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml'
      });
      var hasSharedStrings = model.sharedStrings && model.sharedStrings.count;

      if (hasSharedStrings) {
        xmlStream.leafNode('Override', {
          PartName: '/xl/sharedStrings.xml',
          ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml'
        });
      }

      if (model.tables) {
        model.tables.forEach(function (table) {
          xmlStream.leafNode('Override', {
            PartName: "/xl/tables/".concat(table.target),
            ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml'
          });
        });
      }

      if (model.drawings) {
        model.drawings.forEach(function (drawing) {
          xmlStream.leafNode('Override', {
            PartName: "/xl/drawings/".concat(drawing.name, ".xml"),
            ContentType: 'application/vnd.openxmlformats-officedocument.drawing+xml'
          });
        });
      }

      if (model.commentRefs) {
        xmlStream.leafNode('Default', {
          Extension: 'vml',
          ContentType: 'application/vnd.openxmlformats-officedocument.vmlDrawing'
        });
        model.commentRefs.forEach(function (_ref) {
          var commentName = _ref.commentName;
          xmlStream.leafNode('Override', {
            PartName: "/xl/".concat(commentName, ".xml"),
            ContentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml'
          });
        });
      }

      xmlStream.leafNode('Override', {
        PartName: '/docProps/core.xml',
        ContentType: 'application/vnd.openxmlformats-package.core-properties+xml'
      });
      xmlStream.leafNode('Override', {
        PartName: '/docProps/app.xml',
        ContentType: 'application/vnd.openxmlformats-officedocument.extended-properties+xml'
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen() {
      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return ContentTypesXform;
}(BaseXform);

ContentTypesXform.PROPERTY_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/package/2006/content-types'
};
module.exports = ContentTypesXform;

},{"../../../utils/xml-stream":27,"../base-xform":31}],52:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var DateXform = require('../simple/date-xform');

var StringXform = require('../simple/string-xform');

var IntegerXform = require('../simple/integer-xform');

var CoreXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(CoreXform, _BaseXform);

  var _super = _createSuper(CoreXform);

  function CoreXform() {
    var _this;

    _classCallCheck(this, CoreXform);

    _this = _super.call(this);
    _this.map = {
      'dc:creator': new StringXform({
        tag: 'dc:creator'
      }),
      'dc:title': new StringXform({
        tag: 'dc:title'
      }),
      'dc:subject': new StringXform({
        tag: 'dc:subject'
      }),
      'dc:description': new StringXform({
        tag: 'dc:description'
      }),
      'dc:identifier': new StringXform({
        tag: 'dc:identifier'
      }),
      'dc:language': new StringXform({
        tag: 'dc:language'
      }),
      'cp:keywords': new StringXform({
        tag: 'cp:keywords'
      }),
      'cp:category': new StringXform({
        tag: 'cp:category'
      }),
      'cp:lastModifiedBy': new StringXform({
        tag: 'cp:lastModifiedBy'
      }),
      'cp:lastPrinted': new DateXform({
        tag: 'cp:lastPrinted',
        format: CoreXform.DateFormat
      }),
      'cp:revision': new IntegerXform({
        tag: 'cp:revision'
      }),
      'cp:version': new StringXform({
        tag: 'cp:version'
      }),
      'cp:contentStatus': new StringXform({
        tag: 'cp:contentStatus'
      }),
      'cp:contentType': new StringXform({
        tag: 'cp:contentType'
      }),
      'dcterms:created': new DateXform({
        tag: 'dcterms:created',
        attrs: CoreXform.DateAttrs,
        format: CoreXform.DateFormat
      }),
      'dcterms:modified': new DateXform({
        tag: 'dcterms:modified',
        attrs: CoreXform.DateAttrs,
        format: CoreXform.DateFormat
      })
    };
    return _this;
  }

  _createClass(CoreXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('cp:coreProperties', CoreXform.CORE_PROPERTY_ATTRIBUTES);
      this.map['dc:creator'].render(xmlStream, model.creator);
      this.map['dc:title'].render(xmlStream, model.title);
      this.map['dc:subject'].render(xmlStream, model.subject);
      this.map['dc:description'].render(xmlStream, model.description);
      this.map['dc:identifier'].render(xmlStream, model.identifier);
      this.map['dc:language'].render(xmlStream, model.language);
      this.map['cp:keywords'].render(xmlStream, model.keywords);
      this.map['cp:category'].render(xmlStream, model.category);
      this.map['cp:lastModifiedBy'].render(xmlStream, model.lastModifiedBy);
      this.map['cp:lastPrinted'].render(xmlStream, model.lastPrinted);
      this.map['cp:revision'].render(xmlStream, model.revision);
      this.map['cp:version'].render(xmlStream, model.version);
      this.map['cp:contentStatus'].render(xmlStream, model.contentStatus);
      this.map['cp:contentType'].render(xmlStream, model.contentType);
      this.map['dcterms:created'].render(xmlStream, model.created);
      this.map['dcterms:modified'].render(xmlStream, model.modified);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'cp:coreProperties':
        case 'coreProperties':
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          }

          throw new Error("Unexpected xml node in parseOpen: ".concat(JSON.stringify(node)));
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'cp:coreProperties':
        case 'coreProperties':
          this.model = {
            creator: this.map['dc:creator'].model,
            title: this.map['dc:title'].model,
            subject: this.map['dc:subject'].model,
            description: this.map['dc:description'].model,
            identifier: this.map['dc:identifier'].model,
            language: this.map['dc:language'].model,
            keywords: this.map['cp:keywords'].model,
            category: this.map['cp:category'].model,
            lastModifiedBy: this.map['cp:lastModifiedBy'].model,
            lastPrinted: this.map['cp:lastPrinted'].model,
            revision: this.map['cp:revision'].model,
            contentStatus: this.map['cp:contentStatus'].model,
            contentType: this.map['cp:contentType'].model,
            created: this.map['dcterms:created'].model,
            modified: this.map['dcterms:modified'].model
          };
          return false;

        default:
          throw new Error("Unexpected xml node in parseClose: ".concat(name));
      }
    }
  }]);

  return CoreXform;
}(BaseXform);

CoreXform.DateFormat = function (dt) {
  return dt.toISOString().replace(/[.]\d{3}/, '');
};

CoreXform.DateAttrs = {
  'xsi:type': 'dcterms:W3CDTF'
};
CoreXform.CORE_PROPERTY_ATTRIBUTES = {
  'xmlns:cp': 'http://schemas.openxmlformats.org/package/2006/metadata/core-properties',
  'xmlns:dc': 'http://purl.org/dc/elements/1.1/',
  'xmlns:dcterms': 'http://purl.org/dc/terms/',
  'xmlns:dcmitype': 'http://purl.org/dc/dcmitype/',
  'xmlns:xsi': 'http://www.w3.org/2001/XMLSchema-instance'
};
module.exports = CoreXform;

},{"../../../utils/xml-stream":27,"../base-xform":31,"../simple/date-xform":116,"../simple/integer-xform":117,"../simple/string-xform":118}],53:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var RelationshipXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(RelationshipXform, _BaseXform);

  var _super = _createSuper(RelationshipXform);

  function RelationshipXform() {
    _classCallCheck(this, RelationshipXform);

    return _super.apply(this, arguments);
  }

  _createClass(RelationshipXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('Relationship', model);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'Relationship':
          this.model = node.attributes;
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return RelationshipXform;
}(BaseXform);

module.exports = RelationshipXform;

},{"../base-xform":31}],54:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var RelationshipXform = require('./relationship-xform');

var RelationshipsXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(RelationshipsXform, _BaseXform);

  var _super = _createSuper(RelationshipsXform);

  function RelationshipsXform() {
    var _this;

    _classCallCheck(this, RelationshipsXform);

    _this = _super.call(this);
    _this.map = {
      Relationship: new RelationshipXform()
    };
    return _this;
  }

  _createClass(RelationshipsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      model = model || this._values;
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('Relationships', RelationshipsXform.RELATIONSHIPS_ATTRIBUTES);
      model.forEach(function (relationship) {
        _this2.map.Relationship.render(xmlStream, relationship);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'Relationships':
          this.model = [];
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          }

          throw new Error("Unexpected xml node in parseOpen: ".concat(JSON.stringify(node)));
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.push(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'Relationships':
          return false;

        default:
          throw new Error("Unexpected xml node in parseClose: ".concat(name));
      }
    }
  }]);

  return RelationshipsXform;
}(BaseXform);

RelationshipsXform.RELATIONSHIPS_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/package/2006/relationships'
};
module.exports = RelationshipsXform;

},{"../../../utils/xml-stream":27,"../base-xform":31,"./relationship-xform":53}],55:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var BaseCellAnchorXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(BaseCellAnchorXform, _BaseXform);

  var _super = _createSuper(BaseCellAnchorXform);

  function BaseCellAnchorXform() {
    _classCallCheck(this, BaseCellAnchorXform);

    return _super.apply(this, arguments);
  }

  _createClass(BaseCellAnchorXform, [{
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          this.model = {
            range: {
              editAs: node.attributes.editAs || 'oneCell'
            }
          };
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "reconcilePicture",
    value: function reconcilePicture(model, options) {
      if (model && model.rId) {
        var rel = options.rels[model.rId];
        var match = rel.Target.match(/.*\/media\/(.+[.][a-zA-Z]{3,4})/);

        if (match) {
          var name = match[1];
          var mediaId = options.mediaIndex[name];
          return options.media[mediaId];
        }
      }

      return undefined;
    }
  }]);

  return BaseCellAnchorXform;
}(BaseXform);

module.exports = BaseCellAnchorXform;

},{"../base-xform":31}],56:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var BlipXform = require('./blip-xform');

var BlipFillXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(BlipFillXform, _BaseXform);

  var _super = _createSuper(BlipFillXform);

  function BlipFillXform() {
    var _this;

    _classCallCheck(this, BlipFillXform);

    _this = _super.call(this);
    _this.map = {
      'a:blip': new BlipXform()
    };
    return _this;
  }

  _createClass(BlipFillXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);
      this.map['a:blip'].render(xmlStream, model); // TODO: options for this + parsing

      xmlStream.openNode('a:stretch');
      xmlStream.leafNode('a:fillRect');
      xmlStream.closeNode();
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model = this.map['a:blip'].model;
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:blipFill';
    }
  }]);

  return BlipFillXform;
}(BaseXform);

module.exports = BlipFillXform;

},{"../base-xform":31,"./blip-xform":57}],57:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var BlipXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(BlipXform, _BaseXform);

  var _super = _createSuper(BlipXform);

  function BlipXform() {
    _classCallCheck(this, BlipXform);

    return _super.apply(this, arguments);
  }

  _createClass(BlipXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        'xmlns:r': 'http://schemas.openxmlformats.org/officeDocument/2006/relationships',
        'r:embed': model.rId,
        cstate: 'print'
      }); // TODO: handle children (e.g. a:extLst=>a:ext=>a14:useLocalDpi
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            rId: node.attributes['r:embed']
          };
          return true;

        default:
          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case this.tag:
          return false;

        default:
          // unprocessed internal nodes
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'a:blip';
    }
  }]);

  return BlipXform;
}(BaseXform);

module.exports = BlipXform;

},{"../base-xform":31}],58:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var CNvPicPrXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(CNvPicPrXform, _BaseXform);

  var _super = _createSuper(CNvPicPrXform);

  function CNvPicPrXform() {
    _classCallCheck(this, CNvPicPrXform);

    return _super.apply(this, arguments);
  }

  _createClass(CNvPicPrXform, [{
    key: "render",
    value: function render(xmlStream) {
      xmlStream.openNode(this.tag);
      xmlStream.leafNode('a:picLocks', {
        noChangeAspect: '1'
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          return true;

        default:
          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case this.tag:
          return false;

        default:
          // unprocessed internal nodes
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:cNvPicPr';
    }
  }]);

  return CNvPicPrXform;
}(BaseXform);

module.exports = CNvPicPrXform;

},{"../base-xform":31}],59:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var HlickClickXform = require('./hlink-click-xform');

var ExtLstXform = require('./ext-lst-xform');

var CNvPrXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(CNvPrXform, _BaseXform);

  var _super = _createSuper(CNvPrXform);

  function CNvPrXform() {
    var _this;

    _classCallCheck(this, CNvPrXform);

    _this = _super.call(this);
    _this.map = {
      'a:hlinkClick': new HlickClickXform(),
      'a:extLst': new ExtLstXform()
    };
    return _this;
  }

  _createClass(CNvPrXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        id: model.index,
        name: "Picture ".concat(model.index)
      });
      this.map['a:hlinkClick'].render(xmlStream, model);
      this.map['a:extLst'].render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model = this.map['a:hlinkClick'].model;
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:cNvPr';
    }
  }]);

  return CNvPrXform;
}(BaseXform);

module.exports = CNvPrXform;

},{"../base-xform":31,"./ext-lst-xform":62,"./hlink-click-xform":64}],60:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var IntegerXform = require('../simple/integer-xform');

var CellPositionXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(CellPositionXform, _BaseXform);

  var _super = _createSuper(CellPositionXform);

  function CellPositionXform(options) {
    var _this;

    _classCallCheck(this, CellPositionXform);

    _this = _super.call(this);
    _this.tag = options.tag;
    _this.map = {
      'xdr:col': new IntegerXform({
        tag: 'xdr:col',
        zero: true
      }),
      'xdr:colOff': new IntegerXform({
        tag: 'xdr:colOff',
        zero: true
      }),
      'xdr:row': new IntegerXform({
        tag: 'xdr:row',
        zero: true
      }),
      'xdr:rowOff': new IntegerXform({
        tag: 'xdr:rowOff',
        zero: true
      })
    };
    return _this;
  }

  _createClass(CellPositionXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);
      this.map['xdr:col'].render(xmlStream, model.nativeCol);
      this.map['xdr:colOff'].render(xmlStream, model.nativeColOff);
      this.map['xdr:row'].render(xmlStream, model.nativeRow);
      this.map['xdr:rowOff'].render(xmlStream, model.nativeRowOff);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model = {
            nativeCol: this.map['xdr:col'].model,
            nativeColOff: this.map['xdr:colOff'].model,
            nativeRow: this.map['xdr:row'].model,
            nativeRowOff: this.map['xdr:rowOff'].model
          };
          return false;

        default:
          // not quite sure how we get here!
          return true;
      }
    }
  }]);

  return CellPositionXform;
}(BaseXform);

module.exports = CellPositionXform;

},{"../base-xform":31,"../simple/integer-xform":117}],61:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var colCache = require('../../../utils/col-cache');

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var TwoCellAnchorXform = require('./two-cell-anchor-xform');

var OneCellAnchorXform = require('./one-cell-anchor-xform');

function getAnchorType(model) {
  var range = typeof model.range === 'string' ? colCache.decode(model.range) : model.range;
  return range.br ? 'xdr:twoCellAnchor' : 'xdr:oneCellAnchor';
}

var DrawingXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(DrawingXform, _BaseXform);

  var _super = _createSuper(DrawingXform);

  function DrawingXform() {
    var _this;

    _classCallCheck(this, DrawingXform);

    _this = _super.call(this);
    _this.map = {
      'xdr:twoCellAnchor': new TwoCellAnchorXform(),
      'xdr:oneCellAnchor': new OneCellAnchorXform()
    };
    return _this;
  }

  _createClass(DrawingXform, [{
    key: "prepare",
    value: function prepare(model) {
      var _this2 = this;

      model.anchors.forEach(function (item, index) {
        item.anchorType = getAnchorType(item);
        var anchor = _this2.map[item.anchorType];
        anchor.prepare(item, {
          index: index
        });
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var _this3 = this;

      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode(this.tag, DrawingXform.DRAWING_ATTRIBUTES);
      model.anchors.forEach(function (item) {
        var anchor = _this3.map[item.anchorType];
        anchor.render(xmlStream, item);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          this.model = {
            anchors: []
          };
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.anchors.push(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          // could be some unrecognised tags
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      var _this4 = this;

      model.anchors.forEach(function (anchor) {
        if (anchor.br) {
          _this4.map['xdr:twoCellAnchor'].reconcile(anchor, options);
        } else {
          _this4.map['xdr:oneCellAnchor'].reconcile(anchor, options);
        }
      });
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:wsDr';
    }
  }]);

  return DrawingXform;
}(BaseXform);

DrawingXform.DRAWING_ATTRIBUTES = {
  'xmlns:xdr': 'http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing',
  'xmlns:a': 'http://schemas.openxmlformats.org/drawingml/2006/main'
};
module.exports = DrawingXform;

},{"../../../utils/col-cache":19,"../../../utils/xml-stream":27,"../base-xform":31,"./one-cell-anchor-xform":66,"./two-cell-anchor-xform":69}],62:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var ExtLstXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(ExtLstXform, _BaseXform);

  var _super = _createSuper(ExtLstXform);

  function ExtLstXform() {
    _classCallCheck(this, ExtLstXform);

    return _super.apply(this, arguments);
  }

  _createClass(ExtLstXform, [{
    key: "render",
    value: function render(xmlStream) {
      xmlStream.openNode(this.tag);
      xmlStream.openNode('a:ext', {
        uri: '{FF2B5EF4-FFF2-40B4-BE49-F238E27FC236}'
      });
      xmlStream.leafNode('a16:creationId', {
        'xmlns:a16': 'http://schemas.microsoft.com/office/drawing/2014/main',
        id: '{00000000-0008-0000-0000-000002000000}'
      });
      xmlStream.closeNode();
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          return true;

        default:
          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case this.tag:
          return false;

        default:
          // unprocessed internal nodes
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'a:extLst';
    }
  }]);

  return ExtLstXform;
}(BaseXform);

module.exports = ExtLstXform;

},{"../base-xform":31}],63:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');
/** https://en.wikipedia.org/wiki/Office_Open_XML_file_formats#DrawingML */


var EMU_PER_PIXEL_AT_96_DPI = 9525;

var ExtXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(ExtXform, _BaseXform);

  var _super = _createSuper(ExtXform);

  function ExtXform(options) {
    var _this;

    _classCallCheck(this, ExtXform);

    _this = _super.call(this);
    _this.tag = options.tag;
    _this.map = {};
    return _this;
  }

  _createClass(ExtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);
      var width = Math.floor(model.width * EMU_PER_PIXEL_AT_96_DPI);
      var height = Math.floor(model.height * EMU_PER_PIXEL_AT_96_DPI);
      xmlStream.addAttribute('cx', width);
      xmlStream.addAttribute('cy', height);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        this.model = {
          width: parseInt(node.attributes.cx || '0', 10) / EMU_PER_PIXEL_AT_96_DPI,
          height: parseInt(node.attributes.cy || '0', 10) / EMU_PER_PIXEL_AT_96_DPI
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText()
    /* text */
    {}
  }, {
    key: "parseClose",
    value: function parseClose()
    /* name */
    {
      return false;
    }
  }]);

  return ExtXform;
}(BaseXform);

module.exports = ExtXform;

},{"../base-xform":31}],64:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var HLinkClickXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(HLinkClickXform, _BaseXform);

  var _super = _createSuper(HLinkClickXform);

  function HLinkClickXform() {
    _classCallCheck(this, HLinkClickXform);

    return _super.apply(this, arguments);
  }

  _createClass(HLinkClickXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (!(model.hyperlinks && model.hyperlinks.rId)) {
        return;
      }

      xmlStream.leafNode(this.tag, {
        'xmlns:r': 'http://schemas.openxmlformats.org/officeDocument/2006/relationships',
        'r:id': model.hyperlinks.rId,
        tooltip: model.hyperlinks.tooltip
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            hyperlinks: {
              rId: node.attributes['r:id'],
              tooltip: node.attributes.tooltip
            }
          };
          return true;

        default:
          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'a:hlinkClick';
    }
  }]);

  return HLinkClickXform;
}(BaseXform);

module.exports = HLinkClickXform;

},{"../base-xform":31}],65:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var CNvPrXform = require('./c-nv-pr-xform');

var CNvPicPrXform = require('./c-nv-pic-pr-xform');

var NvPicPrXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(NvPicPrXform, _BaseXform);

  var _super = _createSuper(NvPicPrXform);

  function NvPicPrXform() {
    var _this;

    _classCallCheck(this, NvPicPrXform);

    _this = _super.call(this);
    _this.map = {
      'xdr:cNvPr': new CNvPrXform(),
      'xdr:cNvPicPr': new CNvPicPrXform()
    };
    return _this;
  }

  _createClass(NvPicPrXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);
      this.map['xdr:cNvPr'].render(xmlStream, model);
      this.map['xdr:cNvPicPr'].render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model = this.map['xdr:cNvPr'].model;
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:nvPicPr';
    }
  }]);

  return NvPicPrXform;
}(BaseXform);

module.exports = NvPicPrXform;

},{"../base-xform":31,"./c-nv-pic-pr-xform":58,"./c-nv-pr-xform":59}],66:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseCellAnchorXform = require('./base-cell-anchor-xform');

var StaticXform = require('../static-xform');

var CellPositionXform = require('./cell-position-xform');

var ExtXform = require('./ext-xform');

var PicXform = require('./pic-xform');

var OneCellAnchorXform = /*#__PURE__*/function (_BaseCellAnchorXform) {
  _inherits(OneCellAnchorXform, _BaseCellAnchorXform);

  var _super = _createSuper(OneCellAnchorXform);

  function OneCellAnchorXform() {
    var _this;

    _classCallCheck(this, OneCellAnchorXform);

    _this = _super.call(this);
    _this.map = {
      'xdr:from': new CellPositionXform({
        tag: 'xdr:from'
      }),
      'xdr:ext': new ExtXform({
        tag: 'xdr:ext'
      }),
      'xdr:pic': new PicXform(),
      'xdr:clientData': new StaticXform({
        tag: 'xdr:clientData'
      })
    };
    return _this;
  }

  _createClass(OneCellAnchorXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      this.map['xdr:pic'].prepare(model.picture, options);
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        editAs: model.range.editAs || 'oneCell'
      });
      this.map['xdr:from'].render(xmlStream, model.range.tl);
      this.map['xdr:ext'].render(xmlStream, model.range.ext);
      this.map['xdr:pic'].render(xmlStream, model.picture);
      this.map['xdr:clientData'].render(xmlStream, {});
      xmlStream.closeNode();
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model.range.tl = this.map['xdr:from'].model;
          this.model.range.ext = this.map['xdr:ext'].model;
          this.model.picture = this.map['xdr:pic'].model;
          return false;

        default:
          // could be some unrecognised tags
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      model.medium = this.reconcilePicture(model.picture, options);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:oneCellAnchor';
    }
  }]);

  return OneCellAnchorXform;
}(BaseCellAnchorXform);

module.exports = OneCellAnchorXform;

},{"../static-xform":119,"./base-cell-anchor-xform":55,"./cell-position-xform":60,"./ext-xform":63,"./pic-xform":67}],67:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var StaticXform = require('../static-xform');

var BlipFillXform = require('./blip-fill-xform');

var NvPicPrXform = require('./nv-pic-pr-xform');

var spPrJSON = require('./sp-pr');

var PicXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(PicXform, _BaseXform);

  var _super = _createSuper(PicXform);

  function PicXform() {
    var _this;

    _classCallCheck(this, PicXform);

    _this = _super.call(this);
    _this.map = {
      'xdr:nvPicPr': new NvPicPrXform(),
      'xdr:blipFill': new BlipFillXform(),
      'xdr:spPr': new StaticXform(spPrJSON)
    };
    return _this;
  }

  _createClass(PicXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      model.index = options.index + 1;
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);
      this.map['xdr:nvPicPr'].render(xmlStream, model);
      this.map['xdr:blipFill'].render(xmlStream, model);
      this.map['xdr:spPr'].render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.reset();
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.mergeModel(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          // not quite sure how we get here!
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:pic';
    }
  }]);

  return PicXform;
}(BaseXform);

module.exports = PicXform;

},{"../base-xform":31,"../static-xform":119,"./blip-fill-xform":56,"./nv-pic-pr-xform":65,"./sp-pr":68}],68:[function(require,module,exports){
"use strict";

module.exports = {
  tag: 'xdr:spPr',
  c: [{
    tag: 'a:xfrm',
    c: [{
      tag: 'a:off',
      $: {
        x: '0',
        y: '0'
      }
    }, {
      tag: 'a:ext',
      $: {
        cx: '0',
        cy: '0'
      }
    }]
  }, {
    tag: 'a:prstGeom',
    $: {
      prst: 'rect'
    },
    c: [{
      tag: 'a:avLst'
    }]
  }]
};

},{}],69:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseCellAnchorXform = require('./base-cell-anchor-xform');

var StaticXform = require('../static-xform');

var CellPositionXform = require('./cell-position-xform');

var PicXform = require('./pic-xform');

var TwoCellAnchorXform = /*#__PURE__*/function (_BaseCellAnchorXform) {
  _inherits(TwoCellAnchorXform, _BaseCellAnchorXform);

  var _super = _createSuper(TwoCellAnchorXform);

  function TwoCellAnchorXform() {
    var _this;

    _classCallCheck(this, TwoCellAnchorXform);

    _this = _super.call(this);
    _this.map = {
      'xdr:from': new CellPositionXform({
        tag: 'xdr:from'
      }),
      'xdr:to': new CellPositionXform({
        tag: 'xdr:to'
      }),
      'xdr:pic': new PicXform(),
      'xdr:clientData': new StaticXform({
        tag: 'xdr:clientData'
      })
    };
    return _this;
  }

  _createClass(TwoCellAnchorXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      this.map['xdr:pic'].prepare(model.picture, options);
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        editAs: model.range.editAs || 'oneCell'
      });
      this.map['xdr:from'].render(xmlStream, model.range.tl);
      this.map['xdr:to'].render(xmlStream, model.range.br);
      this.map['xdr:pic'].render(xmlStream, model.picture);
      this.map['xdr:clientData'].render(xmlStream, {});
      xmlStream.closeNode();
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model.range.tl = this.map['xdr:from'].model;
          this.model.range.br = this.map['xdr:to'].model;
          this.model.picture = this.map['xdr:pic'].model;
          return false;

        default:
          // could be some unrecognised tags
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      model.medium = this.reconcilePicture(model.picture, options);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xdr:twoCellAnchor';
    }
  }]);

  return TwoCellAnchorXform;
}(BaseCellAnchorXform);

module.exports = TwoCellAnchorXform;

},{"../static-xform":119,"./base-cell-anchor-xform":55,"./cell-position-xform":60,"./pic-xform":67}],70:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('./base-xform');

var ListXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(ListXform, _BaseXform);

  var _super = _createSuper(ListXform);

  function ListXform(options) {
    var _this;

    _classCallCheck(this, ListXform);

    _this = _super.call(this);
    _this.tag = options.tag;
    _this.always = !!options.always;
    _this.count = options.count;
    _this.empty = options.empty;
    _this.$count = options.$count || 'count';
    _this.$ = options.$;
    _this.childXform = options.childXform;
    _this.maxItems = options.maxItems;
    return _this;
  }

  _createClass(ListXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      var childXform = this.childXform;

      if (model) {
        model.forEach(function (childModel, index) {
          options.index = index;
          childXform.prepare(childModel, options);
        });
      }
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      if (this.always || model && model.length) {
        xmlStream.openNode(this.tag, this.$);

        if (this.count) {
          xmlStream.addAttribute(this.$count, model && model.length || 0);
        }

        var childXform = this.childXform;
        (model || []).forEach(function (childModel, index) {
          childXform.render(xmlStream, childModel, index);
        });
        xmlStream.closeNode();
      } else if (this.empty) {
        xmlStream.leafNode(this.tag);
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.model = [];
          return true;

        default:
          if (this.childXform.parseOpen(node)) {
            this.parser = this.childXform;
            return true;
          }

          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.push(this.parser.model);
          this.parser = undefined;

          if (this.maxItems && this.model.length > this.maxItems) {
            throw new Error("Max ".concat(this.childXform.tag, " count (").concat(this.maxItems, ") exceeded"));
          }
        }

        return true;
      }

      return false;
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      if (model) {
        var childXform = this.childXform;
        model.forEach(function (childModel) {
          childXform.reconcile(childModel, options);
        });
      }
    }
  }]);

  return ListXform;
}(BaseXform);

module.exports = ListXform;

},{"./base-xform":31}],71:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var colCache = require('../../../utils/col-cache');

var BaseXform = require('../base-xform');

var AutoFilterXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(AutoFilterXform, _BaseXform);

  var _super = _createSuper(AutoFilterXform);

  function AutoFilterXform() {
    _classCallCheck(this, AutoFilterXform);

    return _super.apply(this, arguments);
  }

  _createClass(AutoFilterXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        if (typeof model === 'string') {
          // assume range
          xmlStream.leafNode('autoFilter', {
            ref: model
          });
        } else {
          var getAddress = function getAddress(addr) {
            if (typeof addr === 'string') {
              return addr;
            }

            return colCache.getAddress(addr.row, addr.column).address;
          };

          var firstAddress = getAddress(model.from);
          var secondAddress = getAddress(model.to);

          if (firstAddress && secondAddress) {
            xmlStream.leafNode('autoFilter', {
              ref: "".concat(firstAddress, ":").concat(secondAddress)
            });
          }
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'autoFilter') {
        this.model = node.attributes.ref;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'autoFilter';
    }
  }]);

  return AutoFilterXform;
}(BaseXform);

module.exports = AutoFilterXform;

},{"../../../utils/col-cache":19,"../base-xform":31}],72:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var Range = require('../../../doc/range');

var Enums = require('../../../doc/enums');

var RichTextXform = require('../strings/rich-text-xform');

function getValueType(v) {
  if (v === null || v === undefined) {
    return Enums.ValueType.Null;
  }

  if (v instanceof String || typeof v === 'string') {
    return Enums.ValueType.String;
  }

  if (typeof v === 'number') {
    return Enums.ValueType.Number;
  }

  if (typeof v === 'boolean') {
    return Enums.ValueType.Boolean;
  }

  if (v instanceof Date) {
    return Enums.ValueType.Date;
  }

  if (v.text && v.hyperlink) {
    return Enums.ValueType.Hyperlink;
  }

  if (v.formula) {
    return Enums.ValueType.Formula;
  }

  if (v.error) {
    return Enums.ValueType.Error;
  }

  throw new Error('I could not understand type of value');
}

function getEffectiveCellType(cell) {
  switch (cell.type) {
    case Enums.ValueType.Formula:
      return getValueType(cell.result);

    default:
      return cell.type;
  }
}

var CellXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(CellXform, _BaseXform);

  var _super = _createSuper(CellXform);

  function CellXform() {
    var _this;

    _classCallCheck(this, CellXform);

    _this = _super.call(this);
    _this.richTextXForm = new RichTextXform();
    return _this;
  }

  _createClass(CellXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      var styleId = options.styles.addStyleModel(model.style || {}, getEffectiveCellType(model));

      if (styleId) {
        model.styleId = styleId;
      }

      if (model.comment) {
        options.comments.push(_objectSpread(_objectSpread({}, model.comment), {}, {
          ref: model.address
        }));
      }

      switch (model.type) {
        case Enums.ValueType.String:
        case Enums.ValueType.RichText:
          if (options.sharedStrings) {
            model.ssId = options.sharedStrings.add(model.value);
          }

          break;

        case Enums.ValueType.Date:
          if (options.date1904) {
            model.date1904 = true;
          }

          break;

        case Enums.ValueType.Hyperlink:
          if (options.sharedStrings && model.text !== undefined && model.text !== null) {
            model.ssId = options.sharedStrings.add(model.text);
          }

          options.hyperlinks.push({
            address: model.address,
            target: model.hyperlink,
            tooltip: model.tooltip
          });
          break;

        case Enums.ValueType.Merge:
          options.merges.add(model);
          break;

        case Enums.ValueType.Formula:
          if (options.date1904) {
            // in case valueType is date
            model.date1904 = true;
          }

          if (model.shareType === 'shared') {
            model.si = options.siFormulae++;
          }

          if (model.formula) {
            options.formulae[model.address] = model;
          } else if (model.sharedFormula) {
            var master = options.formulae[model.sharedFormula];

            if (!master) {
              throw new Error("Shared Formula master must exist above and or left of clone for cell ".concat(model.address));
            }

            if (master.si === undefined) {
              master.shareType = 'shared';
              master.si = options.siFormulae++;
              master.range = new Range(master.address, model.address);
            } else if (master.range) {
              master.range.expandToAddress(model.address);
            }

            model.si = master.si;
          }

          break;

        default:
          break;
      }
    }
  }, {
    key: "renderFormula",
    value: function renderFormula(xmlStream, model) {
      var attrs = null;

      switch (model.shareType) {
        case 'shared':
          attrs = {
            t: 'shared',
            ref: model.ref || model.range.range,
            si: model.si
          };
          break;

        case 'array':
          attrs = {
            t: 'array',
            ref: model.ref
          };
          break;

        default:
          if (model.si !== undefined) {
            attrs = {
              t: 'shared',
              si: model.si
            };
          }

          break;
      }

      switch (getValueType(model.result)) {
        case Enums.ValueType.Null:
          // ?
          xmlStream.leafNode('f', attrs, model.formula);
          break;

        case Enums.ValueType.String:
          // oddly, formula results don't ever use shared strings
          xmlStream.addAttribute('t', 'str');
          xmlStream.leafNode('f', attrs, model.formula);
          xmlStream.leafNode('v', null, model.result);
          break;

        case Enums.ValueType.Number:
          xmlStream.leafNode('f', attrs, model.formula);
          xmlStream.leafNode('v', null, model.result);
          break;

        case Enums.ValueType.Boolean:
          xmlStream.addAttribute('t', 'b');
          xmlStream.leafNode('f', attrs, model.formula);
          xmlStream.leafNode('v', null, model.result ? 1 : 0);
          break;

        case Enums.ValueType.Error:
          xmlStream.addAttribute('t', 'e');
          xmlStream.leafNode('f', attrs, model.formula);
          xmlStream.leafNode('v', null, model.result.error);
          break;

        case Enums.ValueType.Date:
          xmlStream.leafNode('f', attrs, model.formula);
          xmlStream.leafNode('v', null, utils.dateToExcel(model.result, model.date1904));
          break;
        // case Enums.ValueType.Hyperlink: // ??
        // case Enums.ValueType.Formula:

        default:
          throw new Error('I could not understand type of value');
      }
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      if (model.type === Enums.ValueType.Null && !model.styleId) {
        // if null and no style, exit
        return;
      }

      xmlStream.openNode('c');
      xmlStream.addAttribute('r', model.address);

      if (model.styleId) {
        xmlStream.addAttribute('s', model.styleId);
      }

      switch (model.type) {
        case Enums.ValueType.Null:
          break;

        case Enums.ValueType.Number:
          xmlStream.leafNode('v', null, model.value);
          break;

        case Enums.ValueType.Boolean:
          xmlStream.addAttribute('t', 'b');
          xmlStream.leafNode('v', null, model.value ? '1' : '0');
          break;

        case Enums.ValueType.Error:
          xmlStream.addAttribute('t', 'e');
          xmlStream.leafNode('v', null, model.value.error);
          break;

        case Enums.ValueType.String:
        case Enums.ValueType.RichText:
          if (model.ssId !== undefined) {
            xmlStream.addAttribute('t', 's');
            xmlStream.leafNode('v', null, model.ssId);
          } else if (model.value && model.value.richText) {
            xmlStream.addAttribute('t', 'inlineStr');
            xmlStream.openNode('is');
            model.value.richText.forEach(function (text) {
              _this2.richTextXForm.render(xmlStream, text);
            });
            xmlStream.closeNode('is');
          } else {
            xmlStream.addAttribute('t', 'str');
            xmlStream.leafNode('v', null, model.value);
          }

          break;

        case Enums.ValueType.Date:
          xmlStream.leafNode('v', null, utils.dateToExcel(model.value, model.date1904));
          break;

        case Enums.ValueType.Hyperlink:
          if (model.ssId !== undefined) {
            xmlStream.addAttribute('t', 's');
            xmlStream.leafNode('v', null, model.ssId);
          } else {
            xmlStream.addAttribute('t', 'str');
            xmlStream.leafNode('v', null, model.text);
          }

          break;

        case Enums.ValueType.Formula:
          this.renderFormula(xmlStream, model);
          break;

        case Enums.ValueType.Merge:
          // nothing to add
          break;

        default:
          break;
      }

      xmlStream.closeNode(); // </c>
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'c':
          // const address = colCache.decodeAddress(node.attributes.r);
          this.model = {
            address: node.attributes.r
          };
          this.t = node.attributes.t;

          if (node.attributes.s) {
            this.model.styleId = parseInt(node.attributes.s, 10);
          }

          return true;

        case 'f':
          this.currentNode = 'f';
          this.model.si = node.attributes.si;
          this.model.shareType = node.attributes.t;
          this.model.ref = node.attributes.ref;
          return true;

        case 'v':
          this.currentNode = 'v';
          return true;

        case 't':
          this.currentNode = 't';
          return true;

        case 'r':
          this.parser = this.richTextXForm;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
        return;
      }

      switch (this.currentNode) {
        case 'f':
          this.model.formula = this.model.formula ? this.model.formula + text : text;
          break;

        case 'v':
        case 't':
          if (this.model.value && this.model.value.richText) {
            this.model.value.richText.text = this.model.value.richText.text ? this.model.value.richText.text + text : text;
          } else {
            this.model.value = this.model.value ? this.model.value + text : text;
          }

          break;

        default:
          break;
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case 'c':
          {
            var model = this.model; // first guess on cell type

            if (model.formula || model.shareType) {
              model.type = Enums.ValueType.Formula;

              if (model.value) {
                if (this.t === 'str') {
                  model.result = utils.xmlDecode(model.value);
                } else if (this.t === 'b') {
                  model.result = parseInt(model.value, 10) !== 0;
                } else if (this.t === 'e') {
                  model.result = {
                    error: model.value
                  };
                } else {
                  model.result = parseFloat(model.value);
                }

                model.value = undefined;
              }
            } else if (model.value !== undefined) {
              switch (this.t) {
                case 's':
                  model.type = Enums.ValueType.String;
                  model.value = parseInt(model.value, 10);
                  break;

                case 'str':
                  model.type = Enums.ValueType.String;
                  model.value = utils.xmlDecode(model.value);
                  break;

                case 'inlineStr':
                  model.type = Enums.ValueType.String;
                  break;

                case 'b':
                  model.type = Enums.ValueType.Boolean;
                  model.value = parseInt(model.value, 10) !== 0;
                  break;

                case 'e':
                  model.type = Enums.ValueType.Error;
                  model.value = {
                    error: model.value
                  };
                  break;

                default:
                  model.type = Enums.ValueType.Number;
                  model.value = parseFloat(model.value);
                  break;
              }
            } else if (model.styleId) {
              model.type = Enums.ValueType.Null;
            } else {
              model.type = Enums.ValueType.Merge;
            }

            return false;
          }

        case 'f':
        case 'v':
        case 'is':
          this.currentNode = undefined;
          return true;

        case 't':
          if (this.parser) {
            this.parser.parseClose(name);
            return true;
          }

          this.currentNode = undefined;
          return true;

        case 'r':
          this.model.value = this.model.value || {};
          this.model.value.richText = this.model.value.richText || [];
          this.model.value.richText.push(this.parser.model);
          this.parser = undefined;
          this.currentNode = undefined;
          return true;

        default:
          if (this.parser) {
            this.parser.parseClose(name);
            return true;
          }

          return false;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      var style = model.styleId && options.styles && options.styles.getStyleModel(model.styleId);

      if (style) {
        model.style = style;
      }

      if (model.styleId !== undefined) {
        model.styleId = undefined;
      }

      switch (model.type) {
        case Enums.ValueType.String:
          if (typeof model.value === 'number') {
            if (options.sharedStrings) {
              model.value = options.sharedStrings.getString(model.value);
            }
          }

          if (model.value.richText) {
            model.type = Enums.ValueType.RichText;
          }

          break;

        case Enums.ValueType.Number:
          if (style && utils.isDateFmt(style.numFmt)) {
            model.type = Enums.ValueType.Date;
            model.value = utils.excelToDate(model.value, options.date1904);
          }

          break;

        case Enums.ValueType.Formula:
          if (model.result !== undefined && style && utils.isDateFmt(style.numFmt)) {
            model.result = utils.excelToDate(model.result, options.date1904);
          }

          if (model.shareType === 'shared') {
            if (model.ref) {
              // master
              options.formulae[model.si] = model.address;
            } else {
              // slave
              model.sharedFormula = options.formulae[model.si];
              delete model.shareType;
            }

            delete model.si;
          }

          break;

        default:
          break;
      } // look for hyperlink


      var hyperlink = options.hyperlinkMap[model.address];

      if (hyperlink) {
        if (model.type === Enums.ValueType.Formula) {
          model.text = model.result;
          model.result = undefined;
        } else {
          model.text = model.value;
          model.value = undefined;
        }

        model.type = Enums.ValueType.Hyperlink;
        model.hyperlink = hyperlink;
      }

      var comment = options.commentsMap && options.commentsMap[model.address];

      if (comment) {
        model.comment = comment;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'c';
    }
  }]);

  return CellXform;
}(BaseXform);

module.exports = CellXform;

},{"../../../doc/enums":7,"../../../doc/range":10,"../../../utils/utils":26,"../base-xform":31,"../strings/rich-text-xform":121}],73:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var CfIconExtXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(CfIconExtXform, _BaseXform);

  var _super = _createSuper(CfIconExtXform);

  function CfIconExtXform() {
    _classCallCheck(this, CfIconExtXform);

    return _super.apply(this, arguments);
  }

  _createClass(CfIconExtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        iconSet: model.iconSet,
        iconId: model.iconId
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(_ref) {
      var attributes = _ref.attributes;
      this.model = {
        iconSet: attributes.iconSet,
        iconId: BaseXform.toIntValue(attributes.iconId)
      };
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      return name !== this.tag;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x14:cfIcon';
    }
  }]);

  return CfIconExtXform;
}(BaseXform);

module.exports = CfIconExtXform;

},{"../../base-xform":31}],74:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var _require = require('uuid'),
    uuidv4 = _require.v4;

var BaseXform = require('../../base-xform');

var CompositeXform = require('../../composite-xform');

var DatabarExtXform = require('./databar-ext-xform');

var IconSetExtXform = require('./icon-set-ext-xform');

var extIcons = {
  '3Triangles': true,
  '3Stars': true,
  '5Boxes': true
};

var CfRuleExtXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(CfRuleExtXform, _CompositeXform);

  var _super = _createSuper(CfRuleExtXform);

  function CfRuleExtXform() {
    var _this;

    _classCallCheck(this, CfRuleExtXform);

    _this = _super.call(this);
    _this.map = {
      'x14:dataBar': _this.databarXform = new DatabarExtXform(),
      'x14:iconSet': _this.iconSetXform = new IconSetExtXform()
    };
    return _this;
  }

  _createClass(CfRuleExtXform, [{
    key: "prepare",
    value: function prepare(model) {
      if (CfRuleExtXform.isExt(model)) {
        model.x14Id = "{".concat(uuidv4(), "}").toUpperCase();
      }
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      if (!CfRuleExtXform.isExt(model)) {
        return;
      }

      switch (model.type) {
        case 'dataBar':
          this.renderDataBar(xmlStream, model);
          break;

        case 'iconSet':
          this.renderIconSet(xmlStream, model);
          break;
      }
    }
  }, {
    key: "renderDataBar",
    value: function renderDataBar(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        type: 'dataBar',
        id: model.x14Id
      });
      this.databarXform.render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "renderIconSet",
    value: function renderIconSet(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        type: 'iconSet',
        priority: model.priority,
        id: model.x14Id || "{".concat(uuidv4(), "}")
      });
      this.iconSetXform.render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel(_ref) {
      var attributes = _ref.attributes;
      return {
        type: attributes.type,
        x14Id: attributes.id,
        priority: BaseXform.toIntValue(attributes.priority)
      };
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      Object.assign(this.model, parser.model);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x14:cfRule';
    }
  }], [{
    key: "isExt",
    value: function isExt(rule) {
      // is this rule primitive?
      if (rule.type === 'dataBar') {
        return DatabarExtXform.isExt(rule);
      }

      if (rule.type === 'iconSet') {
        if (rule.custom || extIcons[rule.iconSet]) {
          return true;
        }
      }

      return false;
    }
  }]);

  return CfRuleExtXform;
}(CompositeXform);

module.exports = CfRuleExtXform;

},{"../../base-xform":31,"../../composite-xform":47,"./databar-ext-xform":78,"./icon-set-ext-xform":80,"uuid":416}],75:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var CompositeXform = require('../../composite-xform');

var FExtXform = require('./f-ext-xform');

var CfvoExtXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(CfvoExtXform, _CompositeXform);

  var _super = _createSuper(CfvoExtXform);

  function CfvoExtXform() {
    var _this;

    _classCallCheck(this, CfvoExtXform);

    _this = _super.call(this);
    _this.map = {
      'xm:f': _this.fExtXform = new FExtXform()
    };
    return _this;
  }

  _createClass(CfvoExtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        type: model.type
      });

      if (model.value !== undefined) {
        this.fExtXform.render(xmlStream, model.value);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel(node) {
      return {
        type: node.attributes.type
      };
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      switch (name) {
        case 'xm:f':
          this.model.value = parser.model ? parseFloat(parser.model) : 0;
          break;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x14:cfvo';
    }
  }]);

  return CfvoExtXform;
}(CompositeXform);

module.exports = CfvoExtXform;

},{"../../composite-xform":47,"./f-ext-xform":79}],76:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var CompositeXform = require('../../composite-xform');

var SqRefExtXform = require('./sqref-ext-xform');

var CfRuleExtXform = require('./cf-rule-ext-xform');

var ConditionalFormattingExtXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(ConditionalFormattingExtXform, _CompositeXform);

  var _super = _createSuper(ConditionalFormattingExtXform);

  function ConditionalFormattingExtXform() {
    var _this;

    _classCallCheck(this, ConditionalFormattingExtXform);

    _this = _super.call(this);
    _this.map = {
      'xm:sqref': _this.sqRef = new SqRefExtXform(),
      'x14:cfRule': _this.cfRule = new CfRuleExtXform()
    };
    return _this;
  }

  _createClass(ConditionalFormattingExtXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      var _this2 = this;

      model.rules.forEach(function (rule) {
        _this2.cfRule.prepare(rule, options);
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var _this3 = this;

      if (!model.rules.some(CfRuleExtXform.isExt)) {
        return;
      }

      xmlStream.openNode(this.tag, {
        'xmlns:xm': 'http://schemas.microsoft.com/office/excel/2006/main'
      });
      model.rules.filter(CfRuleExtXform.isExt).forEach(function (rule) {
        return _this3.cfRule.render(xmlStream, rule);
      }); // for some odd reason, Excel needs the <xm:sqref> node to be after the rules

      this.sqRef.render(xmlStream, model.ref);
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel() {
      return {
        rules: []
      };
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      switch (name) {
        case 'xm:sqref':
          this.model.ref = parser.model;
          break;

        case 'x14:cfRule':
          this.model.rules.push(parser.model);
          break;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x14:conditionalFormatting';
    }
  }]);

  return ConditionalFormattingExtXform;
}(CompositeXform);

module.exports = ConditionalFormattingExtXform;

},{"../../composite-xform":47,"./cf-rule-ext-xform":74,"./sqref-ext-xform":81}],77:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var CompositeXform = require('../../composite-xform');

var CfRuleExtXform = require('./cf-rule-ext-xform');

var ConditionalFormattingExtXform = require('./conditional-formatting-ext-xform');

var ConditionalFormattingsExtXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(ConditionalFormattingsExtXform, _CompositeXform);

  var _super = _createSuper(ConditionalFormattingsExtXform);

  function ConditionalFormattingsExtXform() {
    var _this;

    _classCallCheck(this, ConditionalFormattingsExtXform);

    _this = _super.call(this);
    _this.map = {
      'x14:conditionalFormatting': _this.cfXform = new ConditionalFormattingExtXform()
    };
    return _this;
  }

  _createClass(ConditionalFormattingsExtXform, [{
    key: "hasContent",
    value: function hasContent(model) {
      if (model.hasExtContent === undefined) {
        model.hasExtContent = model.some(function (cf) {
          return cf.rules.some(CfRuleExtXform.isExt);
        });
      }

      return model.hasExtContent;
    }
  }, {
    key: "prepare",
    value: function prepare(model, options) {
      var _this2 = this;

      model.forEach(function (cf) {
        _this2.cfXform.prepare(cf, options);
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var _this3 = this;

      if (this.hasContent(model)) {
        xmlStream.openNode(this.tag);
        model.forEach(function (cf) {
          return _this3.cfXform.render(xmlStream, cf);
        });
        xmlStream.closeNode();
      }
    }
  }, {
    key: "createNewModel",
    value: function createNewModel() {
      return [];
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      // model is array of conditional formatting objects
      this.model.push(parser.model);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x14:conditionalFormattings';
    }
  }]);

  return ConditionalFormattingsExtXform;
}(CompositeXform);

module.exports = ConditionalFormattingsExtXform;

},{"../../composite-xform":47,"./cf-rule-ext-xform":74,"./conditional-formatting-ext-xform":76}],78:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var CompositeXform = require('../../composite-xform');

var ColorXform = require('../../style/color-xform');

var CfvoExtXform = require('./cfvo-ext-xform');

var DatabarExtXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(DatabarExtXform, _CompositeXform);

  var _super = _createSuper(DatabarExtXform);

  function DatabarExtXform() {
    var _this;

    _classCallCheck(this, DatabarExtXform);

    _this = _super.call(this);
    _this.map = {
      'x14:cfvo': _this.cfvoXform = new CfvoExtXform(),
      'x14:borderColor': _this.borderColorXform = new ColorXform('x14:borderColor'),
      'x14:negativeBorderColor': _this.negativeBorderColorXform = new ColorXform('x14:negativeBorderColor'),
      'x14:negativeFillColor': _this.negativeFillColorXform = new ColorXform('x14:negativeFillColor'),
      'x14:axisColor': _this.axisColorXform = new ColorXform('x14:axisColor')
    };
    return _this;
  }

  _createClass(DatabarExtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      xmlStream.openNode(this.tag, {
        minLength: BaseXform.toIntAttribute(model.minLength, 0, true),
        maxLength: BaseXform.toIntAttribute(model.maxLength, 100, true),
        border: BaseXform.toBoolAttribute(model.border, false),
        gradient: BaseXform.toBoolAttribute(model.gradient, true),
        negativeBarColorSameAsPositive: BaseXform.toBoolAttribute(model.negativeBarColorSameAsPositive, true),
        negativeBarBorderColorSameAsPositive: BaseXform.toBoolAttribute(model.negativeBarBorderColorSameAsPositive, true),
        axisPosition: BaseXform.toAttribute(model.axisPosition, 'auto'),
        direction: BaseXform.toAttribute(model.direction, 'leftToRight')
      });
      model.cfvo.forEach(function (cfvo) {
        _this2.cfvoXform.render(xmlStream, cfvo);
      });
      this.borderColorXform.render(xmlStream, model.borderColor);
      this.negativeBorderColorXform.render(xmlStream, model.negativeBorderColor);
      this.negativeFillColorXform.render(xmlStream, model.negativeFillColor);
      this.axisColorXform.render(xmlStream, model.axisColor);
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel(_ref) {
      var attributes = _ref.attributes;
      return {
        cfvo: [],
        minLength: BaseXform.toIntValue(attributes.minLength, 0),
        maxLength: BaseXform.toIntValue(attributes.maxLength, 100),
        border: BaseXform.toBoolValue(attributes.border, false),
        gradient: BaseXform.toBoolValue(attributes.gradient, true),
        negativeBarColorSameAsPositive: BaseXform.toBoolValue(attributes.negativeBarColorSameAsPositive, true),
        negativeBarBorderColorSameAsPositive: BaseXform.toBoolValue(attributes.negativeBarBorderColorSameAsPositive, true),
        axisPosition: BaseXform.toStringValue(attributes.axisPosition, 'auto'),
        direction: BaseXform.toStringValue(attributes.direction, 'leftToRight')
      };
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      var _name$split = name.split(':'),
          _name$split2 = _slicedToArray(_name$split, 2),
          prop = _name$split2[1];

      switch (prop) {
        case 'cfvo':
          this.model.cfvo.push(parser.model);
          break;

        default:
          this.model[prop] = parser.model;
          break;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x14:dataBar';
    }
  }], [{
    key: "isExt",
    value: function isExt(rule) {
      // not all databars need ext
      // TODO: refine this
      return !rule.gradient;
    }
  }]);

  return DatabarExtXform;
}(CompositeXform);

module.exports = DatabarExtXform;

},{"../../base-xform":31,"../../composite-xform":47,"../../style/color-xform":127,"./cfvo-ext-xform":75}],79:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var FExtXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(FExtXform, _BaseXform);

  var _super = _createSuper(FExtXform);

  function FExtXform() {
    _classCallCheck(this, FExtXform);

    return _super.apply(this, arguments);
  }

  _createClass(FExtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, null, model);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen() {
      this.model = '';
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this.model += text;
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      return name !== this.tag;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xm:f';
    }
  }]);

  return FExtXform;
}(BaseXform);

module.exports = FExtXform;

},{"../../base-xform":31}],80:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var CompositeXform = require('../../composite-xform');

var CfvoExtXform = require('./cfvo-ext-xform');

var CfIconExtXform = require('./cf-icon-ext-xform');

var IconSetExtXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(IconSetExtXform, _CompositeXform);

  var _super = _createSuper(IconSetExtXform);

  function IconSetExtXform() {
    var _this;

    _classCallCheck(this, IconSetExtXform);

    _this = _super.call(this);
    _this.map = {
      'x14:cfvo': _this.cfvoXform = new CfvoExtXform(),
      'x14:cfIcon': _this.cfIconXform = new CfIconExtXform()
    };
    return _this;
  }

  _createClass(IconSetExtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      xmlStream.openNode(this.tag, {
        iconSet: BaseXform.toStringAttribute(model.iconSet),
        reverse: BaseXform.toBoolAttribute(model.reverse, false),
        showValue: BaseXform.toBoolAttribute(model.showValue, true),
        custom: BaseXform.toBoolAttribute(model.icons, false)
      });
      model.cfvo.forEach(function (cfvo) {
        _this2.cfvoXform.render(xmlStream, cfvo);
      });

      if (model.icons) {
        model.icons.forEach(function (icon, i) {
          icon.iconId = i;

          _this2.cfIconXform.render(xmlStream, icon);
        });
      }

      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel(_ref) {
      var attributes = _ref.attributes;
      return {
        cfvo: [],
        iconSet: BaseXform.toStringValue(attributes.iconSet, '3TrafficLights'),
        reverse: BaseXform.toBoolValue(attributes.reverse, false),
        showValue: BaseXform.toBoolValue(attributes.showValue, true)
      };
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      var _name$split = name.split(':'),
          _name$split2 = _slicedToArray(_name$split, 2),
          prop = _name$split2[1];

      switch (prop) {
        case 'cfvo':
          this.model.cfvo.push(parser.model);
          break;

        case 'cfIcon':
          if (!this.model.icons) {
            this.model.icons = [];
          }

          this.model.icons.push(parser.model);
          break;

        default:
          this.model[prop] = parser.model;
          break;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x14:iconSet';
    }
  }]);

  return IconSetExtXform;
}(CompositeXform);

module.exports = IconSetExtXform;

},{"../../base-xform":31,"../../composite-xform":47,"./cf-icon-ext-xform":73,"./cfvo-ext-xform":75}],81:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var SqrefExtXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(SqrefExtXform, _BaseXform);

  var _super = _createSuper(SqrefExtXform);

  function SqrefExtXform() {
    _classCallCheck(this, SqrefExtXform);

    return _super.apply(this, arguments);
  }

  _createClass(SqrefExtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, null, model);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen() {
      this.model = '';
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this.model += text;
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      return name !== this.tag;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xm:sqref';
    }
  }]);

  return SqrefExtXform;
}(BaseXform);

module.exports = SqrefExtXform;

},{"../../base-xform":31}],82:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var CompositeXform = require('../../composite-xform');

var Range = require('../../../../doc/range');

var DatabarXform = require('./databar-xform');

var ExtLstRefXform = require('./ext-lst-ref-xform');

var FormulaXform = require('./formula-xform');

var ColorScaleXform = require('./color-scale-xform');

var IconSetXform = require('./icon-set-xform');

var extIcons = {
  '3Triangles': true,
  '3Stars': true,
  '5Boxes': true
};

var getTextFormula = function getTextFormula(model) {
  if (model.formulae && model.formulae[0]) {
    return model.formulae[0];
  }

  var range = new Range(model.ref);
  var tl = range.tl;

  switch (model.operator) {
    case 'containsText':
      return "NOT(ISERROR(SEARCH(\"".concat(model.text, "\",").concat(tl, ")))");

    case 'containsBlanks':
      return "LEN(TRIM(".concat(tl, "))=0");

    case 'notContainsBlanks':
      return "LEN(TRIM(".concat(tl, "))>0");

    case 'containsErrors':
      return "ISERROR(".concat(tl, ")");

    case 'notContainsErrors':
      return "NOT(ISERROR(".concat(tl, "))");

    default:
      return undefined;
  }
};

var getTimePeriodFormula = function getTimePeriodFormula(model) {
  if (model.formulae && model.formulae[0]) {
    return model.formulae[0];
  }

  var range = new Range(model.ref);
  var tl = range.tl;

  switch (model.timePeriod) {
    case 'thisWeek':
      return "AND(TODAY()-ROUNDDOWN(".concat(tl, ",0)<=WEEKDAY(TODAY())-1,ROUNDDOWN(").concat(tl, ",0)-TODAY()<=7-WEEKDAY(TODAY()))");

    case 'lastWeek':
      return "AND(TODAY()-ROUNDDOWN(".concat(tl, ",0)>=(WEEKDAY(TODAY())),TODAY()-ROUNDDOWN(").concat(tl, ",0)<(WEEKDAY(TODAY())+7))");

    case 'nextWeek':
      return "AND(ROUNDDOWN(".concat(tl, ",0)-TODAY()>(7-WEEKDAY(TODAY())),ROUNDDOWN(").concat(tl, ",0)-TODAY()<(15-WEEKDAY(TODAY())))");

    case 'yesterday':
      return "FLOOR(".concat(tl, ",1)=TODAY()-1");

    case 'today':
      return "FLOOR(".concat(tl, ",1)=TODAY()");

    case 'tomorrow':
      return "FLOOR(".concat(tl, ",1)=TODAY()+1");

    case 'last7Days':
      return "AND(TODAY()-FLOOR(".concat(tl, ",1)<=6,FLOOR(").concat(tl, ",1)<=TODAY())");

    case 'lastMonth':
      return "AND(MONTH(".concat(tl, ")=MONTH(EDATE(TODAY(),0-1)),YEAR(").concat(tl, ")=YEAR(EDATE(TODAY(),0-1)))");

    case 'thisMonth':
      return "AND(MONTH(".concat(tl, ")=MONTH(TODAY()),YEAR(").concat(tl, ")=YEAR(TODAY()))");

    case 'nextMonth':
      return "AND(MONTH(".concat(tl, ")=MONTH(EDATE(TODAY(),0+1)),YEAR(").concat(tl, ")=YEAR(EDATE(TODAY(),0+1)))");

    default:
      return undefined;
  }
};

var opType = function opType(attributes) {
  var type = attributes.type,
      operator = attributes.operator;

  switch (type) {
    case 'containsText':
    case 'containsBlanks':
    case 'notContainsBlanks':
    case 'containsErrors':
    case 'notContainsErrors':
      return {
        type: 'containsText',
        operator: type
      };

    default:
      return {
        type: type,
        operator: operator
      };
  }
};

var CfRuleXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(CfRuleXform, _CompositeXform);

  var _super = _createSuper(CfRuleXform);

  function CfRuleXform() {
    var _this;

    _classCallCheck(this, CfRuleXform);

    _this = _super.call(this);
    _this.map = {
      dataBar: _this.databarXform = new DatabarXform(),
      extLst: _this.extLstRefXform = new ExtLstRefXform(),
      formula: _this.formulaXform = new FormulaXform(),
      colorScale: _this.colorScaleXform = new ColorScaleXform(),
      iconSet: _this.iconSetXform = new IconSetXform()
    };
    return _this;
  }

  _createClass(CfRuleXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      switch (model.type) {
        case 'expression':
          this.renderExpression(xmlStream, model);
          break;

        case 'cellIs':
          this.renderCellIs(xmlStream, model);
          break;

        case 'top10':
          this.renderTop10(xmlStream, model);
          break;

        case 'aboveAverage':
          this.renderAboveAverage(xmlStream, model);
          break;

        case 'dataBar':
          this.renderDataBar(xmlStream, model);
          break;

        case 'colorScale':
          this.renderColorScale(xmlStream, model);
          break;

        case 'iconSet':
          this.renderIconSet(xmlStream, model);
          break;

        case 'containsText':
          this.renderText(xmlStream, model);
          break;

        case 'timePeriod':
          this.renderTimePeriod(xmlStream, model);
          break;
      }
    }
  }, {
    key: "renderExpression",
    value: function renderExpression(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        type: 'expression',
        dxfId: model.dxfId,
        priority: model.priority
      });
      this.formulaXform.render(xmlStream, model.formulae[0]);
      xmlStream.closeNode();
    }
  }, {
    key: "renderCellIs",
    value: function renderCellIs(xmlStream, model) {
      var _this2 = this;

      xmlStream.openNode(this.tag, {
        type: 'cellIs',
        dxfId: model.dxfId,
        priority: model.priority,
        operator: model.operator
      });
      model.formulae.forEach(function (formula) {
        _this2.formulaXform.render(xmlStream, formula);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "renderTop10",
    value: function renderTop10(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        type: 'top10',
        dxfId: model.dxfId,
        priority: model.priority,
        percent: BaseXform.toBoolAttribute(model.percent, false),
        bottom: BaseXform.toBoolAttribute(model.bottom, false),
        rank: BaseXform.toIntValue(model.rank, 10, true)
      });
    }
  }, {
    key: "renderAboveAverage",
    value: function renderAboveAverage(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        type: 'aboveAverage',
        dxfId: model.dxfId,
        priority: model.priority,
        aboveAverage: BaseXform.toBoolAttribute(model.aboveAverage, true)
      });
    }
  }, {
    key: "renderDataBar",
    value: function renderDataBar(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        type: 'dataBar',
        priority: model.priority
      });
      this.databarXform.render(xmlStream, model);
      this.extLstRefXform.render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "renderColorScale",
    value: function renderColorScale(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        type: 'colorScale',
        priority: model.priority
      });
      this.colorScaleXform.render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "renderIconSet",
    value: function renderIconSet(xmlStream, model) {
      // iconset is all primitive or all extLst
      if (!CfRuleXform.isPrimitive(model)) {
        return;
      }

      xmlStream.openNode(this.tag, {
        type: 'iconSet',
        priority: model.priority
      });
      this.iconSetXform.render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "renderText",
    value: function renderText(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        type: model.operator,
        dxfId: model.dxfId,
        priority: model.priority,
        operator: BaseXform.toStringAttribute(model.operator, 'containsText')
      });
      var formula = getTextFormula(model);

      if (formula) {
        this.formulaXform.render(xmlStream, formula);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "renderTimePeriod",
    value: function renderTimePeriod(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        type: 'timePeriod',
        dxfId: model.dxfId,
        priority: model.priority,
        timePeriod: model.timePeriod
      });
      var formula = getTimePeriodFormula(model);

      if (formula) {
        this.formulaXform.render(xmlStream, formula);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel(_ref) {
      var attributes = _ref.attributes;
      return _objectSpread(_objectSpread({}, opType(attributes)), {}, {
        dxfId: BaseXform.toIntValue(attributes.dxfId),
        priority: BaseXform.toIntValue(attributes.priority),
        timePeriod: attributes.timePeriod,
        percent: BaseXform.toBoolValue(attributes.percent),
        bottom: BaseXform.toBoolValue(attributes.bottom),
        rank: BaseXform.toIntValue(attributes.rank),
        aboveAverage: BaseXform.toBoolValue(attributes.aboveAverage)
      });
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      switch (name) {
        case 'dataBar':
        case 'extLst':
        case 'colorScale':
        case 'iconSet':
          // merge parser model with ours
          Object.assign(this.model, parser.model);
          break;

        case 'formula':
          // except - formula is a string and appends to formulae
          this.model.formulae = this.model.formulae || [];
          this.model.formulae.push(parser.model);
          break;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'cfRule';
    }
  }], [{
    key: "isPrimitive",
    value: function isPrimitive(rule) {
      // is this rule primitive?
      if (rule.type === 'iconSet') {
        if (rule.custom || extIcons[rule.iconSet]) {
          return false;
        }
      }

      return true;
    }
  }]);

  return CfRuleXform;
}(CompositeXform);

module.exports = CfRuleXform;

},{"../../../../doc/range":10,"../../base-xform":31,"../../composite-xform":47,"./color-scale-xform":84,"./databar-xform":87,"./ext-lst-ref-xform":88,"./formula-xform":89,"./icon-set-xform":90}],83:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var CfvoXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(CfvoXform, _BaseXform);

  var _super = _createSuper(CfvoXform);

  function CfvoXform() {
    _classCallCheck(this, CfvoXform);

    return _super.apply(this, arguments);
  }

  _createClass(CfvoXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        type: model.type,
        val: model.value
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      this.model = {
        type: node.attributes.type,
        value: BaseXform.toFloatValue(node.attributes.val)
      };
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      return name !== this.tag;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'cfvo';
    }
  }]);

  return CfvoXform;
}(BaseXform);

module.exports = CfvoXform;

},{"../../base-xform":31}],84:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var CompositeXform = require('../../composite-xform');

var ColorXform = require('../../style/color-xform');

var CfvoXform = require('./cfvo-xform');

var ColorScaleXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(ColorScaleXform, _CompositeXform);

  var _super = _createSuper(ColorScaleXform);

  function ColorScaleXform() {
    var _this;

    _classCallCheck(this, ColorScaleXform);

    _this = _super.call(this);
    _this.map = {
      cfvo: _this.cfvoXform = new CfvoXform(),
      color: _this.colorXform = new ColorXform()
    };
    return _this;
  }

  _createClass(ColorScaleXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      xmlStream.openNode(this.tag);
      model.cfvo.forEach(function (cfvo) {
        _this2.cfvoXform.render(xmlStream, cfvo);
      });
      model.color.forEach(function (color) {
        _this2.colorXform.render(xmlStream, color);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel(node) {
      return {
        cfvo: [],
        color: []
      };
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      this.model[name].push(parser.model);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'colorScale';
    }
  }]);

  return ColorScaleXform;
}(CompositeXform);

module.exports = ColorScaleXform;

},{"../../composite-xform":47,"../../style/color-xform":127,"./cfvo-xform":83}],85:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var CompositeXform = require('../../composite-xform');

var CfRuleXform = require('./cf-rule-xform');

var ConditionalFormattingXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(ConditionalFormattingXform, _CompositeXform);

  var _super = _createSuper(ConditionalFormattingXform);

  function ConditionalFormattingXform() {
    var _this;

    _classCallCheck(this, ConditionalFormattingXform);

    _this = _super.call(this);
    _this.map = {
      cfRule: new CfRuleXform()
    };
    return _this;
  }

  _createClass(ConditionalFormattingXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      // if there are no primitive rules, exit now
      if (!model.rules.some(CfRuleXform.isPrimitive)) {
        return;
      }

      xmlStream.openNode(this.tag, {
        sqref: model.ref
      });
      model.rules.forEach(function (rule) {
        if (CfRuleXform.isPrimitive(rule)) {
          rule.ref = model.ref;

          _this2.map.cfRule.render(xmlStream, rule);
        }
      });
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel(_ref) {
      var attributes = _ref.attributes;
      return {
        ref: attributes.sqref,
        rules: []
      };
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      this.model.rules.push(parser.model);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'conditionalFormatting';
    }
  }]);

  return ConditionalFormattingXform;
}(CompositeXform);

module.exports = ConditionalFormattingXform;

},{"../../composite-xform":47,"./cf-rule-xform":82}],86:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var ConditionalFormattingXform = require('./conditional-formatting-xform');

var ConditionalFormattingsXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(ConditionalFormattingsXform, _BaseXform);

  var _super = _createSuper(ConditionalFormattingsXform);

  function ConditionalFormattingsXform() {
    var _this;

    _classCallCheck(this, ConditionalFormattingsXform);

    _this = _super.call(this);
    _this.cfXform = new ConditionalFormattingXform();
    return _this;
  }

  _createClass(ConditionalFormattingsXform, [{
    key: "reset",
    value: function reset() {
      this.model = [];
    }
  }, {
    key: "prepare",
    value: function prepare(model, options) {
      // ensure each rule has a priority value
      var nextPriority = model.reduce(function (p, cf) {
        return Math.max.apply(Math, [p].concat(_toConsumableArray(cf.rules.map(function (rule) {
          return rule.priority || 0;
        }))));
      }, 1);
      model.forEach(function (cf) {
        cf.rules.forEach(function (rule) {
          if (!rule.priority) {
            rule.priority = nextPriority++;
          }

          if (rule.style) {
            rule.dxfId = options.styles.addDxfStyle(rule.style);
          }
        });
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      model.forEach(function (cf) {
        _this2.cfXform.render(xmlStream, cf);
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'conditionalFormatting':
          this.parser = this.cfXform;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.push(this.parser.model);
          this.parser = undefined;
          return false;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      model.forEach(function (cf) {
        cf.rules.forEach(function (rule) {
          if (rule.dxfId !== undefined) {
            rule.style = options.styles.getDxfStyle(rule.dxfId);
            delete rule.dxfId;
          }
        });
      });
    }
  }, {
    key: "tag",
    get: function get() {
      return 'conditionalFormatting';
    }
  }]);

  return ConditionalFormattingsXform;
}(BaseXform);

module.exports = ConditionalFormattingsXform;

},{"../../base-xform":31,"./conditional-formatting-xform":85}],87:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var CompositeXform = require('../../composite-xform');

var ColorXform = require('../../style/color-xform');

var CfvoXform = require('./cfvo-xform');

var DatabarXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(DatabarXform, _CompositeXform);

  var _super = _createSuper(DatabarXform);

  function DatabarXform() {
    var _this;

    _classCallCheck(this, DatabarXform);

    _this = _super.call(this);
    _this.map = {
      cfvo: _this.cfvoXform = new CfvoXform(),
      color: _this.colorXform = new ColorXform()
    };
    return _this;
  }

  _createClass(DatabarXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      xmlStream.openNode(this.tag);
      model.cfvo.forEach(function (cfvo) {
        _this2.cfvoXform.render(xmlStream, cfvo);
      });
      this.colorXform.render(xmlStream, model.color);
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel() {
      return {
        cfvo: []
      };
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      switch (name) {
        case 'cfvo':
          this.model.cfvo.push(parser.model);
          break;

        case 'color':
          this.model.color = parser.model;
          break;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'dataBar';
    }
  }]);

  return DatabarXform;
}(CompositeXform);

module.exports = DatabarXform;

},{"../../composite-xform":47,"../../style/color-xform":127,"./cfvo-xform":83}],88:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/* eslint-disable max-classes-per-file */
var BaseXform = require('../../base-xform');

var CompositeXform = require('../../composite-xform');

var X14IdXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(X14IdXform, _BaseXform);

  var _super = _createSuper(X14IdXform);

  function X14IdXform() {
    _classCallCheck(this, X14IdXform);

    return _super.apply(this, arguments);
  }

  _createClass(X14IdXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, null, model);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen() {
      this.model = '';
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this.model += text;
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      return name !== this.tag;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'x14:id';
    }
  }]);

  return X14IdXform;
}(BaseXform);

var ExtXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(ExtXform, _CompositeXform);

  var _super2 = _createSuper(ExtXform);

  function ExtXform() {
    var _this;

    _classCallCheck(this, ExtXform);

    _this = _super2.call(this);
    _this.map = {
      'x14:id': _this.idXform = new X14IdXform()
    };
    return _this;
  }

  _createClass(ExtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        uri: '{B025F937-C7B1-47D3-B67F-A62EFF666E3E}',
        'xmlns:x14': 'http://schemas.microsoft.com/office/spreadsheetml/2009/9/main'
      });
      this.idXform.render(xmlStream, model.x14Id);
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel() {
      return {};
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      this.model.x14Id = parser.model;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'ext';
    }
  }]);

  return ExtXform;
}(CompositeXform);

var ExtLstRefXform = /*#__PURE__*/function (_CompositeXform2) {
  _inherits(ExtLstRefXform, _CompositeXform2);

  var _super3 = _createSuper(ExtLstRefXform);

  function ExtLstRefXform() {
    var _this2;

    _classCallCheck(this, ExtLstRefXform);

    _this2 = _super3.call(this);
    _this2.map = {
      ext: new ExtXform()
    };
    return _this2;
  }

  _createClass(ExtLstRefXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);
      this.map.ext.render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel() {
      return {};
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      Object.assign(this.model, parser.model);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'extLst';
    }
  }]);

  return ExtLstRefXform;
}(CompositeXform);

module.exports = ExtLstRefXform;

},{"../../base-xform":31,"../../composite-xform":47}],89:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var FormulaXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(FormulaXform, _BaseXform);

  var _super = _createSuper(FormulaXform);

  function FormulaXform() {
    _classCallCheck(this, FormulaXform);

    return _super.apply(this, arguments);
  }

  _createClass(FormulaXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, null, model);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen() {
      this.model = '';
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this.model += text;
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      return name !== this.tag;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'formula';
    }
  }]);

  return FormulaXform;
}(BaseXform);

module.exports = FormulaXform;

},{"../../base-xform":31}],90:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../../base-xform');

var CompositeXform = require('../../composite-xform');

var CfvoXform = require('./cfvo-xform');

var IconSetXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(IconSetXform, _CompositeXform);

  var _super = _createSuper(IconSetXform);

  function IconSetXform() {
    var _this;

    _classCallCheck(this, IconSetXform);

    _this = _super.call(this);
    _this.map = {
      cfvo: _this.cfvoXform = new CfvoXform()
    };
    return _this;
  }

  _createClass(IconSetXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      xmlStream.openNode(this.tag, {
        iconSet: BaseXform.toStringAttribute(model.iconSet, '3TrafficLights'),
        reverse: BaseXform.toBoolAttribute(model.reverse, false),
        showValue: BaseXform.toBoolAttribute(model.showValue, true)
      });
      model.cfvo.forEach(function (cfvo) {
        _this2.cfvoXform.render(xmlStream, cfvo);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel(_ref) {
      var attributes = _ref.attributes;
      return {
        iconSet: BaseXform.toStringValue(attributes.iconSet, '3TrafficLights'),
        reverse: BaseXform.toBoolValue(attributes.reverse),
        showValue: BaseXform.toBoolValue(attributes.showValue),
        cfvo: []
      };
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      this.model[name].push(parser.model);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'iconSet';
    }
  }]);

  return IconSetXform;
}(CompositeXform);

module.exports = IconSetXform;

},{"../../base-xform":31,"../../composite-xform":47,"./cfvo-xform":83}],91:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var ColXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(ColXform, _BaseXform);

  var _super = _createSuper(ColXform);

  function ColXform() {
    _classCallCheck(this, ColXform);

    return _super.apply(this, arguments);
  }

  _createClass(ColXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      var styleId = options.styles.addStyleModel(model.style || {});

      if (styleId) {
        model.styleId = styleId;
      }
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('col');
      xmlStream.addAttribute('min', model.min);
      xmlStream.addAttribute('max', model.max);

      if (model.width) {
        xmlStream.addAttribute('width', model.width);
      }

      if (model.styleId) {
        xmlStream.addAttribute('style', model.styleId);
      }

      if (model.hidden) {
        xmlStream.addAttribute('hidden', '1');
      }

      if (model.bestFit) {
        xmlStream.addAttribute('bestFit', '1');
      }

      if (model.outlineLevel) {
        xmlStream.addAttribute('outlineLevel', model.outlineLevel);
      }

      if (model.collapsed) {
        xmlStream.addAttribute('collapsed', '1');
      }

      xmlStream.addAttribute('customWidth', '1');
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'col') {
        var model = this.model = {
          min: parseInt(node.attributes.min || '0', 10),
          max: parseInt(node.attributes.max || '0', 10),
          width: node.attributes.width === undefined ? undefined : parseFloat(node.attributes.width || '0')
        };

        if (node.attributes.style) {
          model.styleId = parseInt(node.attributes.style, 10);
        }

        if (node.attributes.hidden === true || node.attributes.hidden === 'true' || node.attributes.hidden === 1 || node.attributes.hidden === '1') {
          model.hidden = true;
        }

        if (node.attributes.bestFit) {
          model.bestFit = true;
        }

        if (node.attributes.outlineLevel) {
          model.outlineLevel = parseInt(node.attributes.outlineLevel, 10);
        }

        if (node.attributes.collapsed) {
          model.collapsed = true;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      // reconcile column styles
      if (model.styleId) {
        model.style = options.styles.getStyleModel(model.styleId);
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'col';
    }
  }]);

  return ColXform;
}(BaseXform);

module.exports = ColXform;

},{"../base-xform":31}],92:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _ = require('../../../utils/under-dash');

var utils = require('../../../utils/utils');

var colCache = require('../../../utils/col-cache');

var BaseXform = require('../base-xform');

var Range = require('../../../doc/range');

function assign(definedName, attributes, name, defaultValue) {
  var value = attributes[name];

  if (value !== undefined) {
    definedName[name] = value;
  } else if (defaultValue !== undefined) {
    definedName[name] = defaultValue;
  }
}

function parseBool(value) {
  switch (value) {
    case '1':
    case 'true':
      return true;

    default:
      return false;
  }
}

function assignBool(definedName, attributes, name, defaultValue) {
  var value = attributes[name];

  if (value !== undefined) {
    definedName[name] = parseBool(value);
  } else if (defaultValue !== undefined) {
    definedName[name] = defaultValue;
  }
}

function optimiseDataValidations(model) {
  // Squeeze alike data validations together into rectangular ranges
  // to reduce file size and speed up Excel load time
  var dvList = _.map(model, function (dataValidation, address) {
    return {
      address: address,
      dataValidation: dataValidation,
      marked: false
    };
  }).sort(function (a, b) {
    return _.strcmp(a.address, b.address);
  });

  var dvMap = _.keyBy(dvList, 'address');

  var matchCol = function matchCol(addr, height, col) {
    for (var i = 0; i < height; i++) {
      var otherAddress = colCache.encodeAddress(addr.row + i, col);

      if (!model[otherAddress] || !_.isEqual(model[addr.address], model[otherAddress])) {
        return false;
      }
    }

    return true;
  };

  return dvList.map(function (dv) {
    if (!dv.marked) {
      var addr = colCache.decodeEx(dv.address);

      if (addr.dimensions) {
        dvMap[addr.dimensions].marked = true;
        return _objectSpread(_objectSpread({}, dv.dataValidation), {}, {
          sqref: dv.address
        });
      } // iterate downwards - finding matching cells


      var height = 1;
      var otherAddress = colCache.encodeAddress(addr.row + height, addr.col);

      while (model[otherAddress] && _.isEqual(dv.dataValidation, model[otherAddress])) {
        height++;
        otherAddress = colCache.encodeAddress(addr.row + height, addr.col);
      } // iterate rightwards...


      var width = 1;

      while (matchCol(addr, height, addr.col + width)) {
        width++;
      } // mark all included addresses


      for (var i = 0; i < height; i++) {
        for (var j = 0; j < width; j++) {
          otherAddress = colCache.encodeAddress(addr.row + i, addr.col + j);
          dvMap[otherAddress].marked = true;
        }
      }

      if (height > 1 || width > 1) {
        var bottom = addr.row + (height - 1);
        var right = addr.col + (width - 1);
        return _objectSpread(_objectSpread({}, dv.dataValidation), {}, {
          sqref: "".concat(dv.address, ":").concat(colCache.encodeAddress(bottom, right))
        });
      }

      return _objectSpread(_objectSpread({}, dv.dataValidation), {}, {
        sqref: dv.address
      });
    }

    return null;
  }).filter(Boolean);
}

var DataValidationsXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(DataValidationsXform, _BaseXform);

  var _super = _createSuper(DataValidationsXform);

  function DataValidationsXform() {
    _classCallCheck(this, DataValidationsXform);

    return _super.apply(this, arguments);
  }

  _createClass(DataValidationsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var optimizedModel = optimiseDataValidations(model);

      if (optimizedModel.length) {
        xmlStream.openNode('dataValidations', {
          count: optimizedModel.length
        });
        optimizedModel.forEach(function (value) {
          xmlStream.openNode('dataValidation');

          if (value.type !== 'any') {
            xmlStream.addAttribute('type', value.type);

            if (value.operator && value.type !== 'list' && value.operator !== 'between') {
              xmlStream.addAttribute('operator', value.operator);
            }

            if (value.allowBlank) {
              xmlStream.addAttribute('allowBlank', '1');
            }
          }

          if (value.showInputMessage) {
            xmlStream.addAttribute('showInputMessage', '1');
          }

          if (value.promptTitle) {
            xmlStream.addAttribute('promptTitle', value.promptTitle);
          }

          if (value.prompt) {
            xmlStream.addAttribute('prompt', value.prompt);
          }

          if (value.showErrorMessage) {
            xmlStream.addAttribute('showErrorMessage', '1');
          }

          if (value.errorStyle) {
            xmlStream.addAttribute('errorStyle', value.errorStyle);
          }

          if (value.errorTitle) {
            xmlStream.addAttribute('errorTitle', value.errorTitle);
          }

          if (value.error) {
            xmlStream.addAttribute('error', value.error);
          }

          xmlStream.addAttribute('sqref', value.sqref);
          (value.formulae || []).forEach(function (formula, index) {
            xmlStream.openNode("formula".concat(index + 1));

            if (value.type === 'date') {
              xmlStream.writeText(utils.dateToExcel(new Date(formula)));
            } else {
              xmlStream.writeText(formula);
            }

            xmlStream.closeNode();
          });
          xmlStream.closeNode();
        });
        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'dataValidations':
          this.model = {};
          return true;

        case 'dataValidation':
          {
            this._address = node.attributes.sqref;
            var dataValidation = {
              type: node.attributes.type || 'any',
              formulae: []
            };

            if (node.attributes.type) {
              assignBool(dataValidation, node.attributes, 'allowBlank');
            }

            assignBool(dataValidation, node.attributes, 'showInputMessage');
            assignBool(dataValidation, node.attributes, 'showErrorMessage');

            switch (dataValidation.type) {
              case 'any':
              case 'list':
              case 'custom':
                break;

              default:
                assign(dataValidation, node.attributes, 'operator', 'between');
                break;
            }

            assign(dataValidation, node.attributes, 'promptTitle');
            assign(dataValidation, node.attributes, 'prompt');
            assign(dataValidation, node.attributes, 'errorStyle');
            assign(dataValidation, node.attributes, 'errorTitle');
            assign(dataValidation, node.attributes, 'error');
            this._dataValidation = dataValidation;
            return true;
          }

        case 'formula1':
        case 'formula2':
          this._formula = [];
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this._formula) {
        this._formula.push(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      var _this = this;

      switch (name) {
        case 'dataValidations':
          return false;

        case 'dataValidation':
          {
            if (!this._dataValidation.formulae || !this._dataValidation.formulae.length) {
              delete this._dataValidation.formulae;
              delete this._dataValidation.operator;
            } // The four known cases: 1. E4:L9 N4:U9  2.E4 L9  3. N4:U9  4. E4


            var list = this._address.split(/\s+/g) || [];
            list.forEach(function (addr) {
              if (addr.includes(':')) {
                var range = new Range(addr);
                range.forEachAddress(function (address) {
                  _this.model[address] = _this._dataValidation;
                });
              } else {
                _this.model[addr] = _this._dataValidation;
              }
            });
            return true;
          }

        case 'formula1':
        case 'formula2':
          {
            var formula = this._formula.join('');

            switch (this._dataValidation.type) {
              case 'whole':
              case 'textLength':
                formula = parseInt(formula, 10);
                break;

              case 'decimal':
                formula = parseFloat(formula);
                break;

              case 'date':
                formula = utils.excelToDate(parseFloat(formula));
                break;

              default:
                break;
            }

            this._dataValidation.formulae.push(formula);

            this._formula = undefined;
            return true;
          }

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'dataValidations';
    }
  }]);

  return DataValidationsXform;
}(BaseXform);

module.exports = DataValidationsXform;

},{"../../../doc/range":10,"../../../utils/col-cache":19,"../../../utils/under-dash":25,"../../../utils/utils":26,"../base-xform":31}],93:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var DimensionXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(DimensionXform, _BaseXform);

  var _super = _createSuper(DimensionXform);

  function DimensionXform() {
    _classCallCheck(this, DimensionXform);

    return _super.apply(this, arguments);
  }

  _createClass(DimensionXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.leafNode('dimension', {
          ref: model
        });
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'dimension') {
        this.model = node.attributes.ref;
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'dimension';
    }
  }]);

  return DimensionXform;
}(BaseXform);

module.exports = DimensionXform;

},{"../base-xform":31}],94:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var DrawingXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(DrawingXform, _BaseXform);

  var _super = _createSuper(DrawingXform);

  function DrawingXform() {
    _classCallCheck(this, DrawingXform);

    return _super.apply(this, arguments);
  }

  _createClass(DrawingXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.leafNode(this.tag, {
          'r:id': model.rId
        });
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            rId: node.attributes['r:id']
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'drawing';
    }
  }]);

  return DrawingXform;
}(BaseXform);

module.exports = DrawingXform;

},{"../base-xform":31}],95:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/* eslint-disable max-classes-per-file */
var CompositeXform = require('../composite-xform');

var ConditionalFormattingsExt = require('./cf-ext/conditional-formattings-ext-xform');

var ExtXform = /*#__PURE__*/function (_CompositeXform) {
  _inherits(ExtXform, _CompositeXform);

  var _super = _createSuper(ExtXform);

  function ExtXform() {
    var _this;

    _classCallCheck(this, ExtXform);

    _this = _super.call(this);
    _this.map = {
      'x14:conditionalFormattings': _this.conditionalFormattings = new ConditionalFormattingsExt()
    };
    return _this;
  }

  _createClass(ExtXform, [{
    key: "hasContent",
    value: function hasContent(model) {
      return this.conditionalFormattings.hasContent(model.conditionalFormattings);
    }
  }, {
    key: "prepare",
    value: function prepare(model, options) {
      this.conditionalFormattings.prepare(model.conditionalFormattings, options);
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('ext', {
        uri: '{78C0D931-6437-407d-A8EE-F0AAD7539E65}',
        'xmlns:x14': 'http://schemas.microsoft.com/office/spreadsheetml/2009/9/main'
      });
      this.conditionalFormattings.render(xmlStream, model.conditionalFormattings);
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel() {
      return {};
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      this.model[name] = parser.model;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'ext';
    }
  }]);

  return ExtXform;
}(CompositeXform);

var ExtLstXform = /*#__PURE__*/function (_CompositeXform2) {
  _inherits(ExtLstXform, _CompositeXform2);

  var _super2 = _createSuper(ExtLstXform);

  function ExtLstXform() {
    var _this2;

    _classCallCheck(this, ExtLstXform);

    _this2 = _super2.call(this);
    _this2.map = {
      ext: _this2.ext = new ExtXform()
    };
    return _this2;
  }

  _createClass(ExtLstXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      this.ext.prepare(model, options);
    }
  }, {
    key: "hasContent",
    value: function hasContent(model) {
      return this.ext.hasContent(model);
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      if (!this.hasContent(model)) {
        return;
      }

      xmlStream.openNode('extLst');
      this.ext.render(xmlStream, model);
      xmlStream.closeNode();
    }
  }, {
    key: "createNewModel",
    value: function createNewModel() {
      return {};
    }
  }, {
    key: "onParserClose",
    value: function onParserClose(name, parser) {
      Object.assign(this.model, parser.model);
    }
  }, {
    key: "tag",
    get: function get() {
      return 'extLst';
    }
  }]);

  return ExtLstXform;
}(CompositeXform);

module.exports = ExtLstXform;

},{"../composite-xform":47,"./cf-ext/conditional-formattings-ext-xform":77}],96:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var HeaderFooterXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(HeaderFooterXform, _BaseXform);

  var _super = _createSuper(HeaderFooterXform);

  function HeaderFooterXform() {
    _classCallCheck(this, HeaderFooterXform);

    return _super.apply(this, arguments);
  }

  _createClass(HeaderFooterXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.addRollback();
        var createTag = false;
        xmlStream.openNode('headerFooter');

        if (model.differentFirst) {
          xmlStream.addAttribute('differentFirst', '1');
          createTag = true;
        }

        if (model.differentOddEven) {
          xmlStream.addAttribute('differentOddEven', '1');
          createTag = true;
        }

        if (model.oddHeader && typeof model.oddHeader === 'string') {
          xmlStream.leafNode('oddHeader', null, model.oddHeader);
          createTag = true;
        }

        if (model.oddFooter && typeof model.oddFooter === 'string') {
          xmlStream.leafNode('oddFooter', null, model.oddFooter);
          createTag = true;
        }

        if (model.evenHeader && typeof model.evenHeader === 'string') {
          xmlStream.leafNode('evenHeader', null, model.evenHeader);
          createTag = true;
        }

        if (model.evenFooter && typeof model.evenFooter === 'string') {
          xmlStream.leafNode('evenFooter', null, model.evenFooter);
          createTag = true;
        }

        if (model.firstHeader && typeof model.firstHeader === 'string') {
          xmlStream.leafNode('firstHeader', null, model.firstHeader);
          createTag = true;
        }

        if (model.firstFooter && typeof model.firstFooter === 'string') {
          xmlStream.leafNode('firstFooter', null, model.firstFooter);
          createTag = true;
        }

        if (createTag) {
          xmlStream.closeNode();
          xmlStream.commit();
        } else {
          xmlStream.rollback();
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'headerFooter':
          this.model = {};

          if (node.attributes.differentFirst) {
            this.model.differentFirst = parseInt(node.attributes.differentFirst, 0) === 1;
          }

          if (node.attributes.differentOddEven) {
            this.model.differentOddEven = parseInt(node.attributes.differentOddEven, 0) === 1;
          }

          return true;

        case 'oddHeader':
          this.currentNode = 'oddHeader';
          return true;

        case 'oddFooter':
          this.currentNode = 'oddFooter';
          return true;

        case 'evenHeader':
          this.currentNode = 'evenHeader';
          return true;

        case 'evenFooter':
          this.currentNode = 'evenFooter';
          return true;

        case 'firstHeader':
          this.currentNode = 'firstHeader';
          return true;

        case 'firstFooter':
          this.currentNode = 'firstFooter';
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      switch (this.currentNode) {
        case 'oddHeader':
          this.model.oddHeader = text;
          break;

        case 'oddFooter':
          this.model.oddFooter = text;
          break;

        case 'evenHeader':
          this.model.evenHeader = text;
          break;

        case 'evenFooter':
          this.model.evenFooter = text;
          break;

        case 'firstHeader':
          this.model.firstHeader = text;
          break;

        case 'firstFooter':
          this.model.firstFooter = text;
          break;

        default:
          break;
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      switch (this.currentNode) {
        case 'oddHeader':
        case 'oddFooter':
        case 'evenHeader':
        case 'evenFooter':
        case 'firstHeader':
        case 'firstFooter':
          this.currentNode = undefined;
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'headerFooter';
    }
  }]);

  return HeaderFooterXform;
}(BaseXform);

module.exports = HeaderFooterXform;

},{"../base-xform":31}],97:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var HyperlinkXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(HyperlinkXform, _BaseXform);

  var _super = _createSuper(HyperlinkXform);

  function HyperlinkXform() {
    _classCallCheck(this, HyperlinkXform);

    return _super.apply(this, arguments);
  }

  _createClass(HyperlinkXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('hyperlink', {
        ref: model.address,
        'r:id': model.rId,
        tooltip: model.tooltip
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'hyperlink') {
        this.model = {
          address: node.attributes.ref,
          rId: node.attributes['r:id'],
          tooltip: node.attributes.tooltip
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'hyperlink';
    }
  }]);

  return HyperlinkXform;
}(BaseXform);

module.exports = HyperlinkXform;

},{"../base-xform":31}],98:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var MergeCellXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(MergeCellXform, _BaseXform);

  var _super = _createSuper(MergeCellXform);

  function MergeCellXform() {
    _classCallCheck(this, MergeCellXform);

    return _super.apply(this, arguments);
  }

  _createClass(MergeCellXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('mergeCell', {
        ref: model
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'mergeCell') {
        this.model = node.attributes.ref;
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'mergeCell';
    }
  }]);

  return MergeCellXform;
}(BaseXform);

module.exports = MergeCellXform;

},{"../base-xform":31}],99:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _ = require('../../../utils/under-dash');

var Range = require('../../../doc/range');

var colCache = require('../../../utils/col-cache');

var Enums = require('../../../doc/enums');

var Merges = /*#__PURE__*/function () {
  function Merges() {
    _classCallCheck(this, Merges);

    // optional mergeCells is array of ranges (like the xml)
    this.merges = {};
  }

  _createClass(Merges, [{
    key: "add",
    value: function add(merge) {
      // merge is {address, master}
      if (this.merges[merge.master]) {
        this.merges[merge.master].expandToAddress(merge.address);
      } else {
        var range = "".concat(merge.master, ":").concat(merge.address);
        this.merges[merge.master] = new Range(range);
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(mergeCells, rows) {
      // reconcile merge list with merge cells
      _.each(mergeCells, function (merge) {
        var dimensions = colCache.decode(merge);

        for (var i = dimensions.top; i <= dimensions.bottom; i++) {
          var row = rows[i - 1];

          for (var j = dimensions.left; j <= dimensions.right; j++) {
            var cell = row.cells[j - 1];

            if (!cell) {
              // nulls are not included in document - so if master cell has no value - add a null one here
              row.cells[j] = {
                type: Enums.ValueType.Null,
                address: colCache.encodeAddress(i, j)
              };
            } else if (cell.type === Enums.ValueType.Merge) {
              cell.master = dimensions.tl;
            }
          }
        }
      });
    }
  }, {
    key: "getMasterAddress",
    value: function getMasterAddress(address) {
      // if address has been merged, return its master's address. Assumes reconcile has been called
      var range = this.hash[address];
      return range && range.tl;
    }
  }, {
    key: "mergeCells",
    get: function get() {
      return _.map(this.merges, function (merge) {
        return merge.range;
      });
    }
  }]);

  return Merges;
}();

module.exports = Merges;

},{"../../../doc/enums":7,"../../../doc/range":10,"../../../utils/col-cache":19,"../../../utils/under-dash":25}],100:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var isDefined = function isDefined(attr) {
  return typeof attr !== 'undefined';
};

var OutlinePropertiesXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(OutlinePropertiesXform, _BaseXform);

  var _super = _createSuper(OutlinePropertiesXform);

  function OutlinePropertiesXform() {
    _classCallCheck(this, OutlinePropertiesXform);

    return _super.apply(this, arguments);
  }

  _createClass(OutlinePropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model && (isDefined(model.summaryBelow) || isDefined(model.summaryRight))) {
        xmlStream.leafNode(this.tag, {
          summaryBelow: isDefined(model.summaryBelow) ? Number(model.summaryBelow) : undefined,
          summaryRight: isDefined(model.summaryRight) ? Number(model.summaryRight) : undefined
        });
        return true;
      }

      return false;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        this.model = {
          summaryBelow: isDefined(node.attributes.summaryBelow) ? Boolean(Number(node.attributes.summaryBelow)) : undefined,
          summaryRight: isDefined(node.attributes.summaryRight) ? Boolean(Number(node.attributes.summaryRight)) : undefined
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'outlinePr';
    }
  }]);

  return OutlinePropertiesXform;
}(BaseXform);

module.exports = OutlinePropertiesXform;

},{"../base-xform":31}],101:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var PageBreaksXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(PageBreaksXform, _BaseXform);

  var _super = _createSuper(PageBreaksXform);

  function PageBreaksXform() {
    _classCallCheck(this, PageBreaksXform);

    return _super.apply(this, arguments);
  }

  _createClass(PageBreaksXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('brk', model);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'brk') {
        this.model = node.attributes.ref;
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'brk';
    }
  }]);

  return PageBreaksXform;
}(BaseXform);

module.exports = PageBreaksXform;

},{"../base-xform":31}],102:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform');

var PageMarginsXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(PageMarginsXform, _BaseXform);

  var _super = _createSuper(PageMarginsXform);

  function PageMarginsXform() {
    _classCallCheck(this, PageMarginsXform);

    return _super.apply(this, arguments);
  }

  _createClass(PageMarginsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        var attributes = {
          left: model.left,
          right: model.right,
          top: model.top,
          bottom: model.bottom,
          header: model.header,
          footer: model.footer
        };

        if (_.some(attributes, function (value) {
          return value !== undefined;
        })) {
          xmlStream.leafNode(this.tag, attributes);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            left: parseFloat(node.attributes.left || 0.7),
            right: parseFloat(node.attributes.right || 0.7),
            top: parseFloat(node.attributes.top || 0.75),
            bottom: parseFloat(node.attributes.bottom || 0.75),
            header: parseFloat(node.attributes.header || 0.3),
            footer: parseFloat(node.attributes.footer || 0.3)
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'pageMargins';
    }
  }]);

  return PageMarginsXform;
}(BaseXform);

module.exports = PageMarginsXform;

},{"../../../utils/under-dash":25,"../base-xform":31}],103:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var PageSetupPropertiesXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(PageSetupPropertiesXform, _BaseXform);

  var _super = _createSuper(PageSetupPropertiesXform);

  function PageSetupPropertiesXform() {
    _classCallCheck(this, PageSetupPropertiesXform);

    return _super.apply(this, arguments);
  }

  _createClass(PageSetupPropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model && model.fitToPage) {
        xmlStream.leafNode(this.tag, {
          fitToPage: model.fitToPage ? '1' : undefined
        });
        return true;
      }

      return false;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        this.model = {
          fitToPage: node.attributes.fitToPage === '1'
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'pageSetUpPr';
    }
  }]);

  return PageSetupPropertiesXform;
}(BaseXform);

module.exports = PageSetupPropertiesXform;

},{"../base-xform":31}],104:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform');

function booleanToXml(model) {
  return model ? '1' : undefined;
}

function pageOrderToXml(model) {
  switch (model) {
    case 'overThenDown':
      return model;

    default:
      return undefined;
  }
}

function cellCommentsToXml(model) {
  switch (model) {
    case 'atEnd':
    case 'asDisplyed':
      return model;

    default:
      return undefined;
  }
}

function errorsToXml(model) {
  switch (model) {
    case 'dash':
    case 'blank':
    case 'NA':
      return model;

    default:
      return undefined;
  }
}

function pageSizeToModel(value) {
  return value !== undefined ? parseInt(value, 10) : undefined;
}

var PageSetupXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(PageSetupXform, _BaseXform);

  var _super = _createSuper(PageSetupXform);

  function PageSetupXform() {
    _classCallCheck(this, PageSetupXform);

    return _super.apply(this, arguments);
  }

  _createClass(PageSetupXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        var attributes = {
          paperSize: model.paperSize,
          orientation: model.orientation,
          horizontalDpi: model.horizontalDpi,
          verticalDpi: model.verticalDpi,
          pageOrder: pageOrderToXml(model.pageOrder),
          blackAndWhite: booleanToXml(model.blackAndWhite),
          draft: booleanToXml(model.draft),
          cellComments: cellCommentsToXml(model.cellComments),
          errors: errorsToXml(model.errors),
          scale: model.scale,
          fitToWidth: model.fitToWidth,
          fitToHeight: model.fitToHeight,
          firstPageNumber: model.firstPageNumber,
          useFirstPageNumber: booleanToXml(model.firstPageNumber),
          usePrinterDefaults: booleanToXml(model.usePrinterDefaults),
          copies: model.copies
        };

        if (_.some(attributes, function (value) {
          return value !== undefined;
        })) {
          xmlStream.leafNode(this.tag, attributes);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            paperSize: pageSizeToModel(node.attributes.paperSize),
            orientation: node.attributes.orientation || 'portrait',
            horizontalDpi: parseInt(node.attributes.horizontalDpi || '4294967295', 10),
            verticalDpi: parseInt(node.attributes.verticalDpi || '4294967295', 10),
            pageOrder: node.attributes.pageOrder || 'downThenOver',
            blackAndWhite: node.attributes.blackAndWhite === '1',
            draft: node.attributes.draft === '1',
            cellComments: node.attributes.cellComments || 'None',
            errors: node.attributes.errors || 'displayed',
            scale: parseInt(node.attributes.scale || '100', 10),
            fitToWidth: parseInt(node.attributes.fitToWidth || '1', 10),
            fitToHeight: parseInt(node.attributes.fitToHeight || '1', 10),
            firstPageNumber: parseInt(node.attributes.firstPageNumber || '1', 10),
            useFirstPageNumber: node.attributes.useFirstPageNumber === '1',
            usePrinterDefaults: node.attributes.usePrinterDefaults === '1',
            copies: parseInt(node.attributes.copies || '1', 10)
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'pageSetup';
    }
  }]);

  return PageSetupXform;
}(BaseXform);

module.exports = PageSetupXform;

},{"../../../utils/under-dash":25,"../base-xform":31}],105:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var PictureXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(PictureXform, _BaseXform);

  var _super = _createSuper(PictureXform);

  function PictureXform() {
    _classCallCheck(this, PictureXform);

    return _super.apply(this, arguments);
  }

  _createClass(PictureXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.leafNode(this.tag, {
          'r:id': model.rId
        });
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            rId: node.attributes['r:id']
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'picture';
    }
  }]);

  return PictureXform;
}(BaseXform);

module.exports = PictureXform;

},{"../base-xform":31}],106:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform');

function booleanToXml(model) {
  return model ? '1' : undefined;
}

var PrintOptionsXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(PrintOptionsXform, _BaseXform);

  var _super = _createSuper(PrintOptionsXform);

  function PrintOptionsXform() {
    _classCallCheck(this, PrintOptionsXform);

    return _super.apply(this, arguments);
  }

  _createClass(PrintOptionsXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        var attributes = {
          headings: booleanToXml(model.showRowColHeaders),
          gridLines: booleanToXml(model.showGridLines),
          horizontalCentered: booleanToXml(model.horizontalCentered),
          verticalCentered: booleanToXml(model.verticalCentered)
        };

        if (_.some(attributes, function (value) {
          return value !== undefined;
        })) {
          xmlStream.leafNode(this.tag, attributes);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            showRowColHeaders: node.attributes.headings === '1',
            showGridLines: node.attributes.gridLines === '1',
            horizontalCentered: node.attributes.horizontalCentered === '1',
            verticalCentered: node.attributes.verticalCentered === '1'
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'printOptions';
    }
  }]);

  return PrintOptionsXform;
}(BaseXform);

module.exports = PrintOptionsXform;

},{"../../../utils/under-dash":25,"../base-xform":31}],107:[function(require,module,exports){
'use strict';

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var PageBreaksXform = require('./page-breaks-xform');

var ListXform = require('../list-xform');

var RowBreaksXform = /*#__PURE__*/function (_ListXform) {
  _inherits(RowBreaksXform, _ListXform);

  var _super = _createSuper(RowBreaksXform);

  function RowBreaksXform() {
    _classCallCheck(this, RowBreaksXform);

    var options = {
      tag: 'rowBreaks',
      count: true,
      childXform: new PageBreaksXform()
    };
    return _super.call(this, options);
  } // get tag() { return 'rowBreaks'; }


  _createClass(RowBreaksXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model && model.length) {
        xmlStream.openNode(this.tag, this.$);

        if (this.count) {
          xmlStream.addAttribute(this.$count, model.length);
          xmlStream.addAttribute('manualBreakCount', model.length);
        }

        var childXform = this.childXform;
        model.forEach(function (childModel) {
          childXform.render(xmlStream, childModel);
        });
        xmlStream.closeNode();
      } else if (this.empty) {
        xmlStream.leafNode(this.tag);
      }
    }
  }]);

  return RowBreaksXform;
}(ListXform);

module.exports = RowBreaksXform;

},{"../list-xform":70,"./page-breaks-xform":101}],108:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var CellXform = require('./cell-xform');

var RowXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(RowXform, _BaseXform);

  var _super = _createSuper(RowXform);

  function RowXform(options) {
    var _this;

    _classCallCheck(this, RowXform);

    _this = _super.call(this);
    _this.maxItems = options && options.maxItems;
    _this.map = {
      c: new CellXform()
    };
    return _this;
  }

  _createClass(RowXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      var styleId = options.styles.addStyleModel(model.style);

      if (styleId) {
        model.styleId = styleId;
      }

      var cellXform = this.map.c;
      model.cells.forEach(function (cellModel) {
        cellXform.prepare(cellModel, options);
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model, options) {
      xmlStream.openNode('row');
      xmlStream.addAttribute('r', model.number);

      if (model.height) {
        xmlStream.addAttribute('ht', model.height);
        xmlStream.addAttribute('customHeight', '1');
      }

      if (model.hidden) {
        xmlStream.addAttribute('hidden', '1');
      }

      if (model.min > 0 && model.max > 0 && model.min <= model.max) {
        xmlStream.addAttribute('spans', "".concat(model.min, ":").concat(model.max));
      }

      if (model.styleId) {
        xmlStream.addAttribute('s', model.styleId);
        xmlStream.addAttribute('customFormat', '1');
      }

      xmlStream.addAttribute('x14ac:dyDescent', '0.25');

      if (model.outlineLevel) {
        xmlStream.addAttribute('outlineLevel', model.outlineLevel);
      }

      if (model.collapsed) {
        xmlStream.addAttribute('collapsed', '1');
      }

      var cellXform = this.map.c;
      model.cells.forEach(function (cellModel) {
        cellXform.render(xmlStream, cellModel, options);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (node.name === 'row') {
        this.numRowsSeen += 1;
        var spans = node.attributes.spans ? node.attributes.spans.split(':').map(function (span) {
          return parseInt(span, 10);
        }) : [undefined, undefined];
        var model = this.model = {
          number: parseInt(node.attributes.r, 10),
          min: spans[0],
          max: spans[1],
          cells: []
        };

        if (node.attributes.s) {
          model.styleId = parseInt(node.attributes.s, 10);
        }

        if (node.attributes.hidden === true || node.attributes.hidden === 'true' || node.attributes.hidden === 1 || node.attributes.hidden === '1') {
          model.hidden = true;
        }

        if (node.attributes.bestFit) {
          model.bestFit = true;
        }

        if (node.attributes.ht) {
          model.height = parseFloat(node.attributes.ht);
        }

        if (node.attributes.outlineLevel) {
          model.outlineLevel = parseInt(node.attributes.outlineLevel, 10);
        }

        if (node.attributes.collapsed) {
          model.collapsed = true;
        }

        return true;
      }

      this.parser = this.map[node.name];

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.cells.push(this.parser.model);

          if (this.maxItems && this.model.cells.length > this.maxItems) {
            throw new Error("Max column count (".concat(this.maxItems, ") exceeded"));
          }

          this.parser = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      model.style = model.styleId ? options.styles.getStyleModel(model.styleId) : {};

      if (model.styleId !== undefined) {
        model.styleId = undefined;
      }

      var cellXform = this.map.c;
      model.cells.forEach(function (cellModel) {
        cellXform.reconcile(cellModel, options);
      });
    }
  }, {
    key: "tag",
    get: function get() {
      return 'row';
    }
  }]);

  return RowXform;
}(BaseXform);

module.exports = RowXform;

},{"../base-xform":31,"./cell-xform":72}],109:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform');

var SheetFormatPropertiesXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(SheetFormatPropertiesXform, _BaseXform);

  var _super = _createSuper(SheetFormatPropertiesXform);

  function SheetFormatPropertiesXform() {
    _classCallCheck(this, SheetFormatPropertiesXform);

    return _super.apply(this, arguments);
  }

  _createClass(SheetFormatPropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        var attributes = {
          defaultRowHeight: model.defaultRowHeight,
          outlineLevelRow: model.outlineLevelRow,
          outlineLevelCol: model.outlineLevelCol,
          'x14ac:dyDescent': model.dyDescent
        };

        if (model.defaultColWidth) {
          attributes.defaultColWidth = model.defaultColWidth;
        } // default value for 'defaultRowHeight' is 15, this should not be 'custom'


        if (!model.defaultRowHeight || model.defaultRowHeight !== 15) {
          attributes.customHeight = '1';
        }

        if (_.some(attributes, function (value) {
          return value !== undefined;
        })) {
          xmlStream.leafNode('sheetFormatPr', attributes);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'sheetFormatPr') {
        this.model = {
          defaultRowHeight: parseFloat(node.attributes.defaultRowHeight || '0'),
          dyDescent: parseFloat(node.attributes['x14ac:dyDescent'] || '0'),
          outlineLevelRow: parseInt(node.attributes.outlineLevelRow || '0', 10),
          outlineLevelCol: parseInt(node.attributes.outlineLevelCol || '0', 10)
        };

        if (node.attributes.defaultColWidth) {
          this.model.defaultColWidth = parseFloat(node.attributes.defaultColWidth);
        }

        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'sheetFormatPr';
    }
  }]);

  return SheetFormatPropertiesXform;
}(BaseXform);

module.exports = SheetFormatPropertiesXform;

},{"../../../utils/under-dash":25,"../base-xform":31}],110:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var ColorXform = require('../style/color-xform');

var PageSetupPropertiesXform = require('./page-setup-properties-xform');

var OutlinePropertiesXform = require('./outline-properties-xform');

var SheetPropertiesXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(SheetPropertiesXform, _BaseXform);

  var _super = _createSuper(SheetPropertiesXform);

  function SheetPropertiesXform() {
    var _this;

    _classCallCheck(this, SheetPropertiesXform);

    _this = _super.call(this);
    _this.map = {
      tabColor: new ColorXform('tabColor'),
      pageSetUpPr: new PageSetupPropertiesXform(),
      outlinePr: new OutlinePropertiesXform()
    };
    return _this;
  }

  _createClass(SheetPropertiesXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.addRollback();
        xmlStream.openNode('sheetPr');
        var inner = false;
        inner = this.map.tabColor.render(xmlStream, model.tabColor) || inner;
        inner = this.map.pageSetUpPr.render(xmlStream, model.pageSetup) || inner;
        inner = this.map.outlinePr.render(xmlStream, model.outlineProperties) || inner;

        if (inner) {
          xmlStream.closeNode();
          xmlStream.commit();
        } else {
          xmlStream.rollback();
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (node.name === this.tag) {
        this.reset();
        return true;
      }

      if (this.map[node.name]) {
        this.parser = this.map[node.name];
        this.parser.parseOpen(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
        return true;
      }

      return false;
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      if (this.map.tabColor.model || this.map.pageSetUpPr.model || this.map.outlinePr.model) {
        this.model = {};

        if (this.map.tabColor.model) {
          this.model.tabColor = this.map.tabColor.model;
        }

        if (this.map.pageSetUpPr.model) {
          this.model.pageSetup = this.map.pageSetUpPr.model;
        }

        if (this.map.outlinePr.model) {
          this.model.outlineProperties = this.map.outlinePr.model;
        }
      } else {
        this.model = null;
      }

      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'sheetPr';
    }
  }]);

  return SheetPropertiesXform;
}(BaseXform);

module.exports = SheetPropertiesXform;

},{"../base-xform":31,"../style/color-xform":127,"./outline-properties-xform":100,"./page-setup-properties-xform":103}],111:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform');

function booleanToXml(model, value) {
  return model ? value : undefined;
}

function xmlToBoolean(value, equals) {
  return value === equals ? true : undefined;
}

var SheetProtectionXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(SheetProtectionXform, _BaseXform);

  var _super = _createSuper(SheetProtectionXform);

  function SheetProtectionXform() {
    _classCallCheck(this, SheetProtectionXform);

    return _super.apply(this, arguments);
  }

  _createClass(SheetProtectionXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        var attributes = {
          sheet: booleanToXml(model.sheet, '1'),
          selectLockedCells: model.selectLockedCells === false ? '1' : undefined,
          selectUnlockedCells: model.selectUnlockedCells === false ? '1' : undefined,
          formatCells: booleanToXml(model.formatCells, '0'),
          formatColumns: booleanToXml(model.formatColumns, '0'),
          formatRows: booleanToXml(model.formatRows, '0'),
          insertColumns: booleanToXml(model.insertColumns, '0'),
          insertRows: booleanToXml(model.insertRows, '0'),
          insertHyperlinks: booleanToXml(model.insertHyperlinks, '0'),
          deleteColumns: booleanToXml(model.deleteColumns, '0'),
          deleteRows: booleanToXml(model.deleteRows, '0'),
          sort: booleanToXml(model.sort, '0'),
          autoFilter: booleanToXml(model.autoFilter, '0'),
          pivotTables: booleanToXml(model.pivotTables, '0')
        };

        if (model.sheet) {
          attributes.algorithmName = model.algorithmName;
          attributes.hashValue = model.hashValue;
          attributes.saltValue = model.saltValue;
          attributes.spinCount = model.spinCount;
          attributes.objects = booleanToXml(model.objects === false, '1');
          attributes.scenarios = booleanToXml(model.scenarios === false, '1');
        }

        if (_.some(attributes, function (value) {
          return value !== undefined;
        })) {
          xmlStream.leafNode(this.tag, attributes);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            sheet: xmlToBoolean(node.attributes.sheet, '1'),
            objects: node.attributes.objects === '1' ? false : undefined,
            scenarios: node.attributes.scenarios === '1' ? false : undefined,
            selectLockedCells: node.attributes.selectLockedCells === '1' ? false : undefined,
            selectUnlockedCells: node.attributes.selectUnlockedCells === '1' ? false : undefined,
            formatCells: xmlToBoolean(node.attributes.formatCells, '0'),
            formatColumns: xmlToBoolean(node.attributes.formatColumns, '0'),
            formatRows: xmlToBoolean(node.attributes.formatRows, '0'),
            insertColumns: xmlToBoolean(node.attributes.insertColumns, '0'),
            insertRows: xmlToBoolean(node.attributes.insertRows, '0'),
            insertHyperlinks: xmlToBoolean(node.attributes.insertHyperlinks, '0'),
            deleteColumns: xmlToBoolean(node.attributes.deleteColumns, '0'),
            deleteRows: xmlToBoolean(node.attributes.deleteRows, '0'),
            sort: xmlToBoolean(node.attributes.sort, '0'),
            autoFilter: xmlToBoolean(node.attributes.autoFilter, '0'),
            pivotTables: xmlToBoolean(node.attributes.pivotTables, '0')
          };

          if (node.attributes.algorithmName) {
            this.model.algorithmName = node.attributes.algorithmName;
            this.model.hashValue = node.attributes.hashValue;
            this.model.saltValue = node.attributes.saltValue;
            this.model.spinCount = parseInt(node.attributes.spinCount, 10);
          }

          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'sheetProtection';
    }
  }]);

  return SheetProtectionXform;
}(BaseXform);

module.exports = SheetProtectionXform;

},{"../../../utils/under-dash":25,"../base-xform":31}],112:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var colCache = require('../../../utils/col-cache');

var BaseXform = require('../base-xform');

var VIEW_STATES = {
  frozen: 'frozen',
  frozenSplit: 'frozen',
  split: 'split'
};

var SheetViewXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(SheetViewXform, _BaseXform);

  var _super = _createSuper(SheetViewXform);

  function SheetViewXform() {
    _classCallCheck(this, SheetViewXform);

    return _super.apply(this, arguments);
  }

  _createClass(SheetViewXform, [{
    key: "prepare",
    value: function prepare(model) {
      switch (model.state) {
        case 'frozen':
        case 'split':
          break;

        default:
          model.state = 'normal';
          break;
      }
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('sheetView', {
        workbookViewId: model.workbookViewId || 0
      });

      var add = function add(name, value, included) {
        if (included) {
          xmlStream.addAttribute(name, value);
        }
      };

      add('rightToLeft', '1', model.rightToLeft === true);
      add('tabSelected', '1', model.tabSelected);
      add('showRuler', '0', model.showRuler === false);
      add('showRowColHeaders', '0', model.showRowColHeaders === false);
      add('showGridLines', '0', model.showGridLines === false);
      add('zoomScale', model.zoomScale, model.zoomScale);
      add('zoomScaleNormal', model.zoomScaleNormal, model.zoomScaleNormal);
      add('view', model.style, model.style);
      var topLeftCell;
      var xSplit;
      var ySplit;
      var activePane;

      switch (model.state) {
        case 'frozen':
          xSplit = model.xSplit || 0;
          ySplit = model.ySplit || 0;
          topLeftCell = model.topLeftCell || colCache.getAddress(ySplit + 1, xSplit + 1).address;
          activePane = model.xSplit && model.ySplit && 'bottomRight' || model.xSplit && 'topRight' || 'bottomLeft';
          xmlStream.leafNode('pane', {
            xSplit: model.xSplit || undefined,
            ySplit: model.ySplit || undefined,
            topLeftCell: topLeftCell,
            activePane: activePane,
            state: 'frozen'
          });
          xmlStream.leafNode('selection', {
            pane: activePane,
            activeCell: model.activeCell,
            sqref: model.activeCell
          });
          break;

        case 'split':
          if (model.activePane === 'topLeft') {
            model.activePane = undefined;
          }

          xmlStream.leafNode('pane', {
            xSplit: model.xSplit || undefined,
            ySplit: model.ySplit || undefined,
            topLeftCell: model.topLeftCell,
            activePane: model.activePane
          });
          xmlStream.leafNode('selection', {
            pane: model.activePane,
            activeCell: model.activeCell,
            sqref: model.activeCell
          });
          break;

        case 'normal':
          if (model.activeCell) {
            xmlStream.leafNode('selection', {
              activeCell: model.activeCell,
              sqref: model.activeCell
            });
          }

          break;

        default:
          break;
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'sheetView':
          this.sheetView = {
            workbookViewId: parseInt(node.attributes.workbookViewId, 10),
            rightToLeft: node.attributes.rightToLeft === '1',
            tabSelected: node.attributes.tabSelected === '1',
            showRuler: !(node.attributes.showRuler === '0'),
            showRowColHeaders: !(node.attributes.showRowColHeaders === '0'),
            showGridLines: !(node.attributes.showGridLines === '0'),
            zoomScale: parseInt(node.attributes.zoomScale || '100', 10),
            zoomScaleNormal: parseInt(node.attributes.zoomScaleNormal || '100', 10),
            style: node.attributes.view
          };
          this.pane = undefined;
          this.selections = {};
          return true;

        case 'pane':
          this.pane = {
            xSplit: parseInt(node.attributes.xSplit || '0', 10),
            ySplit: parseInt(node.attributes.ySplit || '0', 10),
            topLeftCell: node.attributes.topLeftCell,
            activePane: node.attributes.activePane || 'topLeft',
            state: node.attributes.state
          };
          return true;

        case 'selection':
          {
            var name = node.attributes.pane || 'topLeft';
            this.selections[name] = {
              pane: name,
              activeCell: node.attributes.activeCell
            };
            return true;
          }

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      var model;
      var selection;

      switch (name) {
        case 'sheetView':
          if (this.sheetView && this.pane) {
            model = this.model = {
              workbookViewId: this.sheetView.workbookViewId,
              rightToLeft: this.sheetView.rightToLeft,
              state: VIEW_STATES[this.pane.state] || 'split',
              // split is default
              xSplit: this.pane.xSplit,
              ySplit: this.pane.ySplit,
              topLeftCell: this.pane.topLeftCell,
              showRuler: this.sheetView.showRuler,
              showRowColHeaders: this.sheetView.showRowColHeaders,
              showGridLines: this.sheetView.showGridLines,
              zoomScale: this.sheetView.zoomScale,
              zoomScaleNormal: this.sheetView.zoomScaleNormal
            };

            if (this.model.state === 'split') {
              model.activePane = this.pane.activePane;
            }

            selection = this.selections[this.pane.activePane];

            if (selection && selection.activeCell) {
              model.activeCell = selection.activeCell;
            }

            if (this.sheetView.style) {
              model.style = this.sheetView.style;
            }
          } else {
            model = this.model = {
              workbookViewId: this.sheetView.workbookViewId,
              rightToLeft: this.sheetView.rightToLeft,
              state: 'normal',
              showRuler: this.sheetView.showRuler,
              showRowColHeaders: this.sheetView.showRowColHeaders,
              showGridLines: this.sheetView.showGridLines,
              zoomScale: this.sheetView.zoomScale,
              zoomScaleNormal: this.sheetView.zoomScaleNormal
            };
            selection = this.selections.topLeft;

            if (selection && selection.activeCell) {
              model.activeCell = selection.activeCell;
            }

            if (this.sheetView.style) {
              model.style = this.sheetView.style;
            }
          }

          return false;

        default:
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile() {}
  }, {
    key: "tag",
    get: function get() {
      return 'sheetView';
    }
  }]);

  return SheetViewXform;
}(BaseXform);

module.exports = SheetViewXform;

},{"../../../utils/col-cache":19,"../base-xform":31}],113:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var TablePartXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(TablePartXform, _BaseXform);

  var _super = _createSuper(TablePartXform);

  function TablePartXform() {
    _classCallCheck(this, TablePartXform);

    return _super.apply(this, arguments);
  }

  _createClass(TablePartXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.leafNode(this.tag, {
          'r:id': model.rId
        });
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case this.tag:
          this.model = {
            rId: node.attributes['r:id']
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'tablePart';
    }
  }]);

  return TablePartXform;
}(BaseXform);

module.exports = TablePartXform;

},{"../base-xform":31}],114:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var _ = require('../../../utils/under-dash');

var colCache = require('../../../utils/col-cache');

var XmlStream = require('../../../utils/xml-stream');

var RelType = require('../../rel-type');

var Merges = require('./merges');

var BaseXform = require('../base-xform');

var ListXform = require('../list-xform');

var RowXform = require('./row-xform');

var ColXform = require('./col-xform');

var DimensionXform = require('./dimension-xform');

var HyperlinkXform = require('./hyperlink-xform');

var MergeCellXform = require('./merge-cell-xform');

var DataValidationsXform = require('./data-validations-xform');

var SheetPropertiesXform = require('./sheet-properties-xform');

var SheetFormatPropertiesXform = require('./sheet-format-properties-xform');

var SheetViewXform = require('./sheet-view-xform');

var SheetProtectionXform = require('./sheet-protection-xform');

var PageMarginsXform = require('./page-margins-xform');

var PageSetupXform = require('./page-setup-xform');

var PrintOptionsXform = require('./print-options-xform');

var AutoFilterXform = require('./auto-filter-xform');

var PictureXform = require('./picture-xform');

var DrawingXform = require('./drawing-xform');

var TablePartXform = require('./table-part-xform');

var RowBreaksXform = require('./row-breaks-xform');

var HeaderFooterXform = require('./header-footer-xform');

var ConditionalFormattingsXform = require('./cf/conditional-formattings-xform');

var ExtListXform = require('./ext-lst-xform');

var mergeRule = function mergeRule(rule, extRule) {
  Object.keys(extRule).forEach(function (key) {
    var value = rule[key];
    var extValue = extRule[key];

    if (value === undefined && extValue !== undefined) {
      rule[key] = extValue;
    }
  });
};

var mergeConditionalFormattings = function mergeConditionalFormattings(model, extModel) {
  // conditional formattings are rendered in worksheet.conditionalFormatting and also in
  // worksheet.extLst.ext.x14:conditionalFormattings
  // some (e.g. dataBar) are even spread across both!
  if (!extModel || !extModel.length) {
    return model;
  }

  if (!model || !model.length) {
    return extModel;
  } // index model rules by x14Id


  var cfMap = {};
  var ruleMap = {};
  model.forEach(function (cf) {
    cfMap[cf.ref] = cf;
    cf.rules.forEach(function (rule) {
      var x14Id = rule.x14Id;

      if (x14Id) {
        ruleMap[x14Id] = rule;
      }
    });
  });
  extModel.forEach(function (extCf) {
    extCf.rules.forEach(function (extRule) {
      var rule = ruleMap[extRule.x14Id];

      if (rule) {
        // merge with matching rule
        mergeRule(rule, extRule);
      } else if (cfMap[extCf.ref]) {
        // reuse existing cf ref
        cfMap[extCf.ref].rules.push(extRule);
      } else {
        // create new cf
        model.push({
          ref: extCf.ref,
          rules: [extRule]
        });
      }
    });
  }); // need to cope with rules in extModel that don't exist in model

  return model;
};

var WorkSheetXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(WorkSheetXform, _BaseXform);

  var _super = _createSuper(WorkSheetXform);

  function WorkSheetXform(options) {
    var _this;

    _classCallCheck(this, WorkSheetXform);

    _this = _super.call(this);

    var _ref = options || {},
        maxRows = _ref.maxRows,
        maxCols = _ref.maxCols;

    _this.map = {
      sheetPr: new SheetPropertiesXform(),
      dimension: new DimensionXform(),
      sheetViews: new ListXform({
        tag: 'sheetViews',
        count: false,
        childXform: new SheetViewXform()
      }),
      sheetFormatPr: new SheetFormatPropertiesXform(),
      cols: new ListXform({
        tag: 'cols',
        count: false,
        childXform: new ColXform()
      }),
      sheetData: new ListXform({
        tag: 'sheetData',
        count: false,
        empty: true,
        childXform: new RowXform({
          maxItems: maxCols
        }),
        maxItems: maxRows
      }),
      autoFilter: new AutoFilterXform(),
      mergeCells: new ListXform({
        tag: 'mergeCells',
        count: true,
        childXform: new MergeCellXform()
      }),
      rowBreaks: new RowBreaksXform(),
      hyperlinks: new ListXform({
        tag: 'hyperlinks',
        count: false,
        childXform: new HyperlinkXform()
      }),
      pageMargins: new PageMarginsXform(),
      dataValidations: new DataValidationsXform(),
      pageSetup: new PageSetupXform(),
      headerFooter: new HeaderFooterXform(),
      printOptions: new PrintOptionsXform(),
      picture: new PictureXform(),
      drawing: new DrawingXform(),
      sheetProtection: new SheetProtectionXform(),
      tableParts: new ListXform({
        tag: 'tableParts',
        count: true,
        childXform: new TablePartXform()
      }),
      conditionalFormatting: new ConditionalFormattingsXform(),
      extLst: new ExtListXform()
    };
    return _this;
  }

  _createClass(WorkSheetXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      var _this2 = this;

      options.merges = new Merges();
      model.hyperlinks = options.hyperlinks = [];
      model.comments = options.comments = [];
      options.formulae = {};
      options.siFormulae = 0;
      this.map.cols.prepare(model.cols, options);
      this.map.sheetData.prepare(model.rows, options);
      this.map.conditionalFormatting.prepare(model.conditionalFormattings, options);
      model.mergeCells = options.merges.mergeCells; // prepare relationships

      var rels = model.rels = [];

      function nextRid(r) {
        return "rId".concat(r.length + 1);
      }

      model.hyperlinks.forEach(function (hyperlink) {
        var rId = nextRid(rels);
        hyperlink.rId = rId;
        rels.push({
          Id: rId,
          Type: RelType.Hyperlink,
          Target: hyperlink.target,
          TargetMode: 'External'
        });
      }); // prepare comment relationships

      if (model.comments.length > 0) {
        var comment = {
          Id: nextRid(rels),
          Type: RelType.Comments,
          Target: "../comments".concat(model.id, ".xml")
        };
        rels.push(comment);
        var vmlDrawing = {
          Id: nextRid(rels),
          Type: RelType.VmlDrawing,
          Target: "../drawings/vmlDrawing".concat(model.id, ".vml")
        };
        rels.push(vmlDrawing);
        model.comments.forEach(function (item) {
          item.refAddress = colCache.decodeAddress(item.ref);
        });
        options.commentRefs.push({
          commentName: "comments".concat(model.id),
          vmlDrawing: "vmlDrawing".concat(model.id)
        });
      }

      var drawingRelsHash = [];
      var bookImage;
      model.media.forEach(function (medium) {
        if (medium.type === 'background') {
          var rId = nextRid(rels);
          bookImage = options.media[medium.imageId];
          rels.push({
            Id: rId,
            Type: RelType.Image,
            Target: "../media/".concat(bookImage.name, ".").concat(bookImage.extension)
          });
          model.background = {
            rId: rId
          };
          model.image = options.media[medium.imageId];
        } else if (medium.type === 'image') {
          var drawing = model.drawing;
          bookImage = options.media[medium.imageId];

          if (!drawing) {
            drawing = model.drawing = {
              rId: nextRid(rels),
              name: "drawing".concat(++options.drawingsCount),
              anchors: [],
              rels: []
            };
            options.drawings.push(drawing);
            rels.push({
              Id: drawing.rId,
              Type: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing',
              Target: "../drawings/".concat(drawing.name, ".xml")
            });
          }

          var rIdImage = _this2.preImageId === medium.imageId ? drawingRelsHash[medium.imageId] : drawingRelsHash[drawing.rels.length];

          if (!rIdImage) {
            rIdImage = nextRid(drawing.rels);
            drawingRelsHash[drawing.rels.length] = rIdImage;
            drawing.rels.push({
              Id: rIdImage,
              Type: 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/image',
              Target: "../media/".concat(bookImage.name, ".").concat(bookImage.extension)
            });
          }

          var anchor = {
            picture: {
              rId: rIdImage
            },
            range: medium.range
          };

          if (medium.hyperlinks && medium.hyperlinks.hyperlink) {
            var rIdHyperLink = nextRid(drawing.rels);
            drawingRelsHash[drawing.rels.length] = rIdHyperLink;
            anchor.picture.hyperlinks = {
              tooltip: medium.hyperlinks.tooltip,
              rId: rIdHyperLink
            };
            drawing.rels.push({
              Id: rIdHyperLink,
              Type: RelType.Hyperlink,
              Target: medium.hyperlinks.hyperlink,
              TargetMode: 'External'
            });
          }

          _this2.preImageId = medium.imageId;
          drawing.anchors.push(anchor);
        }
      }); // prepare tables

      model.tables.forEach(function (table) {
        // relationships
        var rId = nextRid(rels);
        table.rId = rId;
        rels.push({
          Id: rId,
          Type: RelType.Table,
          Target: "../tables/".concat(table.target)
        }); // dynamic styles

        table.columns.forEach(function (column) {
          var style = column.style;

          if (style) {
            column.dxfId = options.styles.addDxfStyle(style);
          }
        });
      }); // prepare ext items

      this.map.extLst.prepare(model, options);
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('worksheet', WorkSheetXform.WORKSHEET_ATTRIBUTES);
      var sheetFormatPropertiesModel = model.properties ? {
        defaultRowHeight: model.properties.defaultRowHeight,
        dyDescent: model.properties.dyDescent,
        outlineLevelCol: model.properties.outlineLevelCol,
        outlineLevelRow: model.properties.outlineLevelRow
      } : undefined;

      if (model.properties && model.properties.defaultColWidth) {
        sheetFormatPropertiesModel.defaultColWidth = model.properties.defaultColWidth;
      }

      var sheetPropertiesModel = {
        outlineProperties: model.properties && model.properties.outlineProperties,
        tabColor: model.properties && model.properties.tabColor,
        pageSetup: model.pageSetup && model.pageSetup.fitToPage ? {
          fitToPage: model.pageSetup.fitToPage
        } : undefined
      };
      var pageMarginsModel = model.pageSetup && model.pageSetup.margins;
      var printOptionsModel = {
        showRowColHeaders: model.pageSetup && model.pageSetup.showRowColHeaders,
        showGridLines: model.pageSetup && model.pageSetup.showGridLines,
        horizontalCentered: model.pageSetup && model.pageSetup.horizontalCentered,
        verticalCentered: model.pageSetup && model.pageSetup.verticalCentered
      };
      var sheetProtectionModel = model.sheetProtection;
      this.map.sheetPr.render(xmlStream, sheetPropertiesModel);
      this.map.dimension.render(xmlStream, model.dimensions);
      this.map.sheetViews.render(xmlStream, model.views);
      this.map.sheetFormatPr.render(xmlStream, sheetFormatPropertiesModel);
      this.map.cols.render(xmlStream, model.cols);
      this.map.sheetData.render(xmlStream, model.rows);
      this.map.sheetProtection.render(xmlStream, sheetProtectionModel); // Note: must be after sheetData and before autoFilter

      this.map.autoFilter.render(xmlStream, model.autoFilter);
      this.map.mergeCells.render(xmlStream, model.mergeCells);
      this.map.conditionalFormatting.render(xmlStream, model.conditionalFormattings); // Note: must be before dataValidations

      this.map.dataValidations.render(xmlStream, model.dataValidations); // For some reason hyperlinks have to be after the data validations

      this.map.hyperlinks.render(xmlStream, model.hyperlinks);
      this.map.printOptions.render(xmlStream, printOptionsModel); // Note: must be before pageMargins

      this.map.pageMargins.render(xmlStream, pageMarginsModel);
      this.map.pageSetup.render(xmlStream, model.pageSetup);
      this.map.headerFooter.render(xmlStream, model.headerFooter);
      this.map.rowBreaks.render(xmlStream, model.rowBreaks);
      this.map.drawing.render(xmlStream, model.drawing); // Note: must be after rowBreaks

      this.map.picture.render(xmlStream, model.background); // Note: must be after drawing

      this.map.tableParts.render(xmlStream, model.tables);
      this.map.extLst.render(xmlStream, model);

      if (model.rels) {
        // add a <legacyDrawing /> node for each comment
        model.rels.forEach(function (rel) {
          if (rel.Type === RelType.VmlDrawing) {
            xmlStream.leafNode('legacyDrawing', {
              'r:id': rel.Id
            });
          }
        });
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (node.name === 'worksheet') {
        _.each(this.map, function (xform) {
          xform.reset();
        });

        return true;
      }

      this.parser = this.map[node.name];

      if (this.parser) {
        this.parser.parseOpen(node);
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'worksheet':
          {
            var properties = this.map.sheetFormatPr.model || {};

            if (this.map.sheetPr.model && this.map.sheetPr.model.tabColor) {
              properties.tabColor = this.map.sheetPr.model.tabColor;
            }

            if (this.map.sheetPr.model && this.map.sheetPr.model.outlineProperties) {
              properties.outlineProperties = this.map.sheetPr.model.outlineProperties;
            }

            var sheetProperties = {
              fitToPage: this.map.sheetPr.model && this.map.sheetPr.model.pageSetup && this.map.sheetPr.model.pageSetup.fitToPage || false,
              margins: this.map.pageMargins.model
            };
            var pageSetup = Object.assign(sheetProperties, this.map.pageSetup.model, this.map.printOptions.model);
            var conditionalFormattings = mergeConditionalFormattings(this.map.conditionalFormatting.model, this.map.extLst.model && this.map.extLst.model['x14:conditionalFormattings']);
            this.model = {
              dimensions: this.map.dimension.model,
              cols: this.map.cols.model,
              rows: this.map.sheetData.model,
              mergeCells: this.map.mergeCells.model,
              hyperlinks: this.map.hyperlinks.model,
              dataValidations: this.map.dataValidations.model,
              properties: properties,
              views: this.map.sheetViews.model,
              pageSetup: pageSetup,
              headerFooter: this.map.headerFooter.model,
              background: this.map.picture.model,
              drawing: this.map.drawing.model,
              tables: this.map.tableParts.model,
              conditionalFormattings: conditionalFormattings
            };

            if (this.map.autoFilter.model) {
              this.model.autoFilter = this.map.autoFilter.model;
            }

            if (this.map.sheetProtection.model) {
              this.model.sheetProtection = this.map.sheetProtection.model;
            }

            return false;
          }

        default:
          // not quite sure how we get here!
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      // options.merges = new Merges();
      // options.merges.reconcile(model.mergeCells, model.rows);
      var rels = (model.relationships || []).reduce(function (h, rel) {
        h[rel.Id] = rel;

        if (rel.Type === RelType.Comments) {
          model.comments = options.comments[rel.Target].comments;
        }

        if (rel.Type === RelType.VmlDrawing && model.comments && model.comments.length) {
          var vmlComment = options.vmlDrawings[rel.Target].comments;
          model.comments.forEach(function (comment, index) {
            comment.note = Object.assign({}, comment.note, vmlComment[index]);
          });
        }

        return h;
      }, {});
      options.commentsMap = (model.comments || []).reduce(function (h, comment) {
        if (comment.ref) {
          h[comment.ref] = comment;
        }

        return h;
      }, {});
      options.hyperlinkMap = (model.hyperlinks || []).reduce(function (h, hyperlink) {
        if (hyperlink.rId) {
          h[hyperlink.address] = rels[hyperlink.rId].Target;
        }

        return h;
      }, {});
      options.formulae = {}; // compact the rows and cells

      model.rows = model.rows && model.rows.filter(Boolean) || [];
      model.rows.forEach(function (row) {
        row.cells = row.cells && row.cells.filter(Boolean) || [];
      });
      this.map.cols.reconcile(model.cols, options);
      this.map.sheetData.reconcile(model.rows, options);
      this.map.conditionalFormatting.reconcile(model.conditionalFormattings, options);
      model.media = [];

      if (model.drawing) {
        var drawingRel = rels[model.drawing.rId];
        var match = drawingRel.Target.match(/\/drawings\/([a-zA-Z0-9]+)[.][a-zA-Z]{3,4}$/);

        if (match) {
          var drawingName = match[1];
          var drawing = options.drawings[drawingName];
          drawing.anchors.forEach(function (anchor) {
            if (anchor.medium) {
              var image = {
                type: 'image',
                imageId: anchor.medium.index,
                range: anchor.range,
                hyperlinks: anchor.picture.hyperlinks
              };
              model.media.push(image);
            }
          });
        }
      }

      var backgroundRel = model.background && rels[model.background.rId];

      if (backgroundRel) {
        var target = backgroundRel.Target.split('/media/')[1];
        var imageId = options.mediaIndex && options.mediaIndex[target];

        if (imageId !== undefined) {
          model.media.push({
            type: 'background',
            imageId: imageId
          });
        }
      }

      model.tables = (model.tables || []).map(function (tablePart) {
        var rel = rels[tablePart.rId];
        return options.tables[rel.Target];
      });
      delete model.relationships;
      delete model.hyperlinks;
      delete model.comments;
    }
  }]);

  return WorkSheetXform;
}(BaseXform);

WorkSheetXform.WORKSHEET_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
  'xmlns:r': 'http://schemas.openxmlformats.org/officeDocument/2006/relationships',
  'xmlns:mc': 'http://schemas.openxmlformats.org/markup-compatibility/2006',
  'mc:Ignorable': 'x14ac',
  'xmlns:x14ac': 'http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac'
};
module.exports = WorkSheetXform;

},{"../../../utils/col-cache":19,"../../../utils/under-dash":25,"../../../utils/xml-stream":27,"../../rel-type":30,"../base-xform":31,"../list-xform":70,"./auto-filter-xform":71,"./cf/conditional-formattings-xform":86,"./col-xform":91,"./data-validations-xform":92,"./dimension-xform":93,"./drawing-xform":94,"./ext-lst-xform":95,"./header-footer-xform":96,"./hyperlink-xform":97,"./merge-cell-xform":98,"./merges":99,"./page-margins-xform":102,"./page-setup-xform":104,"./picture-xform":105,"./print-options-xform":106,"./row-breaks-xform":107,"./row-xform":108,"./sheet-format-properties-xform":109,"./sheet-properties-xform":110,"./sheet-protection-xform":111,"./sheet-view-xform":112,"./table-part-xform":113}],115:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var BooleanXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(BooleanXform, _BaseXform);

  var _super = _createSuper(BooleanXform);

  function BooleanXform(options) {
    var _this;

    _classCallCheck(this, BooleanXform);

    _this = _super.call(this);
    _this.tag = options.tag;
    _this.attr = options.attr;
    return _this;
  }

  _createClass(BooleanXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.openNode(this.tag);
        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        this.model = true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }]);

  return BooleanXform;
}(BaseXform);

module.exports = BooleanXform;

},{"../base-xform":31}],116:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var DateXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(DateXform, _BaseXform);

  var _super = _createSuper(DateXform);

  function DateXform(options) {
    var _this;

    _classCallCheck(this, DateXform);

    _this = _super.call(this);
    _this.tag = options.tag;
    _this.attr = options.attr;
    _this.attrs = options.attrs;

    _this._format = options.format || function (dt) {
      try {
        if (Number.isNaN(dt.getTime())) return '';
        return dt.toISOString();
      } catch (e) {
        return '';
      }
    };

    _this._parse = options.parse || function (str) {
      return new Date(str);
    };

    return _this;
  }

  _createClass(DateXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.openNode(this.tag);

        if (this.attrs) {
          xmlStream.addAttributes(this.attrs);
        }

        if (this.attr) {
          xmlStream.addAttribute(this.attr, this._format(model));
        } else {
          xmlStream.writeText(this._format(model));
        }

        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        if (this.attr) {
          this.model = this._parse(node.attributes[this.attr]);
        } else {
          this.text = [];
        }
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (!this.attr) {
        this.text.push(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      if (!this.attr) {
        this.model = this._parse(this.text.join(''));
      }

      return false;
    }
  }]);

  return DateXform;
}(BaseXform);

module.exports = DateXform;

},{"../base-xform":31}],117:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var IntegerXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(IntegerXform, _BaseXform);

  var _super = _createSuper(IntegerXform);

  function IntegerXform(options) {
    var _this;

    _classCallCheck(this, IntegerXform);

    _this = _super.call(this);
    _this.tag = options.tag;
    _this.attr = options.attr;
    _this.attrs = options.attrs; // option to render zero

    _this.zero = options.zero;
    return _this;
  }

  _createClass(IntegerXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      // int is different to float in that zero is not rendered
      if (model || this.zero) {
        xmlStream.openNode(this.tag);

        if (this.attrs) {
          xmlStream.addAttributes(this.attrs);
        }

        if (this.attr) {
          xmlStream.addAttribute(this.attr, model);
        } else {
          xmlStream.writeText(model);
        }

        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        if (this.attr) {
          this.model = parseInt(node.attributes[this.attr], 10);
        } else {
          this.text = [];
        }

        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (!this.attr) {
        this.text.push(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      if (!this.attr) {
        this.model = parseInt(this.text.join('') || 0, 10);
      }

      return false;
    }
  }]);

  return IntegerXform;
}(BaseXform);

module.exports = IntegerXform;

},{"../base-xform":31}],118:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var StringXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(StringXform, _BaseXform);

  var _super = _createSuper(StringXform);

  function StringXform(options) {
    var _this;

    _classCallCheck(this, StringXform);

    _this = _super.call(this);
    _this.tag = options.tag;
    _this.attr = options.attr;
    _this.attrs = options.attrs;
    return _this;
  }

  _createClass(StringXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model !== undefined) {
        xmlStream.openNode(this.tag);

        if (this.attrs) {
          xmlStream.addAttributes(this.attrs);
        }

        if (this.attr) {
          xmlStream.addAttribute(this.attr, model);
        } else {
          xmlStream.writeText(model);
        }

        xmlStream.closeNode();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        if (this.attr) {
          this.model = node.attributes[this.attr];
        } else {
          this.text = [];
        }
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (!this.attr) {
        this.text.push(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      if (!this.attr) {
        this.model = this.text.join('');
      }

      return false;
    }
  }]);

  return StringXform;
}(BaseXform);

module.exports = StringXform;

},{"../base-xform":31}],119:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('./base-xform');

var XmlStream = require('../../utils/xml-stream'); // const model = {
//   tag: 'name',
//   $: {attr: 'value'},
//   c: [
//     { tag: 'child' }
//   ],
//   t: 'some text'
// };


function build(xmlStream, model) {
  xmlStream.openNode(model.tag, model.$);

  if (model.c) {
    model.c.forEach(function (child) {
      build(xmlStream, child);
    });
  }

  if (model.t) {
    xmlStream.writeText(model.t);
  }

  xmlStream.closeNode();
}

var StaticXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(StaticXform, _BaseXform);

  var _super = _createSuper(StaticXform);

  function StaticXform(model) {
    var _this;

    _classCallCheck(this, StaticXform);

    _this = _super.call(this); // This class is an optimisation for static (unimportant and unchanging) xml
    // It is stateless - apart from its static model and so can be used as a singleton
    // Being stateless - it will only track entry to and exit from it's root xml tag during parsing and nothing else
    // Known issues:
    //    since stateless - parseOpen always returns true. Parent xform must know when to start using this xform
    //    if the root tag is recursive, the parsing will behave unpredictably

    _this._model = model;
    return _this;
  }

  _createClass(StaticXform, [{
    key: "render",
    value: function render(xmlStream) {
      if (!this._xml) {
        var stream = new XmlStream();
        build(stream, this._model);
        this._xml = stream.xml;
      }

      xmlStream.writeXml(this._xml);
    }
  }, {
    key: "parseOpen",
    value: function parseOpen() {
      return true;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case this._model.tag:
          return false;

        default:
          return true;
      }
    }
  }]);

  return StaticXform;
}(BaseXform);

module.exports = StaticXform;

},{"../../utils/xml-stream":27,"./base-xform":31}],120:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var TextXform = require('./text-xform');

var RichTextXform = require('./rich-text-xform');

var BaseXform = require('../base-xform'); // <rPh sb="0" eb="1">
//   <t>(its pronounciation in KATAKANA)</t>
// </rPh>


var PhoneticTextXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(PhoneticTextXform, _BaseXform);

  var _super = _createSuper(PhoneticTextXform);

  function PhoneticTextXform() {
    var _this;

    _classCallCheck(this, PhoneticTextXform);

    _this = _super.call(this);
    _this.map = {
      r: new RichTextXform(),
      t: new TextXform()
    };
    return _this;
  }

  _createClass(PhoneticTextXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag, {
        sb: model.sb || 0,
        eb: model.eb || 0
      });

      if (model && model.hasOwnProperty('richText') && model.richText) {
        var r = this.map.r;
        model.richText.forEach(function (text) {
          r.render(xmlStream, text);
        });
      } else if (model) {
        this.map.t.render(xmlStream, model.text);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      var name = node.name;

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (name === this.tag) {
        this.model = {
          sb: parseInt(node.attributes.sb, 10),
          eb: parseInt(node.attributes.eb, 10)
        };
        return true;
      }

      this.parser = this.map[name];

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          switch (name) {
            case 'r':
              {
                var rt = this.model.richText;

                if (!rt) {
                  rt = this.model.richText = [];
                }

                rt.push(this.parser.model);
                break;
              }

            case 't':
              this.model.text = this.parser.model;
              break;

            default:
              break;
          }

          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'rPh';
    }
  }]);

  return PhoneticTextXform;
}(BaseXform);

module.exports = PhoneticTextXform;

},{"../base-xform":31,"./rich-text-xform":121,"./text-xform":124}],121:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var TextXform = require('./text-xform');

var FontXform = require('../style/font-xform');

var BaseXform = require('../base-xform'); // <r>
//   <rPr>
//     <sz val="11"/>
//     <color theme="1" tint="5"/>
//     <rFont val="Calibri"/>
//     <family val="2"/>
//     <scheme val="minor"/>
//   </rPr>
//   <t xml:space="preserve"> is </t>
// </r>


var RichTextXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(RichTextXform, _BaseXform);

  var _super = _createSuper(RichTextXform);

  function RichTextXform(model) {
    var _this;

    _classCallCheck(this, RichTextXform);

    _this = _super.call(this);
    _this.model = model;
    return _this;
  }

  _createClass(RichTextXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      model = model || this.model;
      xmlStream.openNode('r');

      if (model.font) {
        this.fontXform.render(xmlStream, model.font);
      }

      this.textXform.render(xmlStream, model.text);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'r':
          this.model = {};
          return true;

        case 't':
          this.parser = this.textXform;
          this.parser.parseOpen(node);
          return true;

        case 'rPr':
          this.parser = this.fontXform;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      switch (name) {
        case 'r':
          return false;

        case 't':
          this.model.text = this.parser.model;
          this.parser = undefined;
          return true;

        case 'rPr':
          this.model.font = this.parser.model;
          this.parser = undefined;
          return true;

        default:
          if (this.parser) {
            this.parser.parseClose(name);
          }

          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'r';
    }
  }, {
    key: "textXform",
    get: function get() {
      return this._textXform || (this._textXform = new TextXform());
    }
  }, {
    key: "fontXform",
    get: function get() {
      return this._fontXform || (this._fontXform = new FontXform(RichTextXform.FONT_OPTIONS));
    }
  }]);

  return RichTextXform;
}(BaseXform);

RichTextXform.FONT_OPTIONS = {
  tagName: 'rPr',
  fontNameTag: 'rFont'
};
module.exports = RichTextXform;

},{"../base-xform":31,"../style/font-xform":130,"./text-xform":124}],122:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var TextXform = require('./text-xform');

var RichTextXform = require('./rich-text-xform');

var PhoneticTextXform = require('./phonetic-text-xform');

var BaseXform = require('../base-xform'); // <si>
//   <r></r><r></r>...
// </si>
// <si>
//   <t></t>
// </si>


var SharedStringXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(SharedStringXform, _BaseXform);

  var _super = _createSuper(SharedStringXform);

  function SharedStringXform(model) {
    var _this;

    _classCallCheck(this, SharedStringXform);

    _this = _super.call(this);
    _this.model = model;
    _this.map = {
      r: new RichTextXform(),
      t: new TextXform(),
      rPh: new PhoneticTextXform()
    };
    return _this;
  }

  _createClass(SharedStringXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var _this2 = this;

      xmlStream.openNode(this.tag);

      if (model && model.hasOwnProperty('richText') && model.richText) {
        if (model.richText.length) {
          model.richText.forEach(function (text) {
            _this2.map.r.render(xmlStream, text);
          });
        } else {
          this.map.t.render(xmlStream, '');
        }
      } else if (model !== undefined && model !== null) {
        this.map.t.render(xmlStream, model);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      var name = node.name;

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (name === this.tag) {
        this.model = {};
        return true;
      }

      this.parser = this.map[name];

      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          switch (name) {
            case 'r':
              {
                var rt = this.model.richText;

                if (!rt) {
                  rt = this.model.richText = [];
                }

                rt.push(this.parser.model);
                break;
              }

            case 't':
              this.model = this.parser.model;
              break;

            default:
              break;
          }

          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'si';
    }
  }]);

  return SharedStringXform;
}(BaseXform);

module.exports = SharedStringXform;

},{"../base-xform":31,"./phonetic-text-xform":120,"./rich-text-xform":121,"./text-xform":124}],123:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var SharedStringXform = require('./shared-string-xform');

var SharedStringsXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(SharedStringsXform, _BaseXform);

  var _super = _createSuper(SharedStringsXform);

  function SharedStringsXform(model) {
    var _this;

    _classCallCheck(this, SharedStringsXform);

    _this = _super.call(this);
    _this.model = model || {
      values: [],
      count: 0
    };
    _this.hash = Object.create(null);
    _this.rich = Object.create(null);
    return _this;
  }

  _createClass(SharedStringsXform, [{
    key: "getString",
    value: function getString(index) {
      return this.model.values[index];
    }
  }, {
    key: "add",
    value: function add(value) {
      return value.richText ? this.addRichText(value) : this.addText(value);
    }
  }, {
    key: "addText",
    value: function addText(value) {
      var index = this.hash[value];

      if (index === undefined) {
        index = this.hash[value] = this.model.values.length;
        this.model.values.push(value);
      }

      this.model.count++;
      return index;
    }
  }, {
    key: "addRichText",
    value: function addRichText(value) {
      // TODO: add WeakMap here
      var xml = this.sharedStringXform.toXml(value);
      var index = this.rich[xml];

      if (index === undefined) {
        index = this.rich[xml] = this.model.values.length;
        this.model.values.push(value);
      }

      this.model.count++;
      return index;
    } // <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
    // <sst xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" count="<%=totalRefs%>" uniqueCount="<%=count%>">
    //   <si><t><%=text%></t></si>
    //   <si><r><rPr></rPr><t></t></r></si>
    // </sst>

  }, {
    key: "render",
    value: function render(xmlStream, model) {
      model = model || this._values;
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('sst', {
        xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
        count: model.count,
        uniqueCount: model.values.length
      });
      var sx = this.sharedStringXform;
      model.values.forEach(function (sharedString) {
        sx.render(xmlStream, sharedString);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'sst':
          return true;

        case 'si':
          this.parser = this.sharedStringXform;
          this.parser.parseOpen(node);
          return true;

        default:
          throw new Error("Unexpected xml node in parseOpen: ".concat(JSON.stringify(node)));
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.values.push(this.parser.model);
          this.model.count++;
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'sst':
          return false;

        default:
          throw new Error("Unexpected xml node in parseClose: ".concat(name));
      }
    }
  }, {
    key: "sharedStringXform",
    get: function get() {
      return this._sharedStringXform || (this._sharedStringXform = new SharedStringXform());
    }
  }, {
    key: "values",
    get: function get() {
      return this.model.values;
    }
  }, {
    key: "uniqueCount",
    get: function get() {
      return this.model.values.length;
    }
  }, {
    key: "count",
    get: function get() {
      return this.model.count;
    }
  }]);

  return SharedStringsXform;
}(BaseXform);

module.exports = SharedStringsXform;

},{"../../../utils/xml-stream":27,"../base-xform":31,"./shared-string-xform":122}],124:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform'); //   <t xml:space="preserve"> is </t>


var TextXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(TextXform, _BaseXform);

  var _super = _createSuper(TextXform);

  function TextXform() {
    _classCallCheck(this, TextXform);

    return _super.apply(this, arguments);
  }

  _createClass(TextXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('t');

      if (/^\s|\n|\s$/.test(model)) {
        xmlStream.addAttribute('xml:space', 'preserve');
      }

      xmlStream.writeText(model);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 't':
          this._text = [];
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      this._text.push(text);
    }
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 't';
    }
  }, {
    key: "model",
    get: function get() {
      return this._text.join('').replace(/_x([0-9A-F]{4})_/g, function ($0, $1) {
        return String.fromCharCode(parseInt($1, 16));
      });
    }
  }]);

  return TextXform;
}(BaseXform);

module.exports = TextXform;

},{"../base-xform":31}],125:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Enums = require('../../../doc/enums');

var utils = require('../../../utils/utils');

var BaseXform = require('../base-xform');

var validation = {
  horizontalValues: ['left', 'center', 'right', 'fill', 'centerContinuous', 'distributed', 'justify'].reduce(function (p, v) {
    p[v] = true;
    return p;
  }, {}),
  horizontal: function horizontal(value) {
    return this.horizontalValues[value] ? value : undefined;
  },
  verticalValues: ['top', 'middle', 'bottom', 'distributed', 'justify'].reduce(function (p, v) {
    p[v] = true;
    return p;
  }, {}),
  vertical: function vertical(value) {
    if (value === 'middle') return 'center';
    return this.verticalValues[value] ? value : undefined;
  },
  wrapText: function wrapText(value) {
    return value ? true : undefined;
  },
  shrinkToFit: function shrinkToFit(value) {
    return value ? true : undefined;
  },
  textRotation: function textRotation(value) {
    switch (value) {
      case 'vertical':
        return value;

      default:
        value = utils.validInt(value);
        return value >= -90 && value <= 90 ? value : undefined;
    }
  },
  indent: function indent(value) {
    value = utils.validInt(value);
    return Math.max(0, value);
  },
  readingOrder: function readingOrder(value) {
    switch (value) {
      case 'ltr':
        return Enums.ReadingOrder.LeftToRight;

      case 'rtl':
        return Enums.ReadingOrder.RightToLeft;

      default:
        return undefined;
    }
  }
};
var textRotationXform = {
  toXml: function toXml(textRotation) {
    textRotation = validation.textRotation(textRotation);

    if (textRotation) {
      if (textRotation === 'vertical') {
        return 255;
      }

      var tr = Math.round(textRotation);

      if (tr >= 0 && tr <= 90) {
        return tr;
      }

      if (tr < 0 && tr >= -90) {
        return 90 - tr;
      }
    }

    return undefined;
  },
  toModel: function toModel(textRotation) {
    var tr = utils.validInt(textRotation);

    if (tr !== undefined) {
      if (tr === 255) {
        return 'vertical';
      }

      if (tr >= 0 && tr <= 90) {
        return tr;
      }

      if (tr > 90 && tr <= 180) {
        return 90 - tr;
      }
    }

    return undefined;
  }
}; // Alignment encapsulates translation from style.alignment model to/from xlsx

var AlignmentXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(AlignmentXform, _BaseXform);

  var _super = _createSuper(AlignmentXform);

  function AlignmentXform() {
    _classCallCheck(this, AlignmentXform);

    return _super.apply(this, arguments);
  }

  _createClass(AlignmentXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.addRollback();
      xmlStream.openNode('alignment');
      var isValid = false;

      function add(name, value) {
        if (value) {
          xmlStream.addAttribute(name, value);
          isValid = true;
        }
      }

      add('horizontal', validation.horizontal(model.horizontal));
      add('vertical', validation.vertical(model.vertical));
      add('wrapText', validation.wrapText(model.wrapText) ? '1' : false);
      add('shrinkToFit', validation.shrinkToFit(model.shrinkToFit) ? '1' : false);
      add('indent', validation.indent(model.indent));
      add('textRotation', textRotationXform.toXml(model.textRotation));
      add('readingOrder', validation.readingOrder(model.readingOrder));
      xmlStream.closeNode();

      if (isValid) {
        xmlStream.commit();
      } else {
        xmlStream.rollback();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      var model = {};
      var valid = false;

      function add(truthy, name, value) {
        if (truthy) {
          model[name] = value;
          valid = true;
        }
      }

      add(node.attributes.horizontal, 'horizontal', node.attributes.horizontal);
      add(node.attributes.vertical, 'vertical', node.attributes.vertical === 'center' ? 'middle' : node.attributes.vertical);
      add(node.attributes.wrapText, 'wrapText', !!node.attributes.wrapText);
      add(node.attributes.shrinkToFit, 'shrinkToFit', !!node.attributes.shrinkToFit);
      add(node.attributes.indent, 'indent', parseInt(node.attributes.indent, 10));
      add(node.attributes.textRotation, 'textRotation', textRotationXform.toModel(node.attributes.textRotation));
      add(node.attributes.readingOrder, 'readingOrder', node.attributes.readingOrder === '2' ? 'rtl' : 'ltr');
      this.model = valid ? model : null;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'alignment';
    }
  }]);

  return AlignmentXform;
}(BaseXform);

module.exports = AlignmentXform;

},{"../../../doc/enums":7,"../../../utils/utils":26,"../base-xform":31}],126:[function(require,module,exports){
"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/* eslint-disable max-classes-per-file */
var BaseXform = require('../base-xform');

var ColorXform = require('./color-xform');

var EdgeXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(EdgeXform, _BaseXform);

  var _super = _createSuper(EdgeXform);

  function EdgeXform(name) {
    var _this;

    _classCallCheck(this, EdgeXform);

    _this = _super.call(this);
    _this.name = name;
    _this.map = {
      color: new ColorXform()
    };
    return _this;
  }

  _createClass(EdgeXform, [{
    key: "render",
    value: function render(xmlStream, model, defaultColor) {
      var color = model && model.color || defaultColor || this.defaultColor;
      xmlStream.openNode(this.name);

      if (model && model.style) {
        xmlStream.addAttribute('style', model.style);

        if (color) {
          this.map.color.render(xmlStream, color);
        }
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.name:
          {
            var style = node.attributes.style;

            if (style) {
              this.model = {
                style: style
              };
            } else {
              this.model = undefined;
            }

            return true;
          }

        case 'color':
          this.parser = this.map.color;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      if (name === this.name) {
        if (this.map.color.model) {
          if (!this.model) {
            this.model = {};
          }

          this.model.color = this.map.color.model;
        }
      }

      return false;
    }
  }, {
    key: "validStyle",
    value: function validStyle(value) {
      return EdgeXform.validStyleValues[value];
    }
  }, {
    key: "tag",
    get: function get() {
      return this.name;
    }
  }]);

  return EdgeXform;
}(BaseXform);

EdgeXform.validStyleValues = ['thin', 'dotted', 'dashDot', 'hair', 'dashDotDot', 'slantDashDot', 'mediumDashed', 'mediumDashDotDot', 'mediumDashDot', 'medium', 'double', 'thick'].reduce(function (p, v) {
  p[v] = true;
  return p;
}, {}); // Border encapsulates translation from border model to/from xlsx

var BorderXform = /*#__PURE__*/function (_BaseXform2) {
  _inherits(BorderXform, _BaseXform2);

  var _super2 = _createSuper(BorderXform);

  function BorderXform() {
    var _this2;

    _classCallCheck(this, BorderXform);

    _this2 = _super2.call(this);
    _this2.map = {
      top: new EdgeXform('top'),
      left: new EdgeXform('left'),
      bottom: new EdgeXform('bottom'),
      right: new EdgeXform('right'),
      diagonal: new EdgeXform('diagonal')
    };
    return _this2;
  }

  _createClass(BorderXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var color = model.color;
      xmlStream.openNode('border');

      if (model.diagonal && model.diagonal.style) {
        if (model.diagonal.up) {
          xmlStream.addAttribute('diagonalUp', '1');
        }

        if (model.diagonal.down) {
          xmlStream.addAttribute('diagonalDown', '1');
        }
      }

      function add(edgeModel, edgeXform) {
        if (edgeModel && !edgeModel.color && model.color) {
          // don't mess with incoming models
          edgeModel = _objectSpread(_objectSpread({}, edgeModel), {}, {
            color: model.color
          });
        }

        edgeXform.render(xmlStream, edgeModel, color);
      }

      add(model.left, this.map.left);
      add(model.right, this.map.right);
      add(model.top, this.map.top);
      add(model.bottom, this.map.bottom);
      add(model.diagonal, this.map.diagonal);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'border':
          this.reset();
          this.diagonalUp = !!node.attributes.diagonalUp;
          this.diagonalDown = !!node.attributes.diagonalDown;
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          }

          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      if (name === 'border') {
        var model = this.model = {};

        var add = function add(key, edgeModel, extensions) {
          if (edgeModel) {
            if (extensions) {
              Object.assign(edgeModel, extensions);
            }

            model[key] = edgeModel;
          }
        };

        add('left', this.map.left.model);
        add('right', this.map.right.model);
        add('top', this.map.top.model);
        add('bottom', this.map.bottom.model);
        add('diagonal', this.map.diagonal.model, {
          up: this.diagonalUp,
          down: this.diagonalDown
        });
      }

      return false;
    }
  }]);

  return BorderXform;
}(BaseXform);

module.exports = BorderXform;

},{"../base-xform":31,"./color-xform":127}],127:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform'); // Color encapsulates translation from color model to/from xlsx


var ColorXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(ColorXform, _BaseXform);

  var _super = _createSuper(ColorXform);

  function ColorXform(name) {
    var _this;

    _classCallCheck(this, ColorXform);

    _this = _super.call(this); // this.name controls the xm node name

    _this.name = name || 'color';
    return _this;
  }

  _createClass(ColorXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      if (model) {
        xmlStream.openNode(this.name);

        if (model.argb) {
          xmlStream.addAttribute('rgb', model.argb);
        } else if (model.theme !== undefined) {
          xmlStream.addAttribute('theme', model.theme);

          if (model.tint !== undefined) {
            xmlStream.addAttribute('tint', model.tint);
          }
        } else if (model.indexed !== undefined) {
          xmlStream.addAttribute('indexed', model.indexed);
        } else {
          xmlStream.addAttribute('auto', '1');
        }

        xmlStream.closeNode();
        return true;
      }

      return false;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.name) {
        if (node.attributes.rgb) {
          this.model = {
            argb: node.attributes.rgb
          };
        } else if (node.attributes.theme) {
          this.model = {
            theme: parseInt(node.attributes.theme, 10)
          };

          if (node.attributes.tint) {
            this.model.tint = parseFloat(node.attributes.tint);
          }
        } else if (node.attributes.indexed) {
          this.model = {
            indexed: parseInt(node.attributes.indexed, 10)
          };
        } else {
          this.model = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return this.name;
    }
  }]);

  return ColorXform;
}(BaseXform);

module.exports = ColorXform;

},{"../base-xform":31}],128:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var AlignmentXform = require('./alignment-xform');

var BorderXform = require('./border-xform');

var FillXform = require('./fill-xform');

var FontXform = require('./font-xform');

var NumFmtXform = require('./numfmt-xform');

var ProtectionXform = require('./protection-xform'); // <xf numFmtId="[numFmtId]" fontId="[fontId]" fillId="[fillId]" borderId="[xf.borderId]" xfId="[xfId]">
//   Optional <alignment>
//   Optional <protection>
// </xf>
// Style assists translation from style model to/from xlsx


var DxfXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(DxfXform, _BaseXform);

  var _super = _createSuper(DxfXform);

  function DxfXform() {
    var _this;

    _classCallCheck(this, DxfXform);

    _this = _super.call(this);
    _this.map = {
      alignment: new AlignmentXform(),
      border: new BorderXform(),
      fill: new FillXform(),
      font: new FontXform(),
      numFmt: new NumFmtXform(),
      protection: new ProtectionXform()
    };
    return _this;
  }

  _createClass(DxfXform, [{
    key: "render",
    // how do we generate dxfid?
    value: function render(xmlStream, model) {
      xmlStream.openNode(this.tag);

      if (model.alignment) {
        this.map.alignment.render(xmlStream, model.alignment);
      }

      if (model.border) {
        this.map.border.render(xmlStream, model.border);
      }

      if (model.fill) {
        this.map.fill.render(xmlStream, model.fill);
      }

      if (model.font) {
        this.map.font.render(xmlStream, model.font);
      }

      if (model.numFmt) {
        this.map.numFmt.render(xmlStream, model.numFmt);
      }

      if (model.protection) {
        this.map.protection.render(xmlStream, model.protection);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          // this node is often repeated. Need to reset children
          this.reset();
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      if (name === this.tag) {
        this.model = {
          alignment: this.map.alignment.model,
          border: this.map.border.model,
          fill: this.map.fill.model,
          font: this.map.font.model,
          numFmt: this.map.numFmt.model,
          protection: this.map.protection.model
        };
        return false;
      }

      return true;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'dxf';
    }
  }]);

  return DxfXform;
}(BaseXform);

module.exports = DxfXform;

},{"../base-xform":31,"./alignment-xform":125,"./border-xform":126,"./fill-xform":129,"./font-xform":130,"./numfmt-xform":131,"./protection-xform":132}],129:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/* eslint-disable max-classes-per-file */
var BaseXform = require('../base-xform');

var ColorXform = require('./color-xform');

var StopXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(StopXform, _BaseXform);

  var _super = _createSuper(StopXform);

  function StopXform() {
    var _this;

    _classCallCheck(this, StopXform);

    _this = _super.call(this);
    _this.map = {
      color: new ColorXform()
    };
    return _this;
  }

  _createClass(StopXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('stop');
      xmlStream.addAttribute('position', model.position);
      this.map.color.render(xmlStream, model.color);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'stop':
          this.model = {
            position: parseFloat(node.attributes.position)
          };
          return true;

        case 'color':
          this.parser = this.map.color;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.color = this.parser.model;
          this.parser = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'stop';
    }
  }]);

  return StopXform;
}(BaseXform);

var PatternFillXform = /*#__PURE__*/function (_BaseXform2) {
  _inherits(PatternFillXform, _BaseXform2);

  var _super2 = _createSuper(PatternFillXform);

  function PatternFillXform() {
    var _this2;

    _classCallCheck(this, PatternFillXform);

    _this2 = _super2.call(this);
    _this2.map = {
      fgColor: new ColorXform('fgColor'),
      bgColor: new ColorXform('bgColor')
    };
    return _this2;
  }

  _createClass(PatternFillXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('patternFill');
      xmlStream.addAttribute('patternType', model.pattern);

      if (model.fgColor) {
        this.map.fgColor.render(xmlStream, model.fgColor);
      }

      if (model.bgColor) {
        this.map.bgColor.render(xmlStream, model.bgColor);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'patternFill':
          this.model = {
            type: 'pattern',
            pattern: node.attributes.patternType
          };
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          }

          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          if (this.parser.model) {
            this.model[name] = this.parser.model;
          }

          this.parser = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "name",
    get: function get() {
      return 'pattern';
    }
  }, {
    key: "tag",
    get: function get() {
      return 'patternFill';
    }
  }]);

  return PatternFillXform;
}(BaseXform);

var GradientFillXform = /*#__PURE__*/function (_BaseXform3) {
  _inherits(GradientFillXform, _BaseXform3);

  var _super3 = _createSuper(GradientFillXform);

  function GradientFillXform() {
    var _this3;

    _classCallCheck(this, GradientFillXform);

    _this3 = _super3.call(this);
    _this3.map = {
      stop: new StopXform()
    }; // if (model) {
    //   this.gradient = model.gradient;
    //   if (model.center) {
    //     this.center = model.center;
    //   }
    //   if (model.degree !== undefined) {
    //     this.degree = model.degree;
    //   }
    //   this.stops = model.stops.map(function(stop) { return new StopXform(stop); });
    // } else {
    //   this.stops = [];
    // }

    return _this3;
  }

  _createClass(GradientFillXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('gradientFill');

      switch (model.gradient) {
        case 'angle':
          xmlStream.addAttribute('degree', model.degree);
          break;

        case 'path':
          xmlStream.addAttribute('type', 'path');

          if (model.center.left) {
            xmlStream.addAttribute('left', model.center.left);

            if (model.center.right === undefined) {
              xmlStream.addAttribute('right', model.center.left);
            }
          }

          if (model.center.right) {
            xmlStream.addAttribute('right', model.center.right);
          }

          if (model.center.top) {
            xmlStream.addAttribute('top', model.center.top);

            if (model.center.bottom === undefined) {
              xmlStream.addAttribute('bottom', model.center.top);
            }
          }

          if (model.center.bottom) {
            xmlStream.addAttribute('bottom', model.center.bottom);
          }

          break;

        default:
          break;
      }

      var stopXform = this.map.stop;
      model.stops.forEach(function (stopModel) {
        stopXform.render(xmlStream, stopModel);
      });
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'gradientFill':
          {
            var model = this.model = {
              stops: []
            };

            if (node.attributes.degree) {
              model.gradient = 'angle';
              model.degree = parseInt(node.attributes.degree, 10);
            } else if (node.attributes.type === 'path') {
              model.gradient = 'path';
              model.center = {
                left: node.attributes.left ? parseFloat(node.attributes.left) : 0,
                top: node.attributes.top ? parseFloat(node.attributes.top) : 0
              };

              if (node.attributes.right !== node.attributes.left) {
                model.center.right = node.attributes.right ? parseFloat(node.attributes.right) : 0;
              }

              if (node.attributes.bottom !== node.attributes.top) {
                model.center.bottom = node.attributes.bottom ? parseFloat(node.attributes.bottom) : 0;
              }
            }

            return true;
          }

        case 'stop':
          this.parser = this.map.stop;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.stops.push(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "name",
    get: function get() {
      return 'gradient';
    }
  }, {
    key: "tag",
    get: function get() {
      return 'gradientFill';
    }
  }]);

  return GradientFillXform;
}(BaseXform); // Fill encapsulates translation from fill model to/from xlsx


var FillXform = /*#__PURE__*/function (_BaseXform4) {
  _inherits(FillXform, _BaseXform4);

  var _super4 = _createSuper(FillXform);

  function FillXform() {
    var _this4;

    _classCallCheck(this, FillXform);

    _this4 = _super4.call(this);
    _this4.map = {
      patternFill: new PatternFillXform(),
      gradientFill: new GradientFillXform()
    };
    return _this4;
  }

  _createClass(FillXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.addRollback();
      xmlStream.openNode('fill');

      switch (model.type) {
        case 'pattern':
          this.map.patternFill.render(xmlStream, model);
          break;

        case 'gradient':
          this.map.gradientFill.render(xmlStream, model);
          break;

        default:
          xmlStream.rollback();
          return;
      }

      xmlStream.closeNode();
      xmlStream.commit();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'fill':
          this.model = {};
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
            return true;
          }

          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model = this.parser.model;
          this.model.type = this.parser.name;
          this.parser = undefined;
        }

        return true;
      }

      return false;
    }
  }, {
    key: "validStyle",
    value: function validStyle(value) {
      return FillXform.validPatternValues[value];
    }
  }, {
    key: "tag",
    get: function get() {
      return 'fill';
    }
  }]);

  return FillXform;
}(BaseXform);

FillXform.validPatternValues = ['none', 'solid', 'darkVertical', 'darkGray', 'mediumGray', 'lightGray', 'gray125', 'gray0625', 'darkHorizontal', 'darkVertical', 'darkDown', 'darkUp', 'darkGrid', 'darkTrellis', 'lightHorizontal', 'lightVertical', 'lightDown', 'lightUp', 'lightGrid', 'lightTrellis', 'lightGrid'].reduce(function (p, v) {
  p[v] = true;
  return p;
}, {});
FillXform.StopXform = StopXform;
FillXform.PatternFillXform = PatternFillXform;
FillXform.GradientFillXform = GradientFillXform;
module.exports = FillXform;

},{"../base-xform":31,"./color-xform":127}],130:[function(require,module,exports){
'use strict';

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var ColorXform = require('./color-xform');

var BooleanXform = require('../simple/boolean-xform');

var IntegerXform = require('../simple/integer-xform');

var StringXform = require('../simple/string-xform');

var UnderlineXform = require('./underline-xform');

var _ = require('../../../utils/under-dash');

var BaseXform = require('../base-xform'); // Font encapsulates translation from font model to xlsx


var FontXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(FontXform, _BaseXform);

  var _super = _createSuper(FontXform);

  function FontXform(options) {
    var _this;

    _classCallCheck(this, FontXform);

    _this = _super.call(this);
    _this.options = options || FontXform.OPTIONS;
    _this.map = {
      b: {
        prop: 'bold',
        xform: new BooleanXform({
          tag: 'b',
          attr: 'val'
        })
      },
      i: {
        prop: 'italic',
        xform: new BooleanXform({
          tag: 'i',
          attr: 'val'
        })
      },
      u: {
        prop: 'underline',
        xform: new UnderlineXform()
      },
      charset: {
        prop: 'charset',
        xform: new IntegerXform({
          tag: 'charset',
          attr: 'val'
        })
      },
      color: {
        prop: 'color',
        xform: new ColorXform()
      },
      condense: {
        prop: 'condense',
        xform: new BooleanXform({
          tag: 'condense',
          attr: 'val'
        })
      },
      extend: {
        prop: 'extend',
        xform: new BooleanXform({
          tag: 'extend',
          attr: 'val'
        })
      },
      family: {
        prop: 'family',
        xform: new IntegerXform({
          tag: 'family',
          attr: 'val'
        })
      },
      outline: {
        prop: 'outline',
        xform: new BooleanXform({
          tag: 'outline',
          attr: 'val'
        })
      },
      vertAlign: {
        prop: 'vertAlign',
        xform: new StringXform({
          tag: 'vertAlign',
          attr: 'val'
        })
      },
      scheme: {
        prop: 'scheme',
        xform: new StringXform({
          tag: 'scheme',
          attr: 'val'
        })
      },
      shadow: {
        prop: 'shadow',
        xform: new BooleanXform({
          tag: 'shadow',
          attr: 'val'
        })
      },
      strike: {
        prop: 'strike',
        xform: new BooleanXform({
          tag: 'strike',
          attr: 'val'
        })
      },
      sz: {
        prop: 'size',
        xform: new IntegerXform({
          tag: 'sz',
          attr: 'val'
        })
      }
    };
    _this.map[_this.options.fontNameTag] = {
      prop: 'name',
      xform: new StringXform({
        tag: _this.options.fontNameTag,
        attr: 'val'
      })
    };
    return _this;
  }

  _createClass(FontXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      var map = this.map;
      xmlStream.openNode(this.options.tagName);

      _.each(this.map, function (defn, tag) {
        map[tag].xform.render(xmlStream, model[defn.prop]);
      });

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      if (this.map[node.name]) {
        this.parser = this.map[node.name].xform;
        return this.parser.parseOpen(node);
      }

      switch (node.name) {
        case this.options.tagName:
          this.model = {};
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser && !this.parser.parseClose(name)) {
        var item = this.map[name];

        if (this.parser.model) {
          this.model[item.prop] = this.parser.model;
        }

        this.parser = undefined;
        return true;
      }

      switch (name) {
        case this.options.tagName:
          return false;

        default:
          return true;
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return this.options.tagName;
    }
  }]);

  return FontXform;
}(BaseXform);

FontXform.OPTIONS = {
  tagName: 'font',
  fontNameTag: 'name'
};
module.exports = FontXform;

},{"../../../utils/under-dash":25,"../base-xform":31,"../simple/boolean-xform":115,"../simple/integer-xform":117,"../simple/string-xform":118,"./color-xform":127,"./underline-xform":135}],131:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var _ = require('../../../utils/under-dash');

var defaultNumFormats = require('../../defaultnumformats');

var BaseXform = require('../base-xform');

function hashDefaultFormats() {
  var hash = {};

  _.each(defaultNumFormats, function (dnf, id) {
    if (dnf.f) {
      hash[dnf.f] = parseInt(id, 10);
    } // at some point, add the other cultures here...

  });

  return hash;
}

var defaultFmtHash = hashDefaultFormats(); // NumFmt encapsulates translation between number format and xlsx

var NumFmtXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(NumFmtXform, _BaseXform);

  var _super = _createSuper(NumFmtXform);

  function NumFmtXform(id, formatCode) {
    var _this;

    _classCallCheck(this, NumFmtXform);

    _this = _super.call(this);
    _this.id = id;
    _this.formatCode = formatCode;
    return _this;
  }

  _createClass(NumFmtXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode('numFmt', {
        numFmtId: model.id,
        formatCode: model.formatCode
      });
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      switch (node.name) {
        case 'numFmt':
          this.model = {
            id: parseInt(node.attributes.numFmtId, 10),
            formatCode: node.attributes.formatCode.replace(/[\\](.)/g, '$1')
          };
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'numFmt';
    }
  }]);

  return NumFmtXform;
}(BaseXform);

NumFmtXform.getDefaultFmtId = function getDefaultFmtId(formatCode) {
  return defaultFmtHash[formatCode];
};

NumFmtXform.getDefaultFmtCode = function getDefaultFmtCode(numFmtId) {
  return defaultNumFormats[numFmtId] && defaultNumFormats[numFmtId].f;
};

module.exports = NumFmtXform;

},{"../../../utils/under-dash":25,"../../defaultnumformats":29,"../base-xform":31}],132:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var validation = {
  boolean: function boolean(value, dflt) {
    if (value === undefined) {
      return dflt;
    }

    return value;
  }
}; // Protection encapsulates translation from style.protection model to/from xlsx

var ProtectionXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(ProtectionXform, _BaseXform);

  var _super = _createSuper(ProtectionXform);

  function ProtectionXform() {
    _classCallCheck(this, ProtectionXform);

    return _super.apply(this, arguments);
  }

  _createClass(ProtectionXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.addRollback();
      xmlStream.openNode('protection');
      var isValid = false;

      function add(name, value) {
        if (value !== undefined) {
          xmlStream.addAttribute(name, value);
          isValid = true;
        }
      }

      add('locked', validation.boolean(model.locked, true) ? undefined : '0');
      add('hidden', validation.boolean(model.hidden, false) ? '1' : undefined);
      xmlStream.closeNode();

      if (isValid) {
        xmlStream.commit();
      } else {
        xmlStream.rollback();
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      var model = {
        locked: !(node.attributes.locked === '0'),
        hidden: node.attributes.hidden === '1'
      }; // only want to record models that differ from defaults

      var isSignificant = !model.locked || model.hidden;
      this.model = isSignificant ? model : null;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'protection';
    }
  }]);

  return ProtectionXform;
}(BaseXform);

module.exports = ProtectionXform;

},{"../base-xform":31}],133:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var AlignmentXform = require('./alignment-xform');

var ProtectionXform = require('./protection-xform'); // <xf numFmtId="[numFmtId]" fontId="[fontId]" fillId="[fillId]" borderId="[xf.borderId]" xfId="[xfId]">
//   Optional <alignment>
//   Optional <protection>
// </xf>
// Style assists translation from style model to/from xlsx


var StyleXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(StyleXform, _BaseXform);

  var _super = _createSuper(StyleXform);

  function StyleXform(options) {
    var _this;

    _classCallCheck(this, StyleXform);

    _this = _super.call(this);
    _this.xfId = !!(options && options.xfId);
    _this.map = {
      alignment: new AlignmentXform(),
      protection: new ProtectionXform()
    };
    return _this;
  }

  _createClass(StyleXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openNode('xf', {
        numFmtId: model.numFmtId || 0,
        fontId: model.fontId || 0,
        fillId: model.fillId || 0,
        borderId: model.borderId || 0
      });

      if (this.xfId) {
        xmlStream.addAttribute('xfId', model.xfId || 0);
      }

      if (model.numFmtId) {
        xmlStream.addAttribute('applyNumberFormat', '1');
      }

      if (model.fontId) {
        xmlStream.addAttribute('applyFont', '1');
      }

      if (model.fillId) {
        xmlStream.addAttribute('applyFill', '1');
      }

      if (model.borderId) {
        xmlStream.addAttribute('applyBorder', '1');
      }

      if (model.alignment) {
        xmlStream.addAttribute('applyAlignment', '1');
      }

      if (model.protection) {
        xmlStream.addAttribute('applyProtection', '1');
      }
      /**
       * Rendering tags causes close of XML stream.
       * Therefore adding attributes must be done before rendering tags.
       */


      if (model.alignment) {
        this.map.alignment.render(xmlStream, model.alignment);
      }

      if (model.protection) {
        this.map.protection.render(xmlStream, model.protection);
      }

      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      } // used during sax parsing of xml to build font object


      switch (node.name) {
        case 'xf':
          this.model = {
            numFmtId: parseInt(node.attributes.numFmtId, 10),
            fontId: parseInt(node.attributes.fontId, 10),
            fillId: parseInt(node.attributes.fillId, 10),
            borderId: parseInt(node.attributes.borderId, 10)
          };

          if (this.xfId) {
            this.model.xfId = parseInt(node.attributes.xfId, 10);
          }

          return true;

        case 'alignment':
          this.parser = this.map.alignment;
          this.parser.parseOpen(node);
          return true;

        case 'protection':
          this.parser = this.map.protection;
          this.parser.parseOpen(node);
          return true;

        default:
          return false;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          if (this.map.protection === this.parser) {
            this.model.protection = this.parser.model;
          } else {
            this.model.alignment = this.parser.model;
          }

          this.parser = undefined;
        }

        return true;
      }

      return name !== 'xf';
    }
  }, {
    key: "tag",
    get: function get() {
      return 'xf';
    }
  }]);

  return StyleXform;
}(BaseXform);

module.exports = StyleXform;

},{"../base-xform":31,"./alignment-xform":125,"./protection-xform":132}],134:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/* eslint-disable max-classes-per-file */
var Enums = require('../../../doc/enums');

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var StaticXform = require('../static-xform');

var ListXform = require('../list-xform');

var FontXform = require('./font-xform');

var FillXform = require('./fill-xform');

var BorderXform = require('./border-xform');

var NumFmtXform = require('./numfmt-xform');

var StyleXform = require('./style-xform');

var DxfXform = require('./dxf-xform'); // custom numfmt ids start here


var NUMFMT_BASE = 164; // =============================================================================
// StylesXform is used to generate and parse the styles.xml file
// it manages the collections of fonts, number formats, alignments, etc

var StylesXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(StylesXform, _BaseXform);

  var _super = _createSuper(StylesXform);

  function StylesXform(initialise) {
    var _this;

    _classCallCheck(this, StylesXform);

    _this = _super.call(this);
    _this.map = {
      numFmts: new ListXform({
        tag: 'numFmts',
        count: true,
        childXform: new NumFmtXform()
      }),
      fonts: new ListXform({
        tag: 'fonts',
        count: true,
        childXform: new FontXform(),
        $: {
          'x14ac:knownFonts': 1
        }
      }),
      fills: new ListXform({
        tag: 'fills',
        count: true,
        childXform: new FillXform()
      }),
      borders: new ListXform({
        tag: 'borders',
        count: true,
        childXform: new BorderXform()
      }),
      cellStyleXfs: new ListXform({
        tag: 'cellStyleXfs',
        count: true,
        childXform: new StyleXform()
      }),
      cellXfs: new ListXform({
        tag: 'cellXfs',
        count: true,
        childXform: new StyleXform({
          xfId: true
        })
      }),
      dxfs: new ListXform({
        tag: 'dxfs',
        always: true,
        count: true,
        childXform: new DxfXform()
      }),
      // for style manager
      numFmt: new NumFmtXform(),
      font: new FontXform(),
      fill: new FillXform(),
      border: new BorderXform(),
      style: new StyleXform({
        xfId: true
      }),
      cellStyles: StylesXform.STATIC_XFORMS.cellStyles,
      tableStyles: StylesXform.STATIC_XFORMS.tableStyles,
      extLst: StylesXform.STATIC_XFORMS.extLst
    };

    if (initialise) {
      // StylesXform also acts as style manager and is used to build up styles-model during worksheet processing
      _this.init();
    }

    return _this;
  }

  _createClass(StylesXform, [{
    key: "initIndex",
    value: function initIndex() {
      this.index = {
        style: {},
        numFmt: {},
        numFmtNextId: 164,
        // start custom format ids here
        font: {},
        border: {},
        fill: {}
      };
    }
  }, {
    key: "init",
    value: function init() {
      // Prepare for Style Manager role
      this.model = {
        styles: [],
        numFmts: [],
        fonts: [],
        borders: [],
        fills: [],
        dxfs: []
      };
      this.initIndex(); // default (zero) border

      this._addBorder({}); // add default (all zero) style


      this._addStyle({
        numFmtId: 0,
        fontId: 0,
        fillId: 0,
        borderId: 0,
        xfId: 0
      }); // add default fills


      this._addFill({
        type: 'pattern',
        pattern: 'none'
      });

      this._addFill({
        type: 'pattern',
        pattern: 'gray125'
      });

      this.weakMap = new WeakMap();
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      model = model || this.model; //
      //   <fonts count="2" x14ac:knownFonts="1">

      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode('styleSheet', StylesXform.STYLESHEET_ATTRIBUTES);

      if (this.index) {
        // model has been built by style manager role (contains xml)
        if (model.numFmts && model.numFmts.length) {
          xmlStream.openNode('numFmts', {
            count: model.numFmts.length
          });
          model.numFmts.forEach(function (numFmtXml) {
            xmlStream.writeXml(numFmtXml);
          });
          xmlStream.closeNode();
        }

        if (!model.fonts.length) {
          // default (zero) font
          this._addFont({
            size: 11,
            color: {
              theme: 1
            },
            name: 'Calibri',
            family: 2,
            scheme: 'minor'
          });
        }

        xmlStream.openNode('fonts', {
          count: model.fonts.length,
          'x14ac:knownFonts': 1
        });
        model.fonts.forEach(function (fontXml) {
          xmlStream.writeXml(fontXml);
        });
        xmlStream.closeNode();
        xmlStream.openNode('fills', {
          count: model.fills.length
        });
        model.fills.forEach(function (fillXml) {
          xmlStream.writeXml(fillXml);
        });
        xmlStream.closeNode();
        xmlStream.openNode('borders', {
          count: model.borders.length
        });
        model.borders.forEach(function (borderXml) {
          xmlStream.writeXml(borderXml);
        });
        xmlStream.closeNode();
        this.map.cellStyleXfs.render(xmlStream, [{
          numFmtId: 0,
          fontId: 0,
          fillId: 0,
          borderId: 0,
          xfId: 0
        }]);
        xmlStream.openNode('cellXfs', {
          count: model.styles.length
        });
        model.styles.forEach(function (styleXml) {
          xmlStream.writeXml(styleXml);
        });
        xmlStream.closeNode();
      } else {
        // model is plain JSON and needs to be xformed
        this.map.numFmts.render(xmlStream, model.numFmts);
        this.map.fonts.render(xmlStream, model.fonts);
        this.map.fills.render(xmlStream, model.fills);
        this.map.borders.render(xmlStream, model.borders);
        this.map.cellStyleXfs.render(xmlStream, [{
          numFmtId: 0,
          fontId: 0,
          fillId: 0,
          borderId: 0,
          xfId: 0
        }]);
        this.map.cellXfs.render(xmlStream, model.styles);
      }

      StylesXform.STATIC_XFORMS.cellStyles.render(xmlStream);
      this.map.dxfs.render(xmlStream, model.dxfs);
      StylesXform.STATIC_XFORMS.tableStyles.render(xmlStream);
      StylesXform.STATIC_XFORMS.extLst.render(xmlStream);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case 'styleSheet':
          this.initIndex();
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          return true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      var _this2 = this;

      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case 'styleSheet':
          {
            this.model = {};

            var add = function add(propName, xform) {
              if (xform.model && xform.model.length) {
                _this2.model[propName] = xform.model;
              }
            };

            add('numFmts', this.map.numFmts);
            add('fonts', this.map.fonts);
            add('fills', this.map.fills);
            add('borders', this.map.borders);
            add('styles', this.map.cellXfs);
            add('dxfs', this.map.dxfs); // index numFmts

            this.index = {
              model: [],
              numFmt: []
            };

            if (this.model.numFmts) {
              var numFmtIndex = this.index.numFmt;
              this.model.numFmts.forEach(function (numFmt) {
                numFmtIndex[numFmt.id] = numFmt.formatCode;
              });
            }

            return false;
          }

        default:
          // not quite sure how we get here!
          return true;
      }
    } // add a cell's style model to the collection
    // each style property is processed and cross-referenced, etc.
    // the styleId is returned. Note: cellType is used when numFmt not defined

  }, {
    key: "addStyleModel",
    value: function addStyleModel(model, cellType) {
      if (!model) {
        return 0;
      } // if we have no default font, add it here now


      if (!this.model.fonts.length) {
        // default (zero) font
        this._addFont({
          size: 11,
          color: {
            theme: 1
          },
          name: 'Calibri',
          family: 2,
          scheme: 'minor'
        });
      } // if we have seen this style object before, assume it has the same styleId


      if (this.weakMap && this.weakMap.has(model)) {
        return this.weakMap.get(model);
      }

      var style = {};
      cellType = cellType || Enums.ValueType.Number;

      if (model.numFmt) {
        style.numFmtId = this._addNumFmtStr(model.numFmt);
      } else {
        switch (cellType) {
          case Enums.ValueType.Number:
            style.numFmtId = this._addNumFmtStr('General');
            break;

          case Enums.ValueType.Date:
            style.numFmtId = this._addNumFmtStr('mm-dd-yy');
            break;

          default:
            break;
        }
      }

      if (model.font) {
        style.fontId = this._addFont(model.font);
      }

      if (model.border) {
        style.borderId = this._addBorder(model.border);
      }

      if (model.fill) {
        style.fillId = this._addFill(model.fill);
      }

      if (model.alignment) {
        style.alignment = model.alignment;
      }

      if (model.protection) {
        style.protection = model.protection;
      }

      var styleId = this._addStyle(style);

      if (this.weakMap) {
        this.weakMap.set(model, styleId);
      }

      return styleId;
    } // given a styleId (i.e. s="n"), get the cell's style model
    // objects are shared where possible.

  }, {
    key: "getStyleModel",
    value: function getStyleModel(id) {
      // if the style doesn't exist return null
      var style = this.model.styles[id];
      if (!style) return null; // have we built this model before?

      var model = this.index.model[id];
      if (model) return model; // build a new model

      model = this.index.model[id] = {}; // -------------------------------------------------------
      // number format

      if (style.numFmtId) {
        var numFmt = this.index.numFmt[style.numFmtId] || NumFmtXform.getDefaultFmtCode(style.numFmtId);

        if (numFmt) {
          model.numFmt = numFmt;
        }
      }

      function addStyle(name, group, styleId) {
        if (styleId || styleId === 0) {
          var part = group[styleId];

          if (part) {
            model[name] = part;
          }
        }
      }

      addStyle('font', this.model.fonts, style.fontId);
      addStyle('border', this.model.borders, style.borderId);
      addStyle('fill', this.model.fills, style.fillId); // -------------------------------------------------------
      // alignment

      if (style.alignment) {
        model.alignment = style.alignment;
      } // -------------------------------------------------------
      // protection


      if (style.protection) {
        model.protection = style.protection;
      }

      return model;
    }
  }, {
    key: "addDxfStyle",
    value: function addDxfStyle(style) {
      this.model.dxfs.push(style);
      return this.model.dxfs.length - 1;
    }
  }, {
    key: "getDxfStyle",
    value: function getDxfStyle(id) {
      return this.model.dxfs[id];
    } // =========================================================================
    // Private Interface

  }, {
    key: "_addStyle",
    value: function _addStyle(style) {
      var xml = this.map.style.toXml(style);
      var index = this.index.style[xml];

      if (index === undefined) {
        index = this.index.style[xml] = this.model.styles.length;
        this.model.styles.push(xml);
      }

      return index;
    } // =========================================================================
    // Number Formats

  }, {
    key: "_addNumFmtStr",
    value: function _addNumFmtStr(formatCode) {
      // check if default format
      var index = NumFmtXform.getDefaultFmtId(formatCode);
      if (index !== undefined) return index; // check if already in

      index = this.index.numFmt[formatCode];
      if (index !== undefined) return index;
      index = this.index.numFmt[formatCode] = NUMFMT_BASE + this.model.numFmts.length;
      var xml = this.map.numFmt.toXml({
        id: index,
        formatCode: formatCode
      });
      this.model.numFmts.push(xml);
      return index;
    } // =========================================================================
    // Fonts

  }, {
    key: "_addFont",
    value: function _addFont(font) {
      var xml = this.map.font.toXml(font);
      var index = this.index.font[xml];

      if (index === undefined) {
        index = this.index.font[xml] = this.model.fonts.length;
        this.model.fonts.push(xml);
      }

      return index;
    } // =========================================================================
    // Borders

  }, {
    key: "_addBorder",
    value: function _addBorder(border) {
      var xml = this.map.border.toXml(border);
      var index = this.index.border[xml];

      if (index === undefined) {
        index = this.index.border[xml] = this.model.borders.length;
        this.model.borders.push(xml);
      }

      return index;
    } // =========================================================================
    // Fills

  }, {
    key: "_addFill",
    value: function _addFill(fill) {
      var xml = this.map.fill.toXml(fill);
      var index = this.index.fill[xml];

      if (index === undefined) {
        index = this.index.fill[xml] = this.model.fills.length;
        this.model.fills.push(xml);
      }

      return index;
    } // =========================================================================

  }]);

  return StylesXform;
}(BaseXform);

StylesXform.STYLESHEET_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
  'xmlns:mc': 'http://schemas.openxmlformats.org/markup-compatibility/2006',
  'mc:Ignorable': 'x14ac x16r2',
  'xmlns:x14ac': 'http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac',
  'xmlns:x16r2': 'http://schemas.microsoft.com/office/spreadsheetml/2015/02/main'
};
StylesXform.STATIC_XFORMS = {
  cellStyles: new StaticXform({
    tag: 'cellStyles',
    $: {
      count: 1
    },
    c: [{
      tag: 'cellStyle',
      $: {
        name: 'Normal',
        xfId: 0,
        builtinId: 0
      }
    }]
  }),
  dxfs: new StaticXform({
    tag: 'dxfs',
    $: {
      count: 0
    }
  }),
  tableStyles: new StaticXform({
    tag: 'tableStyles',
    $: {
      count: 0,
      defaultTableStyle: 'TableStyleMedium2',
      defaultPivotStyle: 'PivotStyleLight16'
    }
  }),
  extLst: new StaticXform({
    tag: 'extLst',
    c: [{
      tag: 'ext',
      $: {
        uri: '{EB79DEF2-80B8-43e5-95BD-54CBDDF9020C}',
        'xmlns:x14': 'http://schemas.microsoft.com/office/spreadsheetml/2009/9/main'
      },
      c: [{
        tag: 'x14:slicerStyles',
        $: {
          defaultSlicerStyle: 'SlicerStyleLight1'
        }
      }]
    }, {
      tag: 'ext',
      $: {
        uri: '{9260A510-F301-46a8-8635-F512D64BE5F5}',
        'xmlns:x15': 'http://schemas.microsoft.com/office/spreadsheetml/2010/11/main'
      },
      c: [{
        tag: 'x15:timelineStyles',
        $: {
          defaultTimelineStyle: 'TimeSlicerStyleLight1'
        }
      }]
    }]
  })
}; // the stylemanager mock acts like StyleManager except that it always returns 0 or {}

var StylesXformMock = /*#__PURE__*/function (_StylesXform) {
  _inherits(StylesXformMock, _StylesXform);

  var _super2 = _createSuper(StylesXformMock);

  function StylesXformMock() {
    var _this3;

    _classCallCheck(this, StylesXformMock);

    _this3 = _super2.call(this);
    _this3.model = {
      styles: [{
        numFmtId: 0,
        fontId: 0,
        fillId: 0,
        borderId: 0,
        xfId: 0
      }],
      numFmts: [],
      fonts: [{
        size: 11,
        color: {
          theme: 1
        },
        name: 'Calibri',
        family: 2,
        scheme: 'minor'
      }],
      borders: [{}],
      fills: [{
        type: 'pattern',
        pattern: 'none'
      }, {
        type: 'pattern',
        pattern: 'gray125'
      }]
    };
    return _this3;
  } // =========================================================================
  // Style Manager Interface
  // override normal behaviour - consume and dispose


  _createClass(StylesXformMock, [{
    key: "parseStream",
    value: function parseStream(stream) {
      stream.autodrain();
      return Promise.resolve();
    } // add a cell's style model to the collection
    // each style property is processed and cross-referenced, etc.
    // the styleId is returned. Note: cellType is used when numFmt not defined

  }, {
    key: "addStyleModel",
    value: function addStyleModel(model, cellType) {
      switch (cellType) {
        case Enums.ValueType.Date:
          return this.dateStyleId;

        default:
          return 0;
      }
    }
  }, {
    key: "getStyleModel",
    // given a styleId (i.e. s="n"), get the cell's style model
    // objects are shared where possible.
    value: function getStyleModel()
    /* id */
    {
      return {};
    }
  }, {
    key: "dateStyleId",
    get: function get() {
      if (!this._dateStyleId) {
        var dateStyle = {
          numFmtId: NumFmtXform.getDefaultFmtId('mm-dd-yy')
        };
        this._dateStyleId = this.model.styles.length;
        this.model.styles.push(dateStyle);
      }

      return this._dateStyleId;
    }
  }]);

  return StylesXformMock;
}(StylesXform);

StylesXform.Mock = StylesXformMock;
module.exports = StylesXform;

},{"../../../doc/enums":7,"../../../utils/xml-stream":27,"../base-xform":31,"../list-xform":70,"../static-xform":119,"./border-xform":126,"./dxf-xform":128,"./fill-xform":129,"./font-xform":130,"./numfmt-xform":131,"./style-xform":133}],135:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var UnderlineXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(UnderlineXform, _BaseXform);

  var _super = _createSuper(UnderlineXform);

  function UnderlineXform(model) {
    var _this;

    _classCallCheck(this, UnderlineXform);

    _this = _super.call(this);
    _this.model = model;
    return _this;
  }

  _createClass(UnderlineXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      model = model || this.model;

      if (model === true) {
        xmlStream.leafNode('u');
      } else {
        var attr = UnderlineXform.Attributes[model];

        if (attr) {
          xmlStream.leafNode('u', attr);
        }
      }
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === 'u') {
        this.model = node.attributes.val || true;
      }
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'u';
    }
  }]);

  return UnderlineXform;
}(BaseXform);

UnderlineXform.Attributes = {
  single: {},
  double: {
    val: 'double'
  },
  singleAccounting: {
    val: 'singleAccounting'
  },
  doubleAccounting: {
    val: 'doubleAccounting'
  }
};
module.exports = UnderlineXform;

},{"../base-xform":31}],136:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var FilterColumnXform = require('./filter-column-xform');

var AutoFilterXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(AutoFilterXform, _BaseXform);

  var _super = _createSuper(AutoFilterXform);

  function AutoFilterXform() {
    var _this;

    _classCallCheck(this, AutoFilterXform);

    _this = _super.call(this);
    _this.map = {
      filterColumn: new FilterColumnXform()
    };
    return _this;
  }

  _createClass(AutoFilterXform, [{
    key: "prepare",
    value: function prepare(model) {
      var _this2 = this;

      model.columns.forEach(function (column, index) {
        _this2.map.filterColumn.prepare(column, {
          index: index
        });
      });
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      var _this3 = this;

      xmlStream.openNode(this.tag, {
        ref: model.autoFilterRef
      });
      model.columns.forEach(function (column) {
        _this3.map.filterColumn.render(xmlStream, column);
      });
      xmlStream.closeNode();
      return true;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      switch (node.name) {
        case this.tag:
          this.model = {
            autoFilterRef: node.attributes.ref,
            columns: []
          };
          return true;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parseOpen(node);
            return true;
          }

          throw new Error("Unexpected xml node in parseOpen: ".concat(JSON.stringify(node)));
      }
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.model.columns.push(this.parser.model);
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          return false;

        default:
          throw new Error("Unexpected xml node in parseClose: ".concat(name));
      }
    }
  }, {
    key: "tag",
    get: function get() {
      return 'autoFilter';
    }
  }]);

  return AutoFilterXform;
}(BaseXform);

module.exports = AutoFilterXform;

},{"../base-xform":31,"./filter-column-xform":137}],137:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var FilterColumnXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(FilterColumnXform, _BaseXform);

  var _super = _createSuper(FilterColumnXform);

  function FilterColumnXform() {
    _classCallCheck(this, FilterColumnXform);

    return _super.apply(this, arguments);
  }

  _createClass(FilterColumnXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      model.colId = options.index.toString();
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        colId: model.colId,
        hiddenButton: model.filterButton ? '0' : '1'
      });
      return true;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        var attributes = node.attributes;
        this.model = {
          filterButton: attributes.hiddenButton === '0'
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'filterColumn';
    }
  }]);

  return FilterColumnXform;
}(BaseXform);

module.exports = FilterColumnXform;

},{"../base-xform":31}],138:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var TableColumnXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(TableColumnXform, _BaseXform);

  var _super = _createSuper(TableColumnXform);

  function TableColumnXform() {
    _classCallCheck(this, TableColumnXform);

    return _super.apply(this, arguments);
  }

  _createClass(TableColumnXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      model.id = options.index + 1;
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        id: model.id.toString(),
        name: model.name,
        totalsRowLabel: model.totalsRowLabel,
        totalsRowFunction: model.totalsRowFunction,
        dxfId: model.dxfId
      });
      return true;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        var attributes = node.attributes;
        this.model = {
          name: attributes.name,
          totalsRowLabel: attributes.totalsRowLabel,
          totalsRowFunction: attributes.totalsRowFunction,
          dxfId: attributes.dxfId
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'tableColumn';
    }
  }]);

  return TableColumnXform;
}(BaseXform);

module.exports = TableColumnXform;

},{"../base-xform":31}],139:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var BaseXform = require('../base-xform');

var TableStyleInfoXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(TableStyleInfoXform, _BaseXform);

  var _super = _createSuper(TableStyleInfoXform);

  function TableStyleInfoXform() {
    _classCallCheck(this, TableStyleInfoXform);

    return _super.apply(this, arguments);
  }

  _createClass(TableStyleInfoXform, [{
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.leafNode(this.tag, {
        name: model.theme ? model.theme : undefined,
        showFirstColumn: model.showFirstColumn ? '1' : '0',
        showLastColumn: model.showLastColumn ? '1' : '0',
        showRowStripes: model.showRowStripes ? '1' : '0',
        showColumnStripes: model.showColumnStripes ? '1' : '0'
      });
      return true;
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (node.name === this.tag) {
        var attributes = node.attributes;
        this.model = {
          theme: attributes.name ? attributes.name : null,
          showFirstColumn: attributes.showFirstColumn === '1',
          showLastColumn: attributes.showLastColumn === '1',
          showRowStripes: attributes.showRowStripes === '1',
          showColumnStripes: attributes.showColumnStripes === '1'
        };
        return true;
      }

      return false;
    }
  }, {
    key: "parseText",
    value: function parseText() {}
  }, {
    key: "parseClose",
    value: function parseClose() {
      return false;
    }
  }, {
    key: "tag",
    get: function get() {
      return 'tableStyleInfo';
    }
  }]);

  return TableStyleInfoXform;
}(BaseXform);

module.exports = TableStyleInfoXform;

},{"../base-xform":31}],140:[function(require,module,exports){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var XmlStream = require('../../../utils/xml-stream');

var BaseXform = require('../base-xform');

var ListXform = require('../list-xform');

var AutoFilterXform = require('./auto-filter-xform');

var TableColumnXform = require('./table-column-xform');

var TableStyleInfoXform = require('./table-style-info-xform');

var TableXform = /*#__PURE__*/function (_BaseXform) {
  _inherits(TableXform, _BaseXform);

  var _super = _createSuper(TableXform);

  function TableXform() {
    var _this;

    _classCallCheck(this, TableXform);

    _this = _super.call(this);
    _this.map = {
      autoFilter: new AutoFilterXform(),
      tableColumns: new ListXform({
        tag: 'tableColumns',
        count: true,
        empty: true,
        childXform: new TableColumnXform()
      }),
      tableStyleInfo: new TableStyleInfoXform()
    };
    return _this;
  }

  _createClass(TableXform, [{
    key: "prepare",
    value: function prepare(model, options) {
      this.map.autoFilter.prepare(model);
      this.map.tableColumns.prepare(model.columns, options);
    }
  }, {
    key: "render",
    value: function render(xmlStream, model) {
      xmlStream.openXml(XmlStream.StdDocAttributes);
      xmlStream.openNode(this.tag, _objectSpread(_objectSpread({}, TableXform.TABLE_ATTRIBUTES), {}, {
        id: model.id,
        name: model.name,
        displayName: model.displayName || model.name,
        ref: model.tableRef,
        totalsRowCount: model.totalsRow ? '1' : undefined,
        totalsRowShown: model.totalsRow ? undefined : '1',
        headerRowCount: model.headerRow ? '1' : '0'
      }));
      this.map.autoFilter.render(xmlStream, model);
      this.map.tableColumns.render(xmlStream, model.columns);
      this.map.tableStyleInfo.render(xmlStream, model.style);
      xmlStream.closeNode();
    }
  }, {
    key: "parseOpen",
    value: function parseOpen(node) {
      if (this.parser) {
        this.parser.parseOpen(node);
        return true;
      }

      var name = node.name,
          attributes = node.attributes;

      switch (name) {
        case this.tag:
          this.reset();
          this.model = {
            name: attributes.name,
            displayName: attributes.displayName || attributes.name,
            tableRef: attributes.ref,
            totalsRow: attributes.totalsRowCount === '1',
            headerRow: attributes.headerRowCount === '1'
          };
          break;

        default:
          this.parser = this.map[node.name];

          if (this.parser) {
            this.parser.parseOpen(node);
          }

          break;
      }

      return true;
    }
  }, {
    key: "parseText",
    value: function parseText(text) {
      if (this.parser) {
        this.parser.parseText(text);
      }
    }
  }, {
    key: "parseClose",
    value: function parseClose(name) {
      var _this2 = this;

      if (this.parser) {
        if (!this.parser.parseClose(name)) {
          this.parser = undefined;
        }

        return true;
      }

      switch (name) {
        case this.tag:
          this.model.columns = this.map.tableColumns.model;

          if (this.map.autoFilter.model) {
            this.model.autoFilterRef = this.map.autoFilter.model.autoFilterRef;
            this.map.autoFilter.model.columns.forEach(function (column, index) {
              _this2.model.columns[index].filterButton = column.filterButton;
            });
          }

          this.model.style = this.map.tableStyleInfo.model;
          return false;

        default:
          // could be some unrecognised tags
          return true;
      }
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      // fetch the dfxs from styles
      model.columns.forEach(function (column) {
        if (column.dxfId !== undefined) {
          column.style = options.styles.getDxfStyle(column.dxfId);
        }
      });
    }
  }, {
    key: "tag",
    get: function get() {
      return 'table';
    }
  }]);

  return TableXform;
}(BaseXform);

TableXform.TABLE_ATTRIBUTES = {
  xmlns: 'http://schemas.openxmlformats.org/spreadsheetml/2006/main',
  'xmlns:mc': 'http://schemas.openxmlformats.org/markup-compatibility/2006',
  'mc:Ignorable': 'xr xr3',
  'xmlns:xr': 'http://schemas.microsoft.com/office/spreadsheetml/2014/revision',
  'xmlns:xr3': 'http://schemas.microsoft.com/office/spreadsheetml/2016/revision3' // 'xr:uid': '{00000000-000C-0000-FFFF-FFFF00000000}',

};
module.exports = TableXform;

},{"../../../utils/xml-stream":27,"../base-xform":31,"../list-xform":70,"./auto-filter-xform":136,"./table-column-xform":138,"./table-style-info-xform":139}],141:[function(require,module,exports){
(function (process,Buffer){
"use strict";

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _asyncIterator(iterable) { var method; if (typeof Symbol !== "undefined") { if (Symbol.asyncIterator) { method = iterable[Symbol.asyncIterator]; if (method != null) return method.call(iterable); } if (Symbol.iterator) { method = iterable[Symbol.iterator]; if (method != null) return method.call(iterable); } } throw new TypeError("Object is not async iterable"); }

var fs = require('fs');

var JSZip = require('jszip');

var _require = require('readable-stream'),
    PassThrough = _require.PassThrough;

var ZipStream = require('../utils/zip-stream');

var StreamBuf = require('../utils/stream-buf');

var utils = require('../utils/utils');

var XmlStream = require('../utils/xml-stream');

var _require2 = require('../utils/browser-buffer-decode'),
    bufferToString = _require2.bufferToString;

var StylesXform = require('./xform/style/styles-xform');

var CoreXform = require('./xform/core/core-xform');

var SharedStringsXform = require('./xform/strings/shared-strings-xform');

var RelationshipsXform = require('./xform/core/relationships-xform');

var ContentTypesXform = require('./xform/core/content-types-xform');

var AppXform = require('./xform/core/app-xform');

var WorkbookXform = require('./xform/book/workbook-xform');

var WorksheetXform = require('./xform/sheet/worksheet-xform');

var DrawingXform = require('./xform/drawing/drawing-xform');

var TableXform = require('./xform/table/table-xform');

var CommentsXform = require('./xform/comment/comments-xform');

var VmlNotesXform = require('./xform/comment/vml-notes-xform');

var theme1Xml = require('./xml/theme1.js');

function fsReadFileAsync(filename, options) {
  return new Promise(function (resolve, reject) {
    fs.readFile(filename, options, function (error, data) {
      if (error) {
        reject(error);
      } else {
        resolve(data);
      }
    });
  });
}

var XLSX = /*#__PURE__*/function () {
  function XLSX(workbook) {
    _classCallCheck(this, XLSX);

    this.workbook = workbook;
  } // ===============================================================================
  // Workbook
  // =========================================================================
  // Read


  _createClass(XLSX, [{
    key: "readFile",
    value: function () {
      var _readFile = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(filename, options) {
        var stream, workbook;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return utils.fs.exists(filename);

              case 2:
                if (_context.sent) {
                  _context.next = 4;
                  break;
                }

                throw new Error("File not found: ".concat(filename));

              case 4:
                stream = fs.createReadStream(filename);
                _context.prev = 5;
                _context.next = 8;
                return this.read(stream, options);

              case 8:
                workbook = _context.sent;
                stream.close();
                return _context.abrupt("return", workbook);

              case 13:
                _context.prev = 13;
                _context.t0 = _context["catch"](5);
                stream.close();
                throw _context.t0;

              case 17:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[5, 13]]);
      }));

      function readFile(_x, _x2) {
        return _readFile.apply(this, arguments);
      }

      return readFile;
    }()
  }, {
    key: "parseRels",
    value: function parseRels(stream) {
      var xform = new RelationshipsXform();
      return xform.parseStream(stream);
    }
  }, {
    key: "parseWorkbook",
    value: function parseWorkbook(stream) {
      var xform = new WorkbookXform();
      return xform.parseStream(stream);
    }
  }, {
    key: "parseSharedStrings",
    value: function parseSharedStrings(stream) {
      var xform = new SharedStringsXform();
      return xform.parseStream(stream);
    }
  }, {
    key: "reconcile",
    value: function reconcile(model, options) {
      var workbookXform = new WorkbookXform();
      var worksheetXform = new WorksheetXform(options);
      var drawingXform = new DrawingXform();
      var tableXform = new TableXform();
      workbookXform.reconcile(model); // reconcile drawings with their rels

      var drawingOptions = {
        media: model.media,
        mediaIndex: model.mediaIndex
      };
      Object.keys(model.drawings).forEach(function (name) {
        var drawing = model.drawings[name];
        var drawingRel = model.drawingRels[name];

        if (drawingRel) {
          drawingOptions.rels = drawingRel.reduce(function (o, rel) {
            o[rel.Id] = rel;
            return o;
          }, {});
          (drawing.anchors || []).forEach(function (anchor) {
            var hyperlinks = anchor.picture && anchor.picture.hyperlinks;

            if (hyperlinks && drawingOptions.rels[hyperlinks.rId]) {
              hyperlinks.hyperlink = drawingOptions.rels[hyperlinks.rId].Target;
              delete hyperlinks.rId;
            }
          });
          drawingXform.reconcile(drawing, drawingOptions);
        }
      }); // reconcile tables with the default styles

      var tableOptions = {
        styles: model.styles
      };
      Object.values(model.tables).forEach(function (table) {
        tableXform.reconcile(table, tableOptions);
      });
      var sheetOptions = {
        styles: model.styles,
        sharedStrings: model.sharedStrings,
        media: model.media,
        mediaIndex: model.mediaIndex,
        date1904: model.properties && model.properties.date1904,
        drawings: model.drawings,
        comments: model.comments,
        tables: model.tables,
        vmlDrawings: model.vmlDrawings
      };
      model.worksheets.forEach(function (worksheet) {
        worksheet.relationships = model.worksheetRels[worksheet.sheetNo];
        worksheetXform.reconcile(worksheet, sheetOptions);
      }); // delete unnecessary parts

      delete model.worksheetHash;
      delete model.worksheetRels;
      delete model.globalRels;
      delete model.sharedStrings;
      delete model.workbookRels;
      delete model.sheetDefs;
      delete model.styles;
      delete model.mediaIndex;
      delete model.drawings;
      delete model.drawingRels;
      delete model.vmlDrawings;
    }
  }, {
    key: "_processWorksheetEntry",
    value: function () {
      var _processWorksheetEntry2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(stream, model, sheetNo, options, path) {
        var xform, worksheet;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                xform = new WorksheetXform(options);
                _context2.next = 3;
                return xform.parseStream(stream);

              case 3:
                worksheet = _context2.sent;
                worksheet.sheetNo = sheetNo;
                model.worksheetHash[path] = worksheet;
                model.worksheets.push(worksheet);

              case 7:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function _processWorksheetEntry(_x3, _x4, _x5, _x6, _x7) {
        return _processWorksheetEntry2.apply(this, arguments);
      }

      return _processWorksheetEntry;
    }()
  }, {
    key: "_processCommentEntry",
    value: function () {
      var _processCommentEntry2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(stream, model, name) {
        var xform, comments;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                xform = new CommentsXform();
                _context3.next = 3;
                return xform.parseStream(stream);

              case 3:
                comments = _context3.sent;
                model.comments["../".concat(name, ".xml")] = comments;

              case 5:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }));

      function _processCommentEntry(_x8, _x9, _x10) {
        return _processCommentEntry2.apply(this, arguments);
      }

      return _processCommentEntry;
    }()
  }, {
    key: "_processTableEntry",
    value: function () {
      var _processTableEntry2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(stream, model, name) {
        var xform, table;
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                xform = new TableXform();
                _context4.next = 3;
                return xform.parseStream(stream);

              case 3:
                table = _context4.sent;
                model.tables["../tables/".concat(name, ".xml")] = table;

              case 5:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4);
      }));

      function _processTableEntry(_x11, _x12, _x13) {
        return _processTableEntry2.apply(this, arguments);
      }

      return _processTableEntry;
    }()
  }, {
    key: "_processWorksheetRelsEntry",
    value: function () {
      var _processWorksheetRelsEntry2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(stream, model, sheetNo) {
        var xform, relationships;
        return regeneratorRuntime.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                xform = new RelationshipsXform();
                _context5.next = 3;
                return xform.parseStream(stream);

              case 3:
                relationships = _context5.sent;
                model.worksheetRels[sheetNo] = relationships;

              case 5:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5);
      }));

      function _processWorksheetRelsEntry(_x14, _x15, _x16) {
        return _processWorksheetRelsEntry2.apply(this, arguments);
      }

      return _processWorksheetRelsEntry;
    }()
  }, {
    key: "_processMediaEntry",
    value: function () {
      var _processMediaEntry2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6(entry, model, filename) {
        var lastDot, extension, name;
        return regeneratorRuntime.wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                lastDot = filename.lastIndexOf('.'); // if we can't determine extension, ignore it

                if (!(lastDot >= 1)) {
                  _context6.next = 6;
                  break;
                }

                extension = filename.substr(lastDot + 1);
                name = filename.substr(0, lastDot);
                _context6.next = 6;
                return new Promise(function (resolve, reject) {
                  var streamBuf = new StreamBuf();
                  streamBuf.on('finish', function () {
                    model.mediaIndex[filename] = model.media.length;
                    model.mediaIndex[name] = model.media.length;
                    var medium = {
                      type: 'image',
                      name: name,
                      extension: extension,
                      buffer: streamBuf.toBuffer()
                    };
                    model.media.push(medium);
                    resolve();
                  });
                  entry.on('error', function (error) {
                    reject(error);
                  });
                  entry.pipe(streamBuf);
                });

              case 6:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6);
      }));

      function _processMediaEntry(_x17, _x18, _x19) {
        return _processMediaEntry2.apply(this, arguments);
      }

      return _processMediaEntry;
    }()
  }, {
    key: "_processDrawingEntry",
    value: function () {
      var _processDrawingEntry2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7(entry, model, name) {
        var xform, drawing;
        return regeneratorRuntime.wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                xform = new DrawingXform();
                _context7.next = 3;
                return xform.parseStream(entry);

              case 3:
                drawing = _context7.sent;
                model.drawings[name] = drawing;

              case 5:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7);
      }));

      function _processDrawingEntry(_x20, _x21, _x22) {
        return _processDrawingEntry2.apply(this, arguments);
      }

      return _processDrawingEntry;
    }()
  }, {
    key: "_processDrawingRelsEntry",
    value: function () {
      var _processDrawingRelsEntry2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8(entry, model, name) {
        var xform, relationships;
        return regeneratorRuntime.wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                xform = new RelationshipsXform();
                _context8.next = 3;
                return xform.parseStream(entry);

              case 3:
                relationships = _context8.sent;
                model.drawingRels[name] = relationships;

              case 5:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8);
      }));

      function _processDrawingRelsEntry(_x23, _x24, _x25) {
        return _processDrawingRelsEntry2.apply(this, arguments);
      }

      return _processDrawingRelsEntry;
    }()
  }, {
    key: "_processVmlDrawingEntry",
    value: function () {
      var _processVmlDrawingEntry2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9(entry, model, name) {
        var xform, vmlDrawing;
        return regeneratorRuntime.wrap(function _callee9$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                xform = new VmlNotesXform();
                _context9.next = 3;
                return xform.parseStream(entry);

              case 3:
                vmlDrawing = _context9.sent;
                model.vmlDrawings["../drawings/".concat(name, ".vml")] = vmlDrawing;

              case 5:
              case "end":
                return _context9.stop();
            }
          }
        }, _callee9);
      }));

      function _processVmlDrawingEntry(_x26, _x27, _x28) {
        return _processVmlDrawingEntry2.apply(this, arguments);
      }

      return _processVmlDrawingEntry;
    }()
  }, {
    key: "_processThemeEntry",
    value: function () {
      var _processThemeEntry2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10(entry, model, name) {
        return regeneratorRuntime.wrap(function _callee10$(_context10) {
          while (1) {
            switch (_context10.prev = _context10.next) {
              case 0:
                _context10.next = 2;
                return new Promise(function (resolve, reject) {
                  // TODO: stream entry into buffer and store the xml in the model.themes[]
                  var stream = new StreamBuf();
                  entry.on('error', reject);
                  stream.on('error', reject);
                  stream.on('finish', function () {
                    model.themes[name] = stream.read().toString();
                    resolve();
                  });
                  entry.pipe(stream);
                });

              case 2:
              case "end":
                return _context10.stop();
            }
          }
        }, _callee10);
      }));

      function _processThemeEntry(_x29, _x30, _x31) {
        return _processThemeEntry2.apply(this, arguments);
      }

      return _processThemeEntry;
    }()
    /**
     * @deprecated since version 4.0. You should use `#read` instead. Please follow upgrade instruction: https://github.com/exceljs/exceljs/blob/master/UPGRADE-4.0.md
     */

  }, {
    key: "createInputStream",
    value: function createInputStream() {
      throw new Error('`XLSX#createInputStream` is deprecated. You should use `XLSX#read` instead. This method will be removed in version 5.0. Please follow upgrade instruction: https://github.com/exceljs/exceljs/blob/master/UPGRADE-4.0.md');
    }
  }, {
    key: "read",
    value: function () {
      var _read = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee11(stream, options) {
        var chunks, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, _value, chunk;

        return regeneratorRuntime.wrap(function _callee11$(_context11) {
          while (1) {
            switch (_context11.prev = _context11.next) {
              case 0:
                // TODO: Remove once node v8 is deprecated
                // Detect and upgrade old streams
                if (!stream[Symbol.asyncIterator] && stream.pipe) {
                  stream = stream.pipe(new PassThrough());
                }

                chunks = [];
                _iteratorNormalCompletion = true;
                _didIteratorError = false;
                _context11.prev = 4;
                _iterator = _asyncIterator(stream);

              case 6:
                _context11.next = 8;
                return _iterator.next();

              case 8:
                _step = _context11.sent;
                _iteratorNormalCompletion = _step.done;
                _context11.next = 12;
                return _step.value;

              case 12:
                _value = _context11.sent;

                if (_iteratorNormalCompletion) {
                  _context11.next = 19;
                  break;
                }

                chunk = _value;
                chunks.push(chunk);

              case 16:
                _iteratorNormalCompletion = true;
                _context11.next = 6;
                break;

              case 19:
                _context11.next = 25;
                break;

              case 21:
                _context11.prev = 21;
                _context11.t0 = _context11["catch"](4);
                _didIteratorError = true;
                _iteratorError = _context11.t0;

              case 25:
                _context11.prev = 25;
                _context11.prev = 26;

                if (!(!_iteratorNormalCompletion && _iterator.return != null)) {
                  _context11.next = 30;
                  break;
                }

                _context11.next = 30;
                return _iterator.return();

              case 30:
                _context11.prev = 30;

                if (!_didIteratorError) {
                  _context11.next = 33;
                  break;
                }

                throw _iteratorError;

              case 33:
                return _context11.finish(30);

              case 34:
                return _context11.finish(25);

              case 35:
                return _context11.abrupt("return", this.load(Buffer.concat(chunks), options));

              case 36:
              case "end":
                return _context11.stop();
            }
          }
        }, _callee11, this, [[4, 21, 25, 35], [26,, 30, 34]]);
      }));

      function read(_x32, _x33) {
        return _read.apply(this, arguments);
      }

      return read;
    }()
  }, {
    key: "load",
    value: function () {
      var _load = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee12(data, options) {
        var buffer, model, zip, _i, _Object$values, entry, entryName, stream, content, chunkSize, i, workbook, appXform, appProperties, coreXform, coreProperties, match;

        return regeneratorRuntime.wrap(function _callee12$(_context12) {
          while (1) {
            switch (_context12.prev = _context12.next) {
              case 0:
                if (options && options.base64) {
                  buffer = Buffer.from(data.toString(), 'base64');
                } else {
                  buffer = data;
                }

                model = {
                  worksheets: [],
                  worksheetHash: {},
                  worksheetRels: [],
                  themes: {},
                  media: [],
                  mediaIndex: {},
                  drawings: {},
                  drawingRels: {},
                  comments: {},
                  tables: {},
                  vmlDrawings: {}
                };
                _context12.next = 4;
                return JSZip.loadAsync(buffer);

              case 4:
                zip = _context12.sent;
                _i = 0, _Object$values = Object.values(zip.files);

              case 6:
                if (!(_i < _Object$values.length)) {
                  _context12.next = 126;
                  break;
                }

                entry = _Object$values[_i];

                if (entry.dir) {
                  _context12.next = 123;
                  break;
                }

                entryName = entry.name;

                if (entryName[0] === '/') {
                  entryName = entryName.substr(1);
                }

                stream = void 0;

                if (!(entryName.match(/xl\/media\//) || // themes are not parsed as stream
                entryName.match(/xl\/theme\/([a-zA-Z0-9]+)[.]xml/))) {
                  _context12.next = 21;
                  break;
                }

                stream = new PassThrough();
                _context12.t0 = stream;
                _context12.next = 17;
                return entry.async('nodebuffer');

              case 17:
                _context12.t1 = _context12.sent;

                _context12.t0.write.call(_context12.t0, _context12.t1);

                _context12.next = 36;
                break;

              case 21:
                // use object mode to avoid buffer-string convention
                stream = new PassThrough({
                  writableObjectMode: true,
                  readableObjectMode: true
                });
                content = void 0; // https://www.npmjs.com/package/process

                if (!process.browser) {
                  _context12.next = 31;
                  break;
                }

                _context12.t2 = bufferToString;
                _context12.next = 27;
                return entry.async('nodebuffer');

              case 27:
                _context12.t3 = _context12.sent;
                content = (0, _context12.t2)(_context12.t3);
                _context12.next = 34;
                break;

              case 31:
                _context12.next = 33;
                return entry.async('string');

              case 33:
                content = _context12.sent;

              case 34:
                chunkSize = 16 * 1024;

                for (i = 0; i < content.length; i += chunkSize) {
                  stream.write(content.substring(i, i + chunkSize));
                }

              case 36:
                stream.end();
                _context12.t4 = entryName;
                _context12.next = _context12.t4 === '_rels/.rels' ? 40 : _context12.t4 === 'xl/workbook.xml' ? 44 : _context12.t4 === 'xl/_rels/workbook.xml.rels' ? 53 : _context12.t4 === 'xl/sharedStrings.xml' ? 57 : _context12.t4 === 'xl/styles.xml' ? 61 : _context12.t4 === 'docProps/app.xml' ? 65 : _context12.t4 === 'docProps/core.xml' ? 72 : 78;
                break;

              case 40:
                _context12.next = 42;
                return this.parseRels(stream);

              case 42:
                model.globalRels = _context12.sent;
                return _context12.abrupt("break", 123);

              case 44:
                _context12.next = 46;
                return this.parseWorkbook(stream);

              case 46:
                workbook = _context12.sent;
                model.sheets = workbook.sheets;
                model.definedNames = workbook.definedNames;
                model.views = workbook.views;
                model.properties = workbook.properties;
                model.calcProperties = workbook.calcProperties;
                return _context12.abrupt("break", 123);

              case 53:
                _context12.next = 55;
                return this.parseRels(stream);

              case 55:
                model.workbookRels = _context12.sent;
                return _context12.abrupt("break", 123);

              case 57:
                model.sharedStrings = new SharedStringsXform();
                _context12.next = 60;
                return model.sharedStrings.parseStream(stream);

              case 60:
                return _context12.abrupt("break", 123);

              case 61:
                model.styles = new StylesXform();
                _context12.next = 64;
                return model.styles.parseStream(stream);

              case 64:
                return _context12.abrupt("break", 123);

              case 65:
                appXform = new AppXform();
                _context12.next = 68;
                return appXform.parseStream(stream);

              case 68:
                appProperties = _context12.sent;
                model.company = appProperties.company;
                model.manager = appProperties.manager;
                return _context12.abrupt("break", 123);

              case 72:
                coreXform = new CoreXform();
                _context12.next = 75;
                return coreXform.parseStream(stream);

              case 75:
                coreProperties = _context12.sent;
                Object.assign(model, coreProperties);
                return _context12.abrupt("break", 123);

              case 78:
                match = entryName.match(/xl\/worksheets\/sheet(\d+)[.]xml/);

                if (!match) {
                  _context12.next = 83;
                  break;
                }

                _context12.next = 82;
                return this._processWorksheetEntry(stream, model, match[1], options, entryName);

              case 82:
                return _context12.abrupt("break", 123);

              case 83:
                match = entryName.match(/xl\/worksheets\/_rels\/sheet(\d+)[.]xml.rels/);

                if (!match) {
                  _context12.next = 88;
                  break;
                }

                _context12.next = 87;
                return this._processWorksheetRelsEntry(stream, model, match[1]);

              case 87:
                return _context12.abrupt("break", 123);

              case 88:
                match = entryName.match(/xl\/theme\/([a-zA-Z0-9]+)[.]xml/);

                if (!match) {
                  _context12.next = 93;
                  break;
                }

                _context12.next = 92;
                return this._processThemeEntry(stream, model, match[1]);

              case 92:
                return _context12.abrupt("break", 123);

              case 93:
                match = entryName.match(/xl\/media\/([a-zA-Z0-9]+[.][a-zA-Z0-9]{3,4})$/);

                if (!match) {
                  _context12.next = 98;
                  break;
                }

                _context12.next = 97;
                return this._processMediaEntry(stream, model, match[1]);

              case 97:
                return _context12.abrupt("break", 123);

              case 98:
                match = entryName.match(/xl\/drawings\/([a-zA-Z0-9]+)[.]xml/);

                if (!match) {
                  _context12.next = 103;
                  break;
                }

                _context12.next = 102;
                return this._processDrawingEntry(stream, model, match[1]);

              case 102:
                return _context12.abrupt("break", 123);

              case 103:
                match = entryName.match(/xl\/(comments\d+)[.]xml/);

                if (!match) {
                  _context12.next = 108;
                  break;
                }

                _context12.next = 107;
                return this._processCommentEntry(stream, model, match[1]);

              case 107:
                return _context12.abrupt("break", 123);

              case 108:
                match = entryName.match(/xl\/tables\/(table\d+)[.]xml/);

                if (!match) {
                  _context12.next = 113;
                  break;
                }

                _context12.next = 112;
                return this._processTableEntry(stream, model, match[1]);

              case 112:
                return _context12.abrupt("break", 123);

              case 113:
                match = entryName.match(/xl\/drawings\/_rels\/([a-zA-Z0-9]+)[.]xml[.]rels/);

                if (!match) {
                  _context12.next = 118;
                  break;
                }

                _context12.next = 117;
                return this._processDrawingRelsEntry(stream, model, match[1]);

              case 117:
                return _context12.abrupt("break", 123);

              case 118:
                match = entryName.match(/xl\/drawings\/(vmlDrawing\d+)[.]vml/);

                if (!match) {
                  _context12.next = 123;
                  break;
                }

                _context12.next = 122;
                return this._processVmlDrawingEntry(stream, model, match[1]);

              case 122:
                return _context12.abrupt("break", 123);

              case 123:
                _i++;
                _context12.next = 6;
                break;

              case 126:
                this.reconcile(model, options); // apply model

                this.workbook.model = model;
                return _context12.abrupt("return", this.workbook);

              case 129:
              case "end":
                return _context12.stop();
            }
          }
        }, _callee12, this);
      }));

      function load(_x34, _x35) {
        return _load.apply(this, arguments);
      }

      return load;
    }() // =========================================================================
    // Write

  }, {
    key: "addMedia",
    value: function () {
      var _addMedia = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee14(zip, model) {
        return regeneratorRuntime.wrap(function _callee14$(_context14) {
          while (1) {
            switch (_context14.prev = _context14.next) {
              case 0:
                _context14.next = 2;
                return Promise.all(model.media.map( /*#__PURE__*/function () {
                  var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee13(medium) {
                    var filename, data, dataimg64, content;
                    return regeneratorRuntime.wrap(function _callee13$(_context13) {
                      while (1) {
                        switch (_context13.prev = _context13.next) {
                          case 0:
                            if (!(medium.type === 'image')) {
                              _context13.next = 13;
                              break;
                            }

                            filename = "xl/media/".concat(medium.name, ".").concat(medium.extension);

                            if (!medium.filename) {
                              _context13.next = 7;
                              break;
                            }

                            _context13.next = 5;
                            return fsReadFileAsync(medium.filename);

                          case 5:
                            data = _context13.sent;
                            return _context13.abrupt("return", zip.append(data, {
                              name: filename
                            }));

                          case 7:
                            if (!medium.buffer) {
                              _context13.next = 9;
                              break;
                            }

                            return _context13.abrupt("return", zip.append(medium.buffer, {
                              name: filename
                            }));

                          case 9:
                            if (!medium.base64) {
                              _context13.next = 13;
                              break;
                            }

                            dataimg64 = medium.base64;
                            content = dataimg64.substring(dataimg64.indexOf(',') + 1);
                            return _context13.abrupt("return", zip.append(content, {
                              name: filename,
                              base64: true
                            }));

                          case 13:
                            throw new Error('Unsupported media');

                          case 14:
                          case "end":
                            return _context13.stop();
                        }
                      }
                    }, _callee13);
                  }));

                  return function (_x38) {
                    return _ref.apply(this, arguments);
                  };
                }()));

              case 2:
              case "end":
                return _context14.stop();
            }
          }
        }, _callee14);
      }));

      function addMedia(_x36, _x37) {
        return _addMedia.apply(this, arguments);
      }

      return addMedia;
    }()
  }, {
    key: "addDrawings",
    value: function addDrawings(zip, model) {
      var drawingXform = new DrawingXform();
      var relsXform = new RelationshipsXform();
      model.worksheets.forEach(function (worksheet) {
        var drawing = worksheet.drawing;

        if (drawing) {
          drawingXform.prepare(drawing, {});
          var xml = drawingXform.toXml(drawing);
          zip.append(xml, {
            name: "xl/drawings/".concat(drawing.name, ".xml")
          });
          xml = relsXform.toXml(drawing.rels);
          zip.append(xml, {
            name: "xl/drawings/_rels/".concat(drawing.name, ".xml.rels")
          });
        }
      });
    }
  }, {
    key: "addTables",
    value: function addTables(zip, model) {
      var tableXform = new TableXform();
      model.worksheets.forEach(function (worksheet) {
        var tables = worksheet.tables;
        tables.forEach(function (table) {
          tableXform.prepare(table, {});
          var tableXml = tableXform.toXml(table);
          zip.append(tableXml, {
            name: "xl/tables/".concat(table.target)
          });
        });
      });
    }
  }, {
    key: "addContentTypes",
    value: function () {
      var _addContentTypes = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee15(zip, model) {
        var xform, xml;
        return regeneratorRuntime.wrap(function _callee15$(_context15) {
          while (1) {
            switch (_context15.prev = _context15.next) {
              case 0:
                xform = new ContentTypesXform();
                xml = xform.toXml(model);
                zip.append(xml, {
                  name: '[Content_Types].xml'
                });

              case 3:
              case "end":
                return _context15.stop();
            }
          }
        }, _callee15);
      }));

      function addContentTypes(_x39, _x40) {
        return _addContentTypes.apply(this, arguments);
      }

      return addContentTypes;
    }()
  }, {
    key: "addApp",
    value: function () {
      var _addApp = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee16(zip, model) {
        var xform, xml;
        return regeneratorRuntime.wrap(function _callee16$(_context16) {
          while (1) {
            switch (_context16.prev = _context16.next) {
              case 0:
                xform = new AppXform();
                xml = xform.toXml(model);
                zip.append(xml, {
                  name: 'docProps/app.xml'
                });

              case 3:
              case "end":
                return _context16.stop();
            }
          }
        }, _callee16);
      }));

      function addApp(_x41, _x42) {
        return _addApp.apply(this, arguments);
      }

      return addApp;
    }()
  }, {
    key: "addCore",
    value: function () {
      var _addCore = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee17(zip, model) {
        var coreXform;
        return regeneratorRuntime.wrap(function _callee17$(_context17) {
          while (1) {
            switch (_context17.prev = _context17.next) {
              case 0:
                coreXform = new CoreXform();
                zip.append(coreXform.toXml(model), {
                  name: 'docProps/core.xml'
                });

              case 2:
              case "end":
                return _context17.stop();
            }
          }
        }, _callee17);
      }));

      function addCore(_x43, _x44) {
        return _addCore.apply(this, arguments);
      }

      return addCore;
    }()
  }, {
    key: "addThemes",
    value: function () {
      var _addThemes = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee18(zip, model) {
        var themes;
        return regeneratorRuntime.wrap(function _callee18$(_context18) {
          while (1) {
            switch (_context18.prev = _context18.next) {
              case 0:
                themes = model.themes || {
                  theme1: theme1Xml
                };
                Object.keys(themes).forEach(function (name) {
                  var xml = themes[name];
                  var path = "xl/theme/".concat(name, ".xml");
                  zip.append(xml, {
                    name: path
                  });
                });

              case 2:
              case "end":
                return _context18.stop();
            }
          }
        }, _callee18);
      }));

      function addThemes(_x45, _x46) {
        return _addThemes.apply(this, arguments);
      }

      return addThemes;
    }()
  }, {
    key: "addOfficeRels",
    value: function () {
      var _addOfficeRels = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee19(zip) {
        var xform, xml;
        return regeneratorRuntime.wrap(function _callee19$(_context19) {
          while (1) {
            switch (_context19.prev = _context19.next) {
              case 0:
                xform = new RelationshipsXform();
                xml = xform.toXml([{
                  Id: 'rId1',
                  Type: XLSX.RelType.OfficeDocument,
                  Target: 'xl/workbook.xml'
                }, {
                  Id: 'rId2',
                  Type: XLSX.RelType.CoreProperties,
                  Target: 'docProps/core.xml'
                }, {
                  Id: 'rId3',
                  Type: XLSX.RelType.ExtenderProperties,
                  Target: 'docProps/app.xml'
                }]);
                zip.append(xml, {
                  name: '_rels/.rels'
                });

              case 3:
              case "end":
                return _context19.stop();
            }
          }
        }, _callee19);
      }));

      function addOfficeRels(_x47) {
        return _addOfficeRels.apply(this, arguments);
      }

      return addOfficeRels;
    }()
  }, {
    key: "addWorkbookRels",
    value: function () {
      var _addWorkbookRels = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee20(zip, model) {
        var count, relationships, xform, xml;
        return regeneratorRuntime.wrap(function _callee20$(_context20) {
          while (1) {
            switch (_context20.prev = _context20.next) {
              case 0:
                count = 1;
                relationships = [{
                  Id: "rId".concat(count++),
                  Type: XLSX.RelType.Styles,
                  Target: 'styles.xml'
                }, {
                  Id: "rId".concat(count++),
                  Type: XLSX.RelType.Theme,
                  Target: 'theme/theme1.xml'
                }];

                if (model.sharedStrings.count) {
                  relationships.push({
                    Id: "rId".concat(count++),
                    Type: XLSX.RelType.SharedStrings,
                    Target: 'sharedStrings.xml'
                  });
                }

                model.worksheets.forEach(function (worksheet) {
                  worksheet.rId = "rId".concat(count++);
                  relationships.push({
                    Id: worksheet.rId,
                    Type: XLSX.RelType.Worksheet,
                    Target: "worksheets/sheet".concat(worksheet.id, ".xml")
                  });
                });
                xform = new RelationshipsXform();
                xml = xform.toXml(relationships);
                zip.append(xml, {
                  name: 'xl/_rels/workbook.xml.rels'
                });

              case 7:
              case "end":
                return _context20.stop();
            }
          }
        }, _callee20);
      }));

      function addWorkbookRels(_x48, _x49) {
        return _addWorkbookRels.apply(this, arguments);
      }

      return addWorkbookRels;
    }()
  }, {
    key: "addSharedStrings",
    value: function () {
      var _addSharedStrings = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee21(zip, model) {
        return regeneratorRuntime.wrap(function _callee21$(_context21) {
          while (1) {
            switch (_context21.prev = _context21.next) {
              case 0:
                if (model.sharedStrings && model.sharedStrings.count) {
                  zip.append(model.sharedStrings.xml, {
                    name: 'xl/sharedStrings.xml'
                  });
                }

              case 1:
              case "end":
                return _context21.stop();
            }
          }
        }, _callee21);
      }));

      function addSharedStrings(_x50, _x51) {
        return _addSharedStrings.apply(this, arguments);
      }

      return addSharedStrings;
    }()
  }, {
    key: "addStyles",
    value: function () {
      var _addStyles = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee22(zip, model) {
        var xml;
        return regeneratorRuntime.wrap(function _callee22$(_context22) {
          while (1) {
            switch (_context22.prev = _context22.next) {
              case 0:
                xml = model.styles.xml;

                if (xml) {
                  zip.append(xml, {
                    name: 'xl/styles.xml'
                  });
                }

              case 2:
              case "end":
                return _context22.stop();
            }
          }
        }, _callee22);
      }));

      function addStyles(_x52, _x53) {
        return _addStyles.apply(this, arguments);
      }

      return addStyles;
    }()
  }, {
    key: "addWorkbook",
    value: function () {
      var _addWorkbook = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee23(zip, model) {
        var xform;
        return regeneratorRuntime.wrap(function _callee23$(_context23) {
          while (1) {
            switch (_context23.prev = _context23.next) {
              case 0:
                xform = new WorkbookXform();
                zip.append(xform.toXml(model), {
                  name: 'xl/workbook.xml'
                });

              case 2:
              case "end":
                return _context23.stop();
            }
          }
        }, _callee23);
      }));

      function addWorkbook(_x54, _x55) {
        return _addWorkbook.apply(this, arguments);
      }

      return addWorkbook;
    }()
  }, {
    key: "addWorksheets",
    value: function () {
      var _addWorksheets = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee24(zip, model) {
        var worksheetXform, relationshipsXform, commentsXform, vmlNotesXform;
        return regeneratorRuntime.wrap(function _callee24$(_context24) {
          while (1) {
            switch (_context24.prev = _context24.next) {
              case 0:
                // preparation phase
                worksheetXform = new WorksheetXform();
                relationshipsXform = new RelationshipsXform();
                commentsXform = new CommentsXform();
                vmlNotesXform = new VmlNotesXform(); // write sheets

                model.worksheets.forEach(function (worksheet) {
                  var xmlStream = new XmlStream();
                  worksheetXform.render(xmlStream, worksheet);
                  zip.append(xmlStream.xml, {
                    name: "xl/worksheets/sheet".concat(worksheet.id, ".xml")
                  });

                  if (worksheet.rels && worksheet.rels.length) {
                    xmlStream = new XmlStream();
                    relationshipsXform.render(xmlStream, worksheet.rels);
                    zip.append(xmlStream.xml, {
                      name: "xl/worksheets/_rels/sheet".concat(worksheet.id, ".xml.rels")
                    });
                  }

                  if (worksheet.comments.length > 0) {
                    xmlStream = new XmlStream();
                    commentsXform.render(xmlStream, worksheet);
                    zip.append(xmlStream.xml, {
                      name: "xl/comments".concat(worksheet.id, ".xml")
                    });
                    xmlStream = new XmlStream();
                    vmlNotesXform.render(xmlStream, worksheet);
                    zip.append(xmlStream.xml, {
                      name: "xl/drawings/vmlDrawing".concat(worksheet.id, ".vml")
                    });
                  }
                });

              case 5:
              case "end":
                return _context24.stop();
            }
          }
        }, _callee24);
      }));

      function addWorksheets(_x56, _x57) {
        return _addWorksheets.apply(this, arguments);
      }

      return addWorksheets;
    }()
  }, {
    key: "_finalize",
    value: function _finalize(zip) {
      var _this = this;

      return new Promise(function (resolve, reject) {
        zip.on('finish', function () {
          resolve(_this);
        });
        zip.on('error', reject);
        zip.finalize();
      });
    }
  }, {
    key: "prepareModel",
    value: function prepareModel(model, options) {
      // ensure following properties have sane values
      model.creator = model.creator || 'ExcelJS';
      model.lastModifiedBy = model.lastModifiedBy || 'ExcelJS';
      model.created = model.created || new Date();
      model.modified = model.modified || new Date();
      model.useSharedStrings = options.useSharedStrings !== undefined ? options.useSharedStrings : true;
      model.useStyles = options.useStyles !== undefined ? options.useStyles : true; // Manage the shared strings

      model.sharedStrings = new SharedStringsXform(); // add a style manager to handle cell formats, fonts, etc.

      model.styles = model.useStyles ? new StylesXform(true) : new StylesXform.Mock(); // prepare all of the things before the render

      var workbookXform = new WorkbookXform();
      var worksheetXform = new WorksheetXform();
      workbookXform.prepare(model);
      var worksheetOptions = {
        sharedStrings: model.sharedStrings,
        styles: model.styles,
        date1904: model.properties.date1904,
        drawingsCount: 0,
        media: model.media
      };
      worksheetOptions.drawings = model.drawings = [];
      worksheetOptions.commentRefs = model.commentRefs = [];
      var tableCount = 0;
      model.tables = [];
      model.worksheets.forEach(function (worksheet) {
        // assign unique filenames to tables
        worksheet.tables.forEach(function (table) {
          tableCount++;
          table.target = "table".concat(tableCount, ".xml");
          table.id = tableCount;
          model.tables.push(table);
        });
        worksheetXform.prepare(worksheet, worksheetOptions);
      }); // TODO: workbook drawing list
    }
  }, {
    key: "write",
    value: function () {
      var _write = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee25(stream, options) {
        var model, zip;
        return regeneratorRuntime.wrap(function _callee25$(_context25) {
          while (1) {
            switch (_context25.prev = _context25.next) {
              case 0:
                options = options || {};
                model = this.workbook.model;
                zip = new ZipStream.ZipWriter(options.zip);
                zip.pipe(stream);
                this.prepareModel(model, options); // render

                _context25.next = 7;
                return this.addContentTypes(zip, model);

              case 7:
                _context25.next = 9;
                return this.addOfficeRels(zip, model);

              case 9:
                _context25.next = 11;
                return this.addWorkbookRels(zip, model);

              case 11:
                _context25.next = 13;
                return this.addWorksheets(zip, model);

              case 13:
                _context25.next = 15;
                return this.addSharedStrings(zip, model);

              case 15:
                _context25.next = 17;
                return this.addDrawings(zip, model);

              case 17:
                _context25.next = 19;
                return this.addTables(zip, model);

              case 19:
                _context25.next = 21;
                return Promise.all([this.addThemes(zip, model), this.addStyles(zip, model)]);

              case 21:
                _context25.next = 23;
                return this.addMedia(zip, model);

              case 23:
                _context25.next = 25;
                return Promise.all([this.addApp(zip, model), this.addCore(zip, model)]);

              case 25:
                _context25.next = 27;
                return this.addWorkbook(zip, model);

              case 27:
                return _context25.abrupt("return", this._finalize(zip));

              case 28:
              case "end":
                return _context25.stop();
            }
          }
        }, _callee25, this);
      }));

      function write(_x58, _x59) {
        return _write.apply(this, arguments);
      }

      return write;
    }()
  }, {
    key: "writeFile",
    value: function writeFile(filename, options) {
      var _this2 = this;

      var stream = fs.createWriteStream(filename);
      return new Promise(function (resolve, reject) {
        stream.on('finish', function () {
          resolve();
        });
        stream.on('error', function (error) {
          reject(error);
        });

        _this2.write(stream, options).then(function () {
          stream.end();
        });
      });
    }
  }, {
    key: "writeBuffer",
    value: function () {
      var _writeBuffer = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee26(options) {
        var stream;
        return regeneratorRuntime.wrap(function _callee26$(_context26) {
          while (1) {
            switch (_context26.prev = _context26.next) {
              case 0:
                stream = new StreamBuf();
                _context26.next = 3;
                return this.write(stream, options);

              case 3:
                return _context26.abrupt("return", stream.read());

              case 4:
              case "end":
                return _context26.stop();
            }
          }
        }, _callee26, this);
      }));

      function writeBuffer(_x60) {
        return _writeBuffer.apply(this, arguments);
      }

      return writeBuffer;
    }()
  }]);

  return XLSX;
}();

XLSX.RelType = require('./rel-type');
module.exports = XLSX;

}).call(this,require('_process'),require("buffer").Buffer)

},{"../utils/browser-buffer-decode":16,"../utils/stream-buf":23,"../utils/utils":26,"../utils/xml-stream":27,"../utils/zip-stream":28,"./rel-type":30,"./xform/book/workbook-xform":37,"./xform/comment/comments-xform":39,"./xform/comment/vml-notes-xform":44,"./xform/core/app-xform":50,"./xform/core/content-types-xform":51,"./xform/core/core-xform":52,"./xform/core/relationships-xform":54,"./xform/drawing/drawing-xform":61,"./xform/sheet/worksheet-xform":114,"./xform/strings/shared-strings-xform":123,"./xform/style/styles-xform":134,"./xform/table/table-xform":140,"./xml/theme1.js":142,"_process":358,"buffer":216,"fs":215,"jszip":290,"readable-stream":382}],142:[function(require,module,exports){
"use strict";

/* eslint-disable */
module.exports = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>\n<a:theme xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main" name="Office Theme"> <a:themeElements> <a:clrScheme name="Office"> <a:dk1> <a:sysClr val="windowText" lastClr="000000"/> </a:dk1> <a:lt1> <a:sysClr val="window" lastClr="FFFFFF"/> </a:lt1> <a:dk2> <a:srgbClr val="1F497D"/> </a:dk2> <a:lt2> <a:srgbClr val="EEECE1"/> </a:lt2> <a:accent1> <a:srgbClr val="4F81BD"/> </a:accent1> <a:accent2> <a:srgbClr val="C0504D"/> </a:accent2> <a:accent3> <a:srgbClr val="9BBB59"/> </a:accent3> <a:accent4> <a:srgbClr val="8064A2"/> </a:accent4> <a:accent5> <a:srgbClr val="4BACC6"/> </a:accent5> <a:accent6> <a:srgbClr val="F79646"/> </a:accent6> <a:hlink> <a:srgbClr val="0000FF"/> </a:hlink> <a:folHlink> <a:srgbClr val="800080"/> </a:folHlink> </a:clrScheme> <a:fontScheme name="Office"> <a:majorFont> <a:latin typeface="Cambria"/> <a:ea typeface=""/> <a:cs typeface=""/> <a:font script="Jpan" typeface="ＭＳ Ｐゴシック"/> <a:font script="Hang" typeface="맑은 고딕"/> <a:font script="Hans" typeface="宋体"/> <a:font script="Hant" typeface="新細明體"/> <a:font script="Arab" typeface="Times New Roman"/> <a:font script="Hebr" typeface="Times New Roman"/> <a:font script="Thai" typeface="Tahoma"/> <a:font script="Ethi" typeface="Nyala"/> <a:font script="Beng" typeface="Vrinda"/> <a:font script="Gujr" typeface="Shruti"/> <a:font script="Khmr" typeface="MoolBoran"/> <a:font script="Knda" typeface="Tunga"/> <a:font script="Guru" typeface="Raavi"/> <a:font script="Cans" typeface="Euphemia"/> <a:font script="Cher" typeface="Plantagenet Cherokee"/> <a:font script="Yiii" typeface="Microsoft Yi Baiti"/> <a:font script="Tibt" typeface="Microsoft Himalaya"/> <a:font script="Thaa" typeface="MV Boli"/> <a:font script="Deva" typeface="Mangal"/> <a:font script="Telu" typeface="Gautami"/> <a:font script="Taml" typeface="Latha"/> <a:font script="Syrc" typeface="Estrangelo Edessa"/> <a:font script="Orya" typeface="Kalinga"/> <a:font script="Mlym" typeface="Kartika"/> <a:font script="Laoo" typeface="DokChampa"/> <a:font script="Sinh" typeface="Iskoola Pota"/> <a:font script="Mong" typeface="Mongolian Baiti"/> <a:font script="Viet" typeface="Times New Roman"/> <a:font script="Uigh" typeface="Microsoft Uighur"/> <a:font script="Geor" typeface="Sylfaen"/> </a:majorFont> <a:minorFont> <a:latin typeface="Calibri"/> <a:ea typeface=""/> <a:cs typeface=""/> <a:font script="Jpan" typeface="ＭＳ Ｐゴシック"/> <a:font script="Hang" typeface="맑은 고딕"/> <a:font script="Hans" typeface="宋体"/> <a:font script="Hant" typeface="新細明體"/> <a:font script="Arab" typeface="Arial"/> <a:font script="Hebr" typeface="Arial"/> <a:font script="Thai" typeface="Tahoma"/> <a:font script="Ethi" typeface="Nyala"/> <a:font script="Beng" typeface="Vrinda"/> <a:font script="Gujr" typeface="Shruti"/> <a:font script="Khmr" typeface="DaunPenh"/> <a:font script="Knda" typeface="Tunga"/> <a:font script="Guru" typeface="Raavi"/> <a:font script="Cans" typeface="Euphemia"/> <a:font script="Cher" typeface="Plantagenet Cherokee"/> <a:font script="Yiii" typeface="Microsoft Yi Baiti"/> <a:font script="Tibt" typeface="Microsoft Himalaya"/> <a:font script="Thaa" typeface="MV Boli"/> <a:font script="Deva" typeface="Mangal"/> <a:font script="Telu" typeface="Gautami"/> <a:font script="Taml" typeface="Latha"/> <a:font script="Syrc" typeface="Estrangelo Edessa"/> <a:font script="Orya" typeface="Kalinga"/> <a:font script="Mlym" typeface="Kartika"/> <a:font script="Laoo" typeface="DokChampa"/> <a:font script="Sinh" typeface="Iskoola Pota"/> <a:font script="Mong" typeface="Mongolian Baiti"/> <a:font script="Viet" typeface="Arial"/> <a:font script="Uigh" typeface="Microsoft Uighur"/> <a:font script="Geor" typeface="Sylfaen"/> </a:minorFont> </a:fontScheme> <a:fmtScheme name="Office"> <a:fillStyleLst> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="50000"/> <a:satMod val="300000"/> </a:schemeClr> </a:gs> <a:gs pos="35000"> <a:schemeClr val="phClr"> <a:tint val="37000"/> <a:satMod val="300000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:tint val="15000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:lin ang="16200000" scaled="1"/> </a:gradFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="100000"/> <a:shade val="100000"/> <a:satMod val="130000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:tint val="50000"/> <a:shade val="100000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:lin ang="16200000" scaled="0"/> </a:gradFill> </a:fillStyleLst> <a:lnStyleLst> <a:ln w="9525" cap="flat" cmpd="sng" algn="ctr"> <a:solidFill> <a:schemeClr val="phClr"> <a:shade val="95000"/> <a:satMod val="105000"/> </a:schemeClr> </a:solidFill> <a:prstDash val="solid"/> </a:ln> <a:ln w="25400" cap="flat" cmpd="sng" algn="ctr"> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:prstDash val="solid"/> </a:ln> <a:ln w="38100" cap="flat" cmpd="sng" algn="ctr"> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:prstDash val="solid"/> </a:ln> </a:lnStyleLst> <a:effectStyleLst> <a:effectStyle> <a:effectLst> <a:outerShdw blurRad="40000" dist="20000" dir="5400000" rotWithShape="0"> <a:srgbClr val="000000"> <a:alpha val="38000"/> </a:srgbClr> </a:outerShdw> </a:effectLst> </a:effectStyle> <a:effectStyle> <a:effectLst> <a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"> <a:srgbClr val="000000"> <a:alpha val="35000"/> </a:srgbClr> </a:outerShdw> </a:effectLst> </a:effectStyle> <a:effectStyle> <a:effectLst> <a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"> <a:srgbClr val="000000"> <a:alpha val="35000"/> </a:srgbClr> </a:outerShdw> </a:effectLst> <a:scene3d> <a:camera prst="orthographicFront"> <a:rot lat="0" lon="0" rev="0"/> </a:camera> <a:lightRig rig="threePt" dir="t"> <a:rot lat="0" lon="0" rev="1200000"/> </a:lightRig> </a:scene3d> <a:sp3d> <a:bevelT w="63500" h="25400"/> </a:sp3d> </a:effectStyle> </a:effectStyleLst> <a:bgFillStyleLst> <a:solidFill> <a:schemeClr val="phClr"/> </a:solidFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="40000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> <a:gs pos="40000"> <a:schemeClr val="phClr"> <a:tint val="45000"/> <a:shade val="99000"/> <a:satMod val="350000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:shade val="20000"/> <a:satMod val="255000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:path path="circle"> <a:fillToRect l="50000" t="-80000" r="50000" b="180000"/> </a:path> </a:gradFill> <a:gradFill rotWithShape="1"> <a:gsLst> <a:gs pos="0"> <a:schemeClr val="phClr"> <a:tint val="80000"/> <a:satMod val="300000"/> </a:schemeClr> </a:gs> <a:gs pos="100000"> <a:schemeClr val="phClr"> <a:shade val="30000"/> <a:satMod val="200000"/> </a:schemeClr> </a:gs> </a:gsLst> <a:path path="circle"> <a:fillToRect l="50000" t="50000" r="50000" b="50000"/> </a:path> </a:gradFill> </a:bgFillStyleLst> </a:fmtScheme> </a:themeElements> <a:objectDefaults> <a:spDef> <a:spPr/> <a:bodyPr/> <a:lstStyle/> <a:style> <a:lnRef idx="1"> <a:schemeClr val="accent1"/> </a:lnRef> <a:fillRef idx="3"> <a:schemeClr val="accent1"/> </a:fillRef> <a:effectRef idx="2"> <a:schemeClr val="accent1"/> </a:effectRef> <a:fontRef idx="minor"> <a:schemeClr val="lt1"/> </a:fontRef> </a:style> </a:spDef> <a:lnDef> <a:spPr/> <a:bodyPr/> <a:lstStyle/> <a:style> <a:lnRef idx="2"> <a:schemeClr val="accent1"/> </a:lnRef> <a:fillRef idx="0"> <a:schemeClr val="accent1"/> </a:fillRef> <a:effectRef idx="1"> <a:schemeClr val="accent1"/> </a:effectRef> <a:fontRef idx="minor"> <a:schemeClr val="tx1"/> </a:fontRef> </a:style> </a:lnDef> </a:objectDefaults> <a:extraClrSchemeLst/> </a:theme>';

},{}],143:[function(require,module,exports){
(function (Buffer){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CsvFormatterStream = void 0;

var stream_1 = require("stream");

var formatter_1 = require("./formatter");

var CsvFormatterStream = /*#__PURE__*/function (_stream_1$Transform) {
  _inherits(CsvFormatterStream, _stream_1$Transform);

  var _super = _createSuper(CsvFormatterStream);

  function CsvFormatterStream(formatterOptions) {
    var _this;

    _classCallCheck(this, CsvFormatterStream);

    _this = _super.call(this, {
      writableObjectMode: formatterOptions.objectMode
    });
    _this.hasWrittenBOM = false;
    _this.formatterOptions = formatterOptions;
    _this.rowFormatter = new formatter_1.RowFormatter(formatterOptions); // if writeBOM is false then set to true
    // if writeBOM is true then set to false by default so it is written out

    _this.hasWrittenBOM = !formatterOptions.writeBOM;
    return _this;
  }

  _createClass(CsvFormatterStream, [{
    key: "transform",
    value: function transform(transformFunction) {
      this.rowFormatter.rowTransform = transformFunction;
      return this;
    }
  }, {
    key: "_transform",
    value: function _transform(row, encoding, cb) {
      var _this2 = this;

      var cbCalled = false;

      try {
        if (!this.hasWrittenBOM) {
          this.push(this.formatterOptions.BOM);
          this.hasWrittenBOM = true;
        }

        this.rowFormatter.format(row, function (err, rows) {
          if (err) {
            cbCalled = true;
            return cb(err);
          }

          if (rows) {
            rows.forEach(function (r) {
              _this2.push(Buffer.from(r, 'utf8'));
            });
          }

          cbCalled = true;
          return cb();
        });
      } catch (e) {
        if (cbCalled) {
          throw e;
        }

        cb(e);
      }
    }
  }, {
    key: "_flush",
    value: function _flush(cb) {
      var _this3 = this;

      this.rowFormatter.finish(function (err, rows) {
        if (err) {
          return cb(err);
        }

        if (rows) {
          rows.forEach(function (r) {
            _this3.push(Buffer.from(r, 'utf8'));
          });
        }

        return cb();
      });
    }
  }]);

  return CsvFormatterStream;
}(stream_1.Transform);

exports.CsvFormatterStream = CsvFormatterStream;

}).call(this,require("buffer").Buffer)

},{"./formatter":147,"buffer":216,"stream":396}],144:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatterOptions = void 0;

var FormatterOptions = function FormatterOptions() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  _classCallCheck(this, FormatterOptions);

  var _a;

  this.objectMode = true;
  this.delimiter = ',';
  this.rowDelimiter = '\n';
  this.quote = '"';
  this.escape = this.quote;
  this.quoteColumns = false;
  this.quoteHeaders = this.quoteColumns;
  this.headers = null;
  this.includeEndRowDelimiter = false;
  this.writeBOM = false;
  this.BOM = "\uFEFF";
  this.alwaysWriteHeaders = false;
  Object.assign(this, opts || {});

  if (typeof (opts === null || opts === void 0 ? void 0 : opts.quoteHeaders) === 'undefined') {
    this.quoteHeaders = this.quoteColumns;
  }

  if ((opts === null || opts === void 0 ? void 0 : opts.quote) === true) {
    this.quote = '"';
  } else if ((opts === null || opts === void 0 ? void 0 : opts.quote) === false) {
    this.quote = '';
  }

  if (typeof (opts === null || opts === void 0 ? void 0 : opts.escape) !== 'string') {
    this.escape = this.quote;
  }

  this.shouldWriteHeaders = !!this.headers && ((_a = opts.writeHeaders) !== null && _a !== void 0 ? _a : true);
  this.headers = Array.isArray(this.headers) ? this.headers : null;
  this.escapedQuote = "".concat(this.escape).concat(this.quote);
};

exports.FormatterOptions = FormatterOptions;

},{}],145:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFormatter = void 0;

var lodash_isboolean_1 = __importDefault(require("lodash.isboolean"));

var lodash_isnil_1 = __importDefault(require("lodash.isnil"));

var lodash_escaperegexp_1 = __importDefault(require("lodash.escaperegexp"));

var FieldFormatter = /*#__PURE__*/function () {
  function FieldFormatter(formatterOptions) {
    _classCallCheck(this, FieldFormatter);

    this._headers = null;
    this.formatterOptions = formatterOptions;

    if (formatterOptions.headers !== null) {
      this.headers = formatterOptions.headers;
    }

    this.REPLACE_REGEXP = new RegExp(formatterOptions.quote, 'g');
    var escapePattern = "[".concat(formatterOptions.delimiter).concat(lodash_escaperegexp_1.default(formatterOptions.rowDelimiter), "|\r|\n']");
    this.ESCAPE_REGEXP = new RegExp(escapePattern);
  }

  _createClass(FieldFormatter, [{
    key: "shouldQuote",
    value: function shouldQuote(fieldIndex, isHeader) {
      var quoteConfig = isHeader ? this.formatterOptions.quoteHeaders : this.formatterOptions.quoteColumns;

      if (lodash_isboolean_1.default(quoteConfig)) {
        return quoteConfig;
      }

      if (Array.isArray(quoteConfig)) {
        return quoteConfig[fieldIndex];
      }

      if (this._headers !== null) {
        return quoteConfig[this._headers[fieldIndex]];
      }

      return false;
    }
  }, {
    key: "format",
    value: function format(field, fieldIndex, isHeader) {
      var preparedField = "".concat(lodash_isnil_1.default(field) ? '' : field).replace(/\0/g, '');
      var formatterOptions = this.formatterOptions;

      if (formatterOptions.quote !== '') {
        var shouldEscape = preparedField.indexOf(formatterOptions.quote) !== -1;

        if (shouldEscape) {
          return this.quoteField(preparedField.replace(this.REPLACE_REGEXP, formatterOptions.escapedQuote));
        }
      }

      var hasEscapeCharacters = preparedField.search(this.ESCAPE_REGEXP) !== -1;

      if (hasEscapeCharacters || this.shouldQuote(fieldIndex, isHeader)) {
        return this.quoteField(preparedField);
      }

      return preparedField;
    }
  }, {
    key: "quoteField",
    value: function quoteField(field) {
      var quote = this.formatterOptions.quote;
      return "".concat(quote).concat(field).concat(quote);
    }
  }, {
    key: "headers",
    set: function set(headers) {
      this._headers = headers;
    }
  }]);

  return FieldFormatter;
}();

exports.FieldFormatter = FieldFormatter;

},{"lodash.escaperegexp":317,"lodash.isboolean":319,"lodash.isnil":322}],146:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowFormatter = void 0;

var lodash_isfunction_1 = __importDefault(require("lodash.isfunction"));

var lodash_isequal_1 = __importDefault(require("lodash.isequal"));

var FieldFormatter_1 = require("./FieldFormatter");

var types_1 = require("../types");

var RowFormatter = /*#__PURE__*/function () {
  function RowFormatter(formatterOptions) {
    _classCallCheck(this, RowFormatter);

    this.rowCount = 0;
    this.formatterOptions = formatterOptions;
    this.fieldFormatter = new FieldFormatter_1.FieldFormatter(formatterOptions);
    this.headers = formatterOptions.headers;
    this.shouldWriteHeaders = formatterOptions.shouldWriteHeaders;
    this.hasWrittenHeaders = false;

    if (this.headers !== null) {
      this.fieldFormatter.headers = this.headers;
    }

    if (formatterOptions.transform) {
      this.rowTransform = formatterOptions.transform;
    }
  }

  _createClass(RowFormatter, [{
    key: "format",
    value: function format(row, cb) {
      var _this = this;

      this.callTransformer(row, function (err, transformedRow) {
        if (err) {
          return cb(err);
        }

        if (!row) {
          return cb(null);
        }

        var rows = [];

        if (transformedRow) {
          var _this$checkHeaders = _this.checkHeaders(transformedRow),
              shouldFormatColumns = _this$checkHeaders.shouldFormatColumns,
              headers = _this$checkHeaders.headers;

          if (_this.shouldWriteHeaders && headers && !_this.hasWrittenHeaders) {
            rows.push(_this.formatColumns(headers, true));
            _this.hasWrittenHeaders = true;
          }

          if (shouldFormatColumns) {
            var columns = _this.gatherColumns(transformedRow);

            rows.push(_this.formatColumns(columns, false));
          }
        }

        return cb(null, rows);
      });
    }
  }, {
    key: "finish",
    value: function finish(cb) {
      var rows = []; // check if we should write headers and we didnt get any rows

      if (this.formatterOptions.alwaysWriteHeaders && this.rowCount === 0) {
        if (!this.headers) {
          return cb(new Error('`alwaysWriteHeaders` option is set to true but `headers` option not provided.'));
        }

        rows.push(this.formatColumns(this.headers, true));
      }

      if (this.formatterOptions.includeEndRowDelimiter) {
        rows.push(this.formatterOptions.rowDelimiter);
      }

      return cb(null, rows);
    } // check if we need to write header return true if we should also write a row
    // could be false if headers is true and the header row(first item) is passed in

  }, {
    key: "checkHeaders",
    value: function checkHeaders(row) {
      if (this.headers) {
        // either the headers were provided by the user or we have already gathered them.
        return {
          shouldFormatColumns: true,
          headers: this.headers
        };
      }

      var headers = RowFormatter.gatherHeaders(row);
      this.headers = headers;
      this.fieldFormatter.headers = headers;

      if (!this.shouldWriteHeaders) {
        // if we are not supposed to write the headers then
        // always format the columns
        return {
          shouldFormatColumns: true,
          headers: null
        };
      } // if the row is equal to headers dont format


      return {
        shouldFormatColumns: !lodash_isequal_1.default(headers, row),
        headers: headers
      };
    } // todo change this method to unknown[]

  }, {
    key: "gatherColumns",
    value: function gatherColumns(row) {
      if (this.headers === null) {
        throw new Error('Headers is currently null');
      }

      if (!Array.isArray(row)) {
        return this.headers.map(function (header) {
          return row[header];
        });
      }

      if (RowFormatter.isHashArray(row)) {
        return this.headers.map(function (header, i) {
          var col = row[i];

          if (col) {
            return col[1];
          }

          return '';
        });
      }

      return this.headers.map(function (header, i) {
        return row[i];
      });
    }
  }, {
    key: "callTransformer",
    value: function callTransformer(row, cb) {
      if (!this._rowTransform) {
        return cb(null, row);
      }

      return this._rowTransform(row, cb);
    }
  }, {
    key: "formatColumns",
    value: function formatColumns(columns, isHeadersRow) {
      var _this2 = this;

      var formattedCols = columns.map(function (field, i) {
        return _this2.fieldFormatter.format(field, i, isHeadersRow);
      }).join(this.formatterOptions.delimiter);
      var rowCount = this.rowCount;
      this.rowCount += 1;

      if (rowCount) {
        return [this.formatterOptions.rowDelimiter, formattedCols].join('');
      }

      return formattedCols;
    }
  }, {
    key: "rowTransform",
    set: function set(transformFunction) {
      if (!lodash_isfunction_1.default(transformFunction)) {
        throw new TypeError('The transform should be a function');
      }

      this._rowTransform = RowFormatter.createTransform(transformFunction);
    }
  }], [{
    key: "isHashArray",
    value: function isHashArray(row) {
      if (Array.isArray(row)) {
        return Array.isArray(row[0]) && row[0].length === 2;
      }

      return false;
    } // get headers from a row item

  }, {
    key: "gatherHeaders",
    value: function gatherHeaders(row) {
      if (RowFormatter.isHashArray(row)) {
        // lets assume a multi-dimesional array with item 0 being the header
        return row.map(function (it) {
          return it[0];
        });
      }

      if (Array.isArray(row)) {
        return row;
      }

      return Object.keys(row);
    }
  }, {
    key: "createTransform",
    value: function createTransform(transformFunction) {
      if (types_1.isSyncTransform(transformFunction)) {
        return function (row, cb) {
          var transformedRow = null;

          try {
            transformedRow = transformFunction(row);
          } catch (e) {
            return cb(e);
          }

          return cb(null, transformedRow);
        };
      }

      return function (row, cb) {
        transformFunction(row, cb);
      };
    }
  }]);

  return RowFormatter;
}();

exports.RowFormatter = RowFormatter;

},{"../types":149,"./FieldFormatter":145,"lodash.isequal":320,"lodash.isfunction":321}],147:[function(require,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var RowFormatter_1 = require("./RowFormatter");

Object.defineProperty(exports, "RowFormatter", {
  enumerable: true,
  get: function get() {
    return RowFormatter_1.RowFormatter;
  }
});

var FieldFormatter_1 = require("./FieldFormatter");

Object.defineProperty(exports, "FieldFormatter", {
  enumerable: true,
  get: function get() {
    return FieldFormatter_1.FieldFormatter;
  }
});

},{"./FieldFormatter":145,"./RowFormatter":146}],148:[function(require,module,exports){
(function (Buffer){
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  Object.defineProperty(o, k2, {
    enumerable: true,
    get: function get() {
      return m[k];
    }
  });
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});

var __setModuleDefault = void 0 && (void 0).__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});

var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  }

  __setModuleDefault(result, mod);

  return result;
};

var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) {
    if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
  }
};

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writeToPath = exports.writeToString = exports.writeToBuffer = exports.writeToStream = exports.write = exports.format = void 0;

var util_1 = require("util");

var stream_1 = require("stream");

var fs = __importStar(require("fs"));

var FormatterOptions_1 = require("./FormatterOptions");

var CsvFormatterStream_1 = require("./CsvFormatterStream");

__exportStar(require("./types"), exports);

var CsvFormatterStream_2 = require("./CsvFormatterStream");

Object.defineProperty(exports, "CsvFormatterStream", {
  enumerable: true,
  get: function get() {
    return CsvFormatterStream_2.CsvFormatterStream;
  }
});

var FormatterOptions_2 = require("./FormatterOptions");

Object.defineProperty(exports, "FormatterOptions", {
  enumerable: true,
  get: function get() {
    return FormatterOptions_2.FormatterOptions;
  }
});

exports.format = function (options) {
  return new CsvFormatterStream_1.CsvFormatterStream(new FormatterOptions_1.FormatterOptions(options));
};

exports.write = function (rows, options) {
  var csvStream = exports.format(options);
  var promiseWrite = util_1.promisify(function (row, cb) {
    csvStream.write(row, undefined, cb);
  });
  rows.reduce(function (prev, row) {
    return prev.then(function () {
      return promiseWrite(row);
    });
  }, Promise.resolve()).then(function () {
    return csvStream.end();
  }).catch(function (err) {
    csvStream.emit('error', err);
  });
  return csvStream;
};

exports.writeToStream = function (ws, rows, options) {
  return exports.write(rows, options).pipe(ws);
};

exports.writeToBuffer = function (rows) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var buffers = [];
  var ws = new stream_1.Writable({
    write: function write(data, enc, writeCb) {
      buffers.push(data);
      writeCb();
    }
  });
  return new Promise(function (res, rej) {
    ws.on('error', rej).on('finish', function () {
      return res(Buffer.concat(buffers));
    });
    exports.write(rows, opts).pipe(ws);
  });
};

exports.writeToString = function (rows, options) {
  return exports.writeToBuffer(rows, options).then(function (buffer) {
    return buffer.toString();
  });
};

exports.writeToPath = function (path, rows, options) {
  var stream = fs.createWriteStream(path, {
    encoding: 'utf8'
  });
  return exports.write(rows, options).pipe(stream);
};

}).call(this,require("buffer").Buffer)

},{"./CsvFormatterStream":143,"./FormatterOptions":144,"./types":149,"buffer":216,"fs":215,"stream":396,"util":415}],149:[function(require,module,exports){
"use strict";
/* eslint-disable @typescript-eslint/no-explicit-any */

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSyncTransform = void 0;

exports.isSyncTransform = function (transform) {
  return transform.length === 1;
};

},{}],150:[function(require,module,exports){
(function (setImmediate){
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CsvParserStream = void 0;

var string_decoder_1 = require("string_decoder");

var stream_1 = require("stream");

var transforms_1 = require("./transforms");

var parser_1 = require("./parser");

var CsvParserStream = /*#__PURE__*/function (_stream_1$Transform) {
  _inherits(CsvParserStream, _stream_1$Transform);

  var _super = _createSuper(CsvParserStream);

  function CsvParserStream(parserOptions) {
    var _this;

    _classCallCheck(this, CsvParserStream);

    _this = _super.call(this, {
      objectMode: parserOptions.objectMode
    });
    _this.lines = '';
    _this.rowCount = 0;
    _this.parsedRowCount = 0;
    _this.parsedLineCount = 0;
    _this.endEmitted = false;
    _this.headersEmitted = false;
    _this.parserOptions = parserOptions;
    _this.parser = new parser_1.Parser(parserOptions);
    _this.headerTransformer = new transforms_1.HeaderTransformer(parserOptions);
    _this.decoder = new string_decoder_1.StringDecoder(parserOptions.encoding);
    _this.rowTransformerValidator = new transforms_1.RowTransformerValidator();
    return _this;
  }

  _createClass(CsvParserStream, [{
    key: "transform",
    value: function transform(transformFunction) {
      this.rowTransformerValidator.rowTransform = transformFunction;
      return this;
    }
  }, {
    key: "validate",
    value: function validate(validateFunction) {
      this.rowTransformerValidator.rowValidator = validateFunction;
      return this;
    } // eslint-disable-next-line @typescript-eslint/no-explicit-any

  }, {
    key: "emit",
    value: function emit(event) {
      var _get2;

      if (event === 'end') {
        if (!this.endEmitted) {
          this.endEmitted = true;

          _get(_getPrototypeOf(CsvParserStream.prototype), "emit", this).call(this, 'end', this.rowCount);
        }

        return false;
      }

      for (var _len = arguments.length, rest = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        rest[_key - 1] = arguments[_key];
      }

      return (_get2 = _get(_getPrototypeOf(CsvParserStream.prototype), "emit", this)).call.apply(_get2, [this, event].concat(rest));
    }
  }, {
    key: "_transform",
    value: function _transform(data, encoding, done) {
      // if we have hit our maxRows parsing limit then skip parsing
      if (this.hasHitRowLimit) {
        return done();
      }

      try {
        var lines = this.lines;
        var newLine = lines + this.decoder.write(data);
        var rows = this.parse(newLine, true);
        return this.processRows(rows, done);
      } catch (e) {
        return done(e);
      }
    }
  }, {
    key: "_flush",
    value: function _flush(done) {
      // if we have hit our maxRows parsing limit then skip parsing
      if (this.hasHitRowLimit) {
        return done();
      }

      try {
        var newLine = this.lines + this.decoder.end();
        var rows = this.parse(newLine, false);
        return this.processRows(rows, done);
      } catch (e) {
        return done(e);
      }
    }
  }, {
    key: "parse",
    value: function parse(data, hasMoreData) {
      if (!data) {
        return [];
      }

      var _this$parser$parse = this.parser.parse(data, hasMoreData),
          line = _this$parser$parse.line,
          rows = _this$parser$parse.rows;

      this.lines = line;
      return rows;
    }
  }, {
    key: "processRows",
    value: function processRows(rows, cb) {
      var _this2 = this;

      var rowsLength = rows.length;

      var iterate = function iterate(i) {
        var callNext = function callNext(err) {
          if (err) {
            return cb(err);
          }

          if (i % 100 === 0) {
            // incase the transform are sync insert a next tick to prevent stack overflow
            setImmediate(function () {
              return iterate(i + 1);
            });
            return undefined;
          }

          return iterate(i + 1);
        };

        _this2.checkAndEmitHeaders(); // if we have emitted all rows or we have hit the maxRows limit option
        // then end


        if (i >= rowsLength || _this2.hasHitRowLimit) {
          return cb();
        }

        _this2.parsedLineCount += 1;

        if (_this2.shouldSkipLine) {
          return callNext();
        }

        var row = rows[i];
        _this2.rowCount += 1;
        _this2.parsedRowCount += 1;
        var nextRowCount = _this2.rowCount;
        return _this2.transformRow(row, function (err, transformResult) {
          if (err) {
            _this2.rowCount -= 1;
            return callNext(err);
          }

          if (!transformResult) {
            return callNext(new Error('expected transform result'));
          }

          if (!transformResult.isValid) {
            _this2.emit('data-invalid', transformResult.row, nextRowCount, transformResult.reason);
          } else if (transformResult.row) {
            return _this2.pushRow(transformResult.row, callNext);
          }

          return callNext();
        });
      };

      iterate(0);
    }
  }, {
    key: "transformRow",
    value: function transformRow(parsedRow, cb) {
      var _this3 = this;

      try {
        this.headerTransformer.transform(parsedRow, function (err, withHeaders) {
          if (err) {
            return cb(err);
          }

          if (!withHeaders) {
            return cb(new Error('Expected result from header transform'));
          }

          if (!withHeaders.isValid) {
            if (_this3.shouldEmitRows) {
              return cb(null, {
                isValid: false,
                row: parsedRow
              });
            } // skipped because of skipRows option remove from total row count


            return _this3.skipRow(cb);
          }

          if (withHeaders.row) {
            if (_this3.shouldEmitRows) {
              return _this3.rowTransformerValidator.transformAndValidate(withHeaders.row, cb);
            } // skipped because of skipRows option remove from total row count


            return _this3.skipRow(cb);
          } // this is a header row dont include in the rowCount or parsedRowCount


          _this3.rowCount -= 1;
          _this3.parsedRowCount -= 1;
          return cb(null, {
            row: null,
            isValid: true
          });
        });
      } catch (e) {
        cb(e);
      }
    }
  }, {
    key: "checkAndEmitHeaders",
    value: function checkAndEmitHeaders() {
      if (!this.headersEmitted && this.headerTransformer.headers) {
        this.headersEmitted = true;
        this.emit('headers', this.headerTransformer.headers);
      }
    }
  }, {
    key: "skipRow",
    value: function skipRow(cb) {
      // skipped because of skipRows option remove from total row count
      this.rowCount -= 1;
      return cb(null, {
        row: null,
        isValid: true
      });
    }
  }, {
    key: "pushRow",
    value: function pushRow(row, cb) {
      try {
        if (!this.parserOptions.objectMode) {
          this.push(JSON.stringify(row));
        } else {
          this.push(row);
        }

        cb();
      } catch (e) {
        cb(e);
      }
    }
  }, {
    key: "hasHitRowLimit",
    get: function get() {
      return this.parserOptions.limitRows && this.rowCount >= this.parserOptions.maxRows;
    }
  }, {
    key: "shouldEmitRows",
    get: function get() {
      return this.parsedRowCount > this.parserOptions.skipRows;
    }
  }, {
    key: "shouldSkipLine",
    get: function get() {
      return this.parsedLineCount <= this.parserOptions.skipLines;
    }
  }]);

  return CsvParserStream;
}(stream_1.Transform);

exports.CsvParserStream = CsvParserStream;

}).call(this,require("timers").setImmediate)

},{"./parser":162,"./transforms":165,"stream":396,"string_decoder":410,"timers":411}],151:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParserOptions = void 0;

var lodash_escaperegexp_1 = __importDefault(require("lodash.escaperegexp"));

var lodash_isnil_1 = __importDefault(require("lodash.isnil"));

var ParserOptions = function ParserOptions(opts) {
  _classCallCheck(this, ParserOptions);

  var _a;

  this.objectMode = true;
  this.delimiter = ',';
  this.ignoreEmpty = false;
  this.quote = '"';
  this.escape = null;
  this.escapeChar = this.quote;
  this.comment = null;
  this.supportsComments = false;
  this.ltrim = false;
  this.rtrim = false;
  this.trim = false;
  this.headers = null;
  this.renameHeaders = false;
  this.strictColumnHandling = false;
  this.discardUnmappedColumns = false;
  this.carriageReturn = '\r';
  this.encoding = 'utf8';
  this.limitRows = false;
  this.maxRows = 0;
  this.skipLines = 0;
  this.skipRows = 0;
  Object.assign(this, opts || {});

  if (this.delimiter.length > 1) {
    throw new Error('delimiter option must be one character long');
  }

  this.escapedDelimiter = lodash_escaperegexp_1.default(this.delimiter);
  this.escapeChar = (_a = this.escape) !== null && _a !== void 0 ? _a : this.quote;
  this.supportsComments = !lodash_isnil_1.default(this.comment);
  this.NEXT_TOKEN_REGEXP = new RegExp("([^\\s]|\\r\\n|\\n|\\r|".concat(this.escapedDelimiter, ")"));

  if (this.maxRows > 0) {
    this.limitRows = true;
  }
};

exports.ParserOptions = ParserOptions;

},{"lodash.escaperegexp":317,"lodash.isnil":322}],152:[function(require,module,exports){
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  Object.defineProperty(o, k2, {
    enumerable: true,
    get: function get() {
      return m[k];
    }
  });
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});

var __setModuleDefault = void 0 && (void 0).__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});

var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  }

  __setModuleDefault(result, mod);

  return result;
};

var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) {
    if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
  }
};

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseString = exports.parseFile = exports.parseStream = exports.parse = void 0;

var fs = __importStar(require("fs"));

var stream_1 = require("stream");

var ParserOptions_1 = require("./ParserOptions");

var CsvParserStream_1 = require("./CsvParserStream");

__exportStar(require("./types"), exports);

var CsvParserStream_2 = require("./CsvParserStream");

Object.defineProperty(exports, "CsvParserStream", {
  enumerable: true,
  get: function get() {
    return CsvParserStream_2.CsvParserStream;
  }
});

var ParserOptions_2 = require("./ParserOptions");

Object.defineProperty(exports, "ParserOptions", {
  enumerable: true,
  get: function get() {
    return ParserOptions_2.ParserOptions;
  }
});

exports.parse = function (args) {
  return new CsvParserStream_1.CsvParserStream(new ParserOptions_1.ParserOptions(args));
};

exports.parseStream = function (stream, options) {
  return stream.pipe(new CsvParserStream_1.CsvParserStream(new ParserOptions_1.ParserOptions(options)));
};

exports.parseFile = function (location) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return fs.createReadStream(location).pipe(new CsvParserStream_1.CsvParserStream(new ParserOptions_1.ParserOptions(options)));
};

exports.parseString = function (string, options) {
  var rs = new stream_1.Readable();
  rs.push(string);
  rs.push(null);
  return rs.pipe(new CsvParserStream_1.CsvParserStream(new ParserOptions_1.ParserOptions(options)));
};

},{"./CsvParserStream":150,"./ParserOptions":151,"./types":166,"fs":215,"stream":396}],153:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Parser = void 0;

var Scanner_1 = require("./Scanner");

var RowParser_1 = require("./RowParser");

var Token_1 = require("./Token");

var EMPTY_ROW_REGEXP = /^\s*(?:''|"")?\s*(?:,\s*(?:''|"")?\s*)*$/;

var Parser = /*#__PURE__*/function () {
  function Parser(parserOptions) {
    _classCallCheck(this, Parser);

    this.parserOptions = parserOptions;
    this.rowParser = new RowParser_1.RowParser(this.parserOptions);
  }

  _createClass(Parser, [{
    key: "parse",
    value: function parse(line, hasMoreData) {
      var scanner = new Scanner_1.Scanner({
        line: Parser.removeBOM(line),
        parserOptions: this.parserOptions,
        hasMoreData: hasMoreData
      });

      if (this.parserOptions.supportsComments) {
        return this.parseWithComments(scanner);
      }

      return this.parseWithoutComments(scanner);
    }
  }, {
    key: "parseWithoutComments",
    value: function parseWithoutComments(scanner) {
      var rows = [];
      var shouldContinue = true;

      while (shouldContinue) {
        shouldContinue = this.parseRow(scanner, rows);
      }

      return {
        line: scanner.line,
        rows: rows
      };
    }
  }, {
    key: "parseWithComments",
    value: function parseWithComments(scanner) {
      var parserOptions = this.parserOptions;
      var rows = [];

      for (var nextToken = scanner.nextCharacterToken; nextToken !== null; nextToken = scanner.nextCharacterToken) {
        if (Token_1.Token.isTokenComment(nextToken, parserOptions)) {
          var cursor = scanner.advancePastLine();

          if (cursor === null) {
            return {
              line: scanner.lineFromCursor,
              rows: rows
            };
          }

          if (!scanner.hasMoreCharacters) {
            return {
              line: scanner.lineFromCursor,
              rows: rows
            };
          }

          scanner.truncateToCursor();
        } else if (!this.parseRow(scanner, rows)) {
          break;
        }
      }

      return {
        line: scanner.line,
        rows: rows
      };
    }
  }, {
    key: "parseRow",
    value: function parseRow(scanner, rows) {
      var nextToken = scanner.nextNonSpaceToken;

      if (!nextToken) {
        return false;
      }

      var row = this.rowParser.parse(scanner);

      if (row === null) {
        return false;
      }

      if (this.parserOptions.ignoreEmpty && EMPTY_ROW_REGEXP.test(row.join(''))) {
        return true;
      }

      rows.push(row);
      return true;
    }
  }], [{
    key: "removeBOM",
    value: function removeBOM(line) {
      // Catches EFBBBF (UTF-8 BOM) because the buffer-to-string
      // conversion translates it to FEFF (UTF-16 BOM)
      if (line && line.charCodeAt(0) === 0xfeff) {
        return line.slice(1);
      }

      return line;
    }
  }]);

  return Parser;
}();

exports.Parser = Parser;

},{"./RowParser":154,"./Scanner":155,"./Token":156}],154:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowParser = void 0;

var column_1 = require("./column");

var Token_1 = require("./Token");

var _Token_1$Token = Token_1.Token,
    isTokenRowDelimiter = _Token_1$Token.isTokenRowDelimiter,
    isTokenCarriageReturn = _Token_1$Token.isTokenCarriageReturn,
    isTokenDelimiter = _Token_1$Token.isTokenDelimiter;

var RowParser = /*#__PURE__*/function () {
  function RowParser(parserOptions) {
    _classCallCheck(this, RowParser);

    this.parserOptions = parserOptions;
    this.columnParser = new column_1.ColumnParser(parserOptions);
  }

  _createClass(RowParser, [{
    key: "parse",
    value: function parse(scanner) {
      var parserOptions = this.parserOptions;
      var hasMoreData = scanner.hasMoreData;
      var currentScanner = scanner;
      var columns = [];
      var currentToken = this.getStartToken(currentScanner, columns);

      while (currentToken) {
        if (isTokenRowDelimiter(currentToken)) {
          currentScanner.advancePastToken(currentToken); // if ends with CR and there is more data, keep unparsed due to possible
          // coming LF in CRLF

          if (!currentScanner.hasMoreCharacters && isTokenCarriageReturn(currentToken, parserOptions) && hasMoreData) {
            return null;
          }

          currentScanner.truncateToCursor();
          return columns;
        }

        if (!this.shouldSkipColumnParse(currentScanner, currentToken, columns)) {
          var item = this.columnParser.parse(currentScanner);

          if (item === null) {
            return null;
          }

          columns.push(item);
        }

        currentToken = currentScanner.nextNonSpaceToken;
      }

      if (!hasMoreData) {
        currentScanner.truncateToCursor();
        return columns;
      }

      return null;
    }
  }, {
    key: "getStartToken",
    value: function getStartToken(scanner, columns) {
      var currentToken = scanner.nextNonSpaceToken;

      if (currentToken !== null && isTokenDelimiter(currentToken, this.parserOptions)) {
        columns.push('');
        return scanner.nextNonSpaceToken;
      }

      return currentToken;
    }
  }, {
    key: "shouldSkipColumnParse",
    value: function shouldSkipColumnParse(scanner, currentToken, columns) {
      var parserOptions = this.parserOptions;

      if (isTokenDelimiter(currentToken, parserOptions)) {
        scanner.advancePastToken(currentToken); // if the delimiter is at the end of a line

        var nextToken = scanner.nextCharacterToken;

        if (!scanner.hasMoreCharacters || nextToken !== null && isTokenRowDelimiter(nextToken)) {
          columns.push('');
          return true;
        }

        if (nextToken !== null && isTokenDelimiter(nextToken, parserOptions)) {
          columns.push('');
          return true;
        }
      }

      return false;
    }
  }]);

  return RowParser;
}();

exports.RowParser = RowParser;

},{"./Token":156,"./column":161}],155:[function(require,module,exports){
"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Scanner = void 0;

var Token_1 = require("./Token");

var ROW_DELIMITER = /((?:\r\n)|\n|\r)/;

var Scanner = /*#__PURE__*/function () {
  function Scanner(args) {
    _classCallCheck(this, Scanner);

    this.cursor = 0;
    this.line = args.line;
    this.lineLength = this.line.length;
    this.parserOptions = args.parserOptions;
    this.hasMoreData = args.hasMoreData;
    this.cursor = args.cursor || 0;
  }

  _createClass(Scanner, [{
    key: "advancePastLine",
    value: function advancePastLine() {
      var match = ROW_DELIMITER.exec(this.lineFromCursor);

      if (!match) {
        if (this.hasMoreData) {
          return null;
        }

        this.cursor = this.lineLength;
        return this;
      }

      this.cursor += (match.index || 0) + match[0].length;
      return this;
    }
  }, {
    key: "advanceTo",
    value: function advanceTo(cursor) {
      this.cursor = cursor;
      return this;
    }
  }, {
    key: "advanceToToken",
    value: function advanceToToken(token) {
      this.cursor = token.startCursor;
      return this;
    }
  }, {
    key: "advancePastToken",
    value: function advancePastToken(token) {
      this.cursor = token.endCursor + 1;
      return this;
    }
  }