#!/usr/bin/ python3
# -*- coding: utf-8 -*-
# @Time    : 2020/04/17
# @Author  : xinyu xu
# @Software: PyCharm
from common.crm_change_standard import getStandardName
from service.user_behavior import Recom
from flask import Flask, render_template
from flask import request
from flask_cors import CORS
from common import common_result
from service.company_basic import CompanyBase
from service.Image_status import imageInfo
from service.trade import selectcyle,insertcycle
from service.GetImageFromSql import getImageInfo
from service.rec_status import tj_rec_status,tj_rec_remark
from service.online_GetLicenseImage import getlicenceInfo
from service.tf_member import gaoguan,gudong,nianbao
from service.talking import talking,talking_product
from service.moneyAPI import moneyAPI
from service.company_30s import tj_30s_hx
from service.talking_name import talkingName_new
from service.change_message import companyChage
from service.label_connect import hx_connect
from service.label_type_1 import label_type1
from service.select_es_result import hx_company_dict,hx_company_list
from service.hxResult import businessApi
from service.assigned_opportunity import assigned_opportunity
from service.potential import app_website
from service.consultation_record import consultingInfo

server = Flask(__name__,static_url_path="",static_folder="")
server.config['JSON_AS_ASCII'] = False
CORS(server,supports_credentials=True) #跨域请求

recomm = Recom()
companybase = CompanyBase()



moneyAPI(server)
imageInfo(server)
selectcyle(server)
insertcycle(server)
getImageInfo(server)
getlicenceInfo(server)
gaoguan(server)
gudong(server)
nianbao(server)
tj_rec_status(server)
talking(server)
talkingName_new(server)
talking_product(server)
tj_30s_hx(server)
companyChage(server)
hx_connect(server)
label_type1(server)
hx_company_dict(server)
hx_company_list(server)
businessApi(server)
assigned_opportunity(server)
app_website(server)
consultingInfo(server)
tj_rec_remark(server)


#基本信息
@server.route('/base_info', methods=['POST'])
def base_info():
    if request.method == 'POST':
        request_data = request.json
        if not request_data or  not request_data.get('company_name'):
            return common_result.to_result(None,300,"参数错误")
        company_name = request_data.get('company_name')
        standard_company_name = getStandardName(company_name)
        base_result = companybase.companyinfo(standard_company_name)
        return common_result.to_result(base_result)


#画像
@server.route('/label', methods=['POST'])
def lable_post():
    if request.method == 'POST':
        request_data = request.json
        if not request_data or  not request_data.get('company_name'):
            return common_result.to_result(None,300,"参数错误")
        company_name = request_data.get('company_name')
        standard_company_name = getStandardName(company_name)
        lable_result = recomm.company_label(standard_company_name)
        return common_result.to_result(lable_result)


#产品
# @server.route('/product', methods=['POST'])
# def product_post():
#     if request.method == 'POST':
#         request_data = request.json
#         if not request_data or  not request_data.get('company_name'):
#             return common_result.to_result(None,300,"参数错误")
#         company_name = request_data.get('company_name')
#         product_result = recomm.recommend_product(company_name)
#         return common_result.to_result(product_result)

#商机
# @server.route('/api/business',methods=['POST'])
# def business_post():
#     if request.method == 'POST':
#         business_result = recomm.business()
#         return common_result.to_result(business_result)

#商机推荐结果
@server.route('/api/businessProduct',methods=['POST'])
def business_product_post():
    if request.method == 'POST':
        request_data = request.json
        if not request_data or not request_data.get('bussines_id'):
            return common_result.to_result(None, 300, "参数错误")
        if not request_data or not request_data.get('businessType'):
            return common_result.to_result(None, 300, "参数错误")
        business_id = request_data.get('bussines_id')
        business_type = request_data.get('businessType')
        business_product_result, reason,relational_reason,seas_reason = recomm.business_product(business_id, business_type)
        print(business_product_result, reason,relational_reason)
        if business_type != "智能监测" and business_type != "关联推荐"  and business_type != "公海挖掘":
            return common_result.to_result(business_product_result)
        elif business_type == "关联推荐":
            result = common_result.to_result(business_product_result)
            # print('result000',result)
            result['relational_reason'] = relational_reason
            return result
        elif business_type == "公海挖掘":
            result = common_result.to_result(business_product_result)
            # print('result000',result)
            result['seas_reason'] = seas_reason
            return result
        else:
            result = common_result.to_result(business_product_result)
            result['survey_reason'] = reason
            return result

#公司名推荐结果
@server.route('/api/companyProduct',methods=['POST'])
def company_product_post():
    if request.method == 'POST':
        request_data = request.json
        if not request_data or not request_data.get('company_name'):
            return common_result.to_result(None, 300, "参数错误")
        company_name = request_data.get('company_name')
        standard_company_name = getStandardName(company_name)
        business_product_result = recomm.company_product(standard_company_name)
        return common_result.to_result(business_product_result)



#用户购买记录
@server.route('/behavior',methods=['POST'])
def behavior_post():
    if request.method == 'POST':
        request_data = request.json
        if not request_data or  not request_data.get('company_name'):
            return common_result.to_result(None,300,"参数错误")
        company_name = request_data.get('company_name')
        standard_company_name = getStandardName(company_name)
        behavior_result = recomm.company_behavior(standard_company_name)
        return common_result.to_result(behavior_result)

#分公司
@server.route('/branch',methods=['POST'])
def company_branch():
    if request.method == 'POST':
        request_data = request.json
        if not request_data or not request_data.get('company_name'):
            return common_result.to_result(None, 300, "参数错误")
        company_name = request_data.get('company_name')
        standard_company_name = getStandardName(company_name)
        company_branch_result =companybase.companybranch(standard_company_name)
        return common_result.to_result(company_branch_result)

#相似企业
@server.route('/similarCompany',methods=['POST'])
def company_similar():
    if request.method == 'POST':
        request_data = request.json
        if not request_data or not request_data.get('company_name'):
            return common_result.to_result(None, 300, "参数错误")
        company_name = request_data.get('company_name')
        standard_company_name = getStandardName(company_name)
        company_info = companybase.companyinfo(standard_company_name)
        similar_company_list = companybase.similar_company(company_info,company_name)
        return common_result.to_result(similar_company_list)

@server.route('/')
def index_page():
    if request.method == 'GET':
        print("----")
        return render_template('index.html')

if __name__ == '__main__':
    server.run(debug=True,host='0.0.0.0',port=80)
    # server.run(debug=True, host='127.0.0.1', port=8080)
