var path = require('path');
var ENVINPUT = {
  KONG_ADMIAN: process.env.KONG_ADMIAN,
  DB_HOST: process.env.DB_HOST,
  DB_PORT: process.env.DB_PORT,
  DB_USER: process.env.DB_USER,
  DB_PWD: process.env.DB_PWD,
  DB_NAME: process.env.PAAS_DB_NAME,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  REDIS_DB: process.env.PAAS_REDIS_DB,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : "dev"
};
var settings = {
  env: ENVINPUT.APP_ENV,
  salt: "%iatpD1gcxz7iF#B",
  defaultpwd: "gsb2020",
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 80,
  kongurl: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.kongurl;
    } else {
      return "http://kong-dbproxy.kong:8001/";
    }
  },
  icUrl: function () {
    if (this.env == "dev") {
      return "http://ic.com:8000";
    } else {
      return "http://icdeliver-service";
    }
  },
  logUrl:function(){
    if (this.env == "dev") {
      return "http://192.168.1.128:4019/api/queueAction/producer/springBoard";
    } else {
      return "http://logs-sytxpublic-msgq-service/api/queueAction/producer/springBoard";
    }
  },
  pmappname: "center-app",
  pmappid: 1,
  pmcompanyid: 1,
  pmroleid: { "ta": 1, "pr": 2 },
  redis: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.redis;
    } else {
      return {
        host: ENVINPUT.REDIS_HOST,
        port: ENVINPUT.REDIS_PORT,
        password: ENVINPUT.REDIS_PWD,
        db: ENVINPUT.REDIS_DB,
      };
    }
  },
  database: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      console.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>....")
      return localsettings.database;
    } else {
      return {
        dbname: ENVINPUT.DB_NAME,
        user: ENVINPUT.DB_USER,
        password: ENVINPUT.DB_PWD,
        config: {
          host: ENVINPUT.DB_HOST,
          port: ENVINPUT.DB_PORT,
          dialect: 'mysql',
          operatorsAliases: false,
          pool: {
            max: 5,
            min: 0,
            acquire: 90000000,
            idle: 1000000
          },
          debug: false,
          timezone: '+08:00',
          dialectOptions: {
            requestTimeout: 999999,
            // instanceName:'DEV'
          }  //设置MSSQL超时时间
        },
      };
    }
  }
};
settings.ENVINPUT = ENVINPUT;
module.exports = settings;
