const system = require("../../../system");
const ServiceBase = require("../../sve.base");
class ProductService extends ServiceBase {
  constructor() {
    super("product", ServiceBase.getDaoName(ProductService));
    this.priceDao = system.getObject("db.product.productpriceDao")
  }
  async findPriceStrategys(stragetyids,t){
    //按照策略id查询出定价策略集合
    let pts=await this.db.models.pricestrategy.findAll({ where: { id: { [this.db.Op.in]: stragetyids } },attributes:['id','optionunion'],transaction:t})
    let tmpdic={}
    pts.forEach(p=>{
      tmpdic[p.id+'']=p.optionunion
    })
    return tmpdic
  }
  async create(p) {
    if (!p.name || p.name == "") {
      p.name =  p.productcatpath+ "~" + p.regionpath
    }
    //策略ids
    let stragetyids = p.sts
    let skucodemap=p.skucodemap
    var self = this;
    return this.db.transaction(async function (t) {
      let pnew = await self.dao.create(p, t)
      let productprices = []
      //按照策略id查询出定价策略集合
      let tmpdic=await self.findPriceStrategys(stragetyids,t)
      stragetyids.forEach(stragetyid => {
        if(skucodemap){
          p.skucode=skucodemap[stragetyid]
          
        }
        let pps = {
          product_id: pnew.id,
          pricestrategy_id: stragetyid,
          pname:p.name,
          strategyitems:tmpdic[stragetyid+''],
          company_id:p.company_id,
          skucode:p.skucode?p.skucode:self.getUUID(),
          skuname:p.skuname?p.skuname:p.name,
          sptags:p.sptags,
          channeltags:p.channeltags
        }
        productprices.push(pps)
      })
      await self.priceDao.bulkCreate(productprices, t)
      return pnew;
    });
  }
  async update(p) {
    if (!p.name || p.name == "") {
      p.name = p.regionpath + "~" + p.productcatpath
    }
    //策略ids
    let stragetyids = p.sts
    var self = this;
    return this.db.transaction(async function (t) {
      let pupdate = await self.dao.update(p, t)

      //先按照产品id检查出当前产品的价格策略，检查出不在传入中的，需要删除
      //在传入中的不做处理
      let currentProduct = await self.dao.model.findOne({
        where: { id: p.id }, include: [
          {model: self.db.models.productprice, as:"skus",attributes: ['id', 'pricestrategy_id'],raw:true},
        ], transaction: t
      })
      let notInInput=[]//需要删除
      let skusarray=[]
      currentProduct.skus.forEach(sku=>{
        skusarray.push(sku.pricestrategy_id)
        if(stragetyids.indexOf(sku.pricestrategy_id)<0){
          notInInput.push(sku.id)
        }
      })
     //删除
     if(notInInput.length>0){
      await self.priceDao.bulkDelete(notInInput,t)
     }
      //传入不在查出中的，需要新增
      let notintables=[]
      stragetyids.forEach(st=>{
        if(skusarray.indexOf(st)<0){
          notintables.push(st)
        }
      })
      //新增
      let productprices = []
      let tmpdic=await self.findPriceStrategys(stragetyids,t)
      notintables.forEach(stragetyid => {
        let pps = {
          product_id: p.id,
          pricestrategy_id: stragetyid,
          pname:p.name,
          strategyitems:tmpdic[stragetyid+''],
          company_id:p.company_id,
          skucode:this.getUUID(),
          skuname:p.name,
        }
        productprices.push(pps)
      })
      if(productprices.length>0){
        await self.priceDao.bulkCreate(productprices, t)
      }
      return {};
    });
  }
}
module.exports = ProductService;