const system = require("../../../system");
const ServiceBase = require("../../sve.base");
class TreeArchService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(TreeArchService));
  }
  async getRegions() {
    let rs = await this.dao.model.findAll({ attributes: ['regionJSON'] })
    return JSON.parse(rs[0].regionJSON)
  }
  async getSysArchJSON() {
    let rs = await this.dao.model.findAll({ attributes: ['sysArchJSON'] })
    return JSON.parse(rs[0].sysArchJSON)
  }
  async saveSysArchJSON(sysArchJSON) {
    let rs = await this.dao.model.findAll()
    let upobj = rs[0]
    upobj.sysArchJSON = JSON.stringify(sysArchJSON)
    upobj.save()
    return sysArchJSON
  }
  async saveRegions(regionJson) {
    let rs = await this.dao.model.findAll()
    let upobj = rs[0]
    upobj.regionJSON = JSON.stringify(regionJson)
    upobj.save()
    return regionJson
  }
  async getProductcats() {
    let rs = await this.dao.model.findAll({ attributes: ['productcatJSON'] })
    return JSON.parse(rs[0].productcatJSON)
  }
  async saveProductcats(productcatJson) {
    let rs = await this.dao.model.findAll()
    let upobj = rs[0]
    upobj.productcatJSON = JSON.stringify(productcatJson)
    upobj.save()
    return productcatJson
  }
  // async itetree(jsontree, level, results) {
  //   jsontree.forEach(item => {
  //     if (item.level < level) {
  //       let cloneobj = { ...item }
  //       if (results) {
  //         results.push(cloneobj)
  //       }
  //       if (item.children) {
  //         cloneobj.children = []
  //         itetree(item.children, level, cloneobj.children)
  //       }
  //     } else {
  //       if (results) {
  //         results.push(cloneobj)
  //       }
  //     }
  //   })
  // }
 findNodeByCode(jsontree, code, results) {
    jsontree.forEach(item => {
      if (item.code == code) {
        if (item.children) {
          item.children.forEach(c => {
            let tmp = { ...c }
            tmp.loading = false
            if (tmp.children) {
              tmp.children = []
            }
            results.push(tmp)
          })
         //this.findNodeByCode(item.children, code, results)
        }
      }else{
        if(item.children){
          this.findNodeByCode(item.children, code, results)
        }
      }
    })
  }
  async getTreeArchByCode(archName,code) {
    let results = []
    let rs = await this.dao.model.findAll({ attributes: [archName] })
    let jsontree = JSON.parse(rs[0][archName])
    this.findNodeByCode(jsontree,code,results)
    console.log(results)
    return results;
  }
  /**
   * 按照字段和及级别读取树部分节点
   * @param {*} archName 
   * @param {*} level 
   */
  // async getTreeArchs(archName, level) {
  //   let results = []
  //   let rs = await this.dao.model.findAll({ attributes: [archName] })
  //   let jsontree = JSON.parse(rs[0].[archName])
  //   await this.itetree(jsontree, level, results)
  //   console.log(results)
  //   return results;
  // }
}
module.exports = TreeArchService;
// (async ()=>{
//   const fs=require("fs")
//   let treeS=new TreeArchService();
//   let s= fs.readFileSync("./a.json")
//   await treeS.dao.model.create({id:1,regionJSON:s})
//   console.log("insert ok.....")
//  //  let x=await u.cregister("jiangong")
//  //  console.log(x)
//  // let x=await u.cunregister("jiangong")
//  //  console.log(x)
//   // let t=await u.cmakejwt()
//   // console.log(t)
//   //let ux=await u.cjsonregister(AppService.newRouteUrl("test-service2"),{name:"test-service2",hosts:["ttest1.com"]})
//   //let ux=await u.cjsonregister(AppService.newServiceUrl(),{name:"test-service3",url:"http://zhichan.gongsibao.com"})
//   //let ux=await u.cdel(AppService.routeUrl("test-service2"))
//   //let ux=await u.cdel(AppService.serviceUrl("test-service2"))
//   //  let ux=await u.create({name:"test4-service",backend:"zhichan-service",domainName:"domain.com"})
//   //   console.log(ux);
//   // let delrtn=await u.delete({id:2,name:"test4-service"})
//   // console.log(delrtn);
// })()