const system = require("../../../system");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
module.exports = (db, DataTypes) => {
  return db.define("msg", {
    msgType: {
      type: DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(appconfig.pdict.msgType),
    },
    app_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    app_key: {
      type: DataTypes.STRING,
      allowNull: true
    },
    company_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    sender: {
      type: DataTypes.STRING,
      allowNull: true
    },
    sender_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    title: {
      type: DataTypes.STRING,
      allowNull: false
    },
    emergency_level: {
      type: DataTypes.INTEGER,
      defaultValue: 0
    },
    content: {
      type: DataTypes.TEXT('long'),
      allowNull: false,
    },
    jump_address: {
      type: DataTypes.STRING,
      allowNull: true
    },
    other: {
      allowNull: true,
      type: DataTypes.JSON
    },
    is_undo: {
      type: DataTypes.BOOLEAN,
      defaultValue: false
    }
  }, {
    paranoid: false,//假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'msg_history',
    validate: {

    },
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}
