const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class UserCache extends CacheBase{
  constructor(){
    super();
    this.userDao=system.getObject("db.auth.userDao");
  }
  isdebug(){
   return settings.env=="dev";
 }
  desc(){
    return "缓存本地应用对象";
 }
 prefix(){
    return "g_userlocal_cm:"
 }
 async buildCacheVal(cachekey,inputkey, val, ex, ...items) {
   const configValue = await this.userDao.model.findAll({
    where: { userName: inputkey, app_id: settings.pmappid,isEnabled:true},
    attributes: ['id','userName', 'nickName','headUrl','jwtkey','jwtsecret','created_at','isSuper','isAdmin','isAllocated','mail','mobile','opath','ptags'],
    include: [
      { model: this.db.models.company,attributes:['id','name','companykey','appids'],raw:true},
      {model:this.db.models.role,as:"Roles",attributes:["id","code"],}
    ],
  });
   
   if (configValue && configValue[0]) {
     return JSON.stringify(configValue[0]);
   }
   return null;
 }
}
module.exports=UserCache;