var system = require("../../../system");
const http = require("http");
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
class MsgCtl extends CtlBase {
    constructor() {
        super("msg", CtlBase.getServiceName(MsgCtl));
    }

    /**
     * 创建消息
     * @param {
     *  msgType,
     *  app_id,
     *  app_key(跳转链接时需要)
    //  *  company_id(需要给某个交付商发送，暂时不考虑)
     *  sender (如果不传默认系统发的)
     *  sender_id
     *  emergency_level（紧急级别暂时不考虑）
     *  jump_address （详情跳转地址）
     *  target:[{id:"",name:''}] 发送给目标人 (非系统消息时必填)
     * } pobj 
     * @param {*} qobj 
     * @param {*} req 
     */
    async create(pobj, qobj, req) {
        if (!pobj.title) {
            return system.getResult(null, "title  can not be empty，100290");
        }
        if (!pobj.content) {
            return system.getResult(null, "content  can not be empty，100290");
        }
        if (!pobj.sender || (pobj.sender_id !== 0 && !pobj.sender_id)) {
            return system.getResult(null, "发送者信息 can not be empty，100290");
        }
        if (pobj.jump_address && !pobj.app_key) {
            return system.getResult(null, "需要跳转时,app_key不能为空");
        }
        if (!pobj.msgType) {
            return system.getResult(null, "msgType  can not be empty，100290");
        }
        if (pobj.msgType !== system.Msg.SYS && !pobj.target) {
            return system.getResult(null, "非系统公告，target 不能为空");
        }
        if (pobj.msgType === system.Msg.SINGLE && Object.prototype.toString.call(pobj.target) !== '[object Object]') {
            return system.getResult(null, "单条消息时,target格式是对象");
        }
        if ((pobj.msgType === system.Msg.SINGLE && pobj.target) && !pobj.target.id) {
            return system.getResult(null, "单条消息时,目标用户id不能为空");
        }
        if (pobj.msgType === system.Msg.MULTI && Object.prototype.toString.call(pobj.target) !== "[object Array]") {
            return system.getResult(null, "多条消息时,target格式是数组");
        }
        if ((pobj.msgType === system.Msg.MULTI && pobj.target) && pobj.target.length <= 0) {
            return system.getResult(null, "多条消息时,target数组不能为空");
        }
        if ((pobj.msgType === system.Msg.MULTI && pobj.target) && pobj.target.length > 0) {
            for (let val of pobj.target) {
                if (!val.id) {
                    return system.getResult(null, "目标用户id不能为空");
                }
            }
        }

        try {
            const rs = await this.service.create(pobj, qobj, req);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)

        }
    }

    /**
     * 返回未提醒 消息
     * @param {*} pobj 
     * @param {*} qobj 
     * @param {*} req 
     */
    async findRemindMessage(pobj, qobj, req) {
        if (!pobj.userid) {
            return system.getResult(null, "userid  can not be empty，100290");
        }
        try {
            const rs = await this.service.findRemindMessage(pobj, qobj, req);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)

        }
    }

    /**
     * 查询 未读消息条数
     * @param {*} pobj 
     * @param {*} qobj 
     * @param {*} req 
     */
    async findUnreadCount(pobj, qobj, req) {
        if (!pobj.userid) {
            return system.getResult(null, "userid  can not be empty，100290");
        }
        pobj.is_read = false;
        try {
            const rs = await this.service.findUnreadCount(pobj, qobj, req);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    /**
     * 更新已读未读
     * @param {
     *  all  true| false 全部已读未读
     * } pobj 
     * @param {*} qobj 
     * @param {*} req 
     */
    async updateStatus(pobj, qobj, req) {
        if (!pobj.userid) {
            return system.getResult(null, "userid  can not be empty，100290");
        }
        if (!pobj.id && !pobj.all) {
            return system.getResult(null, "id  can not be empty，100290");
        }
        try {
            const rs = await this.service.updateStatus(pobj, qobj, req);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    /**
     * 查询系统公告
     * @param {*} pobj 
     * @param {*} qobj 
     * @param {*} req 
     */
    async findSystemMsgCount(pobj, qobj, req) {
        try {
            pobj.type = 'recently';
            const rs = await this.service.findSystemMsgCount(pobj, qobj, req);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    /**
     * 消息列表
     * @param {*} pobj 
     * @param {*} qobj 
     * @param {*} req 
     */
    async list(pobj, qobj, req) {
        if (!pobj.msgType) {
            return system.getResult(null, "msgType  can not be empty，100290");
        }
        if (!pobj.userid) {
            return system.getResult(null, "userid  can not be empty，100290");
        }
        try {
            const rs = await this.service.list(pobj, qobj, req);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    /**
     *  各个消息类型条数统计
     */
    async groupCount(pobj, qobj, req) {
        if (!pobj.userid) {
            return system.getResult(null, "userid  can not be empty，100290");
        }
        try {
            const rs = await this.service.groupCount(pobj, qobj, req);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }
}
module.exports = MsgCtl;
