const system = require("../system");
const uuidv4 = require('uuid/v4');
const settings = require("../../config/settings");
class APIBase{
    constructor() {
        this.cacheManager = system.getObject("db.common.cacheManager");
    }
    getUUID() {
      var uuid = uuidv4();
      var u = uuid.replace(/\-/g, "");
      return u;
    }
    async setContextParams(pobj, qobj, req) {
        let custtags = req.headers["x-consumetag"]?req.headers["x-consumetag"].split("|"):null;
        //当自由用户注册时，需要根据前端传来的companykey,查询出公司，给companyid赋值
        req.xctx = {
          appkey: req.headers["xappkey"],//用于系统管理区分应用,比如角色
          companyid: custtags?custtags[0].split("_")[1]:null,
          password: custtags?custtags[1].split("_")[1]:null,
          username: req.headers["x-consumer-username"],
          credid: req.headers["x-credential-identifier"],
          companykey:req.headers["x-company-key"],//专用于自由用户注册,自由用户用于一定属于某个存在的公司
          codename:req.headers["xcodename"],
          codetitle:req.headers["xcodetitle"]?decodeURI(req.headers["xcodetitle"]):'',
        }
        if(!req.xctx.appkey){
            return [-200,"请求头缺少应用x-app-key"]
        }else{
          let app=await this.cacheManager["AppCache"].cache(req.xctx.appkey);
          req.xctx.appid=app.id;
          pobj.app_id=app.id;//传递参数对象里注入app_id
        }
        //平台注册时，companyid，companykey都为空
        //自由注册时，companykey不能为空
        // if(!req.xctx.companyid && !req.xctx.companykey){
        //   return [-200,"请求头缺少应用x-app-key"]
        // }
        if(!req.xctx.companyid && req.xctx.companykey){
          let comptmp=await this.cacheManager["CompanyCache"].cache(req.xctx.companykey);
          req.xctx.companyid=comptmp.id;
        }
        if(req.xctx.companyid){//在请求传递数据对象注入公司id
          pobj.company_id=req.xctx.companyid;
        }
      }
    async doexec(gname, methodname, pobj, query, req) {
        try {
            let xarg=await this.setContextParams(pobj, query, req);
            if(xarg && xarg[0]<0){
               return system.getResultFail(...xarg);
            }
         
            var rtn = await this[methodname](pobj, query, req);
            rtn.requestId=this.getUUID()
            req.params.param=pobj
            let t=req.xctx.codetitle
            let codename=req.xctx.codename
            if(t==''){
               t="外部调用"
               codename=req.xctx.appkey
            }
            system.execLogs(t,req.params,codename,rtn,null).then(res=>{
              if(res && res.status==1){
                console.log("log.....success")
              }else{
                console.log("log.....fail")
              }
            }).catch(e=>{
              console.log("log.....fail")
            })
            return rtn;
        } catch (e) {
          let rtn={}
          rtn.requestId=this.getUUID()
          req.params.param=pobj
          let t=req.xctx.codetitle
          let codename=req.xctx.codename
          if(t==''){
             t="外部调用"
             codename=req.xctx.appkey
          }
          system.execLogs(t,req.params,codename,rtn,e.stack).then(res=>{
            if(res && res.status==1){
              console.log("log.....success")
            }else{
              console.log("log.....fail")
            }
          }).catch(e=>{
            console.log("log.....fail")
          })
            console.log(e.stack, "api调用异常--error...................");
            var rtnerror = system.getResultFail(-200, "出现异常，请联系管理员");
            return rtnerror;
        }
    }
}
module.exports = APIBase;

