var APIBase = require("../../api.base");
var system = require("../../../system");
class ChannelPayment extends APIBase {
    constructor() {
        super();
        this.utilsAlibankSve = system.getObject("service.utilsSve.utilsAlibankSve");
    }
    /**
    * 接口跳转-POST请求
    * actionProcess  执行的流程
    * actionType     执行的类型
    * actionBody     执行的参数
    */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj, action_type, action_body, req) {
        var opResult = null;
        switch (action_type) {
            // sy
            case "getAliPayInfo"://唤起钉钉h5支付信息---只供简单应用
                opResult = await this.utilsAlibankSve.getH5AliDingPayInfo(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    //支付成功后通知
    async receiveCallBackNotify(pobj, query, req) {
        // var rtn = await this.utilstlbankSve.receiveCallBackNotify(pobj.actionBody.parmas, pobj.client_ip);
        // return rtn;
    }
}
module.exports = ChannelPayment;