const system=require("../../../system");
const ServiceBase=require("../../sve.base");
const settings=require("../../../../config/settings");
class MetaService extends ServiceBase{
  constructor(){
     super("common",ServiceBase.getDaoName(MetaService));
     this.restS=system.getObject("util.restClient");
  }
  async getApiDoc(appid){
   var p=settings.basepath+"/app/base/db/impl/common/apiDocManager.js";
    var ClassObj=  require(p) ;
    var obj=new ClassObj();
   return obj.doc;
  }
  async getApiDocRemote(appid,docUrl){
      var rtn=await this.restS.execPost({}, docUrl);
      if(rtn.stdout){
         var dod=JSON.parse(rtn.stdout);
         if(dod.data){
             return dod.data;
         }
      }
      return null;
  }
  async getUiConfig(appid){
     const cfg=await this.cacheManager["UIConfigCache"].cache(appid,null,60);
     return cfg;
  }
  async getRemoteUiConfig(appkey,uiconfigUrl){
   const cfg=await this.cacheManager["UIRemoteConfigCache"].cache(appkey,null,120,uiconfigUrl);
   return cfg;
  }
}
module.exports=MetaService;
