/**
 * 表单提交记录表
 * @param db
 * @param DataTypes
 * @returns {Model|void|*}
 */
const record_status = {"1":"未读", "2":"已读", "3":"无效"};
module.exports = (db, DataTypes) => {
    return db.define("formsubmitrecord", {
        business_code:DataTypes.STRING(100),
        template_id: DataTypes.INTEGER(11),//模板id
        templatelink_id: DataTypes.INTEGER(11),//模板链接id
        form_id: DataTypes.INTEGER(11),//表单id                                                                                                             
        record_status      :{//记录状态 1未读 2已读 3无效    
          type: DataTypes.STRING(60),
          set: function (val) {
            this.setDataValue("record_status", val);
            this.setDataValue("record_status_name",record_status[val]);
          }
        },
        record_status_name: DataTypes.STRING(60),//记录状态名称
        templatelink_snapshot:DataTypes.JSON,//模板链接快照
        form_snapshot:DataTypes.JSON,//表单快照
        ali_code:DataTypes.STRING,
        record_content:DataTypes.JSON,//记录内容
        push_status:DataTypes.INTEGER,//推送状态 0：未推送，1：已推送  2：异常
        op_notes:DataTypes.STRING,//操作备注
    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        timestamps: true,
        updated_at: true,
        tableName: 'c_form_submit_record',
        validate: {},
        indexes: []
    });
}

