/**
 * 业务类型表
 * @param db
 * @param DataTypes
 * @returns {Model|void|*}
 */
module.exports = (db, DataTypes) => {
    return db.define("businesstype", {
        p_id: DataTypes.INTEGER(11),//产品一类id
        p_name: DataTypes.STRING,//产品一类id
        code: DataTypes.STRING(100),//渠道编码
        name: DataTypes.STRING(100),//渠道名称
        notes: DataTypes.STRING(255),//备注
        user_id: DataTypes.INTEGER(11),//创建用户id
        user_name: DataTypes.STRING(60),//创建用户名称
        company_id: DataTypes.INTEGER(11)
    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        timestamps: true,
        updated_at: true,
        tableName: 'c_business_type',
        validate: {},
        indexes: []
    });
}

