var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const logCtl = system.getObject("web.common.oplogCtl");

var cacheBaseComp = null;
class TradetransferCtl extends CtlBase {
  constructor() {
    super("transfer", CtlBase.getServiceName(TradetransferCtl));
    this.postfile = system.getObject("util.restClient");
  }
  async submit(p, q, req) {
    if (req && req.session && req.session.user) {
      p.onlyCode = req.session.user.unionId;
    }
    if (req.codepath) {
      p.codepath = req.codepath;
    }
    var result = null;
    try {
      if (p.transfer_status == "CONFIRM_ORDER") {
        p.aliorder_status = "1",
          result = await this.service.confirmorder(p);
        console.log(result)
      }
      if (p.transfer_status == "CLOSE_ORDER_ONLY") {
        p.aliorder_status = "11",
          result = await this.service.refuseorder(p)
      }
      if (p.transfer_status == "PROVIDE_MATERIAL") {
        p.aliorder_status = "3",
          result = await this.service.supplymaterail(p)
      }
      if (p.transfer_status == "BUYER_EXPRESS") {
        p.aliorder_status = "5",
          result = await this.service.posttransfermatereial(p)
      }
      if (p.transfer_status == "BUYER_PROVIDE_MATERIAL") {
        p.aliorder_status = "6",
          result = await this.service.receivedtransfermaterail(p)
      }
      if (p.transfer_status == "SUBMIT_TO_SBJ") {
        p.aliorder_status = "7",
          result = await this.service.submittedtransfermaterail(p)
      }
      if (p.transfer_status == "SBJ_ACCEPT") {
        p.aliorder_status = "8",
          result = await this.service.acceptedtransfermaterail(p)
      }

      if (p.transfer_status == "SBJ_SUCCESS") {
        p.aliorder_status = "8",
          result = await this.service.approvedtransfer(p)
      }
      if (p.transfer_status == "SBJ_FAIL") {
        p.aliorder_status = "８",
          result = await this.service.refusetransfer(p)
      }

      if (p.transfer_status == "TRANSFER_SUCCESS") {
        p.aliorder_status = "12",
          result = await this.service.tradesuccess(p)
      }
      if (p.transfer_status == "TRANSFER_FAIL") {
        p.aliorder_status = "10",
          result = await this.service.tradefail(p)
      }
      if (p.transfer_status == "RefuseOrder") {
        p.aliorder_status = "10",
          result = await this.service.tradefail(p)
      }
      if (result && result.Success) {
        var rd = await this.service.update(p);
        return system.getResult(rd);
      } else {
        return system.getResult(null, "阿里请求失败");
      }

    } catch (error) {
      return system.getResult(null, "请求异常");
    }

  }

  async findone(p, q, req) {
    var traninfo = await this.service.findOne({ ali_bizid: p.ali_bizid });
    return { data: traninfo.dataValues, status: 0, msg: "操作成功" }
  }

  //获取签名
  async generateuploadfilepolicy(p, q, req) {
    var self = this;;
    var gobj = {
      action: "GenerateUploadFilePolicy",
      reqbody: { FileType: "LEGAL_NOTICE" }
    }
    if (p.mtype && p.mtype == 'json') {
      gobj.reqbody.FileType = 'PARTNER_SYNC_FILE';
    }
    try {
      var rst = await self.service.aliclient(gobj);
      console.log(rst)
      var source = {
        OSSAccessKeyId: rst.AccessId,
        policy: rst.EncodedPolicy,
        Signature: rst.Signature,
        Bucket: 'trade-mark-user-upload',
        url: "https://trade-mark-user-upload.oss-cn-beijing.aliyuncs.com",
        filedir: rst.FileDir
      }
      if (p.mtype && p.mtype == 'json') {
        source.url = "https://partner-sync-file.oss-cn-beijing.aliyuncs.com";
        source.Bucket = "partner-sync-file";
      }
      console.log(source)
      return source;
    } catch (e) {
      console.log(e)
    }

  }


}
module.exports = TradetransferCtl;

