var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const logCtl = system.getObject("web.common.oplogCtl");

class TmjsonfileCtl extends CtlBase {
  constructor() {
    super("transfer", CtlBase.getServiceName(TmjsonfileCtl));
    this.execS = system.getObject("util.execClient");
    this.uploadfileossurl=settings.uploadfileossurl();
  }
  async createjsonfile(p, o, q) {
    var rtn = await this.service.createjsonfile();
    var self=this;
    console.log(rtn);
    if (rtn.status > -1) {
      var newdate = new Date();
      var strdate = ""
      if (newdate.getHours() > 12) {
        strdate = newdate.toISOString().split("T")[0].replace(/\-/g, "") + "_2.json";
      } else {
        strdate = newdate.toISOString().split("T")[0].replace(/\-/g, "") + "_1.json";
      }
      var self = this;;
      var gobj = {
        action: "GenerateUploadFilePolicy",
        reqbody: { FileType: "PARTNER_SYNC_FILE" }
      }
      var rst = await self.service.aliclient(gobj);
      console.log(rst)
      var url=this.uploadfileossurl+"/uploadfile/"+strdate+"/"+rst.EncodedPolicy+"/"+rst.Signature;
      var upl=await self.execS.execGet(null,url);
      console.log(upl);
      if(upl.stdout){
        var obj = { zc_url: "https://partner-sync-file.oss-cn-beijing.aliyuncs.com/1525276744866147/"+ strdate};
        var rtn = await this.service.create(obj);
        if (rtn) {
          return { status: 0, msg: "成功" };
        }else{
          return { status: -201, msg: "创建失败" };
        }
      }else {
        return { status: -202, msg: "上传失败" };
      }
    } else {
      return { status: -200, msg: "json文件生成失败" };
    }
  }

}
module.exports = TmjsonfileCtl;
