let system = require("../../../system")
let settings = require("../../../../config/settings");
const trademarkCtl = require("./trademarkCtl.js");
const tmtransactionPath = "/tmtransaction/action/trademarktransaction/springBoard";
const tmurl = settings.tmtransactionurl() + tmtransactionPath;

//全部标源管理
class OperationCtl extends trademarkCtl {
    constructor() {
        super();
    }


    /**
     * @api {post} /web/trademark/operationCtl/findAndCountAll 获取全部列表
     * @apiGroup 标源管理
     * @apiParamExample {json} 请求参数
     * {"pageInfo": {"pageNo":1,"pageSize":10}}
     * @apiSuccessExample {json} 成功示例:
     * {"status":0,"msg":""data":{"results":{"rows":[]}}}
     * @apiErrorExample {json} 失败示例:
     * {"error": ""}
     */
    async findAndCountAll(p, q, req) {
        let query = {
            "actionType": "tmInfo",
            "actionBody": {
                channel_code: p.company_id,
                pageSize: p.pageInfo.pageSize,// 每页数量
                pageNumber: p.pageInfo.pageNo,// 页
            }
        };
        if (p.search) {
            if (p.search.name)
                query.actionBody.excelName = p.search.name;
            if (p.search.code)
                query.actionBody.code = p.search.code;
            if (p.search.tm_applier)
                query.actionBody.tm_applier = p.search.tm_applier;
            if (p.search.tm_start_day)
                query.actionBody.tm_start_day = p.search.tm_start_day;
            if (p.search.tm_end_day)
                query.actionBody.tm_end_day = p.search.tm_end_day;
            if (p.search.publish_status)
                query.actionBody.publish_status = p.search.publish_status;
            if (p.search.ids)
                query.actionBody.tmList = p.search.ids;
        }
        let rtn = await this.execClient.execPost(query, tmurl);
        let data = JSON.parse(rtn.stdout);
        return system.getResultList(data.totalCount, data.data || [])
    }
    async forceUpdate(p, q, req) {
        let query = {
            "actionType": "forceUpdate",
            "actionBody": {
                id: p.id,
                price: p.price,
            }
        };
        let rtn = await this.execClient.execPost(query, tmurl);
        let data = JSON.parse(rtn.stdout);
        if (data.status===1)
            return system.getResultSuccess()
        return data
    }
}

module.exports = OperationCtl;

