var system = require("../../../system")
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
var cacheBaseComp = null;

class TemplateinfoCtl extends CtlBase {
    constructor() {
        super("template", CtlBase.getServiceName(TemplateinfoCtl));
        this.templateinfoSve = system.getObject('service.template.templateinfoSve');
    }
    /**
     * 创建模板
     * @param {*} pobj 
     */
    async createTemplate(pobj){
        return this.templateinfoSve.createTemplate(pobj);
    }
    /**
     * 重写查询方法
     * @param pobj
     * @returns {Promise<{msg: string, data: *, bizmsg: string, status: number}>}
     */
    async findAndCountAll(pobj) {
        let result = await this.templateinfoSve.findByCompanyId(pobj);
        return result;
    }
    /**
     * 根据编码获取模板信息
     * @param {*} pobj 
     */
    async getTemplateInfoByCode(pobj){
        let result = await this.templateinfoSve.findOneByCode(pobj);
        return result;
    }
    /**
     * 根据id获取模板信息
     * @param {*} pobj 
     */
    async getTemplateInfoById(pobj){
        let result = await this.templateinfoSve.getTemplateInfoById(pobj);
        return result;
    }

    async setTemplateBusinessId(pobj){
        let result = await this.templateinfoSve.setTemplateBusinessId(pobj);
        return result;
    }
    /**
     * 重写保存方法
     * @param pobj
     * @returns {Promise<void>}
     */
    async create(pobj){
        let result =  await this.templateinfoSve.editTemplateTdk(pobj);
        return result;
    }
    /**
     * 修改启用状态
     * @param {*} pobj 
     */
    async updateSwitchStatus(pobj){
        let result =  await this.templateinfoSve.updateSwitchStatus(pobj);
        return result;
    }
}

module.exports = TemplateinfoCtl;
