var system = require("../../../system")
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
var cacheBaseComp = null;

class LaunchchannelCtl extends CtlBase {
    constructor() {
        super("configmag", CtlBase.getServiceName(LaunchchannelCtl));
    }

    /**
     * 重写添加方法
     * @param pobj
     * @returns {Promise<{msg: string, data: *, bizmsg: string, status: number}>}
     */
    async create(pobj){
        const result = await this.service.createChannel(pobj);
        return result;
    }

    async refQuery(pobj, qobj, req) {
        pobj.refwhere.company_id = pobj.company_id;
        let rtn = await this.service.refQuery(pobj);
        return rtn
    }

    /**
     * 重写update方法
     * @returns {Promise<void>}
     */
    async update(pobj){
        let result = await this.service.updateChannel(pobj);
        return result ;
    }

    /**
     * 重写删除
     * @param pobj
     * @returns {Promise<void>}
     */
    async delete(pobj){
        let result = await this.service.deleteChannel(pobj);
        return result;
    }

}

module.exports = LaunchchannelCtl;
